/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.history.validation;

import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.history.AbstractHistory;
import io.horizen.history.validation.HistoryBlockValidator;
import io.horizen.params.NetworkParams;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.transaction.MC2SCAggregatedTransaction;
import io.horizen.transaction.Transaction;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.utils.BlockUtils$;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.package$;

@ScalaSignature(bytes="\u0006\u0001U4AAB\u0004\u0001!!Aq\u000b\u0001B\u0001B\u0003%\u0001\fC\u0003^\u0001\u0011\u0005a\fC\u0003b\u0001\u0011\u0005#\rC\u0003o\u0001\u0011%q\u000eC\u0003r\u0001\u0011%!O\u0001\rXSRDGM]1xC2,\u0005o\\2i-\u0006d\u0017\u000eZ1u_JT!\u0001C\u0005\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000b\u0017\u00059\u0001.[:u_JL(B\u0001\u0007\u000e\u0003\u001dAwN]5{K:T\u0011AD\u0001\u0003S>\u001c\u0001!F\u0004\u0012=-*DH\u0012)\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\t3ia\"\u0006N\u001eF\u001f6\tq!\u0003\u0002\u001c\u000f\t)\u0002*[:u_JL(\t\\8dWZ\u000bG.\u001b3bi>\u0014\bCA\u000f\u001f\u0019\u0001!Qa\b\u0001C\u0002\u0001\u0012!\u0001\u0016-\u0012\u0005\u0005\"\u0003CA\n#\u0013\t\u0019CCA\u0004O_RD\u0017N\\4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dZ\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:L!!\u000b\u0014\u0003\u0017Q\u0013\u0018M\\:bGRLwN\u001c\t\u0003;-\"Q\u0001\f\u0001C\u00025\u0012\u0011\u0001S\t\u0003C9\u0002\"a\f\u001a\u000e\u0003AR!!M\u0006\u0002\u000b\tdwnY6\n\u0005M\u0002$\u0001G*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b%fC\u0012,'OQ1tKB\u0011Q$\u000e\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0005!6{E)\u0005\u0002\"qA!q&\u000f\u000f+\u0013\tQ\u0004G\u0001\nTS\u0012,7\r[1j]\ncwnY6CCN,\u0007CA\u000f=\t\u0015i\u0004A1\u0001?\u0005\r1\u0005+S\t\u0003C}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0006\u0002\u000b\rD\u0017-\u001b8\n\u0005\u0011\u000b%aF!cgR\u0014\u0018m\u0019;GK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p!\tib\tB\u0003H\u0001\t\u0007\u0001JA\u0003I'R{%+\u0005\u0002\"\u0013B)!*\u0014\u001b<\u000b6\t1J\u0003\u0002M\u0017\u000591\u000f^8sC\u001e,\u0017B\u0001(L\u0005Y\t%m\u001d;sC\u000e$\b*[:u_JL8\u000b^8sC\u001e,\u0007CA\u000fQ\t\u0015\t\u0006A1\u0001S\u0005\tAE+\u0005\u0002\"'BAA+\u0016\u000f+im*u*D\u0001\n\u0013\t1\u0016BA\bBEN$(/Y2u\u0011&\u001cHo\u001c:z\u0003\u0019\u0001\u0018M]1ngB\u0011\u0011lW\u0007\u00025*\u0011qkC\u0005\u00039j\u0013QBT3uo>\u00148\u000eU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002`ABA\u0011\u0004\u0001\u000f+im*u\nC\u0003X\u0005\u0001\u0007\u0001,\u0001\u0005wC2LG-\u0019;f)\r\u0019G.\u001c\t\u0004I\u001eLW\"A3\u000b\u0005\u0019$\u0012\u0001B;uS2L!\u0001[3\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u0014U&\u00111\u000e\u0006\u0002\u0005+:LG\u000fC\u00032\u0007\u0001\u0007A\u0007C\u0003\u000b\u0007\u0001\u0007q*\u0001\u000bwC2LG-\u0019;f\u000f\u0016tWm]5t\u00052|7m\u001b\u000b\u0003GBDQ!\r\u0003A\u0002Q\nQB^1mS\u0012\fG/\u001a\"m_\u000e\\GcA2ti\")\u0011'\u0002a\u0001i!)!\"\u0002a\u0001\u001f\u0002")
public class WithdrawalEpochValidator<TX extends Transaction, H extends SidechainBlockHeaderBase, PMOD extends SidechainBlockBase<TX, H>, FPI extends AbstractFeePaymentsInfo, HSTOR extends AbstractHistoryStorage<PMOD, FPI, HSTOR>, HT extends AbstractHistory<TX, H, PMOD, FPI, HSTOR, HT>>
implements HistoryBlockValidator<TX, H, PMOD, FPI, HSTOR, HT> {
    private final NetworkParams params;

    @Override
    public Try<BoxedUnit> validate(PMOD block, HT history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (block.id().equals($this.params.sidechainGenesisBlockId())) {
                this.validateGenesisBlock(block).get();
            } else {
                this.validateBlock(block, history).get();
            }
        });
    }

    private Try<BoxedUnit> validateGenesisBlock(PMOD block) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int n;
            if (block.mainchainBlockReferencesData().size() != 1) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: genesis block should contain single MC block reference.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
            }
            SidechainCreation sidechainCreation = (SidechainCreation)BlockUtils$.MODULE$.tryGetSidechainCreation((SidechainBlockBase<?, ? extends SidechainBlockHeaderBase>)block).get();
            if (!$this.params.isNonCeasing() && sidechainCreation.withdrawalEpochLength() != $this.params.withdrawalEpochLength()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: genesis block contains different withdrawal epoch length than expected in configs.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
            }
            Enumeration.Value value = $this.params.circuitType();
            Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                int n2;
                boolean bl = $this.params.isCSWEnabled();
                if (bl) {
                    n2 = 2;
                } else if (!bl) {
                    n2 = 0;
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                n = n2;
            } else {
                Enumeration.Value value4 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    n = 32;
                } else {
                    throw new MatchError((Object)value);
                }
            }
            int expectedNumOfCustomFields = n;
            if (sidechainCreation.getScCrOutput().fieldElementCertificateFieldConfigs().size() != expectedNumOfCustomFields) {
                throw new IllegalArgumentException(new StringBuilder(139).append("Sidechain block validation failed for ").append(BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))).append(": ").append("genesis block declares sidechain with different number of custom field configs. ").append("Actual: ").append(sidechainCreation.getScCrOutput().fieldElementCertificateFieldConfigs().size()).append(", expected ").append(expectedNumOfCustomFields).toString());
            }
            if (sidechainCreation.getScCrOutput().bitVectorCertificateFieldConfigs().nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(97).append("Sidechain block validation failed for ").append(BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))).append(": ").append("genesis block declares sidechain with custom bit vectors.").toString());
            }
            if (sidechainCreation.getScCrOutput().mainchainBackwardTransferRequestDataLength() != 0) {
                throw new IllegalArgumentException(new StringBuilder(91).append("Sidechain block validation failed for ").append(BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))).append(": ").append("genesis block declares sidechain with MBTR support.").toString());
            }
        });
    }

    private Try<BoxedUnit> validateBlock(PMOD block, HT history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            block.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)data -> {
                WithdrawalEpochValidator.$anonfun$validateBlock$2(block, data);
                return BoxedUnit.UNIT;
            });
            Option<SidechainBlockInfo> option = ((AbstractHistoryStorage)history.storage()).blockInfoOptionById(block.parentId());
            if (option instanceof Some) {
                Some some = (Some)option;
                SidechainBlockInfo parentBlockInfo = (SidechainBlockInfo)some.value();
                WithdrawalEpochInfo blockEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(block.mainchainBlockReferencesData().size(), parentBlockInfo.withdrawalEpochInfo(), $this.params);
                if (blockEpochInfo.epoch() > parentBlockInfo.withdrawalEpochInfo().epoch()) {
                    if (parentBlockInfo.withdrawalEpochInfo().lastEpochIndex() != $this.params.withdrawalEpochLength()) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s contains MC Block references, that belong to different withdrawal epochs.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (blockEpochInfo.lastEpochIndex() == $this.params.withdrawalEpochLength() && block.sidechainTransactions().nonEmpty()) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s is the withdrawal epoch last block, but contains Sidechain Transactions.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s parent block is missed.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                }
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        });
    }

    public static final /* synthetic */ void $anonfun$validateBlock$2(SidechainBlockBase block$3, MainchainBlockReferenceData data) {
        Option<MC2SCAggregatedTransaction> option = data.sidechainRelatedAggregatedTransaction();
        if (option instanceof Some) {
            Some some = (Some)option;
            MC2SCAggregatedTransaction aggTx = (MC2SCAggregatedTransaction)some.value();
            if (aggTx.mc2scTransactionsOutputs().stream().anyMatch(output -> output instanceof SidechainCreation)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: non-genesis block contains Sidechain Creation output.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block$3.id()))})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public WithdrawalEpochValidator(NetworkParams params) {
        this.params = params;
    }
}

