/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.cryptolibprovider.implementations;

import com.horizen.certnative.BackwardTransfer;
import com.horizen.certnative.CreateProofResult;
import com.horizen.certnative.NaiveThresholdSignatureWKeyRotation;
import com.horizen.certnative.WithdrawalCertificate;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.provingsystemnative.ProvingSystemType;
import com.horizen.schnorrnative.SchnorrPublicKey;
import com.horizen.schnorrnative.SchnorrSignature;
import com.horizen.schnorrnative.ValidatorKeysUpdatesList;
import io.horizen.block.SidechainCreationVersions;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.SchnorrKeysSignatures;
import io.horizen.cryptolibprovider.CommonCircuit;
import io.horizen.cryptolibprovider.ThresholdSignatureCircuitWithKeyRotation;
import io.horizen.cryptolibprovider.utils.FieldElementUtils;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class ThresholdSignatureCircuitWithKeyRotationImplZendoo
implements ThresholdSignatureCircuitWithKeyRotation {
    private static final int supportedSegmentSize = 262144;

    @Override
    public List<byte[]> getCertificateCustomFields(byte[] keysRootHash) {
        ArrayList<byte[]> customFields = new ArrayList<byte[]>(Collections.nCopies(32, new byte[FieldElementUtils.fieldElementLength()]));
        customFields.set(0, keysRootHash);
        return customFields;
    }

    private List<FieldElement> prepareCustomFieldElements(byte[] keysRootHash) {
        Iterator<byte[]> iterator = this.getCertificateCustomFields(keysRootHash).iterator();
        ArrayList<FieldElement> fieldElements = new ArrayList<FieldElement>();
        while (iterator.hasNext()) {
            byte[] fieldBytes = iterator.next();
            fieldElements.add(FieldElement.deserialize((byte[])fieldBytes));
        }
        return fieldElements;
    }

    @Override
    public byte[] generateMessageToBeSigned(List<BackwardTransfer> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, byte[] keysRootHash) {
        byte[] messageAsBytes;
        FieldElement messageToSign;
        List<FieldElement> customFieldElements;
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        try (FieldElement sidechainIdFe = FieldElement.deserialize((byte[])sidechainId);){
            customFieldElements = this.prepareCustomFieldElements(keysRootHash);
            WithdrawalCertificate withdrawalCertificate = new WithdrawalCertificate(FieldElement.deserialize((byte[])sidechainId), epochNumber, bt, endCumulativeScTxCommTreeRootFe, ftMinAmount, btrFee, customFieldElements);
            messageToSign = NaiveThresholdSignatureWKeyRotation.createMsgToSign((WithdrawalCertificate)withdrawalCertificate);
            messageAsBytes = messageToSign.serializeFieldElement();
            withdrawalCertificate.getScId().freeFieldElement();
            withdrawalCertificate.getMcbScTxsCom().freeFieldElement();
            Arrays.stream(withdrawalCertificate.getCustomFields()).forEach(FieldElement::freeFieldElement);
            endCumulativeScTxCommTreeRootFe.freeFieldElement();
            sidechainIdFe.freeFieldElement();
        }
        customFieldElements.forEach(FieldElement::freeFieldElement);
        messageToSign.freeFieldElement();
        return messageAsBytes;
    }

    @Override
    public Pair<byte[], Long> createProof(List<BackwardTransfer> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, List<Optional<byte[]>> schnorrSignatureBytesList, SchnorrKeysSignatures schnorrKeysSignatures, long threshold, Optional<WithdrawalEpochCertificate> previousEpochCertificateOption, int sidechainCreationVersionNumber, byte[] genesisKeysRootHash, String provingKeyPath, boolean checkProvingKey, boolean zk) {
        List<SchnorrSignature> signatures = CommonCircuit.getSignatures(schnorrSignatureBytesList);
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        FieldElement sidechainIdFieldElement = FieldElement.deserialize((byte[])sidechainId);
        List<FieldElement> customFieldsElements = this.prepareCustomFieldElements(this.getSchnorrKeysHash(schnorrKeysSignatures));
        Optional<WithdrawalCertificate> previousCertificateOption = previousEpochCertificateOption.map(c -> CommonCircuit.createWithdrawalCertificate(c, SidechainCreationVersions.apply(sidechainCreationVersionNumber)));
        ValidatorKeysUpdatesList validatorKeysUpdatesList = this.getSchnorrKeysSignaturesList(schnorrKeysSignatures);
        SchnorrPublicKey[] signingPublicKeys = validatorKeysUpdatesList.getSigningKeys();
        WithdrawalCertificate withdrawalCertificate = new WithdrawalCertificate(sidechainIdFieldElement, epochNumber, bt, endCumulativeScTxCommTreeRootFe, ftMinAmount, btrFee, customFieldsElements);
        CreateProofResult proofAndQuality = null;
        try {
            proofAndQuality = NaiveThresholdSignatureWKeyRotation.createProof((ValidatorKeysUpdatesList)validatorKeysUpdatesList, (WithdrawalCertificate)withdrawalCertificate, previousCertificateOption, signatures, (long)signingPublicKeys.length, (long)threshold, (FieldElement)FieldElement.deserialize((byte[])genesisKeysRootHash), Optional.of(262144), (String)provingKeyPath, (boolean)checkProvingKey, (boolean)zk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        previousCertificateOption.ifPresent(previousCertificate -> {
            previousCertificate.getScId().freeFieldElement();
            previousCertificate.getMcbScTxsCom().freeFieldElement();
            Arrays.stream(previousCertificate.getCustomFields()).forEach(FieldElement::freeFieldElement);
        });
        endCumulativeScTxCommTreeRootFe.freeFieldElement();
        sidechainIdFieldElement.freeFieldElement();
        Arrays.stream(validatorKeysUpdatesList.getSigningKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(validatorKeysUpdatesList.getMasterKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedSigningKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedMasterKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedSigningKeysSkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedSigningKeysMkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedMasterKeysSkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(validatorKeysUpdatesList.getUpdatedMasterKeysMkSignatures()).forEach(SchnorrSignature::freeSignature);
        withdrawalCertificate.getScId().freeFieldElement();
        withdrawalCertificate.getMcbScTxsCom().freeFieldElement();
        Arrays.stream(withdrawalCertificate.getCustomFields()).forEach(FieldElement::freeFieldElement);
        signatures.forEach(SchnorrSignature::freeSignature);
        customFieldsElements.forEach(FieldElement::freeFieldElement);
        return new Pair<byte[], Long>(proofAndQuality.getProof(), proofAndQuality.getQuality());
    }

    @Override
    public Boolean verifyProof(List<BackwardTransfer> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, byte[] keysRootHash, long quality, Optional<WithdrawalCertificate> previousEpochCertificateOption, byte[] genesisConstantBytes, int sidechainCreationVersionNumber, byte[] proof, String verificationKeyPath) {
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        boolean verificationResult = false;
        List<FieldElement> customFieldsElements = this.prepareCustomFieldElements(keysRootHash);
        FieldElement genesisConstant = FieldElement.deserialize((byte[])genesisConstantBytes);
        FieldElement sidechainIdFieldElement = FieldElement.deserialize((byte[])sidechainId);
        WithdrawalCertificate withdrawalCertificate = new WithdrawalCertificate(sidechainIdFieldElement, epochNumber, bt, quality, endCumulativeScTxCommTreeRootFe, ftMinAmount, btrFee, customFieldsElements);
        try {
            verificationResult = NaiveThresholdSignatureWKeyRotation.verifyProof((WithdrawalCertificate)withdrawalCertificate, previousEpochCertificateOption, (FieldElement)genesisConstant, (byte[])proof, (String)verificationKeyPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        endCumulativeScTxCommTreeRootFe.freeFieldElement();
        sidechainIdFieldElement.freeFieldElement();
        withdrawalCertificate.getScId().freeFieldElement();
        withdrawalCertificate.getMcbScTxsCom().freeFieldElement();
        Arrays.stream(withdrawalCertificate.getCustomFields()).forEach(FieldElement::freeFieldElement);
        customFieldsElements.forEach(FieldElement::freeFieldElement);
        genesisConstant.freeFieldElement();
        return verificationResult;
    }

    @Override
    public byte[] generateSysDataConstant(List<byte[]> signerPublicKeysList, List<byte[]> masterPublicKeysList, long threshold) throws Exception {
        SchnorrPublicKey[] signerPublicKeys = (SchnorrPublicKey[])signerPublicKeysList.stream().map(SchnorrPublicKey::deserialize).toArray(SchnorrPublicKey[]::new);
        SchnorrPublicKey[] masterPublicKeys = (SchnorrPublicKey[])masterPublicKeysList.stream().map(SchnorrPublicKey::deserialize).toArray(SchnorrPublicKey[]::new);
        FieldElement hash = ValidatorKeysUpdatesList.getInputKeysRootHash((SchnorrPublicKey[])signerPublicKeys, (SchnorrPublicKey[])masterPublicKeys, (long)signerPublicKeys.length);
        FieldElement sysDataConstant = NaiveThresholdSignatureWKeyRotation.getConstant((FieldElement)hash, (long)threshold);
        byte[] sysDataConstantBytes = sysDataConstant.serializeFieldElement();
        sysDataConstant.freeFieldElement();
        Arrays.stream(signerPublicKeys).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(masterPublicKeys).forEach(SchnorrPublicKey::freePublicKey);
        hash.freeFieldElement();
        return sysDataConstantBytes;
    }

    @Override
    public boolean generateCoboundaryMarlinSnarkKeys(long maxPks, String provingKeyPath, String verificationKeyPath) throws Exception {
        return NaiveThresholdSignatureWKeyRotation.setup((ProvingSystemType)ProvingSystemType.COBOUNDARY_MARLIN, (long)maxPks, (int)32, Optional.of(262144), (String)provingKeyPath, (String)verificationKeyPath, (int)9216);
    }

    @Override
    public byte[] generateKeysRootHash(List<byte[]> signerPublicKeysList, List<byte[]> masterPublicKeysList) {
        FieldElement hash;
        SchnorrPublicKey[] signerPublicKeys = (SchnorrPublicKey[])signerPublicKeysList.stream().map(SchnorrPublicKey::deserialize).toArray(SchnorrPublicKey[]::new);
        SchnorrPublicKey[] masterPublicKeys = (SchnorrPublicKey[])masterPublicKeysList.stream().map(SchnorrPublicKey::deserialize).toArray(SchnorrPublicKey[]::new);
        try {
            hash = ValidatorKeysUpdatesList.getInputKeysRootHash((SchnorrPublicKey[])signerPublicKeys, (SchnorrPublicKey[])masterPublicKeys, (long)signerPublicKeys.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] b = hash.serializeFieldElement();
        hash.freeFieldElement();
        Arrays.stream(signerPublicKeys).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(masterPublicKeys).forEach(SchnorrPublicKey::freePublicKey);
        return b;
    }

    @Override
    public ValidatorKeysUpdatesList getSchnorrKeysSignaturesList(SchnorrKeysSignatures schnorrKeysSignatures) {
        return new ValidatorKeysUpdatesList(ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToKeysList(schnorrKeysSignatures.schnorrSigners()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToKeysList(schnorrKeysSignatures.schnorrMasters()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToKeysList(schnorrKeysSignatures.newSchnorrSigners()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToKeysList(schnorrKeysSignatures.newSchnorrMasters()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToSignaturesList(schnorrKeysSignatures.updatedSigningKeysSkSignatures()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToSignaturesList(schnorrKeysSignatures.updatedSigningKeysMkSignatures()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToSignaturesList(schnorrKeysSignatures.updatedMasterKeysSkSignatures()), ThresholdSignatureCircuitWithKeyRotationImplZendoo.byteArrayToSignaturesList(schnorrKeysSignatures.updatedMasterKeysMkSignatures()), (long)schnorrKeysSignatures.schnorrSigners().size());
    }

    @Override
    public byte[] getSchnorrKeysHash(SchnorrKeysSignatures schnorrKeysSignatures) {
        FieldElement hash;
        ValidatorKeysUpdatesList actualKeys = this.getSchnorrKeysSignaturesList(schnorrKeysSignatures);
        try {
            hash = actualKeys.getUpdatedKeysRootHash();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] serializedHash = hash.serializeFieldElement();
        hash.freeFieldElement();
        Arrays.stream(actualKeys.getSigningKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(actualKeys.getMasterKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(actualKeys.getUpdatedSigningKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(actualKeys.getUpdatedMasterKeys()).forEach(SchnorrPublicKey::freePublicKey);
        Arrays.stream(actualKeys.getUpdatedSigningKeysSkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(actualKeys.getUpdatedSigningKeysMkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(actualKeys.getUpdatedMasterKeysSkSignatures()).forEach(SchnorrSignature::freeSignature);
        Arrays.stream(actualKeys.getUpdatedMasterKeysMkSignatures()).forEach(SchnorrSignature::freeSignature);
        return serializedHash;
    }

    private FieldElement getMsgToSign(SchnorrPublicKey pubKey, int epochNumber, FieldElement scIdFe, KeyType type) throws Exception {
        switch (type) {
            case SIGNING: {
                return NaiveThresholdSignatureWKeyRotation.getMsgToSignForSigningKeyUpdate((SchnorrPublicKey)pubKey, (int)epochNumber, (FieldElement)scIdFe);
            }
            case MASTER: {
                return NaiveThresholdSignatureWKeyRotation.getMsgToSignForMasterKeyUpdate((SchnorrPublicKey)pubKey, (int)epochNumber, (FieldElement)scIdFe);
            }
        }
        throw new IllegalArgumentException("Invalid key type: " + String.valueOf((Object)type));
    }

    private byte[] getMsgToSignForKeyUpdate(byte[] newKeyBytes, int epochNumber, byte[] sidechainId, KeyType type) {
        byte[] messageAsBytes;
        block9: {
            FieldElement sidechainIdFe = FieldElement.deserialize((byte[])sidechainId);
            SchnorrPublicKey newKey = SchnorrPublicKey.deserialize((byte[])newKeyBytes);
            try {
                if (sidechainIdFe != null && newKey != null) {
                    FieldElement messageToSign = this.getMsgToSign(newKey, epochNumber, sidechainIdFe, type);
                    if (messageToSign != null) {
                        messageAsBytes = messageToSign.serializeFieldElement();
                        messageToSign.freeFieldElement();
                        break block9;
                    }
                    throw new IllegalArgumentException("Could not get a valid message to sign from key (type " + String.valueOf((Object)type) + "): " + BytesUtils.toHexString(newKeyBytes));
                }
                throw new IllegalArgumentException("Invalid deserialized obj: sidechainId=" + BytesUtils.toHexString(sidechainId) + " / newKeyBytes=" + BytesUtils.toHexString(newKeyBytes));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (sidechainIdFe != null) {
                    sidechainIdFe.freeFieldElement();
                }
                if (newKey != null) {
                    newKey.freePublicKey();
                }
            }
        }
        return messageAsBytes;
    }

    @Override
    public byte[] getMsgToSignForSigningKeyUpdate(byte[] newSigningKeyBytes, int epochNumber, byte[] sidechainId) {
        return this.getMsgToSignForKeyUpdate(newSigningKeyBytes, epochNumber, sidechainId, KeyType.SIGNING);
    }

    @Override
    public byte[] getMsgToSignForMasterKeyUpdate(byte[] newMasterKeyBytes, int epochNumber, byte[] sidechainId) {
        return this.getMsgToSignForKeyUpdate(newMasterKeyBytes, epochNumber, sidechainId, KeyType.MASTER);
    }

    private static List<SchnorrPublicKey> byteArrayToKeysList(Seq<SchnorrProposition> schnorrPublicKeysBytesList) {
        return JavaConverters.seqAsJavaList(schnorrPublicKeysBytesList).stream().map(SchnorrProposition::pubKeyBytes).map(SchnorrPublicKey::deserialize).collect(Collectors.toList());
    }

    private static List<SchnorrSignature> byteArrayToSignaturesList(Seq<Option<SchnorrProof>> schnorrSignaturesBytesSeq) {
        return JavaConverters.seqAsJavaList(schnorrSignaturesBytesSeq).stream().map(b -> {
            if (b.isDefined()) {
                return SchnorrSignature.deserialize((byte[])((SchnorrProof)b.get()).bytes());
            }
            return new SchnorrSignature();
        }).collect(Collectors.toList());
    }

    private static enum KeyType {
        SIGNING,
        MASTER;

    }
}

