/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.consensus;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.consensus.NonceConsensusEpochInfo;
import io.horizen.consensus.NonceConsensusEpochInfoSerializer$;
import io.horizen.consensus.StakeConsensusEpochInfo;
import io.horizen.consensus.StakeConsensusEpochInfoSerializer$;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0003\u0007\u0001'!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0003K\u0001\u0011\u00051\nC\u0003S\u0001\u0011\u00051\u000bC\u0003W\u0001\u0011%q\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003c\u0001\u0011%1\rC\u0003o\u0001\u0011\u0005sN\u0001\u000bD_:\u001cXM\\:vg\u0012\u000bG/Y*u_J\fw-\u001a\u0006\u0003\u001b9\t\u0011bY8og\u0016t7/^:\u000b\u0005=\u0001\u0012a\u00025pe&TXM\u001c\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001AC\u0007\u0012\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003vi&d'\"A\u0010\u0002\rM\u0004\u0018M]6{\u0013\t\tCDA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K9\tqa\u001d;pe\u0006<W-\u0003\u0002(I\t!2+\u001b3fG\"\f\u0017N\\*u_J\fw-Z%oM>\f\u0011dY8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_N#xN]1hKB\u00111EK\u0005\u0003W\u0011\u0012qa\u0015;pe\u0006<W-\u0001\u0004=S:LGO\u0010\u000b\u0003]A\u0002\"a\f\u0001\u000e\u00031AQ\u0001\u000b\u0002A\u0002%\n!$\u00193e'R\f7.Z\"p]N,gn];t\u000bB|7\r[%oM>$2a\r\u001c@!\t)B'\u0003\u00026-\t!QK\\5u\u0011\u001594\u00011\u00019\u0003\u001d)\u0007o\\2i\u0013\u0012\u0004\"!\u000f\u001f\u000f\u0005=R\u0014BA\u001e\r\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003!\r{gn]3ogV\u001cX\t]8dQ&#'BA\u001e\r\u0011\u0015\u00015\u00011\u0001B\u00039\u0019H/Y6f\u000bB|7\r[%oM>\u0004\"a\f\"\n\u0005\rc!aF*uC.,7i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p\u0003i9W\r^*uC.,7i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p)\t1\u0015\nE\u0002\u0016\u000f\u0006K!\u0001\u0013\f\u0003\r=\u0003H/[8o\u0011\u00159D\u00011\u00019\u0003i\tG\r\u001a(p]\u000e,7i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p)\r\u0019D*\u0014\u0005\u0006o\u0015\u0001\r\u0001\u000f\u0005\u0006\u001d\u0016\u0001\raT\u0001\u000fG>t7/\u001a8tkNtuN\\2f!\ty\u0003+\u0003\u0002R\u0019\t9bj\u001c8dK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\\\u0001\u001bO\u0016$hj\u001c8dK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u000b\u0003)V\u00032!F$P\u0011\u00159d\u00011\u00019\u0003E\u0019H/Y6f\u000bB|7\r[%oM>\\U-\u001f\u000b\u00031z\u0003\"!\u0017/\u000e\u0003iS!a\u0017\b\u0002\u000bU$\u0018\u000e\\:\n\u0005uS&\u0001\u0005\"zi\u0016\f%O]1z/J\f\u0007\u000f]3s\u0011\u00159t\u00011\u00019\u0003EqwN\\2f\u000bB|7\r[%oM>\\U-\u001f\u000b\u00031\u0006DQa\u000e\u0005A\u0002a\n\u0001\"\u00193e\u000b:$(/\u001f\u000b\u0004g\u00114\u0007\"B3\n\u0001\u0004A\u0016aA6fs\")q-\u0003a\u0001Q\u0006)a/\u00197vKB\u0019Q#[6\n\u0005)4\"!B!se\u0006L\bCA\u000bm\u0013\tigC\u0001\u0003CsR,\u0017!\u00047bgR4VM]:j_:LE-F\u0001q!\r)r\t\u0017")
public class ConsensusDataStorage
implements SparkzLogging,
SidechainStorageInfo {
    private final Storage consensusEpochInfoStorage;
    private final Logger logger;

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void addStakeConsensusEpochInfo(String epochId, StakeConsensusEpochInfo stakeEpochInfo) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add stake to consensus data storage: for epochId {} stake info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, stakeEpochInfo});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getStakeConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)stakeInfo -> BoxesRunTime.boxToBoolean((boolean)stakeInfo.equals(stakeEpochInfo))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("StakeConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.stakeEpochInfoKey(epochId), StakeConsensusEpochInfoSerializer$.MODULE$.toBytes(stakeEpochInfo));
    }

    public Option<StakeConsensusEpochInfo> getStakeConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.stakeEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (StakeConsensusEpochInfo)StakeConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    public void addNonceConsensusEpochInfo(String epochId, NonceConsensusEpochInfo consensusNonce) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add nonce to consensus data storage: for epochId {} nonce info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, consensusNonce});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getNonceConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)nonceInfo -> BoxesRunTime.boxToBoolean((boolean)nonceInfo.equals(consensusNonce))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("NonceConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.nonceEpochInfoKey(epochId), NonceConsensusEpochInfoSerializer$.MODULE$.toBytes(consensusNonce));
    }

    public Option<NonceConsensusEpochInfo> getNonceConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.nonceEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (NonceConsensusEpochInfo)NonceConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    private ByteArrayWrapper stakeEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("stake").append(epochId).toString()));
    }

    private ByteArrayWrapper nonceEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("nonce").append(epochId).toString()));
    }

    private void addEntry(ByteArrayWrapper key, byte[] value) {
        BoxedUnit boxedUnit;
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> listForUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        Pair<ByteArrayWrapper, ByteArrayWrapper> addedData = new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper(value));
        listForUpdate.add(addedData);
        ByteArrayWrapper version = new ByteArrayWrapper(Utils.nextVersion());
        this.consensusEpochInfoStorage.update(version, listForUpdate, Collections.emptyList());
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(45).append("Consensus data storage updated with version: ").append(version).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.lastVersionID()));
    }

    public ConsensusDataStorage(Storage consensusEpochInfoStorage) {
        this.consensusEpochInfoStorage = consensusEpochInfoStorage;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainStorageInfo.$init$(this);
    }
}

