/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.consensus;

import com.google.common.primitives.Ints;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.consensus.ConsensusDataProvider$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.consensus.ConsensusParamsUtil$;
import io.horizen.consensus.FullConsensusEpochInfo;
import io.horizen.consensus.NonceConsensusEpochInfo;
import io.horizen.consensus.StakeConsensusEpochInfo;
import io.horizen.consensus.package$;
import io.horizen.fork.ForkManager$;
import io.horizen.params.NetworkParams;
import io.horizen.params.NetworkParamsUtils;
import io.horizen.storage.SidechainBlockInfoProvider;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import sparkz.core.serialization.BytesSerializable;

@ScalaSignature(bytes="\u0006\u0001\tua!\u0003\u000b\u0016!\u0003\r\t\u0001HAJ\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0019a\b\u0001\"\u0001\u0018{\"9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b;q!!7\u0016\u0011\u0003\tYN\u0002\u0004\u0015+!\u0005\u0011Q\u001c\u0005\b\u0003?tA\u0011AAq\u0011\u001d\t\u0019O\u0004C\u0005\u0003KD\u0011\"!?\u000f\u0005\u0004%I!a?\t\u0011\tUa\u0002)A\u0005\u0003{DqAa\u0006\u000f\t\u0003\u0011IBA\u000bD_:\u001cXM\\:vg\u0012\u000bG/\u0019)s_ZLG-\u001a:\u000b\u0005Y9\u0012!C2p]N,gn];t\u0015\tA\u0012$A\u0004i_JL'0\u001a8\u000b\u0003i\t!![8\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005)\u0003C\u0001\u0010'\u0013\t9sD\u0001\u0003V]&$\u0018AG4fiN#\u0018m[3D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|Gc\u0001\u00162\u0003B\u0019adK\u0017\n\u00051z\"AB(qi&|g\u000e\u0005\u0002/_5\tQ#\u0003\u00021+\t92\u000b^1lK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u0005\u0006e\t\u0001\raM\u0001\u000fE2|7m\u001b+j[\u0016\u001cH/Y7q!\t!dH\u0004\u00026y5\taG\u0003\u00028q\u0005)!\r\\8dW*\u0011\u0011HO\u0001\u0005G>\u0014XMC\u0001<\u0003\u0019\u0019\b/\u0019:lu&\u0011QHN\u0001\u0006\u00052|7m[\u0005\u0003\u007f\u0001\u0013\u0011\u0002V5nKN$\u0018-\u001c9\u000b\u0005u2\u0004\"\u0002\"\u0003\u0001\u0004\u0019\u0015!\u00049be\u0016tGO\u00117pG.LE\r\u0005\u0002E!:\u0011Q)\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014B\u0001';\u0003\u0011)H/\u001b7\n\u00059{\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0019jJ!!\u0015*\u0003\u00155{G-\u001b4jKJLEM\u0003\u0002O\u001f\u0006\ts-\u001a;MCN$(\t\\8dW&#wJ\u001a)sKB\u0013XM^5pkN,\u0005o\\2igR\u00191)\u0016,\t\u000bI\u001a\u0001\u0019A\u001a\t\u000b\t\u001b\u0001\u0019A\"\u0002K\u001d,Go\u0014:DC2\u001cW\u000f\\1uK:{gnY3D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|GcA-];B\u0011aFW\u0005\u00037V\u0011qCT8oG\u0016\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\t\u000bI\"\u0001\u0019A\u001a\t\u000b\t#\u0001\u0019A\"\u0002\u001d%\u001cx)\u001a8fg&\u001c(\t\\8dWR\u0019\u0001m\u00193\u0011\u0005y\t\u0017B\u00012 \u0005\u001d\u0011un\u001c7fC:DQAM\u0003A\u0002MBQAQ\u0003A\u0002\r\u000b\u0011eZ3u\rVdGnQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_\u001a{'O\u00117pG.$2a\u001a6r!\tq\u0003.\u0003\u0002j+\t1b)\u001e7m\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eC\u00033\r\u0001\u00071\u000e\u0005\u0002m}9\u0011Q\u000e\u0010\b\u0003]Bt!AR8\n\u0005eR\u0014BA\u001c9\u0011\u0015\u0011e\u00011\u0001D\u0003Y\u0019\u0017\r\\2vY\u0006$XMT8oG\u00164uN]#q_\u000eDGCA-u\u0011\u0015)x\u00011\u0001w\u0003\u001d)\u0007o\\2i\u0013\u0012\u0004\"a^=\u000f\u00059B\u0018B\u0001(\u0016\u0013\tQ8P\u0001\tD_:\u001cXM\\:vg\u0016\u0003xn\u00195JI*\u0011a*F\u0001!G\u0006d7-\u001e7bi\u0016tuN\\2f\r>\u0014hj\u001c8HK:,7/[:Fa>\u001c\u0007\u000e\u0006\u0004Z}\u0006\u0005\u0011\u0011\u0003\u0005\u0006\u007f\"\u0001\raQ\u0001\u0013Y\u0006\u001cHO\u00117pG.LE-\u00138Fa>\u001c\u0007\u000eC\u0004\u0002\u0004!\u0001\r!!\u0002\u0002)1\f7\u000f\u001e\"m_\u000e\\\u0017J\u001c4p\u0013:,\u0005o\\2i!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006/\u0005)1\r[1j]&!\u0011qBA\u0005\u0005I\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.LeNZ8\t\u000f\u0005M\u0001\u00021\u0001\u0002\u0016\u0005\u0001\u0012N\\5uS\u0006dgj\u001c8dK\u0012\u000bG/\u0019\t\u0007\u0003/\ty\"!\n\u000f\t\u0005e\u0011Q\u0004\b\u0004\u000f\u0006m\u0011\"\u0001\u0011\n\u00059{\u0012\u0002BA\u0011\u0003G\u00111aU3r\u0015\tqu\u0004E\u0004\u001f\u0003O\tY#a\u000e\n\u0007\u0005%rD\u0001\u0004UkBdWM\r\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G\f\u0002\u0007Y\u0014h-\u0003\u0003\u00026\u0005=\"!\u0003,sM>+H\u000f];u!\r9\u0018\u0011H\u0005\u0004\u0003wY(aE\"p]N,gn];t'2|GOT;nE\u0016\u0014\u0018\u0001G2sK\u0006$XMT8oG\u0016lUm]:bO\u0016$\u0015nZ3tiRa\u0011\u0011IA)\u0003+\nI&a\u0019\u0002hA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\tiQ*Z:tC\u001e,G)[4fgRDa!a\u0015\n\u0001\u0004\u0019\u0015AD5oSRL\u0017\r\u001c\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003/J\u0001\u0019AA\u0003\u0003AIg.\u001b;jC2\u0014En\\2l\u0013:4w\u000eC\u0004\u0002\\%\u0001\r!!\u0018\u0002/\u0015d\u0017nZ5cY\u0016\u001cFn\u001c;t%\u0006tw-Z*uCJ$\bc\u0001\u0010\u0002`%\u0019\u0011\u0011M\u0010\u0003\u0007%sG\u000fC\u0004\u0002f%\u0001\r!!\u0018\u0002+\u0015d\u0017nZ5cY\u0016\u001cFn\u001c;t%\u0006tw-Z#oI\"9\u00111C\u0005A\u0002\u0005U\u0011\u0001J4fi2\u000b7\u000f\u001e\"m_\u000e\\\u0017J\u001c)sKZLw.^:D_:\u001cXM\\:vg\u0016\u0003xn\u00195\u0015\u000b\r\u000bi'a\u001c\t\u000bIR\u0001\u0019A\u001a\t\r\u0005E$\u00021\u0001D\u0003!\u0001\u0018M]3oi&#\u0017\u0001D4fiZ\u0013hmT;uaV$HCBA<\u0003s\n9\t\u0005\u0003\u001fW\u0005-\u0002bBA>\u0017\u0001\u0007\u0011QP\u0001\fE2|7m\u001b%fC\u0012,'\u000f\u0005\u0003\u0002\u0000\u0005\rUBAAA\u0015\t9t#\u0003\u0003\u0002\u0006\u0006\u0005%\u0001G*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b%fC\u0012,'OQ1tK\"1\u0011\u0011R\u0006A\u0002e\u000bqC\\8oG\u0016\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u0002%\r\fGnY;mCR,gK\u001d4PkR\u0004X\u000f\u001e\u000b\u0007\u0003o\ny)!%\t\u000f\u0005mD\u00021\u0001\u0002~!1\u0011\u0011\u0012\u0007A\u0002e\u0013b!!&\u0002\u001a\u0006meABAL\u0001\u0001\t\u0019J\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002/\u0001I1\u0011QTAP\u0003W3a!a&\u0001\u0001\u0005m\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015v#\u0001\u0004qCJ\fWn]\u0005\u0005\u0003S\u000b\u0019K\u0001\nOKR<xN]6QCJ\fWn]+uS2\u001c\b\u0003BAW\u0003_k\u0011aT\u0005\u0004\u0003c{%!D*qCJ\\'\u0010T8hO&tw\r\u0003\u0006\u00026\u0006u%\u0019!D\u0001\u0003o\u000bqa\u001d;pe\u0006<W-\u0006\u0002\u0002:B!\u00111XA`\u001b\t\tiLC\u0002\u00026^IA!!1\u0002>\nQ2+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017J\u001c4p!J|g/\u001b3fe\"Q\u0011QYAO\u0005\u00045\t!a2\u0002)\r|gn]3ogV\u001cH)\u0019;b'R|'/Y4f+\t\tI\rE\u0002/\u0003\u0017L1!!4\u0016\u0005Q\u0019uN\\:f]N,8\u000fR1uCN#xN]1hK\"Q\u0011QUAO\u0005\u00045\t!!5\u0016\u0005\u0005M\u0007\u0003BAQ\u0003+LA!a6\u0002$\nia*\u001a;x_J\\\u0007+\u0019:b[N\fQcQ8og\u0016t7/^:ECR\f\u0007K]8wS\u0012,'\u000f\u0005\u0002/\u001dM\u0011a\"H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005m\u0017\u0001\u00062m_\u000e\\\u0017\nZ!oI:{gnY3U_.+\u0017\u0010\u0006\u0004\u0002h\u0006M\u0018q\u001f\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q^\f\u0002\u000bU$\u0018\u000e\\:\n\t\u0005E\u00181\u001e\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJDa!!>\u0011\u0001\u0004\u0019\u0015a\u00022m_\u000e\\\u0017\n\u001a\u0005\u0007\u0003\u0013\u0003\u0002\u0019A-\u0002\u001dY\u0014hmT;uaV$8)Y2iKV\u0011\u0011Q \t\t\u0003\u007f\u0014y!a:\u0002,9!!\u0011\u0001B\u0007\u001d\u0011\u0011\u0019Aa\u0003\u000f\t\t\u0015!\u0011\u0002\b\u0004\u000f\n\u001d\u0011\"\u0001\u000e\n\u0005aI\u0012bAAw/%\u0019a*a;\n\t\tE!1\u0003\u0002\t\u0019J,8)Y2iK*\u0019a*a;\u0002\u001fY\u0014hmT;uaV$8)Y2iK\u0002\nQdY1mGVd\u0017\r^3O_:\u001cWMR8s\u000f\u0016tWm]5t\u00052|7m\u001b\u000b\u00043\nm\u0001bBAS'\u0001\u0007\u00111\u001b")
public interface ConsensusDataProvider {
    public static NonceConsensusEpochInfo calculateNonceForGenesisBlock(NetworkParams networkParams) {
        return ConsensusDataProvider$.MODULE$.calculateNonceForGenesisBlock(networkParams);
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("consensusDataStorage", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("storage", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        CallSite methodCache4 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method4 = methodCache4.find(x$1);
        if (method4 != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("consensusDataStorage", methodCache4.parameterTypes()));
        methodCache4.add(x$1, method4);
        return method4;
    }

    public static Method reflMethod$Method5(Class x$1) {
        CallSite methodCache5 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method5 = methodCache5.find(x$1);
        if (method5 != null) {
            return method5;
        }
        method5 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache5.parameterTypes()));
        methodCache5.add(x$1, method5);
        return method5;
    }

    public static Method reflMethod$Method6(Class x$1) {
        CallSite methodCache6 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method6 = methodCache6.find(x$1);
        if (method6 != null) {
            return method6;
        }
        method6 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("consensusDataStorage", methodCache6.parameterTypes()));
        methodCache6.add(x$1, method6);
        return method6;
    }

    public static Method reflMethod$Method7(Class x$1) {
        CallSite methodCache7 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method7 = methodCache7.find(x$1);
        if (method7 != null) {
            return method7;
        }
        method7 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache7.parameterTypes()));
        methodCache7.add(x$1, method7);
        return method7;
    }

    public static Method reflMethod$Method8(Class x$1) {
        CallSite methodCache8 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method8 = methodCache8.find(x$1);
        if (method8 != null) {
            return method8;
        }
        method8 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache8.parameterTypes()));
        methodCache8.add(x$1, method8);
        return method8;
    }

    public static Method reflMethod$Method9(Class x$1) {
        CallSite methodCache9 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method9 = methodCache9.find(x$1);
        if (method9 != null) {
            return method9;
        }
        method9 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("storage", methodCache9.parameterTypes()));
        methodCache9.add(x$1, method9);
        return method9;
    }

    public static Method reflMethod$Method10(Class x$1) {
        CallSite methodCache10 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method10 = methodCache10.find(x$1);
        if (method10 != null) {
            return method10;
        }
        method10 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache10.parameterTypes()));
        methodCache10.add(x$1, method10);
        return method10;
    }

    public static Method reflMethod$Method11(Class x$1) {
        CallSite methodCache11 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method11 = methodCache11.find(x$1);
        if (method11 != null) {
            return method11;
        }
        method11 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache11.parameterTypes()));
        methodCache11.add(x$1, method11);
        return method11;
    }

    public static Method reflMethod$Method12(Class x$1) {
        CallSite methodCache12 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method12 = methodCache12.find(x$1);
        if (method12 != null) {
            return method12;
        }
        method12 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("consensusDataStorage", methodCache12.parameterTypes()));
        methodCache12.add(x$1, method12);
        return method12;
    }

    public static Method reflMethod$Method13(Class x$1) {
        CallSite methodCache13 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method13 = methodCache13.find(x$1);
        if (method13 != null) {
            return method13;
        }
        method13 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache13.parameterTypes()));
        methodCache13.add(x$1, method13);
        return method13;
    }

    public static Method reflMethod$Method14(Class x$1) {
        CallSite methodCache14 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method14 = methodCache14.find(x$1);
        if (method14 != null) {
            return method14;
        }
        method14 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("storage", methodCache14.parameterTypes()));
        methodCache14.add(x$1, method14);
        return method14;
    }

    public static Method reflMethod$Method15(Class x$1) {
        CallSite methodCache15 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method15 = methodCache15.find(x$1);
        if (method15 != null) {
            return method15;
        }
        method15 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache15.parameterTypes()));
        methodCache15.add(x$1, method15);
        return method15;
    }

    public static Method reflMethod$Method16(Class x$1) {
        CallSite methodCache16 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method16 = methodCache16.find(x$1);
        if (method16 != null) {
            return method16;
        }
        method16 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("storage", methodCache16.parameterTypes()));
        methodCache16.add(x$1, method16);
        return method16;
    }

    public static Method reflMethod$Method17(Class x$1) {
        CallSite methodCache17 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method17 = methodCache17.find(x$1);
        if (method17 != null) {
            return method17;
        }
        method17 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache17.parameterTypes()));
        methodCache17.add(x$1, method17);
        return method17;
    }

    public static Method reflMethod$Method18(Class x$1) {
        CallSite methodCache18 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method18 = methodCache18.find(x$1);
        if (method18 != null) {
            return method18;
        }
        method18 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache18.parameterTypes()));
        methodCache18.add(x$1, method18);
        return method18;
    }

    public static Method reflMethod$Method19(Class x$1) {
        CallSite methodCache19 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method19 = methodCache19.find(x$1);
        if (method19 != null) {
            return method19;
        }
        method19 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache19.parameterTypes()));
        methodCache19.add(x$1, method19);
        return method19;
    }

    public static Method reflMethod$Method20(Class x$1) {
        CallSite methodCache20 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method20 = methodCache20.find(x$1);
        if (method20 != null) {
            return method20;
        }
        method20 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("params", methodCache20.parameterTypes()));
        methodCache20.add(x$1, method20);
        return method20;
    }

    public static /* synthetic */ Option getStakeConsensusEpochInfo$(ConsensusDataProvider $this, long blockTimestamp, String parentBlockId) {
        return $this.getStakeConsensusEpochInfo(blockTimestamp, parentBlockId);
    }

    default public Option<StakeConsensusEpochInfo> getStakeConsensusEpochInfo(long blockTimestamp, String parentBlockId) {
        Object object;
        ConsensusDataProvider qual1 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return ((ConsensusDataStorage)object).getStakeConsensusEpochInfo(package$.MODULE$.blockIdToEpochId(this.getLastBlockIdOfPrePreviousEpochs(blockTimestamp, parentBlockId)));
    }

    public static /* synthetic */ String getLastBlockIdOfPrePreviousEpochs$(ConsensusDataProvider $this, long blockTimestamp, String parentBlockId) {
        return $this.getLastBlockIdOfPrePreviousEpochs(blockTimestamp, parentBlockId);
    }

    default public String getLastBlockIdOfPrePreviousEpochs(long blockTimestamp, String parentBlockId) {
        String string;
        if (this.isGenesisBlock(blockTimestamp, parentBlockId)) {
            Object object;
            ConsensusDataProvider qual2 = this;
            try {
                object = ConsensusDataProvider.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            string = ((NetworkParams)object).sidechainGenesisBlockId();
        } else {
            String blockInPrePreviousEpoch;
            Object object;
            String lastBlockInPreviousEpoch = this.getLastBlockInPreviousConsensusEpoch(blockTimestamp, parentBlockId);
            ConsensusDataProvider qual3 = this;
            try {
                object = ConsensusDataProvider.reflMethod$Method3(qual3.getClass()).invoke((Object)qual3, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            string = blockInPrePreviousEpoch = ((SidechainBlockInfoProvider)object).blockInfoById(lastBlockInPreviousEpoch).lastBlockInPreviousConsensusEpoch();
        }
        return string;
    }

    public static /* synthetic */ NonceConsensusEpochInfo getOrCalculateNonceConsensusEpochInfo$(ConsensusDataProvider $this, long blockTimestamp, String parentBlockId) {
        return $this.getOrCalculateNonceConsensusEpochInfo(blockTimestamp, parentBlockId);
    }

    default public NonceConsensusEpochInfo getOrCalculateNonceConsensusEpochInfo(long blockTimestamp, String parentBlockId) {
        NonceConsensusEpochInfo nonceConsensusEpochInfo;
        if (this.isGenesisBlock(blockTimestamp, parentBlockId)) {
            Object object;
            Object object2;
            ConsensusDataProvider qual4 = this;
            try {
                object2 = ConsensusDataProvider.reflMethod$Method4(qual4.getClass()).invoke((Object)qual4, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            ConsensusDataProvider qual5 = this;
            try {
                object = ConsensusDataProvider.reflMethod$Method5(qual5.getClass()).invoke((Object)qual5, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            nonceConsensusEpochInfo = (NonceConsensusEpochInfo)((ConsensusDataStorage)object2).getNonceConsensusEpochInfo(package$.MODULE$.blockIdToEpochId(((NetworkParams)object).sidechainGenesisBlockId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                ConsensusDataProvider qual20 = this;
                try {
                    object = ConsensusDataProvider.reflMethod$Method20(qual20.getClass()).invoke((Object)qual20, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                return ConsensusDataProvider$.MODULE$.calculateNonceForGenesisBlock((NetworkParams)object);
            });
        } else {
            Object object;
            String lastBlockInPreviousEpoch = this.getLastBlockInPreviousConsensusEpoch(blockTimestamp, parentBlockId);
            ConsensusDataProvider qual6 = this;
            try {
                object = ConsensusDataProvider.reflMethod$Method6(qual6.getClass()).invoke((Object)qual6, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            nonceConsensusEpochInfo = (NonceConsensusEpochInfo)((ConsensusDataStorage)object).getNonceConsensusEpochInfo(package$.MODULE$.blockIdToEpochId(lastBlockInPreviousEpoch)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.calculateNonceForEpoch(package$.MODULE$.blockIdToEpochId(this.getLastBlockInPreviousConsensusEpoch(blockTimestamp, parentBlockId))));
        }
        return nonceConsensusEpochInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGenesisBlock(long blockTimestamp, String parentBlockId) {
        Object object;
        Object object2;
        ConsensusDataProvider qual7 = this;
        try {
            object2 = ConsensusDataProvider.reflMethod$Method7(qual7.getClass()).invoke((Object)qual7, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        if (blockTimestamp != ((NetworkParams)object2).sidechainGenesisBlockTimestamp()) return false;
        String string = parentBlockId;
        ConsensusDataProvider qual8 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method8(qual8.getClass()).invoke((Object)qual8, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        String string2 = ((NetworkParams)object).sidechainGenesisBlockParentId();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static /* synthetic */ FullConsensusEpochInfo getFullConsensusEpochInfoForBlock$(ConsensusDataProvider $this, long blockTimestamp, String parentBlockId) {
        return $this.getFullConsensusEpochInfoForBlock(blockTimestamp, parentBlockId);
    }

    default public FullConsensusEpochInfo getFullConsensusEpochInfoForBlock(long blockTimestamp, String parentBlockId) {
        StakeConsensusEpochInfo stakeConsensusEpochInfo = (StakeConsensusEpochInfo)this.getStakeConsensusEpochInfo(blockTimestamp, parentBlockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(32).append("Stake was not defined for block ").append(parentBlockId).toString());
        });
        NonceConsensusEpochInfo nonceConsensusEpochInfo = this.getOrCalculateNonceConsensusEpochInfo(blockTimestamp, parentBlockId);
        return new FullConsensusEpochInfo(stakeConsensusEpochInfo, nonceConsensusEpochInfo);
    }

    public static /* synthetic */ NonceConsensusEpochInfo calculateNonceForEpoch$(ConsensusDataProvider $this, String epochId) {
        return $this.calculateNonceForEpoch(epochId);
    }

    default public NonceConsensusEpochInfo calculateNonceForEpoch(String epochId) {
        NonceConsensusEpochInfo nonceConsensusEpochInfo;
        Object object;
        String lastBlockIdInEpoch = package$.MODULE$.lastBlockIdInEpochId(epochId);
        ConsensusDataProvider qual9 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method9(qual9.getClass()).invoke((Object)qual9, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        SidechainBlockInfo lastBlockInfoInEpoch = ((SidechainBlockInfoProvider)object).blockInfoById(lastBlockIdInEpoch);
        if (((NetworkParamsUtils)((Object)this)).isGenesisBlock(lastBlockIdInEpoch)) {
            Object object2;
            ConsensusDataProvider qual10 = this;
            try {
                object2 = ConsensusDataProvider.reflMethod$Method10(qual10.getClass()).invoke((Object)qual10, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            nonceConsensusEpochInfo = ConsensusDataProvider$.MODULE$.calculateNonceForGenesisBlock((NetworkParams)object2);
        } else {
            nonceConsensusEpochInfo = this.calculateNonceForNonGenesisEpoch(lastBlockIdInEpoch, lastBlockInfoInEpoch, (Seq<Tuple2<VrfOutput, Object>>)((Seq)Nil$.MODULE$));
        }
        return nonceConsensusEpochInfo;
    }

    public static /* synthetic */ NonceConsensusEpochInfo calculateNonceForNonGenesisEpoch$(ConsensusDataProvider $this, String lastBlockIdInEpoch, SidechainBlockInfo lastBlockInfoInEpoch, Seq initialNonceData) {
        return $this.calculateNonceForNonGenesisEpoch(lastBlockIdInEpoch, lastBlockInfoInEpoch, (Seq<Tuple2<VrfOutput, Object>>)initialNonceData);
    }

    default public NonceConsensusEpochInfo calculateNonceForNonGenesisEpoch(String lastBlockIdInEpoch, SidechainBlockInfo lastBlockInfoInEpoch, Seq<Tuple2<VrfOutput, Object>> initialNonceData) {
        Object object;
        Object object2;
        ConsensusDataProvider qual11 = this;
        try {
            object2 = ConsensusDataProvider.reflMethod$Method11(qual11.getClass()).invoke((Object)qual11, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int currentEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(((NetworkParams)object2).sidechainGenesisBlockTimestamp(), lastBlockInfoInEpoch.timestamp());
        byte[] currentEpochNumberBytes = Ints.toByteArray((int)currentEpoch);
        int consensusSlotsPerEpoch = ConsensusParamsUtil$.MODULE$.getConsensusSlotsPerEpoch(currentEpoch);
        int quietSlotsNumber = consensusSlotsPerEpoch / 3;
        int eligibleSlotsRangeStart = quietSlotsNumber + 1;
        int eligibleSlotsRangeEnd = consensusSlotsPerEpoch - quietSlotsNumber - 1;
        MessageDigest nonceMessageDigest = this.createNonceMessageDigest(lastBlockIdInEpoch, lastBlockInfoInEpoch, eligibleSlotsRangeStart, eligibleSlotsRangeEnd, initialNonceData);
        String previousEpoch = package$.MODULE$.blockIdToEpochId(lastBlockInfoInEpoch.lastBlockInPreviousConsensusEpoch());
        ConsensusDataProvider qual12 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method12(qual12.getClass()).invoke((Object)qual12, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        byte[] previousNonce = ((BytesSerializable)((ConsensusDataStorage)object).getNonceConsensusEpochInfo(previousEpoch).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.calculateNonceForEpoch(previousEpoch))).bytes();
        nonceMessageDigest.update(previousNonce);
        nonceMessageDigest.update(currentEpochNumberBytes);
        int nonceLength = ForkManager$.MODULE$.getSidechainFork(currentEpoch).nonceLength();
        byte[] resultHash = nonceMessageDigest.digest();
        return new NonceConsensusEpochInfo(package$.MODULE$.byteArrayToConsensusNonce((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(resultHash)).slice(0, nonceLength)));
    }

    private MessageDigest createNonceMessageDigest(String initialBlockId, SidechainBlockInfo initialBlockInfo, int eligibleSlotsRangeStart, int eligibleSlotsRangeEnd, Seq<Tuple2<VrfOutput, Object>> initialNonceData) {
        Object object;
        Predef$.MODULE$.require(!((NetworkParamsUtils)((Object)this)).isGenesisBlock(initialBlockId));
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        initialNonceData.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConsensusDataProvider.$anonfun$createNonceMessageDigest$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ConsensusDataProvider.$anonfun$createNonceMessageDigest$2(eligibleSlotsRangeStart, eligibleSlotsRangeEnd, digest, x$1);
            return BoxedUnit.UNIT;
        });
        String nextBlockId = initialBlockId;
        SidechainBlockInfo nextBlockInfo = initialBlockInfo;
        ConsensusDataProvider qual13 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method13(qual13.getClass()).invoke((Object)qual13, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int nextBlockSlot = TimeToEpochUtils$.MODULE$.timeStampToSlotNumber(((NetworkParams)object).sidechainGenesisBlockTimestamp(), initialBlockInfo.timestamp());
        while (true) {
            Object object2;
            Object object3;
            String string = nextBlockId;
            String string2 = initialBlockInfo.lastBlockInPreviousConsensusEpoch();
            if (!(string == null ? string2 != null : !string.equals(string2)) || nextBlockSlot < eligibleSlotsRangeStart) break;
            if (eligibleSlotsRangeEnd >= nextBlockSlot) {
                digest.update(((VrfOutput)nextBlockInfo.vrfOutputOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException("Try to calculate nonce by using block with incorrect Vrf proof");
                })).bytes());
            }
            nextBlockId = nextBlockInfo.parentId();
            ConsensusDataProvider qual14 = this;
            try {
                object3 = ConsensusDataProvider.reflMethod$Method14(qual14.getClass()).invoke((Object)qual14, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            nextBlockInfo = ((SidechainBlockInfoProvider)object3).blockInfoById(nextBlockId);
            ConsensusDataProvider qual15 = this;
            try {
                object2 = ConsensusDataProvider.reflMethod$Method15(qual15.getClass()).invoke((Object)qual15, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            nextBlockSlot = TimeToEpochUtils$.MODULE$.timeStampToSlotNumber(((NetworkParams)object2).sidechainGenesisBlockTimestamp(), nextBlockInfo.timestamp());
        }
        return digest;
    }

    public static /* synthetic */ String getLastBlockInPreviousConsensusEpoch$(ConsensusDataProvider $this, long blockTimestamp, String parentId) {
        return $this.getLastBlockInPreviousConsensusEpoch(blockTimestamp, parentId);
    }

    default public String getLastBlockInPreviousConsensusEpoch(long blockTimestamp, String parentId) {
        String string;
        Object object;
        Object object2;
        Object object3;
        ConsensusDataProvider qual16 = this;
        try {
            object3 = ConsensusDataProvider.reflMethod$Method16(qual16.getClass()).invoke((Object)qual16, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        SidechainBlockInfo parentBlockInfo = ((SidechainBlockInfoProvider)object3).blockInfoById(parentId);
        ConsensusDataProvider qual17 = this;
        try {
            object2 = ConsensusDataProvider.reflMethod$Method17(qual17.getClass()).invoke((Object)qual17, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int parentBlockEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(((NetworkParams)object2).sidechainGenesisBlockTimestamp(), parentBlockInfo.timestamp());
        ConsensusDataProvider qual18 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method18(qual18.getClass()).invoke((Object)qual18, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int currentBlockEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(((NetworkParams)object).sidechainGenesisBlockTimestamp(), blockTimestamp);
        int n = Ints.compare((int)parentBlockEpochNumber, (int)currentBlockEpochNumber);
        switch (n) {
            case -1: {
                string = parentId;
                break;
            }
            case 0: {
                string = parentBlockInfo.lastBlockInPreviousConsensusEpoch();
                break;
            }
            default: {
                throw new IllegalArgumentException("Parent of block shall not be generated before block");
            }
        }
        return string;
    }

    public static /* synthetic */ Option getVrfOutput$(ConsensusDataProvider $this, SidechainBlockHeaderBase blockHeader, NonceConsensusEpochInfo nonceConsensusEpochInfo) {
        return $this.getVrfOutput(blockHeader, nonceConsensusEpochInfo);
    }

    default public Option<VrfOutput> getVrfOutput(SidechainBlockHeaderBase blockHeader, NonceConsensusEpochInfo nonceConsensusEpochInfo) {
        ByteArrayWrapper key = ConsensusDataProvider$.MODULE$.io$horizen$consensus$ConsensusDataProvider$$blockIdAndNonceToKey(blockHeader.id(), nonceConsensusEpochInfo);
        VrfOutput cachedValue = (VrfOutput)ConsensusDataProvider$.MODULE$.io$horizen$consensus$ConsensusDataProvider$$vrfOutputCache().get(key);
        return cachedValue == null ? this.calculateVrfOutput(blockHeader, nonceConsensusEpochInfo).map((Function1 & Serializable & scala.Serializable)vrfOutput -> {
            ConsensusDataProvider$.MODULE$.io$horizen$consensus$ConsensusDataProvider$$vrfOutputCache().put(key, (VrfOutput)vrfOutput);
            return vrfOutput;
        }) : new Some((Object)cachedValue);
    }

    private Option<VrfOutput> calculateVrfOutput(SidechainBlockHeaderBase blockHeader, NonceConsensusEpochInfo nonceConsensusEpochInfo) {
        Object object;
        ConsensusDataProvider qual19 = this;
        try {
            object = ConsensusDataProvider.reflMethod$Method19(qual19.getClass()).invoke((Object)qual19, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        int slotNumber = TimeToEpochUtils$.MODULE$.timeStampToSlotNumber(((NetworkParams)object).sidechainGenesisBlockTimestamp(), blockHeader.timestamp());
        byte[] vrfMessage = package$.MODULE$.buildVrfMessage(slotNumber, nonceConsensusEpochInfo);
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(blockHeader.vrfProof().proofToVrfOutput(blockHeader.forgingStakeInfo().vrfPublicKey(), vrfMessage)));
    }

    public static /* synthetic */ boolean $anonfun$createNonceMessageDigest$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static /* synthetic */ void $anonfun$createNonceMessageDigest$2(int eligibleSlotsRangeStart$1, int eligibleSlotsRangeEnd$1, MessageDigest digest$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            VrfOutput vrfOutput = (VrfOutput)tuple2._1();
            int slotNumber = BoxesRunTime.unboxToInt((Object)tuple2._2());
            if (slotNumber >= eligibleSlotsRangeStart$1 && slotNumber <= eligibleSlotsRangeEnd$1) {
                digest$1.update(vrfOutput.bytes());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static void $init$(ConsensusDataProvider $this) {
    }
}

