/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.evm.Address;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ChaChaPrngSecureRandom;
import io.horizen.utils.Pair;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Arrays;
import org.web3j.crypto.ContractUtils;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;
import sparkz.crypto.hash.Keccak256;

public final class Secp256k1 {
    private static final int COORD_SIZE = 32;
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 64;
    public static final int SIGNATURE_RS_SIZE = 32;
    public static final int CHAIN_ID_INC = 35;
    public static final int LOWER_REAL_V = 27;
    public static final int REAL_V_REPLAY_PROTECTED = 35;

    private Secp256k1() {
    }

    public static Pair<byte[], byte[]> createKeyPair(byte[] seed) {
        try {
            SecureRandom rnd = ChaChaPrngSecureRandom.getInstance(seed);
            ECKeyPair keyPair = Keys.createEcKeyPair((SecureRandom)rnd);
            byte[] privateKey = Numeric.toBytesPadded((BigInteger)keyPair.getPrivateKey(), (int)32);
            byte[] publicKey = Numeric.toBytesPadded((BigInteger)keyPair.getPublicKey(), (int)64);
            return new Pair<byte[], byte[]>(privateKey, publicKey);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            return null;
        }
    }

    public static byte[] signedMessageToAddress(byte[] message, BigInteger v, BigInteger r, BigInteger s) throws SignatureException {
        byte[] v_barr = BigIntegerUInt256.getUnsignedByteArray(v);
        byte[] r_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(r), 32);
        byte[] s_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(s), 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v_barr, r_barr, s_barr);
        BigInteger pubKey = Sign.signedMessageToKey((byte[])message, (Sign.SignatureData)signatureData);
        return Secp256k1.getAddress(Numeric.toBytesPadded((BigInteger)pubKey, (int)64));
    }

    public static boolean verify(byte[] message, BigInteger v, BigInteger r, BigInteger s, byte[] address) {
        try {
            byte[] signingAddress = Secp256k1.signedMessageToAddress(message, v, r, s);
            return Arrays.equals(signingAddress, address);
        }
        catch (SignatureException e) {
            return false;
        }
    }

    public static Signature sign(byte[] privateKey, byte[] message) {
        ECKeyPair keyPair = ECKeyPair.create((byte[])privateKey);
        Sign.SignatureData signatureData = Sign.signMessage((byte[])message, (ECKeyPair)keyPair, (boolean)true);
        return new Signature(signatureData.getV(), signatureData.getR(), signatureData.getS());
    }

    public static byte[] getPublicKey(byte[] privateKey) {
        return Numeric.toBytesPadded((BigInteger)ECKeyPair.create((byte[])privateKey).getPublicKey(), (int)64);
    }

    public static byte[] getAddress(byte[] publicKey) {
        byte[] hashedKey = Keccak256.hash((byte[])publicKey);
        return Arrays.copyOfRange(hashedKey, hashedKey.length - 20, hashedKey.length);
    }

    public static String checksumAddress(byte[] address) {
        return Keys.toChecksumAddress((String)Numeric.toHexString((byte[])address));
    }

    public static Address generateContractAddress(Address from, BigInteger nonce) {
        return new Address(ContractUtils.generateContractAddress((byte[])from.toBytes(), (BigInteger)nonce));
    }

    public static class Signature {
        public final BigInteger v;
        public final BigInteger r;
        public final BigInteger s;

        public Signature(byte[] v, byte[] r, byte[] s) {
            this.v = new BigInteger(1, v);
            this.r = new BigInteger(1, r);
            this.s = new BigInteger(1, s);
        }
    }
}

