/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Optional;
import org.web3j.utils.Numeric;

public final class EthereumTransactionUtils {
    private EthereumTransactionUtils() {
    }

    public static byte[] convertToBytes(long x) {
        BigInteger v = BigInteger.valueOf(x);
        return BigIntegerUInt256.getUnsignedByteArray(v);
    }

    public static long convertToLong(BigInteger val) {
        return val.longValueExact();
    }

    public static BigInteger getRealV(BigInteger bv) {
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return bv;
        }
        int inc = 0;
        if ((int)v % 2 == 0) {
            inc = 1;
        }
        return BigInteger.valueOf(27 + inc);
    }

    public static Optional<AddressProposition> getToAddressFromString(String toString) {
        if (toString == null) {
            return Optional.empty();
        }
        String toClean = Numeric.cleanHexPrefix((String)toString);
        if (toClean.isEmpty()) {
            return Optional.empty();
        }
        byte[] toBytes = BytesUtils.fromHexString(toClean);
        if (toBytes.length == 0) {
            throw new IllegalArgumentException("Invalid input to string: " + toString);
        }
        return Optional.of(new AddressProposition(toBytes));
    }

    public static Optional<AddressProposition> getToAddressFromBytes(byte[] addressBytes) {
        if (addressBytes == null) {
            return Optional.empty();
        }
        if (addressBytes.length == 0) {
            return Optional.empty();
        }
        return Optional.of(new AddressProposition(addressBytes));
    }

    public static byte[] getDataFromString(String dataString) {
        if (dataString == null) {
            return new byte[0];
        }
        String dataStringClean = Numeric.cleanHexPrefix((String)dataString);
        if (dataStringClean.isEmpty()) {
            return new byte[0];
        }
        byte[] dataBytes = BytesUtils.fromHexString(dataStringClean);
        if (dataBytes.length == 0) {
            throw new IllegalArgumentException("Invalid input to string: " + dataString);
        }
        return dataBytes;
    }
}

