/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import akka.util.ByteString;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.proposition.AddressPropositionSerializer;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.BigIntegerUInt256;
import java.math.BigInteger;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.util.Try;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Serializer;
import sparkz.util.serialization.Writer;

public final class AccountPaymentSerializer$
implements SparkzSerializer<AccountPayment> {
    public static AccountPaymentSerializer$ MODULE$;

    static {
        new AccountPaymentSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return SparkzSerializer.toByteString$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return SparkzSerializer.parseByteString$((SparkzSerializer)this, (ByteString)byteString);
    }

    public Try<AccountPayment> parseByteStringTry(ByteString byteString) {
        return SparkzSerializer.parseByteStringTry$((SparkzSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return SparkzSerializer.toBytes$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return SparkzSerializer.parseBytes$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountPayment> parseBytesTry(byte[] bytes) {
        return SparkzSerializer.parseBytesTry$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<AccountPayment> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public final int SERIALIZATION_FORMAT_1_4_FLAG() {
        return -1;
    }

    public void serialize(AccountPayment obj, Writer w) {
        AddressPropositionSerializer.getSerializer().serialize(obj.address(), w);
        if (obj.valueFromMainchain().isDefined() && obj.valueFromFees().isDefined()) {
            w.putInt(-1);
            w.putInt(obj.value().toByteArray().length);
            w.putBytes(obj.value().toByteArray());
            w.putInt(((BigInteger)obj.valueFromMainchain().get()).toByteArray().length);
            w.putBytes(((BigInteger)obj.valueFromMainchain().get()).toByteArray());
            w.putInt(((BigInteger)obj.valueFromFees().get()).toByteArray().length);
            w.putBytes(((BigInteger)obj.valueFromFees().get()).toByteArray());
        } else {
            w.putInt(obj.value().toByteArray().length);
            w.putBytes(obj.value().toByteArray());
        }
    }

    public AccountPayment parse(Reader r) {
        AccountPayment accountPayment;
        AddressProposition address = AddressPropositionSerializer.getSerializer().parse(r);
        int valueLength = r.getInt();
        if (valueLength == -1) {
            int valueLength2 = r.getInt();
            BigInteger value = new BigIntegerUInt256(r.getBytes(valueLength2)).getBigInt();
            int valueFromMainchainLength = r.getInt();
            BigInteger valueFromMainchain = new BigIntegerUInt256(r.getBytes(valueFromMainchainLength)).getBigInt();
            int valueFromFeesLength = r.getInt();
            BigInteger valueFromFees = new BigIntegerUInt256(r.getBytes(valueFromFeesLength)).getBigInt();
            accountPayment = new AccountPayment(address, value, (Option<BigInteger>)new Some((Object)valueFromMainchain), (Option<BigInteger>)new Some((Object)valueFromFees));
        } else {
            BigInteger value = new BigIntegerUInt256(r.getBytes(valueLength)).getBigInt();
            accountPayment = new AccountPayment(address, value, (Option<BigInteger>)None$.MODULE$, (Option<BigInteger>)None$.MODULE$);
        }
        return accountPayment;
    }

    private AccountPaymentSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        SparkzSerializer.$init$((SparkzSerializer)this);
    }
}

