/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.network.ForgerInfo;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.ForgerStakeV2MsgProcessor$;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.ForgerIdentifier;
import io.horizen.account.utils.ForgerPayment;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.StateDB;
import io.horizen.evm.TrieHasher;
import io.horizen.params.NetworkParams;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AccountFeePaymentsUtils$ {
    public static AccountFeePaymentsUtils$ MODULE$;
    private final byte[] DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH;
    private final BigInteger MC_DISTRIBUTION_CAP_DIVIDER;
    private final BigInteger TOTAL_SHARE;

    static {
        new AccountFeePaymentsUtils$();
    }

    public byte[] DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH() {
        return this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH;
    }

    public BigInteger MC_DISTRIBUTION_CAP_DIVIDER() {
        return this.MC_DISTRIBUTION_CAP_DIVIDER;
    }

    public BigInteger TOTAL_SHARE() {
        return this.TOTAL_SHARE;
    }

    public byte[] calculateFeePaymentsHash(Seq<AccountPayment> feePayments) {
        return feePayments.isEmpty() ? this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH() : TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)feePayments.map((Function1 & Serializable & scala.Serializable)payment -> payment.bytes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
    }

    public Seq<ForgerPayment> getForgersRewards(Seq<AccountBlockFeeInfo> blockFeeInfoSeq, Map<ForgerIdentifier, BigInteger> mcForgerPoolRewards) {
        if (blockFeeInfoSeq.isEmpty()) {
            return ((TraversableOnce)mcForgerPoolRewards.map((Function1 & Serializable & scala.Serializable)reward -> new ForgerPayment((ForgerIdentifier)reward._1(), (BigInteger)reward._2(), (BigInteger)reward._2()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        ObjectRef poolFee = ObjectRef.create((Object)BigInteger.ZERO);
        Seq forgersBlockRewards = (Seq)blockFeeInfoSeq.map((Function1 & Serializable & scala.Serializable)feeInfo -> {
            poolFee$1.elem = ((BigInteger)poolFee$1.elem).add(feeInfo.baseFee());
            ForgerIdentifier forgerIdentifier = new ForgerIdentifier(feeInfo.forgerAddress(), feeInfo.forgerKeys());
            return new ForgerPayment(forgerIdentifier, feeInfo.forgerTips(), BigInteger.ZERO);
        }, Seq$.MODULE$.canBuildFrom());
        BigInteger[] divAndRem = ((BigInteger)poolFee.elem).divideAndRemainder(BigInteger.valueOf(forgersBlockRewards.size()));
        BigInteger forgerPoolFee = divAndRem[0];
        long rest = divAndRem[1].longValueExact();
        Seq allForgersRewards = (Seq)((TraversableLike)forgersBlockRewards.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int index;
            ForgerPayment forgerBlockReward;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    forgerBlockReward = (ForgerPayment)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    if (forgerBlockReward != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            ForgerPayment forgerPayment = forgerBlockReward;
            int n = index;
            BigInteger finalForgerFee = forgerPayment.value().add(forgerPoolFee).add((long)n < rest ? BigInteger.ONE : BigInteger.ZERO);
            ForgerPayment forgerPayment2 = new ForgerPayment(forgerPayment.identifier(), finalForgerFee, BigInteger.ZERO);
            return forgerPayment2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq forgerKeys = (Seq)((SeqLike)((TraversableLike)allForgersRewards.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)mcForgerPoolRewards.keys(), Seq$.MODULE$.canBuildFrom())).distinct();
        return (Seq)forgerKeys.map((Function1 & Serializable & scala.Serializable)forgerKey -> {
            BigInteger forgerTotalFee = (BigInteger)((TraversableOnce)allForgersRewards.filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)forgerKey.equals(info.identifier())))).foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(sum, info) -> sum.add(info.value()));
            BigInteger mcForgerPoolReward = (BigInteger)mcForgerPoolRewards.getOrElse(forgerKey, (Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
            return new ForgerPayment((ForgerIdentifier)forgerKey, forgerTotalFee.add(mcForgerPoolReward), mcForgerPoolReward);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Map<ForgerIdentifier, BigInteger> getForgersRewards$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Tuple2<AccountPayment, Option<AccountFeePaymentsUtils.DelegatorFeePayment>> getForgerAndDelegatorShares(ForgerPayment feePayment, ForgerInfo forgerInfo) {
        AddressProposition forgerRewardAddress = feePayment.identifier().getAddress();
        BigInteger totalMcReward = feePayment.valueFromMainchain();
        if (forgerInfo.rewardShare() == 0) {
            BigInteger totalFeeReward = feePayment.value().subtract(totalMcReward);
            AccountPayment forgerPayment = new AccountPayment(forgerRewardAddress, feePayment.value(), (Option<BigInteger>)new Some((Object)totalMcReward), (Option<BigInteger>)new Some((Object)totalFeeReward));
            return new Tuple2((Object)forgerPayment, (Object)None$.MODULE$);
        }
        BigInteger delegatorShare = BigInteger.valueOf(forgerInfo.rewardShare());
        BigInteger delegatorReward = feePayment.value().multiply(delegatorShare).divide(this.TOTAL_SHARE());
        BigInteger delegatorMcReward = totalMcReward.multiply(delegatorShare).divide(this.TOTAL_SHARE());
        BigInteger delegatorFeeReward = delegatorReward.subtract(delegatorMcReward);
        BigInteger forgerReward = feePayment.value().subtract(delegatorReward);
        BigInteger forgerMcReward = totalMcReward.subtract(delegatorMcReward);
        BigInteger forgerFeeReward = forgerReward.subtract(forgerMcReward);
        AccountPayment forgerPayment = new AccountPayment(forgerRewardAddress, forgerReward, (Option<BigInteger>)new Some((Object)forgerMcReward), (Option<BigInteger>)new Some((Object)forgerFeeReward));
        AccountFeePaymentsUtils.DelegatorFeePayment delegatorPayment = new AccountFeePaymentsUtils.DelegatorFeePayment(new AccountPayment(forgerInfo.rewardAddress(), delegatorReward, (Option<BigInteger>)new Some((Object)delegatorMcReward), (Option<BigInteger>)new Some((Object)delegatorFeeReward)), forgerInfo.forgerPublicKeys());
        return new Tuple2((Object)forgerPayment, (Object)new Some((Object)delegatorPayment));
    }

    public Seq<AccountPayment> groupAllPaymentsByAddress(Seq<AccountPayment> feePayments, Seq<AccountFeePaymentsUtils.DelegatorFeePayment> delegatorPayments) {
        return ((TraversableOnce)((TraversableLike)feePayments.$plus$plus((GenTraversableOnce)delegatorPayments.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.feePayment(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.address()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AddressProposition address = (AddressProposition)tuple2._1();
            Seq payments = (Seq)tuple2._2();
            AccountPayment accountPayment = new AccountPayment(address, (BigInteger)((TraversableOnce)payments.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.value(), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(a, b) -> a.add((BigInteger)b)), (Option<BigInteger>)new Some(((TraversableOnce)payments.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.valueFromMainchain(), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(a, b) -> a.add((BigInteger)b.getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)))), (Option<BigInteger>)new Some(((TraversableOnce)payments.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.valueFromFees(), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(a, b) -> a.add((BigInteger)b.getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO)))));
            return accountPayment;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public BigInteger getMainchainWithdrawalEpochDistributionCap(long epochMaxHeight, NetworkParams params) {
        double baseReward = 1.25E9;
        int halvingInterval = params.mcHalvingInterval();
        int epochLength = params.withdrawalEpochLength();
        LongRef mcEpochRewardZennies = LongRef.create((long)0L);
        new RichLong(Predef$.MODULE$.longWrapper(epochMaxHeight - (long)epochLength)).until((Object)BoxesRunTime.boxToLong((long)epochMaxHeight)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)height -> {
            LongRef reward = LongRef.create((long)Predef$.MODULE$.double2Double(baseReward).longValue());
            long halvings = height / (long)halvingInterval;
            new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)halvings)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> reward$1.elem >>= 1);
            mcEpochRewardZennies$1.elem += reward.elem;
        });
        BigInteger mcEpochRewardWei = ZenWeiConverter$.MODULE$.convertZenniesToWei(mcEpochRewardZennies.elem);
        return mcEpochRewardWei.divide(this.getMcDistributionCapDivider());
    }

    private BigInteger getMcDistributionCapDivider() {
        return this.MC_DISTRIBUTION_CAP_DIVIDER();
    }

    private AccountFeePaymentsUtils$() {
        MODULE$ = this;
        this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH = StateDB.EMPTY_ROOT_HASH.toBytes();
        this.MC_DISTRIBUTION_CAP_DIVIDER = BigInteger.valueOf(10L);
        this.TOTAL_SHARE = BigInteger.valueOf(ForgerStakeV2MsgProcessor$.MODULE$.MAX_REWARD_SHARE());
    }
}

