/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state.receipt;

import akka.util.ByteString;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataLog$;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.evm.Address;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.Try;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Serializer;
import sparkz.util.serialization.Writer;

public final class EthereumReceiptSerializer$
implements SparkzSerializer<EthereumReceipt> {
    public static EthereumReceiptSerializer$ MODULE$;

    static {
        new EthereumReceiptSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return SparkzSerializer.toByteString$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return SparkzSerializer.parseByteString$((SparkzSerializer)this, (ByteString)byteString);
    }

    public Try<EthereumReceipt> parseByteStringTry(ByteString byteString) {
        return SparkzSerializer.parseByteStringTry$((SparkzSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return SparkzSerializer.toBytes$((SparkzSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return SparkzSerializer.parseBytes$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<EthereumReceipt> parseBytesTry(byte[] bytes) {
        return SparkzSerializer.parseBytesTry$((SparkzSerializer)this, (byte[])bytes);
    }

    public Try<EthereumReceipt> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public void serialize(EthereumReceipt receipt, Writer writer) {
        block0: {
            writer.putInt(receipt.consensusDataReceipt().transactionType());
            writer.putInt(receipt.consensusDataReceipt().status());
            byte[] cumGasUsedBytes = receipt.consensusDataReceipt().cumulativeGasUsed().toByteArray();
            writer.putInt(cumGasUsedBytes.length);
            writer.putBytes(cumGasUsedBytes);
            int numberOfLogs = receipt.consensusDataReceipt().logs().size();
            writer.putInt(numberOfLogs);
            receipt.consensusDataReceipt().logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
                EthereumConsensusDataLog$.MODULE$.serialize(log, writer);
                return BoxedUnit.UNIT;
            });
            writer.putBytes(receipt.transactionHash());
            writer.putInt(receipt.transactionIndex());
            writer.putBytes(receipt.blockHash());
            writer.putInt(receipt.blockNumber());
            byte[] gasUsedBytes = receipt.gasUsed().toByteArray();
            writer.putInt(gasUsedBytes.length);
            writer.putBytes(gasUsedBytes);
            byte[] addr = (byte[])receipt.contractAddress().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toBytes()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            writer.putInt(addr.length);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(addr)).nonEmpty()) break block0;
            writer.putBytes(addr);
        }
    }

    public EthereumReceipt parse(Reader reader) {
        int transactionType = reader.getInt();
        int status = reader.getInt();
        int cumGasUsedLength = reader.getInt();
        BigInteger cumGasUsed = new BigInteger(reader.getBytes(cumGasUsedLength));
        ListBuffer logs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int numberOfLogs = reader.getInt();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfLogs).foreach((Function1 & Serializable & scala.Serializable)_ -> logs.$plus$eq((Object)EthereumConsensusDataLog$.MODULE$.parse(reader)));
        EthereumConsensusDataReceipt receipt = new EthereumConsensusDataReceipt(transactionType, status, cumGasUsed, (Seq<EthereumConsensusDataLog>)logs);
        byte[] txHash = reader.getBytes(32);
        int txIndex = reader.getInt();
        byte[] blockHash = reader.getBytes(32);
        int blockNumber = reader.getInt();
        int gasUsedLength = reader.getInt();
        BigInteger gasUsed = new BigInteger(reader.getBytes(gasUsedLength));
        int contractAddressLength = reader.getInt();
        None$ contractAddress = contractAddressLength == 0 ? None$.MODULE$ : new Some((Object)new Address(reader.getBytes(contractAddressLength)));
        return new EthereumReceipt(receipt, txHash, txIndex, blockHash, blockNumber, gasUsed, (Option<Address>)contractAddress);
    }

    private EthereumReceiptSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        SparkzSerializer.$init$((SparkzSerializer)this);
    }
}

