/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state.nativescdata.forgerstakev2;

import io.horizen.account.network.ForgerInfo;
import io.horizen.account.network.ForgerInfoSerializer$;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.nativescdata.forgerstakev2.ForgerMap$ListOfForgers$;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersListResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage$;
import io.horizen.evm.Address;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ForgerMap$ {
    public static ForgerMap$ MODULE$;

    static {
        new ForgerMap$();
    }

    public boolean existsForger(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey) {
        byte[] forgerData = view.getAccountStorage(StakeStorage$.MODULE$.ACCOUNT(), forgerKey.bytes());
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(forgerData)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    public void addForger(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, int rewardShare, Address rewardAddress) {
        ForgerMap$ListOfForgers$.MODULE$.addForgerKey(view, forgerKey);
        ForgerInfo forgerStakeData = new ForgerInfo(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), rewardShare, new AddressProposition(rewardAddress));
        view.updateAccountStorageBytes(StakeStorage$.MODULE$.ACCOUNT(), forgerKey.bytes(), ForgerInfoSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    public void updateForger(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, int rewardShare, Address rewardAddress) {
        ForgerInfo forgerStakeData = new ForgerInfo(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), rewardShare, new AddressProposition(rewardAddress));
        view.updateAccountStorageBytes(StakeStorage$.MODULE$.ACCOUNT(), forgerKey.bytes(), ForgerInfoSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    public int getSize(BaseAccountStateView view) {
        return ForgerMap$ListOfForgers$.MODULE$.getSize(view);
    }

    public Seq<StakeStorage.ForgerKey> getForgerKeys(BaseAccountStateView view) {
        int listSize = this.getSize(view);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), listSize).map((Function1 & Serializable & scala.Serializable)index -> ForgerMap$ListOfForgers$.MODULE$.getForgerKey(view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<ForgerInfo> getForgerOption(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey) {
        return this.existsForger(view, forgerKey) ? new Some(ForgerInfoSerializer$.MODULE$.parseBytes(view.getAccountStorageBytes(StakeStorage$.MODULE$.ACCOUNT(), forgerKey.bytes()))) : None$.MODULE$;
    }

    public ForgerInfo getForger(BaseAccountStateView view, StakeStorage.ForgerKey forgerKey) {
        return (ForgerInfo)ForgerInfoSerializer$.MODULE$.parseBytes(view.getAccountStorageBytes(StakeStorage$.MODULE$.ACCOUNT(), forgerKey.bytes()));
    }

    public PagedForgersListResponse getPagedListOfForgers(BaseAccountStateView view, int startPos, int pageSize) {
        if (startPos < 0) {
            throw new ExecutionRevertedException(new StringBuilder(44).append("Invalid startPos input: ").append(startPos).append(" can not be negative").toString());
        }
        if (pageSize <= 0) {
            throw new ExecutionRevertedException(new StringBuilder(36).append("Invalid page size ").append(pageSize).append(", must be positive").toString());
        }
        int listSize = this.getSize(view);
        if (startPos == 0 && listSize == 0) {
            return new PagedForgersListResponse(-1, (Seq<ForgerInfo>)((Seq)Nil$.MODULE$));
        }
        if (startPos > listSize - 1) {
            throw new ExecutionRevertedException(new StringBuilder(38).append("Invalid start position: ").append(startPos).append(", array size: ").append(listSize).toString());
        }
        int endPos = startPos + pageSize;
        if (endPos > listSize) {
            endPos = listSize;
        }
        IndexedSeq listOfElems = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPos), endPos).map((Function1 & Serializable & scala.Serializable)index -> ForgerMap$.$anonfun$getPagedListOfForgers$1(view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        if (endPos == listSize) {
            endPos = -1;
        }
        return new PagedForgersListResponse(endPos, (Seq<ForgerInfo>)listOfElems);
    }

    public static final /* synthetic */ ForgerInfo $anonfun$getPagedListOfForgers$1(BaseAccountStateView view$8, int index) {
        StakeStorage.ForgerKey currentKey = ForgerMap$ListOfForgers$.MODULE$.getForgerKey(view$8, index);
        return MODULE$.getForger(view$8, currentKey);
    }

    private ForgerMap$() {
        MODULE$ = this;
    }
}

