/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.fork.Version1_3_0Fork$;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.FeeCapTooLowException;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.InsufficientFundsException;
import io.horizen.account.state.IntrinsicGasException;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.Invocation$;
import io.horizen.account.state.MaxInitCodeSizeExceededException;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceMaxException;
import io.horizen.account.state.NonceTooHighException;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.ProtocolParams$;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.WriteProtectionException;
import io.horizen.account.storage.MsgProcessorMetadataStorageReader;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.evm.Address;
import io.horizen.evm.EvmContext;
import io.horizen.evm.ForkRules;
import io.horizen.evm.Tracer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0011!\t\u0006A!A!\u0002\u0013q\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011A*\t\u0011]\u0003!\u0011!Q\u0001\nQC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019)\b\u0001)A\u0005U\"9a\u000f\u0001b\u0001\n\u00139\bbBA\u0002\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0001\u0003\u000fA\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\t\u0011\u0005u\u0001\u0001)Q\u0005\u0003\u0013Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003[\u0002A\u0011BA8\u0005=\u0019F/\u0019;f)J\fgn]5uS>t'BA\r\u001b\u0003\u0015\u0019H/\u0019;f\u0015\tYB$A\u0004bG\u000e|WO\u001c;\u000b\u0005uq\u0012a\u00025pe&TXM\u001c\u0006\u0002?\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001!\u0005\u000b\u0019\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIc&D\u0001+\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\rM\u0004\u0018M]6{\u0013\ty#FA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003cIj\u0011\u0001G\u0005\u0003ga\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\tYLWm\u001e\t\u0003cYJ!a\u000e\r\u0003/M#\u0018\r^3EE\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<\u0018!E7fgN\fw-\u001a)s_\u000e,7o]8sgB\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 !\u0003\u0019a$o\\8u}%\tQ%\u0003\u0002BI\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003\u0012\u0002\"!\r$\n\u0005\u001dC\"\u0001E'fgN\fw-\u001a)s_\u000e,7o]8s\u00031\u0011Gn\\2l\u000f\u0006\u001c\bk\\8m!\t\t$*\u0003\u0002L1\t9q)Y:Q_>d\u0017\u0001\u00042m_\u000e\\7i\u001c8uKb$X#\u0001(\u0011\u0005Ez\u0015B\u0001)\u0019\u00051\u0011En\\2l\u0007>tG/\u001a=u\u00035\u0011Gn\\2l\u0007>tG/\u001a=uA\u0005\u0019Qn]4\u0016\u0003Q\u0003\"!M+\n\u0005YC\"aB'fgN\fw-Z\u0001\u0005[N<\u0007%\u0001\u0005nKR\fG-\u0019;b!\tQV,D\u0001\\\u0015\ta&$A\u0004ti>\u0014\u0018mZ3\n\u0005y[&!I'tOB\u0013xnY3tg>\u0014X*\u001a;bI\u0006$\u0018m\u0015;pe\u0006<WMU3bI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0004bE\u000e$WMZ4\u0011\u0005E\u0002\u0001\"\u0002\u001b\n\u0001\u0004)\u0004\"\u0002\u001d\n\u0001\u0004I\u0004\"\u0002%\n\u0001\u0004I\u0005\"\u0002'\n\u0001\u0004q\u0005\"\u0002*\n\u0001\u0004!\u0006\"\u0002-\n\u0001\u0004I\u0016aD5om>\u001c\u0017\r^5p]N#\u0018mY6\u0016\u0003)\u00042a\u001b9s\u001b\u0005a'BA7o\u0003\u001diW\u000f^1cY\u0016T!a\u001c\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002rY\nQA*[:u\u0005V4g-\u001a:\u0011\u0005E\u001a\u0018B\u0001;\u0019\u0005)IeN^8dCRLwN\\\u0001\u0011S:4xnY1uS>t7\u000b^1dW\u0002\na\u0001\u001e:bG\u0016\u0014X#\u0001=\u0011\u0007\rJ80\u0003\u0002{I\t1q\n\u001d;j_:\u0004\"\u0001`@\u000e\u0003uT!A \u000f\u0002\u0007\u00154X.C\u0002\u0002\u0002u\u0014a\u0001\u0016:bG\u0016\u0014\u0018a\u0002;sC\u000e,'\u000fI\u0001\u0006I\u0016\u0004H\u000f[\u000b\u0003\u0003\u0013\u00012aIA\u0006\u0013\r\ti\u0001\n\u0002\u0004\u0013:$\u0018!\u00033faRDw\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007\r\n)\"C\u0002\u0002\u0018\u0011\u0012A!\u00168ji\"I\u00111D\b\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\n\u0014A\u00023faRD\u0007%\u0001\u0006ue\u0006t7/\u001b;j_:$\"!a\t\u0011\u000b\r\n)#!\u000b\n\u0007\u0005\u001dBEA\u0003BeJ\f\u0017\u0010E\u0002$\u0003WI1!!\f%\u0005\u0011\u0011\u0015\u0010^3)\u000bE\t\t$!\u0010\u0011\u000b\r\n\u0019$a\u000e\n\u0007\u0005UBE\u0001\u0004uQJ|wo\u001d\t\u0004c\u0005e\u0012bAA\u001e1\tAR\t_3dkRLwN\u001c$bS2,G-\u0012=dKB$\u0018n\u001c8$\u0005\u0005]\u0002&B\t\u0002B\u0005%\u0003#B\u0012\u00024\u0005\r\u0003cA\u0019\u0002F%\u0019\u0011q\t\r\u0003/%sg/\u00197jI6+7o]1hK\u0016C8-\u001a9uS>t7EAA\"\u0003!\u0001(/Z\"iK\u000e\\G\u0003BA\n\u0003\u001fBQA\u0015\nA\u0002Q\u000baAY;z\u000f\u0006\u001cHcA%\u0002V!)!k\u0005a\u0001)\u0006I!/\u001a4v]\u0012<\u0015m\u001d\u000b\u0007\u0003'\tY&!\u0018\t\u000bI#\u0002\u0019\u0001+\t\r\u0005}C\u00031\u0001J\u0003\r9\u0017m]\u0001\bKb,7-\u001e;f)\u0011\t\u0019#!\u001a\t\r\u0005\u001dT\u00031\u0001s\u0003)IgN^8dCRLwN\u001c\u0015\u0006+\u0005E\u0012Q\b\u0015\u0006+\u0005\u0005\u0013\u0011J\u0001\u0007S:4xn[3\u0015\r\u0005\r\u0012\u0011OA;\u0011\u0019\t\u0019H\u0006a\u0001\u000b\u0006I\u0001O]8dKN\u001cxN\u001d\u0005\u0007\u0003O2\u0002\u0019\u0001:")
public class StateTransition
implements SparkzLogging,
ExecutionContext {
    private final StateDbAccountStateView view;
    private final Seq<MessageProcessor> messageProcessors;
    private final GasPool blockGasPool;
    private final BlockContext blockContext;
    private final Message msg;
    private final MsgProcessorMetadataStorageReader metadata;
    private final ListBuffer<Invocation> invocationStack;
    private final Option<Tracer> tracer;
    private int depth;
    private final Logger logger;

    @Override
    public byte[] executeDepth(Invocation invocation, int additionalDepth) throws InvalidMessageException, ExecutionFailedException {
        return ExecutionContext.executeDepth$(this, invocation, additionalDepth);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BlockContext blockContext() {
        return this.blockContext;
    }

    @Override
    public Message msg() {
        return this.msg;
    }

    private ListBuffer<Invocation> invocationStack() {
        return this.invocationStack;
    }

    private Option<Tracer> tracer() {
        return this.tracer;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    public byte[] transition() throws InvalidMessageException, ExecutionFailedException {
        byte[] byArray;
        this.preCheck(this.msg());
        BigInteger initialBlockGas = this.blockGasPool.getGas();
        int rollback = this.view.snapshot();
        boolean skipRefund = false;
        GasPool gasPool = this.buyGas(this.msg());
        this.tracer().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.CaptureTxStart(gasPool.initialGas());
            return BoxedUnit.UNIT;
        });
        try {
            try {
                boolean isShanghaiActive = Version1_3_0Fork$.MODULE$.get(this.blockContext().consensusEpochNumber).active();
                BigInteger intrinsicGas = GasUtil$.MODULE$.intrinsicGas(this.msg().getData(), this.msg().getTo().isEmpty(), isShanghaiActive);
                if (gasPool.getGas().compareTo(intrinsicGas) < 0) {
                    throw new IntrinsicGasException(gasPool.getGas(), intrinsicGas);
                }
                gasPool.subGas(intrinsicGas);
                if (isShanghaiActive && this.msg().getTo().isEmpty() && this.msg().getData().length > ProtocolParams$.MODULE$.MaxInitCodeSize()) {
                    throw new MaxInitCodeSizeExceededException(this.msg().getData().length, ProtocolParams$.MODULE$.MaxInitCodeSize());
                }
                this.view.setupAccessList(this.msg(), this.blockContext().forgerAddress, new ForkRules(isShanghaiActive));
                this.view.increaseNonce(this.msg().getFrom());
                byArray = this.execute(Invocation$.MODULE$.fromMessage(this.msg(), gasPool));
            }
            catch (ExecutionFailedException err) {
                throw err;
            }
            catch (Exception err) {
                skipRefund = true;
                this.view.revertToSnapshot(rollback);
                this.blockGasPool.addGas(initialBlockGas.subtract(this.blockGasPool.getGas()));
                throw err;
            }
        }
        finally {
            if (!skipRefund) {
                this.refundGas(this.msg(), gasPool);
            }
            this.tracer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.CaptureTxEnd(gasPool.getGas());
                return BoxedUnit.UNIT;
            });
        }
        return byArray;
    }

    private void preCheck(Message msg) {
        Address sender = msg.getFrom();
        if (!msg.getIsFakeMsg()) {
            BigInteger stateNonce = this.view.getNonce(sender);
            int n = msg.getNonce().compareTo(stateNonce);
            switch (n) {
                default: 
            }
            if (n < 0) {
                throw new NonceTooLowException(sender, msg.getNonce(), stateNonce);
            }
            if (n > 0) {
                throw new NonceTooHighException(sender, msg.getNonce(), stateNonce);
            }
            if (!BigIntegerUtil$.MODULE$.isUint64(stateNonce.add(BigInteger.ONE))) {
                throw new NonceMaxException(sender, stateNonce);
            }
            if (!this.view.isEoaAccount(sender)) {
                throw new SenderNotEoaException(sender, this.view.getCodeHash(sender));
            }
        }
        if (!(msg.getIsFakeMsg() && msg.getGasFeeCap().bitLength() <= 0 || msg.getGasFeeCap().compareTo(this.blockContext().baseFee) >= 0)) {
            throw new FeeCapTooLowException(sender, msg.getGasFeeCap(), this.blockContext().baseFee);
        }
    }

    private GasPool buyGas(Message msg) {
        BigInteger want;
        BigInteger gas = msg.getGasLimit();
        BigInteger effectiveFees = gas.multiply(msg.getGasPrice());
        BigInteger maxFees = msg.getGasFeeCap() == null ? effectiveFees : gas.multiply(msg.getGasFeeCap());
        Address sender = msg.getFrom();
        BigInteger have = this.view.getBalance(sender);
        if (have.compareTo(want = maxFees.add(msg.getValue())) < 0) {
            throw new InsufficientFundsException(sender, have, want);
        }
        if (this.blockGasPool.getGas().compareTo(gas) < 0) {
            throw new GasLimitReached();
        }
        this.blockGasPool.subGas(gas);
        this.view.subBalance(sender, effectiveFees);
        return new GasPool(gas);
    }

    private void refundGas(Message msg, GasPool gas) {
        gas.addGas(this.view.getRefund().min(gas.getUsedGas().divide(GasUtil$.MODULE$.RefundQuotientEIP3529())));
        BigInteger remaining = gas.getGas().multiply(msg.getGasPrice());
        this.view.addBalance(msg.getFrom(), remaining);
        this.blockGasPool.addGas(gas.getGas());
    }

    @Override
    public byte[] execute(Invocation invocation) throws InvalidMessageException, ExecutionFailedException {
        byte[] byArray;
        boolean firstReadOnlyInvocation;
        if (this.depth() > 1024) {
            throw new ExecutionRevertedException("max call depth exceeded");
        }
        Option callerGas = this.invocationStack().headOption().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.gasPool());
        callerGas.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.subGas(invocation.gasPool().getGas());
            return BoxedUnit.UNIT;
        });
        boolean bl = firstReadOnlyInvocation = invocation.readOnly() && !this.view.readOnly();
        if (firstReadOnlyInvocation) {
            this.view.enableWriteProtection();
        }
        try {
            if (invocation.readOnly() && invocation.value().signum() != 0) {
                throw new WriteProtectionException("invalid value transfer during read-only invocation");
            }
            Option option = this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.canProcess(invocation, this.view, this.blockContext().consensusEpochNumber)));
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("No message processor found for invocation: {}", new Object[]{invocation});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException("Unable to execute invocation.");
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            MessageProcessor processor = (MessageProcessor)some.value();
            byte[] byArray2 = this.invoke(processor, invocation);
            byArray = byArray2;
        }
        finally {
            if (firstReadOnlyInvocation) {
                this.view.disableWriteProtection();
            }
            callerGas.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.addGas(invocation.gasPool().getGas());
                return BoxedUnit.UNIT;
            });
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] invoke(MessageProcessor processor, Invocation invocation) {
        block5: {
            if (!processor.customTracing()) {
                this.tracer().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invoke$1$adapted(io.horizen.account.state.StateTransition io.horizen.account.state.Invocation io.horizen.evm.Tracer ), (Lio/horizen/evm/Tracer;)Ljava/lang/Object;)((StateTransition)this, (Invocation)invocation));
            }
            this.invocationStack().prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Invocation[]{invocation}));
            this.depth_$eq(this.depth() + 1);
            revert = this.view.snapshot();
            result = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$invoke$2(io.horizen.account.state.StateTransition io.horizen.account.state.MessageProcessor io.horizen.account.state.Invocation ), ()[B)((StateTransition)this, (MessageProcessor)processor, (Invocation)invocation));
            var6_5 = false;
            var7_6 = null;
            var8_7 = result;
            if (!(var8_7 instanceof Failure)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Failure)var8_7;
            if (var7_6.exception() instanceof ExecutionRevertedException) {
                this.view.revertToSnapshot(revert);
                var3_8 = BoxedUnit.UNIT;
            } else if (var6_5 && var7_6.exception() instanceof ExecutionFailedException) {
                this.view.revertToSnapshot(revert);
                invocation.gasPool().subGas(invocation.gasPool().getGas());
                var3_9 = BoxedUnit.UNIT;
            } else {
                var3_10 = BoxedUnit.UNIT;
            }
            this.depth_$eq(this.depth() - 1);
            this.invocationStack().remove(0);
            if (processor.customTracing()) break block5;
            this.tracer().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invoke$3$adapted(io.horizen.account.state.StateTransition scala.util.Try io.horizen.account.state.Invocation io.horizen.evm.Tracer ), (Lio/horizen/evm/Tracer;)Ljava/lang/Object;)((StateTransition)this, (Try)result, (Invocation)invocation));
        }
        return (byte[])result.get();
    }

    public static final /* synthetic */ void $anonfun$invoke$1(StateTransition $this, Invocation invocation$2, Tracer tracer) {
        if ($this.depth() == 0) {
            EvmContext context = new EvmContext(BigInteger.valueOf($this.blockContext().chainID), $this.blockContext().forgerAddress, $this.blockContext().blockGasLimit, $this.msg().getGasPrice(), BigInteger.valueOf($this.blockContext().blockNumber), BigInteger.valueOf($this.blockContext().timestamp), $this.blockContext().baseFee, $this.blockContext().random, new ForkRules(Version1_3_0Fork$.MODULE$.get($this.blockContext().consensusEpochNumber).active()));
            tracer.CaptureStart($this.view.getStateDbHandle(), context, invocation$2.caller(), (Address)invocation$2.callee().orNull(Predef$.MODULE$.$conforms()), invocation$2.callee().isEmpty(), invocation$2.input(), invocation$2.gasPool().initialGas(), invocation$2.value());
        } else {
            tracer.CaptureEnter(invocation$2.guessOpCode(), invocation$2.caller(), (Address)invocation$2.callee().orNull(Predef$.MODULE$.$conforms()), invocation$2.input(), invocation$2.gasPool().initialGas(), invocation$2.value());
        }
    }

    public static final /* synthetic */ byte[] $anonfun$invoke$2(StateTransition $this, MessageProcessor processor$1, Invocation invocation$2) {
        return processor$1.process(invocation$2, $this.view, $this.metadata, $this);
    }

    public static final /* synthetic */ void $anonfun$invoke$3(StateTransition $this, Try result$1, Invocation invocation$2, Tracer tracer) {
        String string;
        byte[] byArray;
        Failure failure;
        Throwable err;
        Try try_ = result$1;
        if (try_ instanceof Failure && (err = (failure = (Failure)try_).exception()) instanceof ExecutionRevertedException) {
            ExecutionRevertedException executionRevertedException = (ExecutionRevertedException)err;
            byArray = executionRevertedException.returnData;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] value = (byte[])success.value();
            byArray = value;
        } else {
            byArray = Array$.MODULE$.emptyByteArray();
        }
        byte[] output = byArray;
        Try try_2 = result$1;
        if (try_2 instanceof Failure) {
            Failure failure2 = (Failure)try_2;
            Throwable exception = failure2.exception();
            string = exception.getMessage();
        } else {
            string = "";
        }
        String error = string;
        if ($this.depth() == 0) {
            tracer.CaptureEnd(output, invocation$2.gasPool().getUsedGas(), error);
        } else {
            tracer.CaptureExit(output, invocation$2.gasPool().getUsedGas(), error);
        }
    }

    public StateTransition(StateDbAccountStateView view, Seq<MessageProcessor> messageProcessors, GasPool blockGasPool, BlockContext blockContext, Message msg, MsgProcessorMetadataStorageReader metadata) {
        this.view = view;
        this.messageProcessors = messageProcessors;
        this.blockGasPool = blockGasPool;
        this.blockContext = blockContext;
        this.msg = msg;
        this.metadata = metadata;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        ExecutionContext.$init$(this);
        this.invocationStack = new ListBuffer();
        this.tracer = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(blockContext.getTracer()));
        this.depth = 0;
    }

    public static final /* synthetic */ Object $anonfun$invoke$1$adapted(StateTransition $this, Invocation invocation$2, Tracer tracer) {
        StateTransition.$anonfun$invoke$1($this, invocation$2, tracer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$invoke$3$adapted(StateTransition $this, Try result$1, Invocation invocation$2, Tracer tracer) {
        StateTransition.$anonfun$invoke$3($this, result$1, invocation$2, tracer);
        return BoxedUnit.UNIT;
    }
}

