/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.events.EthereumEvent;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!\u0002\t\u0012\u0003\u0003Q\u0002\"B\u0018\u0001\t\u0003\u0001\u0004b\u0002\u001a\u0001\u0005\u00045\ta\r\u0005\bu\u0001\u0011\rQ\"\u0001<\u0011!)\u0005\u0001#b\u0001\n\u0003Y\u0004\"\u0002$\u0001\t\u0003:\u0005bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002B\u0001!\t!a\u0011\b\u000f\u0005\u001d\u0013\u0003#\u0001\u0002J\u00191\u0001#\u0005E\u0001\u0003\u0017Baa\f\u0007\u0005\u0002\u0005M\u0003\u0002CA+\u0019\t\u0007I\u0011A\u001e\t\u000f\u0005]C\u0002)A\u0005y\tyb*\u0019;jm\u0016\u001cV.\u0019:u\u0007>tGO]1di6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005I\u0019\u0012!B:uCR,'B\u0001\u000b\u0016\u0003\u001d\t7mY8v]RT!AF\f\u0002\u000f!|'/\u001b>f]*\t\u0001$\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u001cG\u001d\u0002\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\t1\fgn\u001a\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0004PE*,7\r\u001e\t\u0003I\u0015j\u0011!E\u0005\u0003ME\u0011\u0001#T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001B;uS2T\u0011\u0001L\u0001\u0007gB\f'o\u001b>\n\u00059J#!D*qCJ\\'\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011A\u0005A\u0001\u0010G>tGO]1di\u0006#GM]3tgV\tA\u0007\u0005\u00026q5\taG\u0003\u00028+\u0005\u0019QM^7\n\u0005e2$aB!eIJ,7o]\u0001\rG>tGO]1di\u000e{G-Z\u000b\u0002yA\u0019Q\b\u0011\"\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012Q!\u0011:sCf\u0004\"!P\"\n\u0005\u0011s$\u0001\u0002\"zi\u0016\f\u0001cY8oiJ\f7\r^\"pI\u0016D\u0015m\u001d5\u0002\t%t\u0017\u000e\u001e\u000b\u0004\u0011.\u0003\u0006CA\u001fJ\u0013\tQeH\u0001\u0003V]&$\b\"\u0002'\u0006\u0001\u0004i\u0015\u0001\u0002<jK^\u0004\"\u0001\n(\n\u0005=\u000b\"\u0001\u0006\"bg\u0016\f5mY8v]R\u001cF/\u0019;f-&,w\u000fC\u0003R\u000b\u0001\u0007!+\u0001\u000bd_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\t\u0003{MK!\u0001\u0016 \u0003\u0007%sG\u000fK\u0002\u0006-r\u00032!P,Z\u0013\tAfH\u0001\u0004uQJ|wo\u001d\t\u0003IiK!aW\t\u0003O5+7o]1hKB\u0013xnY3tg>\u0014\u0018J\\5uS\u0006d\u0017N_1uS>tW\t_2faRLwN\\\u0019\u0006=uC\u00171\u0001\t\u0003=\u0016t!aX2\u0011\u0005\u0001tT\"A1\u000b\u0005\tL\u0012A\u0002\u001fs_>$h(\u0003\u0002e}\u00051\u0001K]3eK\u001aL!AZ4\u0003\rM#(/\u001b8h\u0015\t!g(M\u0003$S6dh.\u0006\u0002kWV\tQ\fB\u0003m3\t\u0007\u0011OA\u0001U\u0013\tqw.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003az\na\u0001\u001e5s_^\u001c\u0018C\u0001:v!\ti4/\u0003\u0002u}\t9aj\u001c;iS:<\u0007C\u0001<z\u001d\tit/\u0003\u0002y}\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005%!\u0006N]8xC\ndWM\u0003\u0002y}E*1% @\u0000a:\u0011QH`\u0005\u0003az\nTAI\u001f?\u0003\u0003\u0011Qa]2bY\u0006\f$AJ-\u0002\u001b\r,8\u000f^8n)J\f7-\u001b8h)\t\tI\u0001E\u0002>\u0003\u0017I1!!\u0004?\u0005\u001d\u0011un\u001c7fC:\f!bY1o!J|7-Z:t)!\tI!a\u0005\u0002\u001e\u0005}\u0001bBA\u000b\u000f\u0001\u0007\u0011qC\u0001\u000bS:4xnY1uS>t\u0007c\u0001\u0013\u0002\u001a%\u0019\u00111D\t\u0003\u0015%sgo\\2bi&|g\u000eC\u0003M\u000f\u0001\u0007Q\nC\u0003R\u000f\u0001\u0007!+A\u000ehKR,E\u000f[3sKVl7i\u001c8tK:\u001cXo\u001d#bi\u0006dun\u001a\u000b\u0005\u0003K\t\t\u0004\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#E\u0001\be\u0016\u001cW-\u001b9u\u0013\u0011\ty#!\u000b\u00031\u0015#\b.\u001a:fk6\u001cuN\\:f]N,8\u000fR1uC2{w\rC\u0004\u00024!\u0001\r!!\u000e\u0002\u000b\u00154XM\u001c;\u0011\u0007u\n9$C\u0002\u0002:y\u00121!\u00118z\u0003M\u0011X-];je\u0016L5OT8u!\u0006L\u0018M\u00197f)\rA\u0015q\b\u0005\b\u0003+I\u0001\u0019AA\f\u0003u\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#pKNtGoQ8oi\u0006Lg\u000eU1sC6\u001cHc\u0001%\u0002F!9\u0011Q\u0003\u0006A\u0002\u0005]\u0011a\b(bi&4XmU7beR\u001cuN\u001c;sC\u000e$Xj]4Qe>\u001cWm]:peB\u0011A\u0005D\n\u0004\u0019\u00055\u0003cA\u001f\u0002P%\u0019\u0011\u0011\u000b \u0003\r\u0005s\u0017PU3g)\t\tI%\u0001\nO+2cu\fS#Y?N#&+\u0013(H?N\u0012\u0014a\u0005(V\u00192{\u0006*\u0012-`'R\u0013\u0016JT$`gI\u0002\u0003")
public abstract class NativeSmartContractMsgProcessor
implements MessageProcessor,
SparkzLogging {
    private byte[] contractCodeHash;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static byte[] NULL_HEX_STRING_32() {
        return NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public abstract Address contractAddress();

    public abstract byte[] contractCode();

    private byte[] contractCodeHash$lzycompute() {
        NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = this;
        synchronized (nativeSmartContractMsgProcessor) {
            if (!this.bitmap$0) {
                this.contractCodeHash = Keccak256$.MODULE$.hash(this.contractCode());
                this.bitmap$0 = true;
            }
        }
        return this.contractCodeHash;
    }

    public byte[] contractCodeHash() {
        return !this.bitmap$0 ? this.contractCodeHash$lzycompute() : this.contractCodeHash;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) throws MessageProcessorInitializationException {
        if (!view.accountExists(this.contractAddress())) {
            BoxedUnit boxedUnit;
            view.addAccount(this.contractAddress(), this.contractCode());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("created Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(23).append("Account ").append(this.contractAddress()).append(" already exists").toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(errorMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new MessageProcessorInitializationException(errorMsg);
        }
    }

    @Override
    public boolean customTracing() {
        return false;
    }

    @Override
    public boolean canProcess(Invocation invocation, BaseAccountStateView view, int consensusEpochNumber) {
        return invocation.callee().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NativeSmartContractMsgProcessor.$anonfun$canProcess$1(this, x$1)));
    }

    public EthereumConsensusDataLog getEthereumConsensusDataLog(Object event) {
        return EthereumEvent.getEthereumConsensusDataLog(this.contractAddress(), event);
    }

    public void requireIsNotPayable(Invocation invocation) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
    }

    public void checkInputDoesntContainParams(Invocation invocation) {
        if (ABIUtil.getArgumentsFromData(invocation.input()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(invocation.input().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(NativeSmartContractMsgProcessor $this, Address x$1) {
        return $this.contractAddress().equals((Object)x$1);
    }

    public NativeSmartContractMsgProcessor() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

