/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.McAddrOwnershipMsgProcessor;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.account.utils.Secp256k1;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;
import sparkz.util.encode.Base64$;

public final class McAddrOwnershipMsgProcessor$
implements SparkzLogging,
scala.Serializable {
    public static McAddrOwnershipMsgProcessor$ MODULE$;
    private byte[] cachedMagicBytes;
    private final byte[] OwnershipsLinkedListTipKey;
    private final byte[] OwnershipLinkedListNullValue;
    private final byte[] ScAddressRefsLinkedListTipKey;
    private final byte[] ScAddressRefsLinkedListNullValue;
    private final String AddNewMultisigOwnershipCmd;
    private final String AddNewOwnershipCmd;
    private final String RemoveOwnershipCmd;
    private final String GetListOfAllOwnershipsCmd;
    private final String GetListOfOwnershipsCmd;
    private final String GetListOfOwnerScAddressesCmd;
    private final X9ECParameters ecParameters;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new McAddrOwnershipMsgProcessor$();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public byte[] OwnershipsLinkedListTipKey() {
        return this.OwnershipsLinkedListTipKey;
    }

    public byte[] OwnershipLinkedListNullValue() {
        return this.OwnershipLinkedListNullValue;
    }

    public byte[] ScAddressRefsLinkedListTipKey() {
        return this.ScAddressRefsLinkedListTipKey;
    }

    public byte[] ScAddressRefsLinkedListNullValue() {
        return this.ScAddressRefsLinkedListNullValue;
    }

    public String AddNewMultisigOwnershipCmd() {
        return this.AddNewMultisigOwnershipCmd;
    }

    public String AddNewOwnershipCmd() {
        return this.AddNewOwnershipCmd;
    }

    public String RemoveOwnershipCmd() {
        return this.RemoveOwnershipCmd;
    }

    public String GetListOfAllOwnershipsCmd() {
        return this.GetListOfAllOwnershipsCmd;
    }

    public String GetListOfOwnershipsCmd() {
        return this.GetListOfOwnershipsCmd;
    }

    public String GetListOfOwnerScAddressesCmd() {
        return this.GetListOfOwnerScAddressesCmd;
    }

    public X9ECParameters ecParameters() {
        return this.ecParameters;
    }

    public byte[] getOwnershipId(String mcAddress) {
        return Keccak256$.MODULE$.hash(mcAddress.getBytes(StandardCharsets.UTF_8));
    }

    public SignatureSecp256k1 getMcSignature(String mcSignatureString) {
        byte[] decodedMcSignature = (byte[])Base64$.MODULE$.decode(mcSignatureString).get();
        BigInteger v = BigInteger.valueOf(decodedMcSignature[0] - 4);
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(decodedMcSignature, 1, 33));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(decodedMcSignature, 33, 65));
        return new SignatureSecp256k1(v, r, s);
    }

    public Tuple2<Object, Seq<byte[]>> checkMcRedeemScriptForMultisig(String redeemScript) {
        byte[] redeemScriptBytes = BytesUtils.fromHexString(redeemScript);
        int redeemScriptLen = redeemScriptBytes.length;
        Predef$.MODULE$.require(redeemScriptLen > 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Invalid number of bytes ").append(redeemScriptLen).append(" in redeemScript").toString());
        Predef$.MODULE$.require(redeemScriptBytes[redeemScriptLen - 1] == BytesUtils.OP_CHECKMULTISIG, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Tail of redeemScript should be OP_CHECKMULTSIG (0x").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToByte((byte)BytesUtils.OP_CHECKMULTISIG)), "%02X")).append(")").toString());
        byte numOfPubKeyByte = redeemScriptBytes[redeemScriptLen - 2];
        Predef$.MODULE$.require(numOfPubKeyByte >= BytesUtils.OP_1 && numOfPubKeyByte <= BytesUtils.OP_16, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Number of pub keys byte 0x").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToByte((byte)numOfPubKeyByte)), "%02X")).append(" out of bounds").toString());
        int numOfPubKeys = numOfPubKeyByte - BytesUtils.OFFSET_FOR_OP_N;
        byte thresholdSignatureValueByte = redeemScriptBytes[0];
        Predef$.MODULE$.require(thresholdSignatureValueByte >= BytesUtils.OP_1 && thresholdSignatureValueByte <= BytesUtils.OP_16, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Invalid threshold signatures byte 0x").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToByte((byte)thresholdSignatureValueByte)), "%02X")).toString());
        int thresholdSignatureValue = thresholdSignatureValueByte - BytesUtils.OFFSET_FOR_OP_N;
        Predef$.MODULE$.require(thresholdSignatureValue <= numOfPubKeys, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Invalid value for threshold signature value: ").append(thresholdSignatureValue).append(" > ").append(numOfPubKeys).toString());
        IntRef pos = IntRef.create((int)1);
        IndexedSeq pubKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfPubKeys).map((Function1 & Serializable & scala.Serializable)n -> McAddrOwnershipMsgProcessor$.$anonfun$checkMcRedeemScriptForMultisig$6(redeemScriptBytes, pos, BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(redeemScriptLen == 2 + pos.elem, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Invalid length of redeemScript: ").append(redeemScriptLen).toString());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)thresholdSignatureValue), (Object)pubKeys);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] checkMcAddresses(String mcAddress, NetworkParams params) {
        void var3_3;
        byte[] decodedAddressDataHash = BytesUtils.fromHorizenMcTransparentAddress(mcAddress, params);
        Predef$.MODULE$.require(decodedAddressDataHash.length == 20, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("MC address decoded ").append(BytesUtils.toHexString(decodedAddressDataHash)).append(", length should be ").append(20).append(", found ").append(decodedAddressDataHash.length).toString());
        return var3_3;
    }

    public boolean checkMultisigAddress(String mcMultisigAddress, String redeemScript, NetworkParams params) {
        boolean bl;
        try {
            byte[] scriptHash = this.checkMcAddresses(mcMultisigAddress, params);
            byte[] computedScriptHash = Utils.Ripemd160Sha256Hash(BytesUtils.fromHexString(redeemScript));
            bl = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scriptHash)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(computedScriptHash));
        }
        catch (Throwable e) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(20).append("invalid mc address: ").append(e.getMessage()).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public boolean io$horizen$account$state$McAddrOwnershipMsgProcessor$$isValidOwnershipSignature(Address scAddress, String mcTransparentAddress, SignatureSecp256k1 mcSignature, NetworkParams networkParams) {
        byte[] v_barr = BigIntegerUInt256.getUnsignedByteArray(mcSignature.getV());
        byte[] r_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getR()), 32);
        byte[] s_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getS()), 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v_barr, r_barr, s_barr);
        byte[] hashedMsg = this.getMcHashedMsg(Keys.toChecksumAddress((String)Numeric.toHexString((byte[])scAddress.toBytes())));
        BigInteger recPubKey = Sign.signedMessageHashToKey((byte[])hashedMsg, (Sign.SignatureData)signatureData);
        byte[] recUncompressedPubKeyBytes = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4}), ClassTag$.MODULE$.Byte()), Numeric.toBytesPadded((BigInteger)recPubKey, (int)Secp256k1.PUBLIC_KEY_SIZE)});
        ECPoint ecpointRec = this.ecParameters().getCurve().decodePoint(recUncompressedPubKeyBytes);
        byte[] recCompressedPubKeyBytes = ecpointRec.getEncoded(true);
        byte[] mcPubkeyhash = Utils.Ripemd160Sha256Hash(recCompressedPubKeyBytes);
        String computedTaddr = BytesUtils.toHorizenPublicKeyAddress(mcPubkeyhash, networkParams);
        return computedTaddr.equals(mcTransparentAddress);
    }

    private boolean isValidOwnershipMultisigSignature(Address scAddress, String mcMultisigAddress, byte[] pubKey, SignatureSecp256k1 mcSignature) {
        byte[] byArray;
        byte[] v_barr = BigIntegerUInt256.getUnsignedByteArray(mcSignature.getV());
        byte[] r_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getR()), 32);
        byte[] s_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getS()), 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v_barr, r_barr, s_barr);
        byte[] hashedMsg = this.getMcHashedMsg(new StringBuilder(0).append(mcMultisigAddress).append(Keys.toChecksumAddress((String)Numeric.toHexString((byte[])scAddress.toBytes()))).toString());
        BigInteger recPubKey = Sign.signedMessageHashToKey((byte[])hashedMsg, (Sign.SignatureData)signatureData);
        byte[] recUncompressedPubKeyBytes = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4}), ClassTag$.MODULE$.Byte()), Numeric.toBytesPadded((BigInteger)recPubKey, (int)Secp256k1.PUBLIC_KEY_SIZE)});
        if (BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(pubKey)).head()) == 4) {
            byArray = recUncompressedPubKeyBytes;
        } else {
            ECPoint ecpointRec = this.ecParameters().getCurve().decodePoint(recUncompressedPubKeyBytes);
            byArray = ecpointRec.getEncoded(true);
        }
        byte[] pubKeyBytes = byArray;
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(pubKey)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(pubKeyBytes));
    }

    public int verifySignaturesWithThreshold(Address senderScAddress, String mcMultisigAddress, Seq<byte[]> pubKeys, Seq<SignatureSecp256k1> signatures, int thresholdSignatureValue) {
        int n;
        Object object = new Object();
        try {
            IntRef score = IntRef.create((int)0);
            ObjectRef verifiedPubKeyIndexes = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            Seq pubKeyIndexPairs = (Seq)pubKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom());
            Seq signaturesIndexPairs = (Seq)signatures.zipWithIndex(Seq$.MODULE$.canBuildFrom());
            signaturesIndexPairs.foreach((Function1 & Serializable & scala.Serializable)sign_idx_pair -> {
                McAddrOwnershipMsgProcessor$.$anonfun$verifySignaturesWithThreshold$1(pubKeyIndexPairs, verifiedPubKeyIndexes, senderScAddress, mcMultisigAddress, score, thresholdSignatureValue, object, sign_idx_pair);
                return BoxedUnit.UNIT;
            });
            n = score.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public byte[] getMcHashedMsg(String messageToSignString) {
        byte[] messageToSignBytes = messageToSignString.getBytes(StandardCharsets.UTF_8);
        Predef$.MODULE$.require(messageToSignBytes.length <= 256, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Too long a message to sign: ").append(messageToSignBytes.length).append(" > 256").toString());
        byte[] mts = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)messageToSignBytes.length}), ClassTag$.MODULE$.Byte()), messageToSignBytes});
        return Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.cachedMagicBytes(), mts}));
    }

    private byte[] getMagicBytes() {
        String strMessageMagic = "Zcash Signed Message:\n";
        byte[] messageMagicBytes = strMessageMagic.getBytes(StandardCharsets.UTF_8);
        return Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)messageMagicBytes.length}), ClassTag$.MODULE$.Byte()), messageMagicBytes});
    }

    private byte[] cachedMagicBytes$lzycompute() {
        McAddrOwnershipMsgProcessor$ mcAddrOwnershipMsgProcessor$ = this;
        synchronized (mcAddrOwnershipMsgProcessor$) {
            if (!this.bitmap$0) {
                this.cachedMagicBytes = this.getMagicBytes();
                this.bitmap$0 = true;
            }
        }
        return this.cachedMagicBytes;
    }

    public byte[] cachedMagicBytes() {
        return !this.bitmap$0 ? this.cachedMagicBytes$lzycompute() : this.cachedMagicBytes;
    }

    public McAddrOwnershipMsgProcessor apply(NetworkParams networkParams) {
        return new McAddrOwnershipMsgProcessor(networkParams);
    }

    public Option<NetworkParams> unapply(McAddrOwnershipMsgProcessor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.networkParams());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ byte[] $anonfun$checkMcRedeemScriptForMultisig$6(byte[] redeemScriptBytes$1, IntRef pos$1, int n) {
        byte nextPubKeySize = redeemScriptBytes$1[pos$1.elem];
        ++pos$1.elem;
        Predef$.MODULE$.require(nextPubKeySize == 33 || nextPubKeySize == 65, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Invalid compressed/uncompressed pub key length ").append(nextPubKeySize).append(" read in redeemScript for pub key ").append(n).toString());
        byte[] pubKey = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(redeemScriptBytes$1)).slice(pos$1.elem, pos$1.elem + nextPubKeySize);
        pos$1.elem += nextPubKeySize;
        return pubKey;
    }

    public static final /* synthetic */ void $anonfun$verifySignaturesWithThreshold$3(ObjectRef verifiedPubKeyIndexes$1, Address senderScAddress$1, String mcMultisigAddress$1, Tuple2 sign_idx_pair$1, BooleanRef currentSignatureVerified$1, IntRef score$1, Tuple2 pk_idx_pair) {
        if (!((Seq)verifiedPubKeyIndexes$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)pk_idx_pair._2$mcI$sp())) && MODULE$.isValidOwnershipMultisigSignature(senderScAddress$1, mcMultisigAddress$1, (byte[])pk_idx_pair._1(), (SignatureSecp256k1)sign_idx_pair$1._1())) {
            BoxedUnit boxedUnit;
            currentSignatureVerified$1.elem = true;
            ++score$1.elem;
            int n = pk_idx_pair._2$mcI$sp();
            verifiedPubKeyIndexes$1.elem = (Seq)((Seq)verifiedPubKeyIndexes$1.elem).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
            if (MODULE$.log().underlying().isDebugEnabled()) {
                MODULE$.log().underlying().debug("Signature {} verified for pubkey {}", new Object[]{BoxesRunTime.boxToInteger((int)sign_idx_pair$1._2$mcI$sp()), BytesUtils.toHexString((byte[])pk_idx_pair._1())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$verifySignaturesWithThreshold$1(Seq pubKeyIndexPairs$1, ObjectRef verifiedPubKeyIndexes$1, Address senderScAddress$1, String mcMultisigAddress$1, IntRef score$1, int thresholdSignatureValue$2, Object nonLocalReturnKey1$1, Tuple2 sign_idx_pair) {
        BooleanRef currentSignatureVerified = BooleanRef.create((boolean)false);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> pubKeyIndexPairs$1.foreach((Function1 & Serializable & scala.Serializable)pk_idx_pair -> {
            McAddrOwnershipMsgProcessor$.$anonfun$verifySignaturesWithThreshold$3(verifiedPubKeyIndexes$1, senderScAddress$1, mcMultisigAddress$1, sign_idx_pair, currentSignatureVerified, score$1, pk_idx_pair);
            return BoxedUnit.UNIT;
        }));
        if (!currentSignatureVerified.elem) {
            BoxedUnit boxedUnit;
            String errMsg = new StringBuilder(20).append("Signature ").append(sign_idx_pair._2$mcI$sp()).append(" not valid").toString();
            if (MODULE$.log().underlying().isWarnEnabled()) {
                MODULE$.log().underlying().warn(errMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (score$1.elem >= thresholdSignatureValue$2) {
            throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, score$1.elem);
        }
    }

    private McAddrOwnershipMsgProcessor$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.OwnershipsLinkedListTipKey = Blake2b256$.MODULE$.hash("OwnershipTipKey");
        this.OwnershipLinkedListNullValue = Blake2b256$.MODULE$.hash("OwnershipTipNullValue");
        this.ScAddressRefsLinkedListTipKey = Blake2b256$.MODULE$.hash("ScAddrRefsTip");
        this.ScAddressRefsLinkedListNullValue = Blake2b256$.MODULE$.hash("ScAddressRefsLinkedListNull");
        this.AddNewMultisigOwnershipCmd = ABIUtil.getABIMethodId("sendMultisigKeysOwnership(string,string,string[])");
        this.AddNewOwnershipCmd = ABIUtil.getABIMethodId("sendKeysOwnership(bytes3,bytes32,bytes24,bytes32,bytes32)");
        this.RemoveOwnershipCmd = ABIUtil.getABIMethodId("removeKeysOwnership(bytes3,bytes32)");
        this.GetListOfAllOwnershipsCmd = ABIUtil.getABIMethodId("getAllKeyOwnerships()");
        this.GetListOfOwnershipsCmd = ABIUtil.getABIMethodId("getKeyOwnerships(address)");
        this.GetListOfOwnerScAddressesCmd = ABIUtil.getABIMethodId("getKeyOwnerScAddresses()");
        this.ecParameters = SECNamedCurves.getByName((String)"secp256k1");
        Predef$.MODULE$.require(this.AddNewMultisigOwnershipCmd().length() == 8 && this.AddNewOwnershipCmd().length() == 8 && this.RemoveOwnershipCmd().length() == 8 && this.GetListOfAllOwnershipsCmd().length() == 8 && this.GetListOfOwnershipsCmd().length() == 8 && this.GetListOfOwnerScAddressesCmd().length() == 8);
    }
}

