/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.abi.ABIEncodable;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.Version1_4_0Fork$;
import io.horizen.account.network.ForgerInfo;
import io.horizen.account.network.PagedForgersOutput;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoList;
import io.horizen.account.state.AccountForgingStakeInfoListDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesV2Provider;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.NativeSmartContractWithFork;
import io.horizen.account.state.nativescdata.forgerstakev2.ConsensusEpochCmdOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersListResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByDelegatorCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByDelegatorCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByDelegatorOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByForgerCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByForgerCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedForgersStakesByForgerOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedStakesByDelegatorResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.PagedStakesByForgerResponse;
import io.horizen.account.state.nativescdata.forgerstakev2.RegisterOrUpdateForgerCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.RegisterOrUpdateForgerCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.RewardsReceivedCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.RewardsReceivedCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.RewardsReceivedCmdOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.SelectByForgerCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.SelectByForgerCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStartCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStartCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStartCmdOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeStorage$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeTotalCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeTotalCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.StakeTotalCmdOutput;
import io.horizen.account.state.nativescdata.forgerstakev2.WithdrawCmdInput;
import io.horizen.account.state.nativescdata.forgerstakev2.WithdrawCmdInputDecoder$;
import io.horizen.account.state.nativescdata.forgerstakev2.events.ActivateStakeV2;
import io.horizen.account.state.nativescdata.forgerstakev2.events.DelegateForgerStake;
import io.horizen.account.state.nativescdata.forgerstakev2.events.DelegateForgerStake$;
import io.horizen.account.state.nativescdata.forgerstakev2.events.RegisterForger;
import io.horizen.account.state.nativescdata.forgerstakev2.events.RegisterForger$;
import io.horizen.account.state.nativescdata.forgerstakev2.events.UpdateForger;
import io.horizen.account.state.nativescdata.forgerstakev2.events.UpdateForger$;
import io.horizen.account.state.nativescdata.forgerstakev2.events.WithdrawForgerStake;
import io.horizen.account.state.nativescdata.forgerstakev2.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.storage.MsgProcessorMetadataStorageReader;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.consensus.package$;
import io.horizen.evm.Address;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

public final class ForgerStakeV2MsgProcessor$
extends NativeSmartContractWithFork
implements ForgerStakesV2Provider {
    public static ForgerStakeV2MsgProcessor$ MODULE$;
    private final int MAX_REWARD_SHARE;
    private final BigInteger MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI;
    private final int NUM_OF_EPOCHS_AFTER_FORK_ACTIVATION_FOR_UPDATE_FORGER;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final String RegisterForgerCmd;
    private final String UpdateForgerCmd;
    private final String DelegateCmd;
    private final String WithdrawCmd;
    private final String StakeTotalCmd;
    private final String StakeStartCmd;
    private final String RewardsReceivedCmd;
    private final String GetPagedForgersStakesByForgerCmd;
    private final String GetPagedForgersStakesByDelegatorCmd;
    private final String ActivateCmd;
    private final String GetForgerCmd;
    private final String GetPagedForgersCmd;
    private final String GetCurrentConsensusEpochCmd;

    static {
        new ForgerStakeV2MsgProcessor$();
    }

    public int MAX_REWARD_SHARE() {
        return this.MAX_REWARD_SHARE;
    }

    public BigInteger MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI() {
        return this.MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI;
    }

    public int NUM_OF_EPOCHS_AFTER_FORK_ACTIVATION_FOR_UPDATE_FORGER() {
        return this.NUM_OF_EPOCHS_AFTER_FORK_ACTIVATION_FOR_UPDATE_FORGER;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public boolean isForkActive(int consensusEpochNumber) {
        return Version1_4_0Fork$.MODULE$.get(consensusEpochNumber).active();
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, MsgProcessorMetadataStorageReader metadata, ExecutionContext context) {
        byte[] byArray;
        if (!this.isForkActive(context.blockContext().consensusEpochNumber)) {
            throw new ExecutionRevertedException("fork not active");
        }
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = this.RegisterForgerCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.doRegisterForger(invocation, gasView, context);
        } else {
            String string4 = this.UpdateForgerCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doUpdateForger(invocation, gasView, context);
            } else {
                String string6 = this.DelegateCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doDelegateCmd(invocation, gasView, context);
                } else {
                    String string8 = this.WithdrawCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doWithdrawCmd(invocation, gasView, context);
                    } else {
                        String string10 = this.StakeTotalCmd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            byArray = this.doStakeTotalCmd(invocation, gasView, context.blockContext().consensusEpochNumber);
                        } else {
                            String string12 = this.StakeStartCmd();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                byArray = this.doStakeStartCmd(invocation, gasView);
                            } else {
                                String string14 = this.RewardsReceivedCmd();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    byArray = this.doRewardsReceivedCmd(invocation, gasView, metadata, context.blockContext().consensusEpochNumber);
                                } else {
                                    String string16 = this.GetPagedForgersStakesByForgerCmd();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        byArray = this.doPagedForgersStakesByForgerCmd(invocation, gasView);
                                    } else {
                                        String string18 = this.GetPagedForgersStakesByDelegatorCmd();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            byArray = this.doPagedForgersStakesByDelegatorCmd(invocation, gasView);
                                        } else {
                                            String string20 = this.GetCurrentConsensusEpochCmd();
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                byArray = this.doGetCurrentConsensusEpochCmd(invocation, gasView, context);
                                            } else {
                                                String string22 = this.ActivateCmd();
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    byArray = this.doActivateCmd(invocation, view, context);
                                                } else {
                                                    String string24 = this.GetPagedForgersCmd();
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        byArray = this.doGetPagedForgersCmd(invocation, gasView);
                                                    } else {
                                                        String string26 = this.GetForgerCmd();
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            byArray = this.doGetForgerCmd(invocation, gasView);
                                                        } else {
                                                            throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return byArray;
    }

    public void verifySignatures(byte[] msgToSign, PublicKey25519Proposition blockSignPubKey, VrfPublicKey vrfPubKey, Signature25519 sign25519, VrfProof signVrf) {
        if (!sign25519.isValid(blockSignPubKey, msgToSign)) {
            BoxedUnit boxedUnit;
            String errMsg = new StringBuilder(77).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignPubKey).append(" (sign=").append(sign25519).append(")").toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!signVrf.isValid(vrfPubKey, msgToSign)) {
            BoxedUnit boxedUnit;
            String errMsg = new StringBuilder(61).append("Invalid signature, could not validate against vrfKey=").append(vrfPubKey).append(" (sign=").append(signVrf).append(")").toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
    }

    public byte[] doRegisterForger(Invocation invocation, BaseAccountStateView gasView, ExecutionContext context) {
        BoxedUnit boxedUnit;
        this.checkForgerStakesV2IsActive(gasView);
        BigInteger stakedAmount = invocation.value();
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount)) {
            BoxedUnit boxedUnit2;
            String errMsg = new StringBuilder(63).append("Value is not a legal wei amount: ").append(stakedAmount.toString()).append(", maximum 10 decimals accepted").toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (stakedAmount.compareTo(this.MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI()) < 0) {
            BoxedUnit boxedUnit3;
            String errMsg = new StringBuilder(53).append("Value ").append(stakedAmount.toString()).append(" is below the minimum stake amount threshold: ").append(this.MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI()).append(" ").toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RegisterOrUpdateForgerCmdInput cmdInput = (RegisterOrUpdateForgerCmdInput)RegisterOrUpdateForgerCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPubKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPubKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        int rewardShare = cmdInput.rewardShare();
        Address smartContractAddr = cmdInput.rewardAddress();
        Signature25519 sign25519 = cmdInput.signature25519();
        VrfProof signVrf = cmdInput.signatureVrf();
        if (gasView.getBalance(invocation.caller()).subtract(stakedAmount).signum() < 0) {
            BoxedUnit boxedUnit4;
            String errMsg = new StringBuilder(20).append("Not enough balance: ").append(cmdInput.forgerPublicKeys().toString()).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (rewardShare < 0 || rewardShare > this.MAX_REWARD_SHARE()) {
            BoxedUnit boxedUnit5;
            String errMsg = new StringBuilder(30).append("Illegal reward share value: = ").append(rewardShare).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (rewardShare == 0) {
            Address address = smartContractAddr;
            Address address2 = Address.ZERO;
            if (address == null ? address2 != null : !address.equals(address2)) {
                BoxedUnit boxedUnit6;
                String errMsg = new StringBuilder(90).append("Reward share cannot be 0 if reward address is defined - Reward share = ").append(rewardShare).append(", reward address = ").append(smartContractAddr).toString();
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(errMsg);
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                throw new ExecutionRevertedException(errMsg);
            }
        }
        if (rewardShare != 0) {
            Address address = smartContractAddr;
            Address address3 = Address.ZERO;
            if (!(address != null ? !address.equals(address3) : address3 != null)) {
                BoxedUnit boxedUnit7;
                String errMsg = new StringBuilder(109).append("Reward share cannot be different from 0 if reward address is not defined - Reward share = ").append(rewardShare).append(", reward address = ").append(smartContractAddr).toString();
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(errMsg);
                    boxedUnit7 = BoxedUnit.UNIT;
                } else {
                    boxedUnit7 = BoxedUnit.UNIT;
                }
                throw new ExecutionRevertedException(errMsg);
            }
        }
        if (StakeStorage$.MODULE$.getForger(gasView, blockSignPubKey, vrfPubKey).isDefined()) {
            BoxedUnit boxedUnit8;
            String errMsg = new StringBuilder(45).append("Can not register an already existing forger: ").append(new ForgerPublicKeys(blockSignPubKey, vrfPubKey).toString()).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] messageToSign = this.getHashedMessageToSign(BytesUtils.toHexString(blockSignPubKey.pubKeyBytes()), BytesUtils.toHexString(vrfPubKey.pubKeyBytes()), rewardShare, BytesUtils.toHexString(smartContractAddr.toBytes()));
        this.verifySignatures(messageToSign, blockSignPubKey, vrfPubKey, sign25519, signVrf);
        Address delegatorAddress = invocation.caller();
        StakeStorage$.MODULE$.addForger(gasView, blockSignPubKey, vrfPubKey, rewardShare, smartContractAddr, context.blockContext().consensusEpochNumber, delegatorAddress, stakedAmount);
        gasView.subBalance(invocation.caller(), stakedAmount);
        gasView.addBalance(this.contractAddress(), stakedAmount);
        RegisterForger registerForgerEvent = RegisterForger$.MODULE$.apply(invocation.caller(), blockSignPubKey, vrfPubKey, stakedAmount, rewardShare, smartContractAddr);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(registerForgerEvent);
        gasView.addLog(evmLog);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("register forger exiting - {}", new Object[]{cmdInput.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Array$.MODULE$.emptyByteArray();
    }

    public byte[] doUpdateForger(Invocation invocation, BaseAccountStateView gasView, ExecutionContext context) {
        BoxedUnit boxedUnit;
        VrfProof signVrf;
        Signature25519 sign25519;
        Address rewardAddress;
        int rewardShare;
        VrfPublicKey vrfPubKey;
        PublicKey25519Proposition blockSignPubKey;
        RegisterOrUpdateForgerCmdInput cmdInput;
        block18: {
            BoxedUnit boxedUnit2;
            ForgerInfo forger;
            block17: {
                ForgerInfo obj;
                this.requireIsNotPayable(invocation);
                this.checkForgerStakesV2IsActive(gasView);
                byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
                cmdInput = (RegisterOrUpdateForgerCmdInput)RegisterOrUpdateForgerCmdInputDecoder$.MODULE$.decode(inputParams);
                blockSignPubKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
                vrfPubKey = cmdInput.forgerPublicKeys().vrfPublicKey();
                rewardShare = cmdInput.rewardShare();
                rewardAddress = cmdInput.rewardAddress();
                sign25519 = cmdInput.signature25519();
                signVrf = cmdInput.signatureVrf();
                if (rewardShare <= 0 || rewardShare > this.MAX_REWARD_SHARE()) {
                    BoxedUnit boxedUnit3;
                    String errMsg = new StringBuilder(30).append("Illegal reward share value: = ").append(rewardShare).toString();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(errMsg);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    throw new ExecutionRevertedException(errMsg);
                }
                Address address = rewardAddress;
                Address address2 = Address.ZERO;
                if (!(address != null ? !address.equals(address2) : address2 != null)) {
                    BoxedUnit boxedUnit4;
                    String errMsg = "Reward address cannot be the ZERO address";
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(errMsg);
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    throw new ExecutionRevertedException(errMsg);
                }
                Option<ForgerInfo> option = StakeStorage$.MODULE$.getForger(gasView, blockSignPubKey, vrfPubKey);
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit5;
                        String errMsg = new StringBuilder(23).append("Forger does not exist: ").append(new ForgerPublicKeys(blockSignPubKey, vrfPubKey).toString()).toString();
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug(errMsg);
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        throw new ExecutionRevertedException(errMsg);
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                ForgerInfo forgerInfo = obj = (ForgerInfo)some.value();
                forger = forgerInfo;
                if (forger.rewardShare() != 0) break block17;
                Address address3 = forger.rewardAddress().address();
                Address address4 = Address.ZERO;
                if (!(address3 == null ? address4 != null : !address3.equals(address4))) break block18;
            }
            String errMsg = new StringBuilder(80).append("Reward share or reward address are not null - Reward share = ").append(forger.rewardShare()).append(", reward address = ").append(forger.rewardAddress()).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] messageToSign = this.getHashedMessageToSign(BytesUtils.toHexString(blockSignPubKey.pubKeyBytes()), BytesUtils.toHexString(vrfPubKey.pubKeyBytes()), rewardShare, BytesUtils.toHexString(rewardAddress.toBytes()));
        this.verifySignatures(messageToSign, blockSignPubKey, vrfPubKey, sign25519, signVrf);
        StakeStorage$.MODULE$.updateForger(gasView, blockSignPubKey, vrfPubKey, rewardShare, rewardAddress);
        UpdateForger updateForgerEvent = UpdateForger$.MODULE$.apply(invocation.caller(), blockSignPubKey, vrfPubKey, rewardShare, rewardAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(updateForgerEvent);
        gasView.addLog(evmLog);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("update forger exiting - {}", new Object[]{cmdInput.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Array$.MODULE$.emptyByteArray();
    }

    public byte[] doDelegateCmd(Invocation invocation, BaseAccountStateView view, ExecutionContext context) {
        BoxedUnit boxedUnit;
        ForgerPublicKeys forgerPublicKeys;
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        SelectByForgerCmdInput selectByForgerCmdInput = (SelectByForgerCmdInput)SelectByForgerCmdInputDecoder$.MODULE$.decode(inputParams);
        if (selectByForgerCmdInput == null) {
            throw new MatchError((Object)selectByForgerCmdInput);
        }
        ForgerPublicKeys forgerPublicKeys2 = forgerPublicKeys = selectByForgerCmdInput.forgerPublicKeys();
        ForgerPublicKeys forgerPublicKeys3 = forgerPublicKeys2;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("delegate called - {}", new Object[]{forgerPublicKeys3});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BigInteger stakedAmount = invocation.value();
        if (stakedAmount.signum() <= 0) {
            BoxedUnit boxedUnit2;
            String msg = "Value must not be zero";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msg);
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount)) {
            BoxedUnit boxedUnit3;
            String msg = new StringBuilder(33).append("Value is not a legal wei amount: ").append(stakedAmount).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msg);
        }
        if (view.getBalance(invocation.caller()).compareTo(stakedAmount) < 0) {
            throw new ExecutionRevertedException(new StringBuilder(43).append("Insufficient funds. Required: ").append(stakedAmount).append(", available: ").append(view.getBalance(invocation.caller())).toString());
        }
        int epochNumber = context.blockContext().consensusEpochNumber;
        StakeStorage$.MODULE$.addStake(view, forgerPublicKeys3.blockSignPublicKey(), forgerPublicKeys3.vrfPublicKey(), epochNumber, invocation.caller(), stakedAmount);
        DelegateForgerStake delegateStakeEvt = DelegateForgerStake$.MODULE$.apply(invocation.caller(), forgerPublicKeys3.blockSignPublicKey(), forgerPublicKeys3.vrfPublicKey(), stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(delegateStakeEvt);
        view.addLog(evmLog);
        view.subBalance(invocation.caller(), stakedAmount);
        view.addBalance(this.contractAddress(), stakedAmount);
        return Array$.MODULE$.emptyByteArray();
    }

    public byte[] doWithdrawCmd(Invocation invocation, BaseAccountStateView view, ExecutionContext context) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        WithdrawCmdInput withdrawCmdInput = (WithdrawCmdInput)WithdrawCmdInputDecoder$.MODULE$.decode(inputParams);
        if (withdrawCmdInput == null) {
            throw new MatchError((Object)withdrawCmdInput);
        }
        ForgerPublicKeys forgerPublicKeys = withdrawCmdInput.forgerPublicKeys();
        BigInteger stakedAmount = withdrawCmdInput.value();
        Tuple2 tuple2 = new Tuple2((Object)forgerPublicKeys, (Object)stakedAmount);
        Tuple2 tuple22 = tuple2;
        ForgerPublicKeys forgerPublicKeys2 = (ForgerPublicKeys)tuple22._1();
        BigInteger stakedAmount2 = (BigInteger)tuple22._2();
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("withdraw called - {} {}", new Object[]{forgerPublicKeys2, stakedAmount2});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (stakedAmount2.signum() != 1) {
            BoxedUnit boxedUnit2;
            String msg = new StringBuilder(45).append("Withdrawal amount must be greater than zero: ").append(stakedAmount2).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msg);
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount2)) {
            BoxedUnit boxedUnit3;
            String msg = new StringBuilder(33).append("Value is not a legal wei amount: ").append(stakedAmount2).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msg);
        }
        int epochNumber = context.blockContext().consensusEpochNumber;
        StakeStorage$.MODULE$.removeStake(view, forgerPublicKeys2.blockSignPublicKey(), forgerPublicKeys2.vrfPublicKey(), epochNumber, invocation.caller(), stakedAmount2);
        WithdrawForgerStake withdrawStakeEvt = WithdrawForgerStake$.MODULE$.apply(invocation.caller(), forgerPublicKeys2.blockSignPublicKey(), forgerPublicKeys2.vrfPublicKey(), stakedAmount2);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(withdrawStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakedAmount2);
        view.addBalance(invocation.caller(), stakedAmount2);
        return Array$.MODULE$.emptyByteArray();
    }

    public void checkForgerStakesV2IsActive(BaseAccountStateView view) {
        if (!StakeStorage$.MODULE$.isActive(view)) {
            BoxedUnit boxedUnit;
            String msg = "Forger stake V2 has not been activated yet";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException("Forger stake V2 has not been activated yet");
        }
    }

    public byte[] doStakeTotalCmd(Invocation invocation, BaseAccountStateView view, int currentEpoch) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        StakeTotalCmdInput cmdInput = (StakeTotalCmdInput)StakeTotalCmdInputDecoder$.MODULE$.decode(inputParams);
        if (cmdInput.consensusEpochStart().isDefined() && BoxesRunTime.unboxToInt((Object)cmdInput.consensusEpochStart().get()) > currentEpoch) {
            String msgStr = new StringBuilder(79).append("Illegal argument - consensus epoch start ").append(cmdInput.consensusEpochStart().get()).append(" can not be greater than currentEpoch ").append(currentEpoch).toString();
            throw new ExecutionRevertedException(msgStr);
        }
        Option<ForgerPublicKeys> forgerKeys = cmdInput.forgerPublicKeys();
        Option<Address> delegator = cmdInput.delegator();
        int consensusEpochStart = cmdInput.consensusEpochStart().isEmpty() ? currentEpoch : BoxesRunTime.unboxToInt((Object)cmdInput.consensusEpochStart().get());
        Option<Object> maxNumOfEpoch = cmdInput.maxNumOfEpoch();
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("stakeTotal called - {} {} epochStart: {} - maxNumOfEpoch: {}", new Object[]{forgerKeys, delegator, BoxesRunTime.boxToInteger((int)consensusEpochStart), maxNumOfEpoch});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (forgerKeys.isEmpty()) {
            if (delegator.isDefined()) {
                String msgStr = "Illegal argument - delegator is defined while forger keys are not";
                throw new ExecutionRevertedException(msgStr);
            }
        } else if (StakeStorage$.MODULE$.getForger(view, ((ForgerPublicKeys)forgerKeys.get()).blockSignPublicKey(), ((ForgerPublicKeys)forgerKeys.get()).vrfPublicKey()).isEmpty()) {
            BoxedUnit boxedUnit2;
            String errMsg = new StringBuilder(23).append("Forger does not exist: ").append(forgerKeys.toString()).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        int consensusEpochEnd = maxNumOfEpoch.isEmpty() ? consensusEpochStart : (consensusEpochStart + BoxesRunTime.unboxToInt((Object)maxNumOfEpoch.get()) > currentEpoch ? currentEpoch : consensusEpochStart + BoxesRunTime.unboxToInt((Object)maxNumOfEpoch.get()) - 1);
        StakeTotalCmdOutput response = StakeStorage$.MODULE$.getStakeTotal(view, forgerKeys, delegator, consensusEpochStart, consensusEpochEnd);
        return response.encode();
    }

    public byte[] doRewardsReceivedCmd(Invocation invocation, BaseAccountStateView view, MsgProcessorMetadataStorageReader metadata, int currentEpoch) {
        BoxedUnit boxedUnit;
        int maxNumOfEpoch;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RewardsReceivedCmdInput cmdInput = (RewardsReceivedCmdInput)RewardsReceivedCmdInputDecoder$.MODULE$.decode(inputParams);
        ForgerPublicKeys forgerKeys = cmdInput.forgerPublicKeys();
        int consensusEpochStart = cmdInput.consensusEpochStart();
        if (consensusEpochStart >= currentEpoch) {
            String msgStr = new StringBuilder(79).append("Illegal argument - consensus epoch start ").append(consensusEpochStart).append(" can not be greater than currentEpoch ").append(currentEpoch).toString();
            throw new ExecutionRevertedException(msgStr);
        }
        int n = maxNumOfEpoch = consensusEpochStart + cmdInput.maxNumOfEpoch() - 1 >= currentEpoch ? currentEpoch - consensusEpochStart : cmdInput.maxNumOfEpoch();
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("rewardsReceived called - {} epochStart: {}", new Object[]{forgerKeys, BoxesRunTime.boxToInteger((int)consensusEpochStart)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StakeStorage$.MODULE$.getForger(view, forgerKeys.blockSignPublicKey(), forgerKeys.vrfPublicKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("Forger doesn't exist.");
        });
        Seq<BigInteger> rewards = metadata.getForgerRewards(forgerKeys, consensusEpochStart, maxNumOfEpoch);
        RewardsReceivedCmdOutput response = new RewardsReceivedCmdOutput(rewards);
        return response.encode();
    }

    public byte[] doStakeStartCmd(Invocation invocation, BaseAccountStateView view) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        StakeStartCmdInput cmdInput = (StakeStartCmdInput)StakeStartCmdInputDecoder$.MODULE$.decode(inputParams);
        ForgerPublicKeys forgerKeys = cmdInput.forgerPublicKeys();
        Address delegator = cmdInput.delegator();
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("stakeStart called - {} {}", new Object[]{forgerKeys, delegator});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StakeStartCmdOutput response = StakeStorage$.MODULE$.getStakeStart(view, forgerKeys, delegator);
        return response.encode();
    }

    public byte[] doPagedForgersStakesByDelegatorCmd(Invocation invocation, BaseAccountStateView view) {
        PagedStakesByDelegatorResponse response;
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        PagedForgersStakesByDelegatorCmdInput cmdInput = (PagedForgersStakesByDelegatorCmdInput)PagedForgersStakesByDelegatorCmdInputDecoder$.MODULE$.decode(inputParams);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("getPagedForgersStakesByDelegator called - {} startIndex: {} - pageSize: {}", new Object[]{cmdInput.delegator(), BoxesRunTime.boxToInteger((int)cmdInput.startIndex()), BoxesRunTime.boxToInteger((int)cmdInput.pageSize())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> StakeStorage$.MODULE$.getPagedForgersStakesByDelegator(view, cmdInput.delegator(), cmdInput.startIndex(), cmdInput.pageSize()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(28).append("Could not get paged result: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        PagedStakesByDelegatorResponse pagedStakesByDelegatorResponse = response = (PagedStakesByDelegatorResponse)success.value();
        PagedStakesByDelegatorResponse response2 = pagedStakesByDelegatorResponse;
        return new PagedForgersStakesByDelegatorOutput(response2.nextStartPos(), response2.stakesData()).encode();
    }

    public byte[] doPagedForgersStakesByForgerCmd(Invocation invocation, BaseAccountStateView view) {
        PagedStakesByForgerResponse response;
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        PagedForgersStakesByForgerCmdInput cmdInput = (PagedForgersStakesByForgerCmdInput)PagedForgersStakesByForgerCmdInputDecoder$.MODULE$.decode(inputParams);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("getPagedForgersStakesByForger called - {} startIndex: {} - pageSize: {}", new Object[]{cmdInput.forgerPublicKeys(), BoxesRunTime.boxToInteger((int)cmdInput.startIndex()), BoxesRunTime.boxToInteger((int)cmdInput.pageSize())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> StakeStorage$.MODULE$.getPagedForgersStakesByForger(view, cmdInput.forgerPublicKeys(), cmdInput.startIndex(), cmdInput.pageSize()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(28).append("Could not get paged result: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        PagedStakesByForgerResponse pagedStakesByForgerResponse = response = (PagedStakesByForgerResponse)success.value();
        PagedStakesByForgerResponse response2 = pagedStakesByForgerResponse;
        return new PagedForgersStakesByForgerOutput(response2.nextStartPos(), response2.stakesData()).encode();
    }

    public byte[] doGetForgerCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        SelectByForgerCmdInput cmdInput = (SelectByForgerCmdInput)SelectByForgerCmdInputDecoder$.MODULE$.decode(inputParams);
        Option<ForgerInfo> forgerOpt = StakeStorage$.MODULE$.getForger(view, cmdInput.forgerPublicKeys().blockSignPublicKey(), cmdInput.forgerPublicKeys().vrfPublicKey());
        if (forgerOpt.isEmpty()) {
            throw new ExecutionRevertedException("Forger doesn't exist.");
        }
        return ((ABIEncodable)forgerOpt.get()).encode();
    }

    public byte[] doGetPagedForgersCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        PagedForgersCmdInput pagedForgersCmdInput = (PagedForgersCmdInput)PagedForgersCmdInputDecoder$.MODULE$.decode(inputParams);
        if (pagedForgersCmdInput == null) {
            throw new MatchError((Object)pagedForgersCmdInput);
        }
        int startPos = pagedForgersCmdInput.startIndex();
        int pageSize = pagedForgersCmdInput.pageSize();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(startPos, pageSize);
        Tuple2.mcII.sp sp3 = sp2;
        int startPos2 = sp3._1$mcI$sp();
        int pageSize2 = sp3._2$mcI$sp();
        PagedForgersListResponse res = StakeStorage$.MODULE$.getPagedListOfForgers(view, startPos2, pageSize2);
        return new PagedForgersOutput(res.nextStartPos(), res.forgers()).encode();
    }

    public byte[] doGetCurrentConsensusEpochCmd(Invocation invocation, BaseAccountStateView view, ExecutionContext context) {
        this.requireIsNotPayable(invocation);
        this.checkForgerStakesV2IsActive(view);
        this.checkInputDoesntContainParams(invocation);
        return new ConsensusEpochCmdOutput(context.blockContext().consensusEpochNumber).encode();
    }

    public byte[] doActivateCmd(Invocation invocation, BaseAccountStateView view, ExecutionContext context) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation);
        if (StakeStorage$.MODULE$.isActive(view)) {
            BoxedUnit boxedUnit2;
            String msgStr = "Forger stake V2 already activated";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        BigInteger intrinsicGas = invocation.gasPool().getUsedGas();
        byte[] result = context.execute(invocation.call(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), BigInteger.ZERO, BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.DisableAndMigrateCmd()), invocation.gasPool().getGas()));
        Seq<AccountForgingStakeInfo> listOfExistingStakes = ((AccountForgingStakeInfoList)AccountForgingStakeInfoListDecoder$.MODULE$.decode(result)).listOfStakes();
        Map stakesByForger = listOfExistingStakes.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.forgerStakeData().forgerPublicKeys());
        int epochNumber = context.blockContext().consensusEpochNumber;
        ObjectRef totalMigratedStakeAmount = ObjectRef.create((Object)BigInteger.ZERO);
        stakesByForger.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ForgerStakeV2MsgProcessor$.$anonfun$doActivateCmd$2(view, epochNumber, totalMigratedStakeAmount, x0$1);
            return BoxedUnit.UNIT;
        });
        view.subBalance(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), (BigInteger)totalMigratedStakeAmount.elem);
        view.addBalance(WellKnownAddresses$.MODULE$.FORGER_STAKE_V2_SMART_CONTRACT_ADDRESS(), (BigInteger)totalMigratedStakeAmount.elem);
        invocation.gasPool().addGas(invocation.gasPool().getUsedGas().subtract(intrinsicGas));
        StakeStorage$.MODULE$.setActive(view);
        ActivateStakeV2 activateEvent = new ActivateStakeV2();
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(activateEvent);
        view.addLog(evmLog);
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(78).append("Forger stakes V2 activated successfully - ").append(listOfExistingStakes.size()).append(" items migrated, ").append("total stake amount ").append((BigInteger)totalMigratedStakeAmount.elem).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Array$.MODULE$.emptyByteArray();
    }

    public String RegisterForgerCmd() {
        return this.RegisterForgerCmd;
    }

    public String UpdateForgerCmd() {
        return this.UpdateForgerCmd;
    }

    public String DelegateCmd() {
        return this.DelegateCmd;
    }

    public String WithdrawCmd() {
        return this.WithdrawCmd;
    }

    public String StakeTotalCmd() {
        return this.StakeTotalCmd;
    }

    public String StakeStartCmd() {
        return this.StakeStartCmd;
    }

    public String RewardsReceivedCmd() {
        return this.RewardsReceivedCmd;
    }

    public String GetPagedForgersStakesByForgerCmd() {
        return this.GetPagedForgersStakesByForgerCmd;
    }

    public String GetPagedForgersStakesByDelegatorCmd() {
        return this.GetPagedForgersStakesByDelegatorCmd;
    }

    public String ActivateCmd() {
        return this.ActivateCmd;
    }

    public String GetForgerCmd() {
        return this.GetForgerCmd;
    }

    public String GetPagedForgersCmd() {
        return this.GetPagedForgersCmd;
    }

    public String GetCurrentConsensusEpochCmd() {
        return this.GetCurrentConsensusEpochCmd;
    }

    public byte[] getHashedMessageToSign(String blockSignPubKeyStr, String vrfPublicKeyStr, int rewardShare, String rewardAddress) {
        String messageToSignString = new StringBuilder(0).append(Numeric.cleanHexPrefix((String)blockSignPubKeyStr).toLowerCase()).append(Numeric.cleanHexPrefix((String)vrfPublicKeyStr).toLowerCase()).append(((Object)BoxesRunTime.boxToInteger((int)rewardShare)).toString()).append(Keys.toChecksumAddress((String)rewardAddress)).toString();
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Keccak256$.MODULE$.hash(messageToSignString.getBytes(StandardCharsets.UTF_8)))).take(31);
    }

    @Override
    public PagedForgersListResponse getPagedListOfForgersStakes(BaseAccountStateView view, int startPos, int pageSize) {
        return StakeStorage$.MODULE$.getPagedListOfForgers(view, startPos, pageSize);
    }

    @Override
    public Seq<ForgerStakeData> getListOfForgersStakes(BaseAccountStateView view) {
        return StakeStorage$.MODULE$.getAllForgerStakes(view);
    }

    @Override
    public PagedStakesByForgerResponse getPagedForgersStakesByForger(BaseAccountStateView view, ForgerPublicKeys forger, int startPos, int pageSize) {
        this.checkForgerStakesV2IsActive(view);
        return StakeStorage$.MODULE$.getPagedForgersStakesByForger(view, forger, startPos, pageSize);
    }

    @Override
    public PagedStakesByDelegatorResponse getPagedForgersStakesByDelegator(BaseAccountStateView view, Address delegator, int startPos, int pageSize) {
        this.checkForgerStakesV2IsActive(view);
        return StakeStorage$.MODULE$.getPagedForgersStakesByDelegator(view, delegator, startPos, pageSize);
    }

    @Override
    public Seq<ForgingStakeInfo> getForgingStakes(BaseAccountStateView view) {
        return StakeStorage$.MODULE$.getForgingStakes(view);
    }

    @Override
    public Option<ForgerInfo> getForgerInfo(BaseAccountStateView view, ForgerPublicKeys forger) {
        return StakeStorage$.MODULE$.getForger(view, forger.blockSignPublicKey(), forger.vrfPublicKey());
    }

    @Override
    public boolean isActive(BaseAccountStateView view) {
        return StakeStorage$.MODULE$.isActive(view);
    }

    public static final /* synthetic */ void $anonfun$doActivateCmd$6(BaseAccountStateView view$3, ForgerPublicKeys forgerKeys$1, int epochNumber$1, ObjectRef totalMigratedStakeAmount$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AddressProposition delegator = (AddressProposition)tuple2._1();
        BigInteger delegatorStakeAmount = (BigInteger)tuple2._2();
        StakeStorage$.MODULE$.addStake(view$3, forgerKeys$1.blockSignPublicKey(), forgerKeys$1.vrfPublicKey(), epochNumber$1, delegator.address(), delegatorStakeAmount);
        totalMigratedStakeAmount$1.elem = ((BigInteger)totalMigratedStakeAmount$1.elem).add(delegatorStakeAmount);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doActivateCmd$2(BaseAccountStateView view$3, int epochNumber$1, ObjectRef totalMigratedStakeAmount$1, Tuple2 x0$1) {
        Tuple2 tuple2;
        Map listOfTotalStakesByDelegator;
        ForgerPublicKeys forgerKeys;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            forgerKeys = (ForgerPublicKeys)tuple22._1();
            Seq stakesByForger = (Seq)tuple22._2();
            Map stakesByDelegator = stakesByForger.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.forgerStakeData().ownerPublicKey());
            listOfTotalStakesByDelegator = stakesByDelegator.mapValues((Function1 & Serializable & scala.Serializable)x$5 -> (BigInteger)x$5.foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(sum, stake) -> sum.add(stake.forgerStakeData().stakedAmount())));
            Tuple2 tuple23 = (Tuple2)listOfTotalStakesByDelegator.head();
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            AddressProposition firstDelegator = (AddressProposition)tuple23._1();
            BigInteger firstDelegatorStakeAmount = (BigInteger)tuple23._2();
            tuple2 = new Tuple2((Object)firstDelegator, (Object)firstDelegatorStakeAmount);
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple24 = tuple2;
        AddressProposition firstDelegator = (AddressProposition)tuple24._1();
        BigInteger firstDelegatorStakeAmount = (BigInteger)tuple24._2();
        StakeStorage$.MODULE$.addForger(view$3, forgerKeys.blockSignPublicKey(), forgerKeys.vrfPublicKey(), 0, Address.ZERO, epochNumber$1, firstDelegator.address(), firstDelegatorStakeAmount);
        totalMigratedStakeAmount$1.elem = ((BigInteger)totalMigratedStakeAmount$1.elem).add(firstDelegatorStakeAmount);
        ((IterableLike)listOfTotalStakesByDelegator.tail()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ForgerStakeV2MsgProcessor$.$anonfun$doActivateCmd$6(view$3, forgerKeys, epochNumber$1, totalMigratedStakeAmount$1, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ForgerStakeV2MsgProcessor$() {
        MODULE$ = this;
        this.MAX_REWARD_SHARE = 1000;
        this.MIN_REGISTER_FORGER_STAKED_AMOUNT_IN_WEI = ZenWeiConverter$.MODULE$.convertZenniesToWei(package$.MODULE$.minForgerStake());
        this.NUM_OF_EPOCHS_AFTER_FORK_ACTIVATION_FOR_UPDATE_FORGER = 2;
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_V2_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeV2SmartContractCode");
        this.RegisterForgerCmd = ABIUtil.getABIMethodId("registerForger(bytes32,bytes32,bytes1,uint32,address,bytes32,bytes32,bytes32,bytes32,bytes32,bytes1)");
        this.UpdateForgerCmd = ABIUtil.getABIMethodId("updateForger(bytes32,bytes32,bytes1,uint32,address,bytes32,bytes32,bytes32,bytes32,bytes32,bytes1)");
        this.DelegateCmd = ABIUtil.getABIMethodId("delegate(bytes32,bytes32,bytes1)");
        this.WithdrawCmd = ABIUtil.getABIMethodId("withdraw(bytes32,bytes32,bytes1,uint256)");
        this.StakeTotalCmd = ABIUtil.getABIMethodId("stakeTotal(bytes32,bytes32,bytes1,address,uint32,uint32)");
        this.StakeStartCmd = ABIUtil.getABIMethodId("stakeStart(bytes32,bytes32,bytes1,address)");
        this.RewardsReceivedCmd = ABIUtil.getABIMethodId("rewardsReceived(bytes32,bytes32,bytes1,uint32,uint32)");
        this.GetPagedForgersStakesByForgerCmd = ABIUtil.getABIMethodId("getPagedForgersStakesByForger(bytes32,bytes32,bytes1,int32,int32)");
        this.GetPagedForgersStakesByDelegatorCmd = ABIUtil.getABIMethodId("getPagedForgersStakesByDelegator(address,int32,int32)");
        this.ActivateCmd = ABIUtil.getABIMethodId("activate()");
        this.GetForgerCmd = ABIUtil.getABIMethodId("getForger(bytes32,bytes32,bytes1)");
        this.GetPagedForgersCmd = ABIUtil.getABIMethodId("getPagedForgers(int32,int32)");
        this.GetCurrentConsensusEpochCmd = ABIUtil.getABIMethodId("getCurrentConsensusEpoch()");
        Predef$.MODULE$.require(this.RegisterForgerCmd().length() == 8 && this.UpdateForgerCmd().length() == 8 && this.DelegateCmd().length() == 8 && this.WithdrawCmd().length() == 8 && this.StakeTotalCmd().length() == 8 && this.StakeStartCmd().length() == 8 && this.RewardsReceivedCmd().length() == 8 && this.ActivateCmd().length() == 8 && this.GetPagedForgersStakesByForgerCmd().length() == 8 && this.GetPagedForgersStakesByDelegatorCmd().length() == 8 && this.GetForgerCmd().length() == 8 && this.GetPagedForgersCmd().length() == 8 && this.GetCurrentConsensusEpochCmd().length() == 8);
    }
}

