/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeStorage;
import io.horizen.account.state.ForgerStakeStorage$;
import io.horizen.account.state.ForgerStakeStorageElem;
import io.horizen.account.state.ForgerStakeStorageElemV2;
import io.horizen.account.state.ForgerStakeStorageElemV2Serializer$;
import io.horizen.account.state.ForgerStakeStorageVersion$;
import io.horizen.account.state.OwnerStakeInfo;
import io.horizen.account.state.StateDbArray;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ForgerStakeStorageV2$
implements ForgerStakeStorage {
    public static ForgerStakeStorageV2$ MODULE$;
    private final StateDbArray forgerStakeArray;

    static {
        new ForgerStakeStorageV2$();
    }

    @Override
    public boolean existsStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeStorage.existsStakeData$(this, view, stakeId);
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeStorage.findStakeData$(this, view, stakeId);
    }

    public StateDbArray forgerStakeArray() {
        return this.forgerStakeArray;
    }

    @Override
    public void setupStorage(BaseAccountStateView view) {
        ForgerStakeStorage$.MODULE$.saveStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
    }

    @Override
    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakes(BaseAccountStateView view, int startPos, int pageSize) {
        int stakeListSize = this.forgerStakeArray().getSize(view);
        if (startPos < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid startPos input: ").append(startPos).append(" can not be negative").toString());
        }
        if (startPos > stakeListSize - 1) {
            throw new IllegalArgumentException(new StringBuilder(76).append("Invalid position where to start reading forger stakes: ").append(startPos).append(", stakes array size: ").append(stakeListSize).toString());
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Invalid page size ").append(pageSize).append(", must be positive").toString());
        }
        int endPos = startPos + pageSize;
        if (endPos > stakeListSize) {
            endPos = stakeListSize;
        }
        IndexedSeq stakeList = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPos), endPos).map((Function1 & Serializable & scala.Serializable)index -> ForgerStakeStorageV2$.$anonfun$getPagedListOfForgersStakes$1(view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        if (endPos == stakeListSize) {
            endPos = -1;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)endPos), (Object)stakeList);
    }

    @Override
    public void addForgerStake(BaseAccountStateView view, byte[] stakeId, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, Address ownerPublicKey, BigInteger stakedAmount) {
        int forgerListIndex = this.forgerStakeArray().append(view, stakeId);
        AddressProposition ownerAddressProposition = new AddressProposition(ownerPublicKey);
        OwnerStakeInfo ownerInfo = new OwnerStakeInfo(ownerAddressProposition);
        int ownerListIndex = ownerInfo.append(view, stakeId);
        ownerInfo.addOwnerStake(view, stakedAmount);
        ForgerStakeStorageElemV2 forgerStakeData = new ForgerStakeStorageElemV2(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), ownerAddressProposition, stakedAmount, forgerListIndex, ownerListIndex);
        view.updateAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId, ForgerStakeStorageElemV2Serializer$.MODULE$.toBytes(forgerStakeData));
    }

    public BigInteger getOwnerStake(BaseAccountStateView view, AddressProposition owner) {
        OwnerStakeInfo ownerInfo = new OwnerStakeInfo(owner);
        return ownerInfo.getOwnerStake(view);
    }

    @Override
    public Option<ForgerStakeStorageElem> findForgerStakeStorageElem(BaseAccountStateView view, byte[] stakeId) {
        None$ none$;
        byte[] data = view.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId);
        if (data.length == 0) {
            none$ = None$.MODULE$;
        } else {
            Try<ForgerStakeStorageElemV2> try_ = ForgerStakeStorageElemV2Serializer$.MODULE$.parseBytesTry(data);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ExecutionRevertedException("Error while parsing forger data.", exception);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            ForgerStakeStorageElemV2 obj = (ForgerStakeStorageElemV2)success.value();
            Some some = new Some((Object)obj);
            none$ = some;
        }
        return none$;
    }

    @Override
    public void removeForgerStake(BaseAccountStateView view, byte[] stakeId, ForgerStakeStorageElem stake2) {
        int ownerStakeListIndex;
        OwnerStakeInfo ownerStakeInfo;
        byte[] stakeIdToMoveFromOwnerList;
        ForgerStakeStorageElemV2 stakeToRemove = (ForgerStakeStorageElemV2)stake2;
        int stakeListIndex = stakeToRemove.stakeListIndex();
        byte[] stakeIdToMove = this.forgerStakeArray().removeAndRearrange(view, stakeListIndex);
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeIdToMove)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(stakeId))) {
            this.updateStake(view, stakeIdToMove, (Function1<ForgerStakeStorageElemV2, ForgerStakeStorageElemV2>)(Function1 & Serializable & scala.Serializable)stake -> {
                stake.stakeListIndex_$eq(stakeListIndex);
                return stake;
            });
        }
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeIdToMoveFromOwnerList = (ownerStakeInfo = new OwnerStakeInfo(stakeToRemove.ownerPublicKey())).removeAndRearrange(view, ownerStakeListIndex = stakeToRemove.ownerListIndex()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(stakeId))) {
            this.updateStake(view, stakeIdToMoveFromOwnerList, (Function1<ForgerStakeStorageElemV2, ForgerStakeStorageElemV2>)(Function1 & Serializable & scala.Serializable)stake -> {
                stake.ownerListIndex_$eq(ownerStakeListIndex);
                return stake;
            });
        }
        ownerStakeInfo.subOwnerStake(view, stake2.stakedAmount());
        view.removeAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId);
    }

    private void updateStake(BaseAccountStateView view, byte[] stakeId, Function1<ForgerStakeStorageElemV2, ForgerStakeStorageElemV2> fun) {
        ForgerStakeStorageElemV2 stake = (ForgerStakeStorageElemV2)this.findForgerStakeStorageElem(view, stakeId).get();
        ForgerStakeStorageElemV2 updatedStake = (ForgerStakeStorageElemV2)fun.apply((Object)stake);
        view.updateAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId, ForgerStakeStorageElemV2Serializer$.MODULE$.toBytes(updatedStake));
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view) {
        return this.getListOfForgersStakesFromList(view, this.forgerStakeArray());
    }

    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakesOfUser(BaseAccountStateView view, AddressProposition owner, int startPos, int size) {
        OwnerStakeInfo ownerStakeIdArray = new OwnerStakeInfo(owner);
        return this.getPagedListOfForgersStakesFromList(view, ownerStakeIdArray, startPos, size);
    }

    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakesFromList(BaseAccountStateView view, StateDbArray stakeArray, int startPos, int pageSize) {
        int stakeListSize = stakeArray.getSize(view);
        if (startPos < 0) {
            throw new IllegalArgumentException(new StringBuilder(45).append("Invalid startPos input: ").append(startPos).append(", can not be negative").toString());
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Invalid page size ").append(pageSize).append(", must be positive").toString());
        }
        if (startPos == 0 && stakeListSize == 0) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)Nil$.MODULE$);
        }
        if (startPos > stakeListSize - 1) {
            throw new IllegalArgumentException(new StringBuilder(76).append("Invalid position where to start reading forger stakes: ").append(startPos).append(", stakes array size: ").append(stakeListSize).toString());
        }
        int endPos = startPos + pageSize;
        if (endPos > stakeListSize) {
            endPos = stakeListSize;
        }
        IndexedSeq stakeList = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPos), endPos).map((Function1 & Serializable & scala.Serializable)index -> ForgerStakeStorageV2$.$anonfun$getPagedListOfForgersStakesFromList$1(stakeArray, view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        if (endPos == stakeListSize) {
            endPos = -1;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)endPos), (Object)stakeList);
    }

    private Seq<AccountForgingStakeInfo> getListOfForgersStakesFromList(BaseAccountStateView view, StateDbArray stakeArray) {
        int numOfForgerStakes = stakeArray.getSize(view);
        IndexedSeq stakeList = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfForgerStakes).map((Function1 & Serializable & scala.Serializable)index -> ForgerStakeStorageV2$.$anonfun$getListOfForgersStakesFromList$1(stakeArray, view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        return stakeList;
    }

    @Override
    public boolean isForgerStakeAvailable(BaseAccountStateView view) {
        return this.forgerStakeArray().getSize(view) <= 5000;
    }

    public static final /* synthetic */ AccountForgingStakeInfo $anonfun$getPagedListOfForgersStakes$1(BaseAccountStateView view$1, int index) {
        byte[] currentStakeId = MODULE$.forgerStakeArray().getValue(view$1, index);
        ForgerStakeData stakeData = (ForgerStakeData)ForgerStakeDataSerializer$.MODULE$.parseBytes(view$1.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), currentStakeId));
        return new AccountForgingStakeInfo(currentStakeId, stakeData);
    }

    public static final /* synthetic */ AccountForgingStakeInfo $anonfun$getPagedListOfForgersStakesFromList$1(StateDbArray stakeArray$1, BaseAccountStateView view$2, int index) {
        byte[] currentStakeId = stakeArray$1.getValue(view$2, index);
        ForgerStakeData stakeData = (ForgerStakeData)ForgerStakeDataSerializer$.MODULE$.parseBytes(view$2.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), currentStakeId));
        return new AccountForgingStakeInfo(currentStakeId, stakeData);
    }

    public static final /* synthetic */ AccountForgingStakeInfo $anonfun$getListOfForgersStakesFromList$1(StateDbArray stakeArray$2, BaseAccountStateView view$3, int index) {
        byte[] currentStakeId = stakeArray$2.getValue(view$3, index);
        ForgerStakeData stakeData = (ForgerStakeData)MODULE$.findStakeData(view$3, currentStakeId).get();
        return new AccountForgingStakeInfo(currentStakeId, new ForgerStakeData(new ForgerPublicKeys(stakeData.forgerPublicKeys().blockSignPublicKey(), stakeData.forgerPublicKeys().vrfPublicKey()), stakeData.ownerPublicKey(), stakeData.stakedAmount()));
    }

    private ForgerStakeStorageV2$() {
        MODULE$ = this;
        ForgerStakeStorage.$init$(this);
        this.forgerStakeArray = new StateDbArray(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), "ForgerStakeList".getBytes("UTF-8"));
    }
}

