/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeStorage;
import io.horizen.account.state.ForgerStakeStorageElem;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import java.math.BigInteger;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import sparkz.crypto.hash.Blake2b256$;

public final class ForgerStakeStorageV1$
implements ForgerStakeStorage {
    public static ForgerStakeStorageV1$ MODULE$;
    private final byte[] LinkedListTipKey;
    private final byte[] LinkedListNullValue;

    static {
        new ForgerStakeStorageV1$();
    }

    @Override
    public boolean existsStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeStorage.existsStakeData$(this, view, stakeId);
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeStorage.findStakeData$(this, view, stakeId);
    }

    public byte[] LinkedListTipKey() {
        return this.LinkedListTipKey;
    }

    public byte[] LinkedListNullValue() {
        return this.LinkedListNullValue;
    }

    @Override
    public void setupStorage(BaseAccountStateView view) {
        byte[] initialTip = view.getAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.LinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("initial tip already set");
        }
        view.updateAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.LinkedListTipKey(), this.LinkedListNullValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view) {
        void var3_2;
        Seq stakeList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.LinkedListTipKey());
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block4: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block3: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getStakeListItem(view, nodeReference);
                    if (tuple2 == null) break block3;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block3;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block4;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            AccountForgingStakeInfo accountForgingStakeInfo2 = item;
            stakeList = (Seq)stakeList.$plus$colon((Object)accountForgingStakeInfo2, Seq$.MODULE$.canBuildFrom());
            nodeReference = prevNodeReference2;
        }
        return var3_2;
    }

    @Override
    public void addForgerStake(BaseAccountStateView view, byte[] stakeId, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, Address ownerPublicKey, BigInteger stakedAmount) {
        ForgerStakeLinkedList$.MODULE$.addNewNode(view, stakeId, WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS());
        ForgerStakeData forgerStakeData = new ForgerStakeData(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), new AddressProposition(ownerPublicKey), stakedAmount);
        view.updateAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId, ForgerStakeDataSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    @Override
    public Option<ForgerStakeStorageElem> findForgerStakeStorageElem(BaseAccountStateView view, byte[] stakeId) {
        return this.findStakeData(view, stakeId);
    }

    @Override
    public void removeForgerStake(BaseAccountStateView view, byte[] stakeId, ForgerStakeStorageElem stake) {
        ForgerStakeLinkedList$.MODULE$.removeNode(view, stakeId, WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS());
        view.removeAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId);
    }

    @Override
    public boolean isForgerStakeAvailable(BaseAccountStateView view) {
        return ForgerStakeLinkedList$.MODULE$.getStakeListSize(view) <= 5000;
    }

    @Override
    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakes(BaseAccountStateView view, int startPos, int pageSize) {
        throw new IllegalArgumentException("Method not supported before fork point 1_3");
    }

    private ForgerStakeStorageV1$() {
        MODULE$ = this;
        ForgerStakeStorage.$init$(this);
        this.LinkedListTipKey = Blake2b256$.MODULE$.hash("Tip");
        this.LinkedListNullValue = Blake2b256$.MODULE$.hash("Null");
    }
}

