/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerStakeStorage;
import io.horizen.account.state.ForgerStakeStorageV1$;
import io.horizen.account.state.ForgerStakeStorageV2$;
import io.horizen.account.state.ForgerStakeStorageVersion$;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.account.utils.WellKnownAddresses$;
import java.math.BigInteger;
import scala.Enumeration;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Blake2b256$;

public final class ForgerStakeStorage$ {
    public static ForgerStakeStorage$ MODULE$;
    private final byte[] ForgerStakeVersionKey;
    private final byte[] DisabledKey;

    static {
        new ForgerStakeStorage$();
    }

    public byte[] ForgerStakeVersionKey() {
        return this.ForgerStakeVersionKey;
    }

    public byte[] DisabledKey() {
        return this.DisabledKey;
    }

    public ForgerStakeStorage apply(Enumeration.Value storageVersion) {
        ForgerStakeStorage forgerStakeStorage;
        Enumeration.Value value = storageVersion;
        Enumeration.Value value2 = ForgerStakeStorageVersion$.MODULE$.VERSION_1();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            forgerStakeStorage = ForgerStakeStorageV1$.MODULE$;
        } else {
            Enumeration.Value value4 = ForgerStakeStorageVersion$.MODULE$.VERSION_2();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                forgerStakeStorage = ForgerStakeStorageV2$.MODULE$;
            } else {
                throw new ExecutionRevertedException("Unknown Forger Stake storage version");
            }
        }
        return forgerStakeStorage;
    }

    public Enumeration.Value getStorageVersionFromDb(BaseAccountStateView view) {
        byte[] version = view.getAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.ForgerStakeVersionKey());
        Enumeration.Value value = ForgerStakeStorageVersion$.MODULE$.apply(new BigInteger(1, version).intValueExact());
        Enumeration.Value value2 = ForgerStakeStorageVersion$.MODULE$.VERSION_2();
        Enumeration.Value value3 = value;
        Enumeration.Value value4 = !(value2 != null ? !value2.equals(value3) : value3 != null) ? ForgerStakeStorageVersion$.MODULE$.VERSION_2() : ForgerStakeStorageVersion$.MODULE$.VERSION_1();
        return value4;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] saveStorageVersion(BaseAccountStateView view, Enumeration.Value version) {
        void var3_3;
        byte[] ver = BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(version.id()));
        view.updateAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.ForgerStakeVersionKey(), ver);
        return var3_3;
    }

    public boolean isDisabled(BaseAccountStateView view) {
        byte[] disabled = view.getAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.DisabledKey());
        return BoxesRunTime.equalsNumNum((Number)new BigInteger(1, disabled), (Number)BigInteger.ONE);
    }

    public void setDisabled(BaseAccountStateView view) {
        byte[] disabled = BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.ONE);
        view.updateAccountStorage(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), this.DisabledKey(), disabled);
    }

    private ForgerStakeStorage$() {
        MODULE$ = this;
        this.ForgerStakeVersionKey = Blake2b256$.MODULE$.hash("ForgerStakeVersion");
        this.DisabledKey = Blake2b256$.MODULE$.hash("Disabled");
    }
}

