/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.fork.Version1_3_0Fork$;
import io.horizen.account.fork.Version1_4_0Fork$;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoListEncoder$;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddNewStakeCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakeStorage;
import io.horizen.account.state.ForgerStakeStorage$;
import io.horizen.account.state.ForgerStakeStorageElem;
import io.horizen.account.state.ForgerStakeStorageV1$;
import io.horizen.account.state.ForgerStakeStorageV2$;
import io.horizen.account.state.ForgerStakeStorageVersion$;
import io.horizen.account.state.ForgerStakeV2MsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GetPagedForgersStakesOfUserCmdInput;
import io.horizen.account.state.GetPagedForgersStakesOfUserCmdInputDecoder$;
import io.horizen.account.state.GetPagedListOfStakesCmdInput;
import io.horizen.account.state.GetPagedListOfStakesCmdInputDecoder$;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.Invocation$;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.OpenStakeForgerListCmdInputDecoder$;
import io.horizen.account.state.PagedListOfStakesOutput;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.RemoveStakeCmdInputDecoder$;
import io.horizen.account.state.StakeAmount;
import io.horizen.account.state.StakeOfCmdInput;
import io.horizen.account.state.StakeOfCmdInputDecoder$;
import io.horizen.account.state.events.DelegateForgerStake;
import io.horizen.account.state.events.DelegateForgerStake$;
import io.horizen.account.state.events.DisableStakeV1;
import io.horizen.account.state.events.OpenForgerList;
import io.horizen.account.state.events.OpenForgerList$;
import io.horizen.account.state.events.StakeUpgrade;
import io.horizen.account.state.events.StakeUpgrade$;
import io.horizen.account.state.events.WithdrawForgerStake;
import io.horizen.account.state.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.storage.MsgProcessorMetadataStorageReader;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\ref\u0001\u0002(P\u0001bC\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\ta\u0002\u0011\t\u0012)A\u0005W\")\u0011\u000f\u0001C\u0001e\"9Q\u000f\u0001b\u0001\n\u00032\bBB?\u0001A\u0003%q\u000fC\u0004\u007f\u0001\t\u0007I\u0011I@\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u0003A\u0001\"a\u0004\u0001\u0005\u0004%\tA\u001b\u0005\b\u0003#\u0001\u0001\u0015!\u0003l\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v!A\u00111\u0012\u0001\u0005BM\u000bi\tC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"I\u0011Q\u001b\u0001\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\b\u0003[\u0004A\u0011BAx\u0011\u001d\t)\u0010\u0001C!\u0003oDqA!\u0006\u0001\t\u0003\u00129\u0002C\u0004\u0003*\u0001!IAa\u000b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B%\u0001\u0011\u0005!1\n\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003l\u0001!\tA!\u001c\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0011\u001d\u00119\n\u0001C!\u00053CqA!)\u0001\t\u0003\u0012\u0019\u000b\u0003\u0005\u0003T\u0002!\te\u0015Bk\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057D\u0001B!9\u0001\t\u0003\u001a&1\u001d\u0005\n\u0005S\u0004\u0011\u0011!C\u0001\u0005WD\u0011Ba<\u0001#\u0003%\tA!=\t\u0013\tU\b!!A\u0005B\t]\b\"CB\u0003\u0001\u0005\u0005I\u0011AB\u0004\u0011%\u0019I\u0001AA\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\u0018\u0001\t\t\u0011\"\u0011\u0004\u001a!I1q\u0005\u0001\u0002\u0002\u0013\u00051\u0011\u0006\u0005\n\u0007[\u0001\u0011\u0011!C!\u0007_A\u0011b!\r\u0001\u0003\u0003%\tea\r\t\u0013\rU\u0002!!A\u0005B\r]raBB\u001e\u001f\"\u00051Q\b\u0004\u0007\u001d>C\taa\u0010\t\rE\fD\u0011AB$\u0011!\u0019I%\rb\u0001\n\u0003y\b\u0002CB&c\u0001\u0006I!!\u0001\t\u0013\r5\u0013G1A\u0005\u0002\r=\u0003\u0002CB0c\u0001\u0006Ia!\u0015\t\u0013\r\u0005\u0014G1A\u0005\u0002\r=\u0003\u0002CB2c\u0001\u0006Ia!\u0015\t\u0013\r\u0015\u0014G1A\u0005\u0002\r=\u0003\u0002CB4c\u0001\u0006Ia!\u0015\t\u0013\r%\u0014G1A\u0005\u0002\r=\u0003\u0002CB6c\u0001\u0006Ia!\u0015\t\u0013\r5\u0014G1A\u0005\u0002\r=\u0003\u0002CB8c\u0001\u0006Ia!\u0015\t\u0013\rE\u0014G1A\u0005\u0002\r=\u0003\u0002CB:c\u0001\u0006Ia!\u0015\t\u0013\rU\u0014G1A\u0005\u0002\r=\u0003\u0002CB<c\u0001\u0006Ia!\u0015\t\u0013\re\u0014G1A\u0005\u0002\r=\u0003\u0002CB>c\u0001\u0006Ia!\u0015\t\u0013\ru\u0014G1A\u0005\u0002\r=\u0003\u0002CB@c\u0001\u0006Ia!\u0015\t\u0013\r\u0005\u0015G1A\u0005\u0002\r=\u0003\u0002CBBc\u0001\u0006Ia!\u0015\t\u000f\r\u0015\u0015\u0007\"\u0001\u0004\b\"911S\u0019\u0005\u0002\rU\u0005\"CBPc\u0005\u0005I\u0011QBQ\u0011%\u0019)+MA\u0001\n\u0003\u001b9\u000bC\u0005\u00040F\n\t\u0011\"\u0003\u00042\n9bi\u001c:hKJ\u001cF/Y6f\u001bN<\u0007K]8dKN\u001cxN\u001d\u0006\u0003!F\u000bQa\u001d;bi\u0016T!AU*\u0002\u000f\u0005\u001c7m\\;oi*\u0011A+V\u0001\bQ>\u0014\u0018N_3o\u0015\u00051\u0016AA5p\u0007\u0001\u0019R\u0001A-^A\u001a\u0004\"AW.\u000e\u0003=K!\u0001X(\u0003?9\u000bG/\u001b<f'6\f'\u000f^\"p]R\u0014\u0018m\u0019;Ng\u001e\u0004&o\\2fgN|'\u000f\u0005\u0002[=&\u0011ql\u0014\u0002\u0015\r>\u0014x-\u001a:Ti\u0006\\Wm\u001d)s_ZLG-\u001a:\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011mZ\u0005\u0003Q\n\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001]1sC6\u001cX#A6\u0011\u00051tW\"A7\u000b\u0005%\u001c\u0016BA8n\u00055qU\r^<pe.\u0004\u0016M]1ng\u00069\u0001/\u0019:b[N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002tiB\u0011!\f\u0001\u0005\u0006S\u000e\u0001\ra[\u0001\u0010G>tGO]1di\u0006#GM]3tgV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{'\u0006\u0019QM^7\n\u0005qL(aB!eIJ,7o]\u0001\u0011G>tGO]1di\u0006#GM]3tg\u0002\nAbY8oiJ\f7\r^\"pI\u0016,\"!!\u0001\u0011\u000b\u0005\f\u0019!a\u0002\n\u0007\u0005\u0015!MA\u0003BeJ\f\u0017\u0010E\u0002b\u0003\u0013I1!a\u0003c\u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\r|g\u000e\u001e:bGR\u001cu\u000eZ3!\u00035qW\r^<pe.\u0004\u0016M]1ng\u0006qa.\u001a;x_J\\\u0007+\u0019:b[N\u0004\u0013AC4fiN#\u0018m[3JIR!\u0011\u0011AA\f\u0011\u001d\tIB\u0003a\u0001\u00037\t1!\\:h!\rQ\u0016QD\u0005\u0004\u0003?y%aB'fgN\fw-Z\u0001\u0005S:LG\u000f\u0006\u0004\u0002&\u0005-\u0012Q\u0007\t\u0004C\u0006\u001d\u0012bAA\u0015E\n!QK\\5u\u0011\u001d\tic\u0003a\u0001\u0003_\tAA^5foB\u0019!,!\r\n\u0007\u0005MrJ\u0001\u000bCCN,\u0017iY2pk:$8\u000b^1uKZKWm\u001e\u0005\b\u0003oY\u0001\u0019AA\u001d\u0003Q\u0019wN\\:f]N,8/\u00129pG\"tU/\u001c2feB\u0019\u0011-a\u000f\n\u0007\u0005u\"MA\u0002J]R\fAdZ3u\r>\u0014x-\u001a:Ti\u0006\\Wm\u0015;pe\u0006<WMV3sg&|g\u000e\u0006\u0004\u0002D\u0005\u001d\u0014\u0011\u000e\t\u0005\u0003\u000b\n\tG\u0004\u0003\u0002H\u0005uc\u0002BA%\u00037rA!a\u0013\u0002Z9!\u0011QJA,\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*/\u00061AH]8pizJ\u0011AV\u0005\u0003)VK!AU*\n\u0005A\u000b\u0016bAA0\u001f\u0006Ibi\u001c:hKJ\u001cF/Y6f'R|'/Y4f-\u0016\u00148/[8o\u0013\u0011\t\u0019'!\u001a\u00033\u0019{'oZ3s'R\f7.Z*u_J\fw-\u001a,feNLwN\u001c\u0006\u0004\u0003?z\u0005bBA\u0017\u0019\u0001\u0007\u0011q\u0006\u0005\b\u0003Wb\u0001\u0019AA7\u0003AI7OR8sWZ\u000btlM!di&4X\rE\u0002b\u0003_J1!!\u001dc\u0005\u001d\u0011un\u001c7fC:\fQBZ5oIN#\u0018m[3ECR\fG\u0003CA<\u0003\u0007\u000b))!#\u0011\u000b\u0005\fI(! \n\u0007\u0005m$M\u0001\u0004PaRLwN\u001c\t\u00045\u0006}\u0014bAAA\u001f\nyai\u001c:hKJ\u001cF/Y6f\t\u0006$\u0018\rC\u0004\u0002.5\u0001\r!a\f\t\u000f\u0005\u001dU\u00021\u0001\u0002\u0002\u000591\u000f^1lK&#\u0007bBA6\u001b\u0001\u0007\u0011QN\u0001\u0017SN4uN]4feN#\u0018m[3Bm\u0006LG.\u00192mKR1\u0011QNAH\u0003#Cq!!\f\u000f\u0001\u0004\ty\u0003C\u0004\u0002l9\u0001\r!!\u001c\u00021\u0005$GmU2De\u0016\fG/[8o\r>\u0014x-\u001a:Ti\u0006\\W\r\u0006\u0006\u0002\u0002\u0005]\u0015\u0011TAO\u0003cCq!!\f\u0010\u0001\u0004\ty\u0003\u0003\u0004\u0002\u001c>\u0001\ra^\u0001\u0006_^tWM\u001d\u0005\b\u0003?{\u0001\u0019AAQ\u0003\u00151\u0018\r\\;f!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bA!\\1uQ*\u0011\u00111V\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0006\u0015&A\u0003\"jO&sG/Z4fe\"9\u00111W\bA\u0002\u0005U\u0016\u0001\u00023bi\u0006\u00042AWA\\\u0013\r\tIl\u0014\u0002\u0014\u0003\u0012$g*Z<Ti\u0006\\WmQ7e\u0013:\u0004X\u000f^\u0001\u0011I>\fE\r\u001a(foN#\u0018m[3D[\u0012$B\"!\u0001\u0002@\u0006%\u00171ZAg\u0003#Dq!!1\u0011\u0001\u0004\t\u0019-\u0001\u0006j]Z|7-\u0019;j_:\u00042AWAc\u0013\r\t9m\u0014\u0002\u000b\u0013:4xnY1uS>t\u0007bBA\u0017!\u0001\u0007\u0011q\u0006\u0005\b\u00033\u0001\u0002\u0019AA\u000e\u0011\u001d\ty\r\u0005a\u0001\u0003[\n\u0011#[:G_J\\g+M04?\u0006\u001bG/\u001b<f\u0011%\t\u0019\u000e\u0005I\u0001\u0002\u0004\ti'A\njg\u001e+g.Z:jgN\u001b7I]3bi&|g.\u0001\u000ee_\u0006#GMT3x'R\f7.Z\"nI\u0012\"WMZ1vYR$S'\u0006\u0002\u0002Z*\"\u0011QNAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtE\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!H2iK\u000e\\\u0017J\u001c9vi\u0012{Wm\u001d8u\u0007>tG/Y5o!\u0006\u0014\u0018-\\:\u0015\t\u0005\u0015\u0012\u0011\u001f\u0005\b\u0003g\u0014\u0002\u0019AA\u0001\u0003!\u0019\u0017\r\u001c7eCR\f\u0017AF4fi2K7\u000f^(g\r>\u0014x-\u001a:t'R\f7.Z:\u0015\r\u0005e(\u0011\u0003B\n!\u0019\tYP!\u0002\u0003\f9!\u0011Q B\u0001\u001d\u0011\ty%a@\n\u0003\rL1Aa\u0001c\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0002\u0003\n\t\u00191+Z9\u000b\u0007\t\r!\rE\u0002[\u0005\u001bI1Aa\u0004P\u0005]\t5mY8v]R4uN]4j]\u001e\u001cF/Y6f\u0013:4w\u000eC\u0004\u0002.M\u0001\r!a\f\t\u000f\u0005-4\u00031\u0001\u0002n\u0005Yr-\u001a;QC\u001e,G\rT5ti>3gi\u001c:hKJ\u001c8\u000b^1lKN$\u0002B!\u0007\u0003 \t\u0005\"Q\u0005\t\bC\nm\u0011\u0011HA}\u0013\r\u0011iB\u0019\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u00055B\u00031\u0001\u00020!9!1\u0005\u000bA\u0002\u0005e\u0012\u0001C:uCJ$\bk\\:\t\u000f\t\u001dB\u00031\u0001\u0002:\u0005A\u0001/Y4f'&TX-A\u000bhKR4uN]4feN#\u0018m[3Ti>\u0014\u0018mZ3\u0015\r\t5\"1\u0007B\u001b!\rQ&qF\u0005\u0004\u0005cy%A\u0005$pe\u001e,'o\u0015;bW\u0016\u001cFo\u001c:bO\u0016Dq!!\f\u0016\u0001\u0004\ty\u0003C\u0004\u0002lU\u0001\r!!\u001c\u0002I\u0011|WK\\2iK\u000e\\W\rZ$fi2K7\u000f^(g\r>\u0014x-\u001a:t'R\f7.Z:D[\u0012$b!!\u0001\u0003<\tu\u0002bBA\u0017-\u0001\u0007\u0011q\u0006\u0005\b\u0003W2\u0002\u0019AA7\u0003U!wnR3u\u0019&\u001cHo\u00144G_J<WM]:D[\u0012$\u0002\"!\u0001\u0003D\t\u0015#q\t\u0005\b\u0003\u0003<\u0002\u0019AAb\u0011\u001d\tic\u0006a\u0001\u0003_Aq!a\u001b\u0018\u0001\u0004\ti'\u0001\u000ee_\u001e+G\u000fU1hK\u0012d\u0015n\u001d;PM\u001a{'oZ3sg\u000ekG\r\u0006\u0004\u0002\u0002\t5#q\n\u0005\b\u0003\u0003D\u0002\u0019AAb\u0011\u001d\ti\u0003\u0007a\u0001\u0003_\tA\u0002Z8Va\u001e\u0014\u0018\rZ3D[\u0012$b!!\u0001\u0003V\t]\u0003bBAa3\u0001\u0007\u00111\u0019\u0005\b\u0003[I\u0002\u0019AA\u0018\u0003i\u0019\u0007.Z2l\u0007V\u0014(/\u001a8u'R|'/Y4f-\u0016\u00148/[8o)\u0019\t)C!\u0018\u0003`!9\u0011Q\u0006\u000eA\u0002\u0005=\u0002b\u0002B15\u0001\u0007\u00111I\u0001\u0017e\u0016\fX/\u001b:fIN#xN]1hKZ+'o]5p]\u0006aAm\\*uC.,wJZ\"nIR1\u0011\u0011\u0001B4\u0005SBq!!1\u001c\u0001\u0004\t\u0019\rC\u0004\u0002.m\u0001\r!a\f\u0002A\u0011|w)\u001a;QC\u001e,GMR8sO\u0016\u00148o\u0015;bW\u0016\u001cxJZ+tKJ\u001cU\u000e\u001a\u000b\u0007\u0003\u0003\u0011yG!\u001d\t\u000f\u0005\u0005G\u00041\u0001\u0002D\"9\u0011Q\u0006\u000fA\u0002\u0005=\u0012\u0001\u00053p%\u0016lwN^3Ti\u0006\\WmQ7e))\t\tAa\u001e\u0003z\tm$Q\u0010\u0005\b\u0003\u0003l\u0002\u0019AAb\u0011\u001d\ti#\ba\u0001\u0003_Aq!!\u0007\u001e\u0001\u0004\tY\u0002C\u0004\u0002lu\u0001\r!!\u001c\u00025\u001d,G/\u00117m_^,GMR8sO\u0016\u00148/\u00138eKbd\u0015n\u001d;\u0015\t\u0005\u0005!1\u0011\u0005\b\u0003[q\u0002\u0019AA\u0018\u0003a!wn\u00149f]N#\u0018m[3G_J<WM\u001d'jgR\u001cU\u000e\u001a\u000b\t\u0003\u0003\u0011IIa#\u0003\u000e\"9\u0011\u0011Y\u0010A\u0002\u0005\r\u0007bBA\u0017?\u0001\u0007\u0011q\u0006\u0005\b\u00033y\u0002\u0019AA\u000e\u0003M!w\u000eR5tC\ndW-\u00118e\u001b&<'/\u0019;f)\u0019\t\tAa%\u0003\u0016\"9\u0011\u0011\u0019\u0011A\u0002\u0005\r\u0007bBA\u0017A\u0001\u0007\u0011qF\u0001%SN4uN]4feN#\u0018m[3WcMk\u0017M\u001d;D_:$(/Y2u\t&\u001c\u0018M\u00197fIR1\u0011Q\u000eBN\u0005;Cq!!\f\"\u0001\u0004\ty\u0003C\u0004\u0003 \u0006\u0002\r!!\u001c\u0002!%\u001chi\u001c:l-FzF'Q2uSZ,\u0017a\u00029s_\u000e,7o\u001d\u000b\u000b\u0003\u0003\u0011)Ka*\u0003*\ne\u0006bBAaE\u0001\u0007\u00111\u0019\u0005\b\u0003[\u0011\u0003\u0019AA\u0018\u0011\u001d\u0011YK\ta\u0001\u0005[\u000b\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0005_\u0013),\u0004\u0002\u00032*\u0019!1W)\u0002\u000fM$xN]1hK&!!q\u0017BY\u0005\u0005j5o\u001a)s_\u000e,7o]8s\u001b\u0016$\u0018\rZ1uCN#xN]1hKJ+\u0017\rZ3s\u0011\u001d\u0011YL\ta\u0001\u0005{\u000bqaY8oi\u0016DH\u000fE\u0002[\u0005\u007fK1A!1P\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fK\u0003#\u0005\u000b\u0014\t\u000eE\u0003b\u0005\u000f\u0014Y-C\u0002\u0003J\n\u0014a\u0001\u001e5s_^\u001c\bc\u0001.\u0003N&\u0019!qZ(\u00031\u0015CXmY;uS>tg)Y5mK\u0012,\u0005pY3qi&|gn\t\u0002\u0003L\u0006\u0001\u0012n\u001d$pe\u001e,'\u000fT5ti>\u0003XM\u001c\u000b\u0005\u0003[\u00129\u000eC\u0004\u0002.\r\u0002\r!a\f\u00023%\u001chi\u001c:hKJd\u0015n\u001d;Pa\u0016tWK\\2iK\u000e\\W\r\u001a\u000b\u0005\u0003[\u0012i\u000eC\u0004\u0003`\u0012\u0002\r!!\u0001\u0002\t1L7\u000f^\u0001\u001cO\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJd\u0015n\u001d;J]\u0012,\u00070Z:\u0015\t\t\u0015(q\u001d\t\u0007\u0003w\u0014)!!\u000f\t\u000f\u00055R\u00051\u0001\u00020\u0005!1m\u001c9z)\r\u0019(Q\u001e\u0005\bS\u001a\u0002\n\u00111\u0001l\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa=+\u0007-\fY.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005s\u0004BAa?\u0004\u00025\u0011!Q \u0006\u0005\u0005\u007f\fI+\u0001\u0003mC:<\u0017\u0002BB\u0002\u0005{\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001d\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!\u0004\u0004\u0014A\u0019\u0011ma\u0004\n\u0007\rE!MA\u0002B]fD\u0011b!\u0006+\u0003\u0003\u0005\r!!\u000f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019Y\u0002\u0005\u0004\u0004\u001e\r\r2QB\u0007\u0003\u0007?Q1a!\tc\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007K\u0019yB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA7\u0007WA\u0011b!\u0006-\u0003\u0003\u0005\ra!\u0004\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!?\u0002\r\u0015\fX/\u00197t)\u0011\tig!\u000f\t\u0013\rUq&!AA\u0002\r5\u0011a\u0006$pe\u001e,'o\u0015;bW\u0016l5o\u001a)s_\u000e,7o]8s!\tQ\u0016g\u0005\u00032\u0007\u00032\u0007cA1\u0004D%\u00191Q\t2\u0003\r\u0005s\u0017PU3g)\t\u0019i$A\rSKN$(/[2uK\u00124uN]4fe\u001ac\u0017mZ:MSN$\u0018A\u0007*fgR\u0014\u0018n\u0019;fI\u001a{'oZ3s\r2\fwm\u001d'jgR\u0004\u0013\u0001G$fiB\u000bw-\u001a3MSN$xJ\u001a$pe\u001e,'o]\"nIV\u00111\u0011\u000b\t\u0005\u0007'\u001aYF\u0004\u0003\u0004V\r]\u0003cAA(E&\u00191\u0011\f2\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019\u0019a!\u0018\u000b\u0007\re#-A\rHKR\u0004\u0016mZ3e\u0019&\u001cHo\u00144G_J<WM]:D[\u0012\u0004\u0013aE$fi2K7\u000f^(g\r>\u0014x-\u001a:t\u00076$\u0017\u0001F$fi2K7\u000f^(g\r>\u0014x-\u001a:t\u00076$\u0007%\u0001\bBI\u0012tUm^*uC.,7)\u001c3\u0002\u001f\u0005#GMT3x'R\f7.Z\"nI\u0002\naBU3n_Z,7\u000b^1lK\u000ekG-A\bSK6|g/Z*uC.,7)\u001c3!\u0003Yy\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$\u0017aF(qK:\u001cF/Y6f\r>\u0014x-\u001a:MSN$8)\u001c3!\u0003uy\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$7i\u001c:sK\u000e$\u0018AH(qK:\u001cF/Y6f\r>\u0014x-\u001a:MSN$8)\u001c3D_J\u0014Xm\u0019;!\u0003))\u0006o\u001a:bI\u0016\u001cU\u000eZ\u0001\f+B<'/\u00193f\u00076$\u0007%\u0001\u0006Ti\u0006\\Wm\u00144D[\u0012\f1b\u0015;bW\u0016|emQ7eA\u0005qr)\u001a;QC\u001e,GMR8sO\u0016\u00148o\u0015;bW\u0016\u001cxJZ+tKJ\u001cU\u000eZ\u0001 \u000f\u0016$\b+Y4fI\u001a{'oZ3sgN#\u0018m[3t\u001f\u001a,6/\u001a:D[\u0012\u0004\u0013\u0001\u0006#jg\u0006\u0014G.Z!oI6KwM]1uK\u000ekG-A\u000bESN\f'\r\\3B]\u0012l\u0015n\u001a:bi\u0016\u001cU\u000e\u001a\u0011\u0002=\u001d,GOU3n_Z,7\u000b^1lK\u000ekG-T3tg\u0006<W\rV8TS\u001etG\u0003CA\u0001\u0007\u0013\u001bYia$\t\u000f\u0005\u001d\u0015\n1\u0001\u0002\u0002!11QR%A\u0002]\fAA\u001a:p[\"91\u0011S%A\u0002\u0005\u0005\u0011!\u00028p]\u000e,\u0017AJ4fi>\u0003XM\\*uC.,gi\u001c:hKJd\u0015n\u001d;D[\u0012lUm]:bO\u0016$vnU5h]RA\u0011\u0011ABL\u00077\u001bi\nC\u0004\u0004\u001a*\u0003\r!!\u000f\u0002\u0017\u0019|'oZ3s\u0013:$W\r\u001f\u0005\u0007\u0007\u001bS\u0005\u0019A<\t\u000f\rE%\n1\u0001\u0002\u0002\u0005)\u0011\r\u001d9msR\u00191oa)\t\u000b%\\\u0005\u0019A6\u0002\u000fUt\u0017\r\u001d9msR!1\u0011VBV!\u0011\t\u0017\u0011P6\t\u0011\r5F*!AA\u0002M\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rM\u0006\u0003\u0002B~\u0007kKAaa.\u0003~\n1qJ\u00196fGR\u0004")
public class ForgerStakeMsgProcessor
extends NativeSmartContractMsgProcessor
implements ForgerStakesProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final NetworkParams networkParams;

    public static Option<NetworkParams> unapply(ForgerStakeMsgProcessor forgerStakeMsgProcessor) {
        return ForgerStakeMsgProcessor$.MODULE$.unapply(forgerStakeMsgProcessor);
    }

    public static ForgerStakeMsgProcessor apply(NetworkParams networkParams) {
        return ForgerStakeMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] getOpenStakeForgerListCmdMessageToSign(int n, Address address, byte[] byArray) {
        return ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(n, address, byArray);
    }

    public static byte[] getRemoveStakeCmdMessageToSign(byte[] byArray, Address address, byte[] byArray2) {
        return ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(byArray, address, byArray2);
    }

    public static String DisableAndMigrateCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.DisableAndMigrateCmd();
    }

    public static String GetPagedForgersStakesOfUserCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetPagedForgersStakesOfUserCmd();
    }

    public static String StakeOfCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.StakeOfCmd();
    }

    public static String UpgradeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.UpgradeCmd();
    }

    public static String OpenStakeForgerListCmdCorrect() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
    }

    public static String OpenStakeForgerListCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
    }

    public static String RemoveStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
    }

    public static String AddNewStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
    }

    public static String GetListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
    }

    public static String GetPagedListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetPagedListOfForgersCmd();
    }

    public static byte[] RestrictedForgerFlagsList() {
        return ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    public byte[] getStakeId(Message msg) {
        return Keccak256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{msg.getFrom().toBytes(), msg.getNonce().toByteArray(), msg.getValue().toByteArray(), msg.getData()}));
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        super.init(view, consensusEpochNumber);
        Enumeration.Value forgingStakeStorageVersion = Version1_3_0Fork$.MODULE$.get(consensusEpochNumber).active() ? ForgerStakeStorageVersion$.MODULE$.VERSION_2() : ForgerStakeStorageVersion$.MODULE$.VERSION_1();
        ForgerStakeStorage forgingStakeStorage = ForgerStakeStorage$.MODULE$.apply(forgingStakeStorageVersion);
        forgingStakeStorage.setupStorage(view);
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("restrictForgerList already set");
        }
    }

    public Enumeration.Value getForgerStakeStorageVersion(BaseAccountStateView view, boolean isForkV1_3Active) {
        return isForkV1_3Active ? ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view) : ForgerStakeStorageVersion$.MODULE$.VERSION_1();
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId, boolean isForkV1_3Active) {
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        return stakeStorage.findStakeData(view, stakeId);
    }

    @Override
    public boolean isForgerStakeAvailable(BaseAccountStateView view, boolean isForkV1_3Active) {
        boolean bl;
        if (!isForkV1_3Active) {
            bl = true;
        } else {
            ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, true);
            bl = stakeStorage.isForgerStakeAvailable(view);
        }
        return bl;
    }

    @Override
    public byte[] addScCreationForgerStake(BaseAccountStateView view, Address owner, BigInteger value, AddNewStakeCmdInput data) {
        Message msg = new Message(owner, Optional.of(this.contractAddress()), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, value, BigInteger.ONE.negate(), Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), data.encode()}), false);
        return this.doAddNewStakeCmd(Invocation$.MODULE$.fromMessage(msg), view, msg, Version1_3_0Fork$.MODULE$.get(0).active(), true);
    }

    public byte[] doAddNewStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg, boolean isForkV1_3_Active, boolean isGenesisScCreation) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        BigInteger stakedAmount = invocation.value();
        if (stakedAmount.signum() <= 0) {
            throw new ExecutionRevertedException("Value must not be zero");
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount)) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Value is not a legal wei amount: ").append(stakedAmount.toString()).toString());
        }
        if (!view.accountExists(invocation.caller()) && !isGenesisScCreation) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(invocation.caller()).toString());
        }
        if (!this.isForgerStakeAvailable(view, isForkV1_3_Active)) {
            throw new ExecutionRevertedException("Unable to add new forger stake");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        AddNewStakeCmdInput cmdInput = (AddNewStakeCmdInput)AddNewStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPublicKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPublicKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        Address ownerAddress = cmdInput.ownerAddress();
        if (!view.isEoaAccount(ownerAddress)) {
            throw new ExecutionRevertedException("Owner account is not an EOA");
        }
        if (!(isGenesisScCreation || this.isForgerListOpen(view) || this.networkParams().allowedForgersList().contains((Object)new Tuple2((Object)blockSignPublicKey, (Object)vrfPublicKey)))) {
            throw new ExecutionRevertedException("Forger is not in the allowed list");
        }
        byte[] newStakeId = this.getStakeId(msg);
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3_Active);
        if (stakeStorage.existsStakeData(view, newStakeId)) {
            throw new ExecutionRevertedException(new StringBuilder(21).append("Stake ").append(BytesUtils.toHexString(newStakeId)).append(" already exists").toString());
        }
        stakeStorage.addForgerStake(view, newStakeId, blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Added stake to stateDb: newStakeId={}, blockSignPublicKey={}, vrfPublicKey={}, ownerAddress={}, stakedAmount={}", new Object[]{BytesUtils.toHexString(newStakeId), blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DelegateForgerStake addNewStakeEvt = DelegateForgerStake$.MODULE$.apply(invocation.caller(), ownerAddress, newStakeId, stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewStakeEvt);
        view.addLog(evmLog);
        if (isGenesisScCreation) {
            view.addBalance(this.contractAddress(), stakedAmount);
        } else {
            view.subBalance(invocation.caller(), stakedAmount);
            view.addBalance(this.contractAddress(), stakedAmount);
        }
        return newStakeId;
    }

    public boolean doAddNewStakeCmd$default$5() {
        return false;
    }

    private void checkInputDoesntContainParams(byte[] calldata) {
        if (ABIUtil.getArgumentsFromData(calldata).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(calldata.length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view, boolean isForkV1_3Active) {
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        return stakeStorage.getListOfForgersStakes(view);
    }

    @Override
    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakes(BaseAccountStateView view, int startPos, int pageSize) {
        return ForgerStakeStorageV2$.MODULE$.getPagedListOfForgersStakes(view, startPos, pageSize);
    }

    private ForgerStakeStorage getForgerStakeStorage(BaseAccountStateView view, boolean isForkV1_3Active) {
        Enumeration.Value forgerStakeStorageVersion = this.getForgerStakeStorageVersion(view, isForkV1_3Active);
        ForgerStakeStorage stakeStorage = ForgerStakeStorage$.MODULE$.apply(forgerStakeStorageVersion);
        return stakeStorage;
    }

    public byte[] doUncheckedGetListOfForgersStakesCmd(BaseAccountStateView view, boolean isForkV1_3Active) {
        Seq<AccountForgingStakeInfo> stakeList = this.getListOfForgersStakes(view, isForkV1_3Active);
        return AccountForgingStakeInfoListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(stakeList).asJava());
    }

    public byte[] doGetListOfForgersCmd(Invocation invocation, BaseAccountStateView view, boolean isForkV1_3Active) {
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation.input());
        return this.doUncheckedGetListOfForgersStakesCmd(view, isForkV1_3Active);
    }

    public byte[] doGetPagedListOfForgersCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        GetPagedListOfStakesCmdInput cmdInput = (GetPagedListOfStakesCmdInput)GetPagedListOfStakesCmdInputDecoder$.MODULE$.decode(inputParams);
        int size = cmdInput.size();
        int startPos = cmdInput.startPos();
        Tuple2<Object, Seq<AccountForgingStakeInfo>> tuple2 = this.getPagedListOfForgersStakes(view, startPos, size);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int nextPos = tuple2._1$mcI$sp();
        Seq stakeList = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextPos), (Object)stakeList);
        Tuple2 tuple23 = tuple22;
        int nextPos2 = tuple23._1$mcI$sp();
        Seq stakeList2 = (Seq)tuple23._2();
        return new PagedListOfStakesOutput(nextPos2, (Seq<AccountForgingStakeInfo>)stakeList2).encode();
    }

    public byte[] doUpgradeCmd(Invocation invocation, BaseAccountStateView view) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation.input());
        Enumeration.Value value = ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view);
        Enumeration.Value value2 = ForgerStakeStorageVersion$.MODULE$.VERSION_2();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            BoxedUnit boxedUnit2;
            String msgStr = "Forger stake storage already upgraded";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        ForgerStakeStorage forgerStakeStorage = ForgerStakeStorage$.MODULE$.apply(ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), ForgerStakeStorageV1$.MODULE$.LinkedListTipKey());
        int numOfMigratedElem = 0;
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block10: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block9: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getStakeListItem(view, nodeReference);
                    if (tuple2 == null) break block9;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block9;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block10;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            forgerStakeStorage.addForgerStake(view, item.stakeId(), item.forgerStakeData().forgerPublicKeys().blockSignPublicKey(), item.forgerStakeData().forgerPublicKeys().vrfPublicKey(), item.forgerStakeData().ownerPublicKey().address(), item.forgerStakeData().stakedAmount());
            ForgerStakeLinkedList$.MODULE$.removeNode(view, item.stakeId(), this.contractAddress());
            nodeReference = prevNodeReference2;
            ++numOfMigratedElem;
        }
        view.removeAccountStorage(this.contractAddress(), ForgerStakeStorageV1$.MODULE$.LinkedListTipKey());
        StakeUpgrade upgradeEvent = StakeUpgrade$.MODULE$.apply(ForgerStakeStorageVersion$.MODULE$.VERSION_1().id(), ForgerStakeStorageVersion$.MODULE$.VERSION_2().id());
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(upgradeEvent);
        view.addLog(evmLog);
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Forger stakes storage upgraded successfully to version 2 - {} items migrated", new Object[]{BoxesRunTime.boxToInteger((int)numOfMigratedElem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ForgerStakeStorage$.MODULE$.saveStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
    }

    public void checkCurrentStorageVersion(BaseAccountStateView view, Enumeration.Value requiredStorageVersion) {
        Enumeration.Value value = ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view);
        Enumeration.Value value2 = requiredStorageVersion;
        if (value == null ? value2 != null : !value.equals(value2)) {
            BoxedUnit boxedUnit;
            String msgStr = "Forger stake storage not upgraded yet";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    public byte[] doStakeOfCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        StakeOfCmdInput cmdInput = (StakeOfCmdInput)StakeOfCmdInputDecoder$.MODULE$.decode(inputParams);
        BigInteger totalStake = ForgerStakeStorageV2$.MODULE$.getOwnerStake(view, new AddressProposition(cmdInput.ownerAddress()));
        return new StakeAmount(totalStake).encode();
    }

    public byte[] doGetPagedForgersStakesOfUserCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        GetPagedForgersStakesOfUserCmdInput cmdInput = (GetPagedForgersStakesOfUserCmdInput)GetPagedForgersStakesOfUserCmdInputDecoder$.MODULE$.decode(inputParams);
        Tuple2<Object, Seq<AccountForgingStakeInfo>> tuple2 = ForgerStakeStorageV2$.MODULE$.getPagedListOfForgersStakesOfUser(view, new AddressProposition(cmdInput.ownerAddress()), cmdInput.startPos(), cmdInput.size());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int nextPos = tuple2._1$mcI$sp();
        Seq stakeList = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextPos), (Object)stakeList);
        Tuple2 tuple23 = tuple22;
        int nextPos2 = tuple23._1$mcI$sp();
        Seq stakeList2 = (Seq)tuple23._2();
        return new PagedListOfStakesOutput(nextPos2, (Seq<AccountForgingStakeInfo>)stakeList2).encode();
    }

    public byte[] doRemoveStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg, boolean isForkV1_3Active) {
        boolean result;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        this.requireIsNotPayable(invocation);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RemoveStakeCmdInput cmdInput = (RemoveStakeCmdInput)RemoveStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        byte[] stakeId = cmdInput.stakeId();
        SignatureSecp256k1 signature = cmdInput.signature();
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        ForgerStakeStorageElem stakeData = (ForgerStakeStorageElem)stakeStorage.findForgerStakeStorageElem(view, stakeId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("No such stake id in state-db");
        });
        byte[] msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(stakeId, invocation.caller(), msg.getNonce().toByteArray());
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> signature.isValid(stakeData.ownerPublicKey(), msgToSign));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(39).append("Could not verify ill-formed signature: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean bl = result = BoxesRunTime.unboxToBoolean((Object)success.value());
        boolean isValid = bl;
        if (!isValid) {
            throw new ExecutionRevertedException("Invalid signature");
        }
        stakeStorage.removeForgerStake(view, stakeId, stakeData);
        WithdrawForgerStake removeStakeEvt = WithdrawForgerStake$.MODULE$.apply(stakeData.ownerPublicKey().address(), stakeId);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakeData.stakedAmount());
        view.addBalance(stakeData.ownerPublicKey().address(), stakeData.stakedAmount());
        return stakeId;
    }

    private byte[] getAllowedForgersIndexList(BaseAccountStateView view) {
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new IllegalStateException("Illegal call when list of forger is empty");
        }
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32())) ? new byte[this.networkParams().allowedForgersList().size()] : view.getAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
    }

    public byte[] doOpenStakeForgerListCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        byte[] msgToSign;
        if (!this.networkParams().restrictForgers()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is not restricted");
        }
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is empty");
        }
        this.requireIsNotPayable(invocation);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        OpenStakeForgerListCmdInput cmdInput = (OpenStakeForgerListCmdInput)OpenStakeForgerListCmdInputDecoder$.MODULE$.decode(inputParams);
        int forgerIndex = cmdInput.forgerIndex();
        Signature25519 signature = cmdInput.signature();
        if (this.networkParams().allowedForgersList().size() < forgerIndex + 1) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Invalid forgerIndex=").append(forgerIndex).append(": allowedForgersList size=").append(this.networkParams().allowedForgersList().size()).toString());
        }
        PublicKey25519Proposition blockSignerProposition = (PublicKey25519Proposition)((Tuple2)this.networkParams().allowedForgersList().apply(forgerIndex))._1();
        if (!signature.isValid(blockSignerProposition, msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(forgerIndex, invocation.caller(), msg.getNonce().toByteArray()))) {
            throw new ExecutionRevertedException(new StringBuilder(69).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignerProposition).toString());
        }
        byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
        if (this.isForgerListOpenUnchecked(restrictForgerList)) {
            throw new ExecutionRevertedException("Forger list already open");
        }
        if (restrictForgerList[forgerIndex] == 1) {
            throw new ExecutionRevertedException("Forger index already processed");
        }
        restrictForgerList[forgerIndex] = 1;
        view.updateAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList(), restrictForgerList);
        OpenForgerList addOpenStakeForgerListEvt = OpenForgerList$.MODULE$.apply(forgerIndex, invocation.caller(), blockSignerProposition);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addOpenStakeForgerListEvt);
        view.addLog(evmLog);
        return restrictForgerList;
    }

    public byte[] doDisableAndMigrate(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation.input());
        Address address = WellKnownAddresses$.MODULE$.FORGER_STAKE_V2_SMART_CONTRACT_ADDRESS();
        Address address2 = invocation.caller();
        if ((address != null ? !address.equals(address2) : address2 != null) || !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(view.getCodeHash(invocation.caller()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(ForgerStakeV2MsgProcessor$.MODULE$.contractCodeHash()))) {
            throw new ExecutionRevertedException("Authorization failed");
        }
        ForgerStakeStorage$.MODULE$.setDisabled(view);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(new DisableStakeV1());
        view.addLog(evmLog);
        return this.doUncheckedGetListOfForgersStakesCmd(view, true);
    }

    @Override
    public boolean isForgerStakeV1SmartContractDisabled(BaseAccountStateView view, boolean isForkV1_4Active) {
        return isForkV1_4Active && ForgerStakeStorage$.MODULE$.isDisabled(view);
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, MsgProcessorMetadataStorageReader metadata, ExecutionContext context) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        if (Version1_4_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active() && ForgerStakeStorage$.MODULE$.isDisabled(gasView)) {
            byte[] byArray2;
            String string = ABIUtil.getFunctionSignature(invocation.input());
            String string2 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                byArray2 = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
            } else {
                String string4 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    byArray2 = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                } else {
                    boolean bl;
                    String string6 = ForgerStakeMsgProcessor$.MODULE$.GetPagedListOfForgersCmd();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        bl = true;
                    } else {
                        String string8 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            bl = true;
                        } else {
                            String string10 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                bl = true;
                            } else {
                                String string12 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                                String string13 = string;
                                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                    bl = true;
                                } else {
                                    String string14 = ForgerStakeMsgProcessor$.MODULE$.UpgradeCmd();
                                    String string15 = string;
                                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                        bl = true;
                                    } else {
                                        String string16 = ForgerStakeMsgProcessor$.MODULE$.StakeOfCmd();
                                        String string17 = string;
                                        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                            bl = true;
                                        } else {
                                            String string18 = ForgerStakeMsgProcessor$.MODULE$.GetPagedForgersStakesOfUserCmd();
                                            String string19 = string;
                                            if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                                bl = true;
                                            } else {
                                                String string20 = ForgerStakeMsgProcessor$.MODULE$.DisableAndMigrateCmd();
                                                String string21 = string;
                                                bl = !(string20 != null ? !string20.equals(string21) : string21 != null);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (bl) {
                        throw new ExecutionRevertedException("Method is disabled - Please use the new ForgeStakeV2");
                    }
                    throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                }
            }
            byArray = byArray2;
        } else {
            byte[] byArray3;
            String string = ABIUtil.getFunctionSignature(invocation.input());
            String string22 = ForgerStakeMsgProcessor$.MODULE$.GetPagedListOfForgersCmd();
            String string23 = string;
            if (!(string22 != null ? !string22.equals(string23) : string23 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                byArray3 = this.doGetPagedListOfForgersCmd(invocation, gasView);
            } else {
                String string24 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
                String string25 = string;
                if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                    byArray3 = this.doGetListOfForgersCmd(invocation, gasView, Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active());
                } else {
                    String string26 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
                    String string27 = string;
                    if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                        byArray3 = this.doAddNewStakeCmd(invocation, gasView, context.msg(), Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active(), this.doAddNewStakeCmd$default$5());
                    } else {
                        String string28 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                        String string29 = string;
                        if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                            byArray3 = this.doRemoveStakeCmd(invocation, gasView, context.msg(), Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active());
                        } else {
                            String string30 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
                            String string31 = string;
                            if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                byArray3 = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                            } else {
                                String string32 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
                                String string33 = string;
                                if (!(string32 != null ? !string32.equals(string33) : string33 != null) && Version1_2_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                    byArray3 = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                                } else {
                                    String string34 = ForgerStakeMsgProcessor$.MODULE$.UpgradeCmd();
                                    String string35 = string;
                                    if (!(string34 != null ? !string34.equals(string35) : string35 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                        byArray3 = this.doUpgradeCmd(invocation, view);
                                    } else {
                                        String string36 = ForgerStakeMsgProcessor$.MODULE$.StakeOfCmd();
                                        String string37 = string;
                                        if (!(string36 != null ? !string36.equals(string37) : string37 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                            byArray3 = this.doStakeOfCmd(invocation, gasView);
                                        } else {
                                            String string38 = ForgerStakeMsgProcessor$.MODULE$.GetPagedForgersStakesOfUserCmd();
                                            String string39 = string;
                                            if (!(string38 != null ? !string38.equals(string39) : string39 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                                byArray3 = this.doGetPagedForgersStakesOfUserCmd(invocation, gasView);
                                            } else {
                                                String string40 = ForgerStakeMsgProcessor$.MODULE$.DisableAndMigrateCmd();
                                                String string41 = string;
                                                if (!(string40 != null ? !string40.equals(string41) : string41 != null) && Version1_4_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                                    byArray3 = this.doDisableAndMigrate(invocation, view);
                                                } else {
                                                    throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            byArray = byArray3;
        }
        return byArray;
    }

    @Override
    public boolean isForgerListOpen(BaseAccountStateView view) {
        boolean bl;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            bl = this.isForgerListOpenUnchecked(restrictForgerList);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isForgerListOpenUnchecked(byte[] list) {
        return BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(list)).sum((Numeric)Numeric.ByteIsIntegral$.MODULE$)) > list.length / 2;
    }

    @Override
    public Seq<Object> getAllowedForgerListIndexes(BaseAccountStateView view) {
        Seq seq;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            seq = (Seq)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$4)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public ForgerStakeMsgProcessor copy(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ForgerStakeMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ForgerStakeMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ForgerStakeMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ForgerStakeMsgProcessor forgerStakeMsgProcessor = (ForgerStakeMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = forgerStakeMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!forgerStakeMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public ForgerStakeMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeSmartContractCode");
        this.networkParams = params;
    }
}

