/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.block;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.Bloom$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.TrieHasher;
import io.horizen.history.validation.InconsistentSidechainBlockDataException;
import io.horizen.history.validation.InconsistentSidechainBlockDataException$;
import io.horizen.history.validation.InvalidSidechainBlockDataException;
import io.horizen.history.validation.InvalidSidechainBlockDataException$;
import io.horizen.json.Views;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"messageToSign", "transactions", "version", "serializer", "modifierTypeId", "encoder", "companion", "forgerPublicKey", "logger"})
@ScalaSignature(bytes="\u0006\u0001\r\re\u0001\u0002\u0016,\u0001QB\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t%\u0017\u0005\n5\u0002\u0011\t\u0011)A\u0005\u0019nC\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%\u0018\u0005\nY\u0002\u0011\t\u0011)A\u0005=6D\u0001B\u001c\u0001\u0003\u0006\u0004%\te\u001c\u0005\ni\u0002\u0011\t\u0011)A\u0005aVD\u0001B\u001e\u0001\u0003\u0006\u0004%\te\u001e\u0005\ny\u0002\u0011\t\u0011)A\u0005qvD\u0001B \u0001\u0003\u0006\u0004%\te \u0005\r\u0003\u0013\u0001!\u0011!Q\u0001\n\u0005\u0005\u00111\u0002\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001bBA\r\u0001\u0011\u0005\u00111D\u0003\u0007\u0003W\u0001\u0001%!\b\t\u0015\u00055\u0002\u0001#b\u0001\n\u0003\ny\u0003C\u0005\u00028\u0001A)\u0019!C!;\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!a)\u0001\t\u0003\t)\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\ty\u000f\u0001C!\u0003cDq!a=\u0001\t\u0003\n)pB\u0004\u0003`-B\tA!\u0019\u0007\r)Z\u0003\u0012\u0001B2\u0011\u001d\tI\"\bC\u0001\u0005cB\u0011Ba\u001d\u001e\u0005\u0004%\tA!\u001e\t\u0011\t5U\u0004)A\u0005\u0005oB\u0011Ba$\u001e\u0005\u0004%\tA!%\t\u0011\teU\u0004)A\u0005\u0005'C\u0011Ba'\u001e\u0005\u0004%\tA!%\t\u0011\tuU\u0004)A\u0005\u0005'CqAa(\u001e\t\u0003\u0011\t\u000bC\u0005\u0004Ru\t\n\u0011\"\u0001\u0004T!91qM\u000f\u0005\u0002\r%\u0004bBB7;\u0011\u00051q\u000e\u0005\n\u0007gj\u0012\u0011!C\u0005\u0007k\u0012A\"Q2d_VtGO\u00117pG.T!\u0001L\u0017\u0002\u000b\tdwnY6\u000b\u00059z\u0013aB1dG>,h\u000e\u001e\u0006\u0003aE\nq\u0001[8sSj,gNC\u00013\u0003\tIwn\u0001\u0001\u0014\u0007\u0001)\u0004\u000b\u0005\u00037qibU\"A\u001c\u000b\u00051z\u0013BA\u001d8\u0005I\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.\u0014\u0015m]3\u0011\tmr\u0004IR\u0007\u0002y)\u0011Q(L\u0001\fiJ\fgn]1di&|g.\u0003\u0002@y\t\u0011\u0012iY2pk:$HK]1og\u0006\u001cG/[8o!\t\tE)D\u0001C\u0015\t\u0019u&A\u0006qe>\u0004xn]5uS>t\u0017BA#C\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\u0007\u001dS\u0005)D\u0001I\u0015\tIu&A\u0003qe>|g-\u0003\u0002L\u0011\n)\u0001K]8pMB\u0011QJT\u0007\u0002W%\u0011qj\u000b\u0002\u0013\u0003\u000e\u001cw.\u001e8u\u00052|7m\u001b%fC\u0012,'\u000f\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016AB:qCJ\\'0\u0003\u0002X%\ni1\u000b]1sWjdunZ4j]\u001e\fa\u0001[3bI\u0016\u0014X#\u0001'\u0002\u000f!,\u0017\rZ3sA%\u0011\u0001\fO\u0001\u0016g&$Wm\u00195bS:$&/\u00198tC\u000e$\u0018n\u001c8t+\u0005q\u0006cA0ju9\u0011\u0001M\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003GN\na\u0001\u0010:p_Rt\u0014\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001dD\u0017a\u00029bG.\fw-\u001a\u0006\u0002K&\u0011!n\u001b\u0002\u0004'\u0016\f(BA4i\u0003Y\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]N\u0004\u0013B\u0001/9\u0003qi\u0017-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cWm\u001d#bi\u0006,\u0012\u0001\u001d\t\u0004?&\f\bC\u0001\u001cs\u0013\t\u0019xGA\u000eNC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\u0012\u000bG/Y\u0001\u001e[\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016\u001cH)\u0019;bA%\u0011a\u000eO\u0001\u0011[\u0006Lgn\u00195bS:DU-\u00193feN,\u0012\u0001\u001f\t\u0004?&L\bC\u0001\u001c{\u0013\tYxGA\bNC&t7\r[1j]\"+\u0017\rZ3s\u0003Ei\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u00148\u000fI\u0005\u0003mb\naa\\7nKJ\u001cXCAA\u0001!\u0011y\u0016.a\u0001\u0011\tY\n)\u0001T\u0005\u0004\u0003\u000f9$!B(n[\u0016\u0014\u0018aB8n[\u0016\u00148\u000fI\u0005\u0003}b\n\u0011bY8na\u0006t\u0017n\u001c8\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q1!!\u0004.\u0013\u0011\t9\"a\u0005\u0003KMKG-Z2iC&t\u0017iY2pk:$HK]1og\u0006\u001cG/[8og\u000e{W\u000e]1oS>t\u0017A\u0002\u001fj]&$h\b\u0006\b\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0011\u00055\u0003\u0001\"\u0002-\r\u0001\u0004a\u0005\"\u0002/\r\u0001\u0004q\u0006\"\u00028\r\u0001\u0004\u0001\b\"\u0002<\r\u0001\u0004A\bB\u0002@\r\u0001\u0004\t\t\u0001C\u0004\u0002\u000e1\u0001\r!a\u0004\u0003\u00035\u000b!b]3sS\u0006d\u0017N_3s+\t\t\t\u0004E\u0002N\u0003gI1!!\u000e,\u0005Y\t5mY8v]R\u0014En\\2l'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001c\u0018a\u00044pe\u001e,'\u000fU;cY&\u001c7*Z=\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0007j!!!\u0011\u000b\u0005\rk\u0013\u0002BA#\u0003\u0003\u0012!#\u00113ee\u0016\u001c8\u000f\u0015:pa>\u001c\u0018\u000e^5p]\u0006\tc/\u001a:jMf$&/\u00198tC\u000e$\u0018n\u001c8t\t\u0006$\u0018mQ8og&\u001cH/\u001a8dsR\u0011\u00111\n\t\u0005\u0003\u001b\ny%D\u0001i\u0013\r\t\t\u0006\u001b\u0002\u0005+:LG\u000fK\u0003\u0012\u0003+\nY\u0007\u0005\u0004\u0002N\u0005]\u00131L\u0005\u0004\u00033B'A\u0002;ie><8\u000f\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0015Y\fG.\u001b3bi&|gNC\u0002\u0002f=\nq\u0001[5ti>\u0014\u00180\u0003\u0003\u0002j\u0005}#aJ%oG>t7/[:uK:$8+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\G)\u0019;b\u000bb\u001cW\r\u001d;j_:\u001c#!a\u0017\u00029Y,'/\u001b4z%\u0016\u001cW-\u001b9u\t\u0006$\u0018mQ8og&\u001cH/\u001a8dsR!\u00111JA9\u0011\u001d\t\u0019H\u0005a\u0001\u0003k\n1B]3dK&\u0004H\u000fT5tiB!q,[A<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nqA]3dK&\u0004HOC\u0002\u0002\u00026\nQa\u001d;bi\u0016LA!!\"\u0002|\taR\t\u001e5fe\u0016,XnQ8og\u0016t7/^:ECR\f'+Z2fSB$\b&\u0002\n\u0002V\u0005-\u0014\u0001\u0007<fe&4\u0017pR1t+N,GmQ8og&\u001cH/\u001a8dsR!\u00111JAG\u0011\u001d\tyi\u0005a\u0001\u0003#\u000bq\"\u001a=qK\u000e$X\rZ$bgV\u001bX\r\u001a\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0011i\u0017\r\u001e5\u000b\u0005\u0005m\u0015\u0001\u00026bm\u0006LA!a(\u0002\u0016\nQ!)[4J]R,w-\u001a:)\u000bM\t)&a\u001b\u0002=Y,'/\u001b4z'R\fG/\u001a*p_R$\u0015\r^1D_:\u001c\u0018n\u001d;f]\u000eLH\u0003BA&\u0003OCq!!+\u0015\u0001\u0004\tY+A\u0005ti\u0006$XMU8piB1\u0011QJAW\u0003cK1!a,i\u0005\u0015\t%O]1z!\u0011\ti%a-\n\u0007\u0005U\u0006N\u0001\u0003CsR,\u0007&\u0002\u000b\u0002V\u0005-\u0014A\u0007<fe&4\u0017\u0010T8hg\ncwn\\7D_:\u001c\u0018n\u001d;f]\u000eLH\u0003BA&\u0003{Cq!a0\u0016\u0001\u0004\t\t-\u0001\u0005sK\u000e,\u0017\u000e\u001d;t!\u0011y\u0016.a1\u0011\t\u0005e\u0014QY\u0005\u0005\u0003\u000f\fYHA\bFi\",'/Z;n%\u0016\u001cW-\u001b9uQ\u0015)\u0012QKA6\u000391XM]:j_:L5OV1mS\u0012$\"!a4\u0011\t\u00055\u0013\u0011[\u0005\u0004\u0003'D'a\u0002\"p_2,\u0017M\\\u0001!iJ\fgn]1di&|gn\u001d'jgR,\u0005pY3fIN\u001c\u0016N_3MS6LG/\u0006\u0002\u0002P\u0006)\"\r\\8dW\u0016C8-Z3egNK'0\u001a'j[&$H\u0003BAh\u0003;Dq!a8\u0019\u0001\u0004\t\t/A\u0005cY>\u001c7nU5{KB!\u0011QJAr\u0013\r\t)\u000f\u001b\u0002\u0005\u0019>tw-A\u000fcY>\u001c7.\u0012=dK\u0016$7o\u0014<fe\",\u0017\rZ*ju\u0016d\u0015.\\5u)\u0011\ty-a;\t\u000f\u00055\u0018\u00041\u0001\u0002b\u0006\t\"\r\\8dW>3XM\u001d5fC\u0012\u001c\u0016N_3\u0002\u0017\tdwnY6UqNK'0\u001a\u000b\u0003\u0003C\fqc\u00195fG.$\u0006pU3nC:$\u0018n\u0019,bY&$\u0017\u000e^=\u0015\t\u0005-\u0013q\u001f\u0005\b\u0003s\\\u0002\u0019AA~\u0003\u0019\u0001\u0018M]1ngB!\u0011Q B\u0001\u001b\t\tyPC\u0002\u0002z>JAAa\u0001\u0002\u0000\nia*\u001a;x_J\\\u0007+\u0019:b[NDs\u0001\u0001B\u0004\u0005?\u0011\t\u0003\u0005\u0003\u0003\n\tmQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0003\u0012\tM\u0011a\u00026bG.\u001cxN\u001c\u0006\u0005\u0005+\u00119\"A\u0005gCN$XM\u001d=nY*\u0011!\u0011D\u0001\u0004G>l\u0017\u0002\u0002B\u000f\u0005\u0017\u0011ACS:p]&;gn\u001c:f!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u0002<bYV,GF\u0005B\u0012\u0005O\u0011IC!\f\u00030\tM\"q\u0007B\u001d\u0005w\t#A!\n\u0002\u001b5,7o]1hKR{7+[4oC\t\t9$\t\u0002\u0003,\u00059a/\u001a:tS>t\u0017EAA\u0017C\t\u0011\t$\u0001\bn_\u0012Lg-[3s)f\u0004X-\u00133\"\u0005\tU\u0012aB3oG>$WM]\u0011\u0003\u0003\u001b\t#!!\u000f\"\u0005\tu\u0012A\u00027pO\u001e,'\u000fK\u0004\u0001\u0005\u0003\u0012yBa\u0012\u0011\t\t%!1I\u0005\u0005\u0005\u000b\u0012YA\u0001\u0005Kg>tg+[3xY\t\u0011Ie\t\u0002\u0003LA!!Q\nB-\u001d\u0011\u0011yE!\u0016\u000e\u0005\tE#b\u0001B*_\u0005!!n]8o\u0013\u0011\u00119F!\u0015\u0002\u000bYKWm^:\n\t\tm#Q\f\u0002\b\t\u00164\u0017-\u001e7u\u0015\u0011\u00119F!\u0015\u0002\u0019\u0005\u001b7m\\;oi\ncwnY6\u0011\u00055k2#B\u000f\u0003f\t-\u0004\u0003BA'\u0005OJ1A!\u001bi\u0005\u0019\te.\u001f*fMB!\u0011Q\nB7\u0013\r\u0011y\u0007\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005C\nQ#Q\"D\u001fVsEk\u0018\"M\u001f\u000e[uLV#S'&{e*\u0006\u0002\u0003xA!!\u0011\u0010BD\u001d\u0011\u0011YHa!\u000e\u0005\tu$b\u0001\u0017\u0003\u0000)\u0019!\u0011\u0011+\u0002\t\r|'/Z\u0005\u0005\u0005\u000b\u0013i(A\u0003CY>\u001c7.\u0003\u0003\u0003\n\n-%a\u0002,feNLwN\u001c\u0006\u0005\u0005\u000b\u0013i(\u0001\fB\u0007\u000e{UK\u0014+`\u00052{5iS0W\u000bJ\u001b\u0016j\u0014(!\u0003}i\u0015\tW0B\u0007\u000e{UK\u0014+`\u00052{5iS0P-\u0016\u0013\u0006*R!E?NK%,R\u000b\u0003\u0005'\u0003B!!\u0014\u0003\u0016&\u0019!q\u00135\u0003\u0007%sG/\u0001\u0011N\u0003b{\u0016iQ\"P+:#vL\u0011'P\u0007.{vJV#S\u0011\u0016\u000bEiX*J5\u0016\u0003\u0013AF'B1~\u000b5iQ(V\u001dR{&\tT(D\u0017~\u001b\u0016JW#\u0002/5\u000b\u0005lX!D\u0007>+f\nV0C\u0019>\u001b5jX*J5\u0016\u0003\u0013AB2sK\u0006$X\r\u0006\u0018\u0003$\n5&q\u0017B^\u0005\u000b\u00149M!3\u0003L\n5'Q\u001cBw\u0005o\u001c9aa\u0006\u0004\u001c\ru1\u0011EB\u0013\u0007S\u0019ic!\r\u00044\r\u0005\u0003C\u0002BS\u0005S\u000bi\"\u0004\u0002\u0003(*\u00111\u000b[\u0005\u0005\u0005W\u00139KA\u0002UefDqAa,&\u0001\u0004\u0011\t,\u0001\u0005qCJ,g\u000e^%e!\u0011\u0011IHa-\n\t\tU&1\u0012\u0002\b\u00052|7m[%e\u0011\u001d\u0011I,\na\u0001\u0005o\nAB\u00197pG.4VM]:j_:DqA!0&\u0001\u0004\u0011y,A\u0005uS6,7\u000f^1naB!!\u0011\u0010Ba\u0013\u0011\u0011\u0019Ma#\u0003\u0013QKW.Z:uC6\u0004\b\"\u00028&\u0001\u0004\u0001\b\"\u0002/&\u0001\u0004q\u0006\"\u0002<&\u0001\u0004A\bB\u0002@&\u0001\u0004\t\t\u0001C\u0004\u0003P\u0016\u0002\rA!5\u0002\u001f=<h.\u001a:Qe&4\u0018\r^3LKf\u0004BAa5\u0003Z6\u0011!Q\u001b\u0006\u0004\u0005/|\u0013AB:fGJ,G/\u0003\u0003\u0003\\\nU'a\u0004)sSZ\fG/Z&fsJ*T'M\u001d\t\u000f\t}W\u00051\u0001\u0003b\u0006\u0001bm\u001c:hS:<7\u000b^1lK&sgm\u001c\t\u0005\u0005G\u0014I/\u0004\u0002\u0003f*\u0019!q]\u0018\u0002\u0013\r|gn]3ogV\u001c\u0018\u0002\u0002Bv\u0005K\u0014\u0001CR8sO&twm\u0015;bW\u0016LeNZ8\t\u000f\t=X\u00051\u0001\u0003r\u0006AaO\u001d4Qe>|g\rE\u0002H\u0005gL1A!>I\u0005!1&O\u001a)s_>4\u0007b\u0002B}K\u0001\u0007!1`\u0001\nmJ4w*\u001e;qkR\u0004BA!@\u0004\u00045\u0011!q \u0006\u0004\u0007\u0003y\u0013a\u0001<sM&!1Q\u0001B\u0000\u0005%1&OZ(viB,H\u000fC\u0004\u0004\n\u0015\u0002\raa\u0003\u00025\u0019|'oZ5oON#\u0018m[3J]\u001a|W*\u001a:lY\u0016\u0004\u0016\r\u001e5\u0011\t\r511C\u0007\u0003\u0007\u001fQ1a!\u00050\u0003\u0015)H/\u001b7t\u0013\u0011\u0019)ba\u0004\u0003\u00155+'o\u001b7f!\u0006$\b\u000eC\u0004\u0004\u001a\u0015\u0002\r!a+\u0002\u001f\u0019,W\rU1z[\u0016tGo\u001d%bg\"Dq!!+&\u0001\u0004\tY\u000bC\u0004\u0004 \u0015\u0002\r!a+\u0002\u0019I,7-Z5qiN\u0014vn\u001c;\t\u000f\r\rR\u00051\u0001\u0002>\u0005iam\u001c:hKJ\fE\r\u001a:fgNDqaa\n&\u0001\u0004\t\t*A\u0004cCN,g)Z3\t\u000f\r-R\u00051\u0001\u0002\u0012\u00069q-Y:Vg\u0016$\u0007bBB\u0018K\u0001\u0007\u0011\u0011S\u0001\tO\u0006\u001cH*[7ji\"9\u0011QB\u0013A\u0002\u0005=\u0001bBB\u001bK\u0001\u00071qG\u0001\nY><7O\u00117p_6\u0004Ba!\u000f\u0004>5\u001111\b\u0006\u0004\u0007#i\u0013\u0002BB \u0007w\u0011QA\u00117p_6D\u0011ba\u0011&!\u0003\u0005\ra!\u0012\u0002\u001fMLwM\\1ukJ,w\n\u001d;j_:\u0004b!!\u0014\u0004H\r-\u0013bAB%Q\n1q\n\u001d;j_:\u00042aRB'\u0013\r\u0019y\u0005\u0013\u0002\u000f'&<g.\u0019;ve\u0016\u0014T'N\u0019:\u0003E\u0019'/Z1uK\u0012\"WMZ1vYR$#GM\u000b\u0003\u0007+RCa!\u0012\u0004X-\u00121\u0011\f\t\u0005\u00077\u001a\u0019'\u0004\u0002\u0004^)!1qLB1\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e!LAa!\u001a\u0004^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002G\r\fGnY;mCR,GK]1og\u0006\u001cG/[8og6+'o\u001b7f%>|G\u000fS1tQR!\u00111VB6\u0011\u0015av\u00051\u0001_\u0003Q\u0019\u0017\r\\2vY\u0006$XMU3dK&\u0004HOU8piR!\u00111VB9\u0011\u001d\t\u0019\b\u000ba\u0001\u0003k\n1B]3bIJ+7o\u001c7wKR\u00111q\u000f\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)!1QPAM\u0003\u0011a\u0017M\\4\n\t\r\u000551\u0010\u0002\u0007\u001f\nTWm\u0019;")
public class AccountBlock
extends SidechainBlockBase<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader>
implements SparkzLogging {
    private AccountBlockSerializer serializer;
    private Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions;
    private final SidechainAccountTransactionsCompanion companion;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static byte[] calculateReceiptRoot(Seq<EthereumConsensusDataReceipt> seq) {
        return AccountBlock$.MODULE$.calculateReceiptRoot(seq);
    }

    public static byte[] calculateTransactionsMerkleRootHash(Seq<AccountTransaction<Proposition, Proof<Proposition>>> seq) {
        return AccountBlock$.MODULE$.calculateTransactionsMerkleRootHash(seq);
    }

    public static Option<Signature25519> create$default$22() {
        return AccountBlock$.MODULE$.create$default$22();
    }

    public static Try<AccountBlock> create(String string, byte by, long l, Seq<MainchainBlockReferenceData> seq, Seq<AccountTransaction<Proposition, Proof<Proposition>>> seq2, Seq<MainchainHeader> seq3, Seq<Ommer<AccountBlockHeader>> seq4, PrivateKey25519 privateKey25519, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath merklePath, byte[] byArray, byte[] byArray2, byte[] byArray3, AddressProposition addressProposition, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SidechainAccountTransactionsCompanion sidechainAccountTransactionsCompanion, Bloom bloom, Option<Signature25519> option) {
        return AccountBlock$.MODULE$.create(string, by, l, seq, seq2, seq3, seq4, privateKey25519, forgingStakeInfo, vrfProof, vrfOutput, merklePath, byArray, byArray2, byArray3, addressProposition, bigInteger, bigInteger2, bigInteger3, sidechainAccountTransactionsCompanion, bloom, option);
    }

    public static int MAX_ACCOUNT_BLOCK_SIZE() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    public static int MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    public static byte ACCOUNT_BLOCK_VERSION() {
        return AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public AccountBlockHeader header() {
        return (AccountBlockHeader)super.header();
    }

    @Override
    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions() {
        return super.sidechainTransactions();
    }

    @Override
    public Seq<MainchainBlockReferenceData> mainchainBlockReferencesData() {
        return super.mainchainBlockReferencesData();
    }

    @Override
    public Seq<MainchainHeader> mainchainHeaders() {
        return super.mainchainHeaders();
    }

    @Override
    public Seq<Ommer<AccountBlockHeader>> ommers() {
        return super.ommers();
    }

    private AccountBlockSerializer serializer$lzycompute() {
        AccountBlock accountBlock = this;
        synchronized (accountBlock) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serializer = new AccountBlockSerializer(this.companion);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serializer;
    }

    public AccountBlockSerializer serializer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    private Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions$lzycompute() {
        AccountBlock accountBlock = this;
        synchronized (accountBlock) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.transactions = this.sidechainTransactions();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transactions;
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transactions$lzycompute() : this.transactions;
    }

    public AddressProposition forgerPublicKey() {
        return this.header().forgerAddress();
    }

    @Override
    public void verifyTransactionsDataConsistency() throws InconsistentSidechainBlockDataException {
        byte[] txRootHash = TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)this.sidechainTransactions().map((Function1 & Serializable & scala.Serializable)tx -> tx.bytes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
        if (!Arrays.equals(txRootHash, this.header().sidechainTransactionsMerkleRootHash())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(49).append("Invalid transaction root hash: actual ").append(BytesUtils.toHexString(this.header().sidechainTransactionsMerkleRootHash())).append(", expected ").append(BytesUtils.toHexString(txRootHash)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyReceiptDataConsistency(Seq<EthereumConsensusDataReceipt> receiptList) throws InconsistentSidechainBlockDataException {
        byte[] receiptRootHash = AccountBlock$.MODULE$.calculateReceiptRoot(receiptList);
        if (!Arrays.equals(receiptRootHash, this.header().receiptsRoot())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(46).append("Invalid receipts root hash: actual ").append(BytesUtils.toHexString(this.header().receiptsRoot())).append(", expected ").append(BytesUtils.toHexString(receiptRootHash)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyGasUsedConsistency(BigInteger expectedGasUsed) throws InconsistentSidechainBlockDataException {
        if (!expectedGasUsed.equals(this.header().gasUsed())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(36).append("Invalid gas used: actual ").append(this.header().gasUsed()).append(", expected ").append(expectedGasUsed).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyStateRootDataConsistency(byte[] stateRoot) throws InconsistentSidechainBlockDataException {
        if (!Arrays.equals(stateRoot, this.header().stateRoot())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(43).append("Invalid state root hash: actual ").append(BytesUtils.toHexString(this.header().stateRoot())).append(", expected ").append(BytesUtils.toHexString(stateRoot)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyLogsBloomConsistency(Seq<EthereumReceipt> receipts) throws InconsistentSidechainBlockDataException {
        Bloom logsBloom = Bloom$.MODULE$.fromReceipts((Seq<EthereumConsensusDataReceipt>)((Seq)receipts.map((Function1 & Serializable & scala.Serializable)r -> r.consensusDataReceipt(), Seq$.MODULE$.canBuildFrom())));
        if (!logsBloom.equals(this.header().logsBloom())) {
            BoxedUnit boxedUnit;
            String reason = "Invalid logs bloom";
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public boolean versionIsValid() {
        return this.version() == AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION();
    }

    @Override
    public boolean transactionsListExceedsSizeLimit() {
        return false;
    }

    @Override
    public boolean blockExceedsSizeLimit(long blockSize) {
        return blockSize > (long)AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    @Override
    public boolean blockExceedsOverheadSizeLimit(long blockOverheadSize) {
        return blockOverheadSize > (long)AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    @Override
    public long blockTxSize() {
        return new ListSerializer<AccountTransaction<Proposition, Proof<Proposition>>>(this.companion).toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(this.sidechainTransactions()).asJava()).length;
    }

    @Override
    public void checkTxSemanticValidity(NetworkParams params) {
        int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params.sidechainGenesisBlockTimestamp(), this.timestamp());
        this.sidechainTransactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
            AccountBlock.$anonfun$checkTxSemanticValidity$1(this, consensusEpochNumber, tx);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkTxSemanticValidity$1(AccountBlock $this, int consensusEpochNumber$1, AccountTransaction tx) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> tx.semanticValidity(consensusEpochNumber$1));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new InvalidSidechainBlockDataException(new StringBuilder(41).append($this.getClass().getSimpleName()).append(" ").append($this.id()).append(" Transaction ").append(tx.id()).append(" is semantically invalid: ").append(e.getMessage()).append(".").toString(), InvalidSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AccountBlock(AccountBlockHeader header, Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<AccountBlockHeader>> ommers, SidechainAccountTransactionsCompanion companion) {
        this.companion = companion;
        super(header, sidechainTransactions, mainchainBlockReferencesData, mainchainHeaders, ommers);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

