/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.block;

import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt$;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.utils.Bloom;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.TrieHasher;
import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.utils.MerklePath;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class AccountBlock$
implements scala.Serializable {
    public static AccountBlock$ MODULE$;
    private final byte ACCOUNT_BLOCK_VERSION;
    private final int MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE;
    private final int MAX_ACCOUNT_BLOCK_SIZE;

    static {
        new AccountBlock$();
    }

    public byte ACCOUNT_BLOCK_VERSION() {
        return this.ACCOUNT_BLOCK_VERSION;
    }

    public int MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE() {
        return this.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE;
    }

    public int MAX_ACCOUNT_BLOCK_SIZE() {
        return this.MAX_ACCOUNT_BLOCK_SIZE;
    }

    public Try<AccountBlock> create(String parentId, byte blockVersion, long timestamp, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<AccountBlockHeader>> ommers, PrivateKey25519 ownerPrivateKey, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath forgingStakeInfoMerklePath, byte[] feePaymentsHash, byte[] stateRoot, byte[] receiptsRoot, AddressProposition forgerAddress, BigInteger baseFee, BigInteger gasUsed, BigInteger gasLimit, SidechainAccountTransactionsCompanion companion, Bloom logsBloom, Option<Signature25519> signatureOption) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Signature25519 signature25519;
            Predef$.MODULE$.require(mainchainBlockReferencesData != null, (Function0 & Serializable & scala.Serializable)() -> "mainchainBlockReferencesData is null");
            Predef$.MODULE$.require(sidechainTransactions != null, (Function0 & Serializable & scala.Serializable)() -> "sidechainTransactions is null");
            Predef$.MODULE$.require(mainchainHeaders != null, (Function0 & Serializable & scala.Serializable)() -> "mainchainHeaders is null");
            Predef$.MODULE$.require(ommers != null, (Function0 & Serializable & scala.Serializable)() -> "ommers is null");
            Predef$.MODULE$.require(ownerPrivateKey != null, (Function0 & Serializable & scala.Serializable)() -> "ownerPrivateKey is null");
            Predef$.MODULE$.require(forgingStakeInfo != null, (Function0 & Serializable & scala.Serializable)() -> "forgingStakeInfo is null");
            Predef$.MODULE$.require(vrfProof != null, (Function0 & Serializable & scala.Serializable)() -> "vrfProof is null");
            Predef$.MODULE$.require(forgingStakeInfoMerklePath != null, (Function0 & Serializable & scala.Serializable)() -> "forgingStakeInfoMerklePath is null");
            Predef$.MODULE$.require(forgingStakeInfoMerklePath.bytes().length > 0, (Function0 & Serializable & scala.Serializable)() -> "forgingStakeInfoMerklePath is empty");
            PublicKey25519Proposition publicKey25519Proposition = ownerPrivateKey.publicImage();
            PublicKey25519Proposition publicKey25519Proposition2 = forgingStakeInfo.blockSignPublicKey();
            Predef$.MODULE$.require(!(publicKey25519Proposition != null ? !((Object)publicKey25519Proposition).equals(publicKey25519Proposition2) : publicKey25519Proposition2 != null), (Function0 & Serializable & scala.Serializable)() -> "owner pub key is different from signer key in forgingStakeInfo");
            byte[] sidechainTransactionsMerkleRootHash = MODULE$.calculateTransactionsMerkleRootHash(sidechainTransactions);
            byte[] mainchainMerkleRootHash = SidechainBlockBase$.MODULE$.calculateMainchainMerkleRootHash(mainchainBlockReferencesData, mainchainHeaders);
            byte[] ommersMerkleRootHash = SidechainBlockBase$.MODULE$.calculateOmmersMerkleRootHash(ommers);
            Option option = signatureOption;
            if (option instanceof Some) {
                Signature25519 sig;
                Some some = (Some)option;
                signature25519 = sig = (Signature25519)some.value();
            } else if (None$.MODULE$.equals(option)) {
                AccountBlockHeader unsignedBlockHeader = new AccountBlockHeader(blockVersion, parentId, timestamp, forgingStakeInfo, forgingStakeInfoMerklePath, vrfProof, vrfOutput, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, stateRoot, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, ommersMerkleRootHash, BoxesRunTime.unboxToLong((Object)((TraversableOnce)ommers.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.score()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), feePaymentsHash, logsBloom, new Signature25519(new byte[Signature25519.SIGNATURE_LENGTH]));
                signature25519 = ownerPrivateKey.sign(unsignedBlockHeader.messageToSign());
            } else {
                throw new MatchError((Object)option);
            }
            Signature25519 signature = signature25519;
            AccountBlockHeader signedBlockHeader = new AccountBlockHeader(blockVersion, parentId, timestamp, forgingStakeInfo, forgingStakeInfoMerklePath, vrfProof, vrfOutput, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, stateRoot, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, ommersMerkleRootHash, BoxesRunTime.unboxToLong((Object)((TraversableOnce)ommers.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.score()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), feePaymentsHash, logsBloom, signature);
            AccountBlock block = new AccountBlock(signedBlockHeader, sidechainTransactions, mainchainBlockReferencesData, mainchainHeaders, ommers, companion);
            return block;
        });
    }

    public Option<Signature25519> create$default$22() {
        return None$.MODULE$;
    }

    public byte[] calculateTransactionsMerkleRootHash(Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions) {
        return TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)sidechainTransactions.map((Function1 & Serializable & scala.Serializable)tx -> tx.bytes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
    }

    public byte[] calculateReceiptRoot(Seq<EthereumConsensusDataReceipt> receiptList) {
        return TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)receiptList.map((Function1 & Serializable & scala.Serializable)r -> EthereumConsensusDataReceipt$.MODULE$.rlpEncode((EthereumConsensusDataReceipt)r), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AccountBlock$() {
        MODULE$ = this;
        this.ACCOUNT_BLOCK_VERSION = (byte)2;
        this.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE = 5000000;
        this.MAX_ACCOUNT_BLOCK_SIZE = 7000000;
    }
}

