/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.json.Views;

@JsonView(value={Views.Default.class})
public class RpcError {
    public final int code;
    public final String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String data;

    public RpcError(int code, String message, String data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public RpcError(RpcCode code, String message, String data) {
        this(code.code, message, data);
    }

    public static RpcError fromCode(RpcCode code, String data) {
        String message = data == null ? code.message : code.message + ": " + data;
        return new RpcError(code.code, message, data);
    }

    public static RpcError fromCode(RpcCode code) {
        return RpcError.fromCode(code, null);
    }

    public String toString() {
        return String.format("RpcError{code=%d, message='%s', data='%s'}", this.code, this.message, this.data);
    }
}

