/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.horizen.account.api.rpc.handler.RpcException;
import io.horizen.account.api.rpc.service.Backend;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.Message;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUtil;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.web3j.utils.Numeric;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransactionArgs {
    public final Address from;
    public final Address to;
    public BigInteger gas;
    public BigInteger gasPrice;
    public BigInteger maxFeePerGas;
    public BigInteger maxPriorityFeePerGas;
    public BigInteger value;
    public BigInteger nonce;
    public final byte[] data;
    public final BigInteger chainId;

    public TransactionArgs(@JsonProperty(value="from") Address from, @JsonProperty(value="to") Address to, @JsonProperty(value="gas") BigInteger gas, @JsonProperty(value="gasPrice") BigInteger gasPrice, @JsonProperty(value="maxFeePerGas") BigInteger maxFeePerGas, @JsonProperty(value="maxPriorityFeePerGas") BigInteger maxPriorityFeePerGas, @JsonProperty(value="value") BigInteger value, @JsonProperty(value="nonce") BigInteger nonce, @JsonProperty(value="data") byte[] data, @JsonProperty(value="input") byte[] input, @JsonProperty(value="chainId") BigInteger chainId) throws RpcException {
        if (gasPrice != null && (maxFeePerGas != null || maxPriorityFeePerGas != null)) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, "both gasPrice and (maxFeePerGas or maxPriorityFeePerGas) specified"));
        }
        if (maxFeePerGas != null && maxPriorityFeePerGas != null) {
            TransactionArgs.checkEIP1559values(maxFeePerGas, maxPriorityFeePerGas);
        }
        if (gas != null && !BigIntegerUtil.isUint64(gas)) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, "invalid gas limit"));
        }
        if (data != null && input != null && !Arrays.equals(data, input)) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, "both \"data\" and \"input\" are set and not equal. Please use \"input\" to pass transaction call data"));
        }
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.maxFeePerGas = maxFeePerGas;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.value = Objects.requireNonNullElse(value, BigInteger.ZERO);
        this.nonce = nonce;
        this.data = Objects.requireNonNullElse(input != null ? input : data, new byte[0]);
        this.chainId = chainId;
        if (this.to == null && this.data.length == 0) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, "contract creation without any data provided"));
        }
    }

    private static void checkEIP1559values(BigInteger maxFeePerGas, BigInteger maxPriorityFeePerGas) throws RpcException {
        if (maxFeePerGas.compareTo(maxPriorityFeePerGas) < 0) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, String.format("maxFeePerGas (%s) < maxPriorityFeePerGas (%s)", maxFeePerGas, maxPriorityFeePerGas)));
        }
    }

    public Address getFrom() {
        return this.from == null ? Address.ZERO : this.from;
    }

    public EthereumTransaction toTransaction(NetworkParams params, AccountHistory history, AccountMemoryPool pool, Supplier<BigInteger> gasEstimator) throws RpcException {
        EthereumTransaction.EthereumTransactionType saneType;
        long saneChainId = params.chainId();
        if (this.chainId != null && this.chainId.longValueExact() != saneChainId) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, String.format("invalid chainID: got %d, want %d", this.chainId, saneChainId)));
        }
        EthereumTransaction.EthereumTransactionType ethereumTransactionType = saneType = this.gasPrice != null ? EthereumTransaction.EthereumTransactionType.LegacyTxType : EthereumTransaction.EthereumTransactionType.DynamicFeeTxType;
        if (saneType == EthereumTransaction.EthereumTransactionType.DynamicFeeTxType) {
            if (this.maxPriorityFeePerGas == null) {
                this.maxPriorityFeePerGas = Backend.suggestTipCap(history);
            }
            if (this.maxFeePerGas == null) {
                BigInteger baseFee = ((AccountBlock)history.bestBlock()).header().baseFee();
                this.maxFeePerGas = BigInteger.TWO.multiply(baseFee).add(this.maxPriorityFeePerGas);
            }
            TransactionArgs.checkEIP1559values(this.maxFeePerGas, this.maxPriorityFeePerGas);
        }
        if (this.nonce == null) {
            this.nonce = pool.getPoolNonce(new AddressProposition(this.getFrom()));
        }
        if (this.gas == null) {
            this.gas = gasEstimator.get();
        }
        Optional<AddressProposition> recipient = Optional.ofNullable(this.to).map(AddressProposition::new);
        switch (saneType) {
            case LegacyTxType: {
                if (this.chainId == null) {
                    return new EthereumTransaction(recipient, this.nonce, this.gasPrice, this.gas, this.value, this.data, null);
                }
                return new EthereumTransaction(saneChainId, recipient, this.nonce, this.gasPrice, this.gas, this.value, this.data, null);
            }
            case DynamicFeeTxType: {
                return new EthereumTransaction(saneChainId, recipient, this.nonce, this.gas, this.maxPriorityFeePerGas, this.maxFeePerGas, this.value, this.data, null);
            }
        }
        return null;
    }

    public Message toMessage(BigInteger baseFee, BigInteger rpcGasCap) {
        if (baseFee == null) {
            throw new IllegalArgumentException("baseFee must be not null.");
        }
        BigInteger gasLimit = rpcGasCap;
        if (this.gas != null && this.gas.compareTo(gasLimit) < 0) {
            gasLimit = this.gas;
        }
        BigInteger effectiveGasPrice = BigInteger.ZERO;
        BigInteger gasFeeCap = BigInteger.ZERO;
        BigInteger gasTipCap = BigInteger.ZERO;
        if (this.gasPrice != null) {
            effectiveGasPrice = this.gasPrice;
            gasFeeCap = this.gasPrice;
            gasTipCap = this.gasPrice;
        } else {
            if (this.maxFeePerGas != null) {
                gasFeeCap = this.maxFeePerGas;
            }
            if (this.maxPriorityFeePerGas != null) {
                gasTipCap = this.maxPriorityFeePerGas;
            }
            if (gasFeeCap.bitLength() > 0 || gasTipCap.bitLength() > 0) {
                effectiveGasPrice = baseFee.add(gasTipCap).min(gasFeeCap);
            }
        }
        return new Message(this.getFrom(), Optional.ofNullable(this.to), effectiveGasPrice, gasFeeCap, gasTipCap, gasLimit, this.value, this.nonce, this.data, true);
    }

    public String toString() {
        return "TransactionArgs{from=" + (this.from != null ? this.from.toString() : "empty") + ", to=" + (this.to != null ? this.to.toString() : "empty") + ", gas=" + (this.gas != null ? this.gas.toString() : "empty") + ", gasPrice=" + (this.gasPrice != null ? this.gasPrice.toString() : "empty") + ", maxFeePerGas=" + (this.maxFeePerGas != null ? this.maxFeePerGas.toString() : "empty") + ", maxPriorityFeePerGas=" + (this.maxPriorityFeePerGas != null ? this.maxPriorityFeePerGas.toString() : "empty") + ", value=" + this.value.toString() + ", nonce=" + (this.nonce != null ? this.nonce.toString() : "empty") + ", data='" + Numeric.toHexString((byte[])this.data) + "', chainId=" + (this.chainId != null ? this.chainId.toString() : "empty") + "}";
    }
}

