/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.utils.AccountPayment;
import io.horizen.evm.Address;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import scala.collection.JavaConverters;

public class FeePaymentsView {
    public final List<FeePaymentData> payments;

    public FeePaymentsView(AccountFeePaymentsInfo info) {
        this.payments = JavaConverters.seqAsJavaList(info.payments()).stream().map(payment -> FeePaymentData.fromAccountFeePayment(payment)).collect(Collectors.toList());
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private static class FeePaymentData {
        public final Address address;
        public final BigInteger value;
        public final Optional<BigInteger> valueFromMainchain;
        public final Optional<BigInteger> valueFromFees;

        public FeePaymentData(Address address, BigInteger value, Optional<BigInteger> valueFromMainchain, Optional<BigInteger> valueFromFees) {
            this.address = address;
            this.value = value;
            this.valueFromMainchain = valueFromMainchain;
            this.valueFromFees = valueFromFees;
        }

        public static FeePaymentData fromAccountFeePayment(AccountPayment payment) {
            return new FeePaymentData(payment.address().address(), payment.value(), Optional.ofNullable((BigInteger)payment.valueFromMainchain().getOrElse(() -> null)), Optional.ofNullable((BigInteger)payment.valueFromFees().getOrElse(() -> null)));
        }
    }
}

