/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Objects;

public class EthereumTransactionView {
    public final Hash blockHash;
    public final BigInteger blockNumber;
    public final BigInteger transactionIndex;
    public final Hash hash;
    public final BigInteger type;
    public final BigInteger nonce;
    public final Address from;
    public final Address to;
    public final BigInteger value;
    public final byte[] input;
    public final BigInteger gas;
    public final BigInteger gasPrice;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final BigInteger maxPriorityFeePerGas;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final BigInteger maxFeePerGas;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final BigInteger chainId;
    public final BigInteger v;
    public final BigInteger r;
    public final BigInteger s;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Object[] accessList;

    public EthereumTransactionView(EthereumTransaction tx, EthereumReceipt receipt, BigInteger baseFee) {
        if (receipt != null) assert (Objects.equals(BytesUtils.toHexString(receipt.transactionHash()), tx.id()));
        this.type = BigInteger.valueOf(tx.version());
        this.nonce = tx.getNonce();
        this.from = tx.getFromAddress();
        this.to = tx.getToAddress();
        this.value = tx.getValue();
        this.input = tx.getData();
        this.gas = tx.getGasLimit();
        BigInteger bigInteger = this.gasPrice = baseFee != null ? tx.getEffectiveGasPrice(baseFee) : tx.getGasPrice();
        if (tx.isEIP1559()) {
            this.maxPriorityFeePerGas = tx.getMaxPriorityFeePerGas();
            this.maxFeePerGas = tx.getMaxFeePerGas();
            this.accessList = new Object[0];
        } else {
            this.maxPriorityFeePerGas = null;
            this.maxFeePerGas = null;
            this.accessList = null;
        }
        this.chainId = tx.getChainId() == null ? null : BigInteger.valueOf(tx.getChainId());
        SignatureSecp256k1 signature = tx.getSignature();
        if (signature == null) {
            this.v = null;
            this.r = null;
            this.s = null;
        } else {
            this.v = tx.isEIP1559() ? signature.getV().subtract(BigInteger.valueOf(27L)) : signature.getV();
            this.r = signature.getR();
            this.s = signature.getS();
        }
        if (receipt != null) {
            this.hash = new Hash(receipt.transactionHash());
            this.blockHash = receipt.blockHash() != null ? new Hash(receipt.blockHash()) : null;
            this.blockNumber = BigInteger.valueOf(receipt.blockNumber());
            this.transactionIndex = BigInteger.valueOf(receipt.transactionIndex());
        } else {
            this.hash = new Hash("0x" + tx.id());
            this.blockHash = null;
            this.blockNumber = null;
            this.transactionIndex = null;
        }
    }

    public EthereumTransactionView(EthereumTransaction tx) {
        this(tx, null, null);
    }
}

