/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.abi;

import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.utils.BytesUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.web3j.utils.Numeric;
import sparkz.crypto.hash.Keccak256;

public class ABIUtil {
    public static final int METHOD_ID_LENGTH = 4;

    public static byte[] getArgumentsFromData(byte[] data) throws ExecutionRevertedException {
        return ABIUtil.getSlice(data, 4, data.length);
    }

    public static String getFunctionSignature(byte[] data) throws ExecutionRevertedException {
        return BytesUtils.toHexString(ABIUtil.getSlice(data, 0, 4));
    }

    private static byte[] getSlice(byte[] data, int from, int to) throws ExecutionRevertedException {
        if (data.length < 4) {
            throw new ExecutionRevertedException("Data length " + data.length + " must be >= 4");
        }
        return Arrays.copyOfRange(data, from, to);
    }

    public static String getABIMethodId(String methodSig) {
        return Numeric.toHexStringNoPrefix((byte[])Arrays.copyOfRange(Keccak256.hash((byte[])methodSig.getBytes(StandardCharsets.UTF_8)), 0, 4));
    }
}

