/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppEvents$SidechainApplicationStart$;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.SidechainSyncInfoMessageSpec$;
import io.horizen.account.AccountNodeViewHolderRef$;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.api.http.route.AccountApplicationApiRoute;
import io.horizen.account.api.http.route.AccountBlockApiRoute;
import io.horizen.account.api.http.route.AccountEthRpcRoute;
import io.horizen.account.api.http.route.AccountMetricsRoute;
import io.horizen.account.api.http.route.AccountTransactionApiRoute;
import io.horizen.account.api.http.route.AccountWalletApiRoute;
import io.horizen.account.api.rpc.handler.RpcHandler;
import io.horizen.account.api.rpc.service.EthService;
import io.horizen.account.api.rpc.service.RpcProcessor;
import io.horizen.account.api.rpc.service.RpcUtils$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.certificatesubmitter.AccountCertificateSubmitterRef$;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.forger.AccountForgerRef$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.network.AccountNodeViewSynchronizer$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.api.http.SidechainBlockActorRef$;
import io.horizen.api.http.SidechainTransactionActorRef$;
import io.horizen.api.http.SidechainTransactionRateLimiterActorRef$;
import io.horizen.api.http.route.MainchainBlockApiRoute;
import io.horizen.api.http.route.SidechainNodeApiRoute;
import io.horizen.api.http.route.SidechainSubmitterApiRoute;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.certificatesubmitter.network.CertificateSignaturesManagerRef$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.evm.Database;
import io.horizen.evm.LevelDBDatabase;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.NodeViewProvider;
import io.horizen.helper.NodeViewProviderImpl;
import io.horizen.helper.TransactionSubmitProvider;
import io.horizen.helper.TransactionSubmitProviderImpl;
import io.horizen.metrics.MetricsManager;
import io.horizen.network.SyncStatusActorRef$;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sparkz.core.NodeViewModifier;
import sparkz.core.api.http.ApiRoute;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.core.transaction.Transaction$;

@ScalaSignature(bytes="\u0006\u0001\u0011ea\u0001B$I\u0001=C\u0011\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016-\t\u0015%\u0004!\u0011!Q\u0001\n)\f\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001bA!\"a\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA#\u00111\t\t\u0007\u0001B\u0001B\u0003%\u00111MAF\u0011)\t\u0019\n\u0001B\u0001B\u0003%\u0011Q\u0013\u0005\r\u0003S\u0003!\u0011!Q\u0001\n\u0005-\u0016\u0011\u0017\u0005\r\u0003s\u0003!\u0011!Q\u0001\n\u0005m\u0016q\u0019\u0005\r\u0003\u001f\u0004!\u0011!Q\u0001\n\u0005E\u0017q\u001b\u0005\u000b\u0003?\u0004!\u0011!Q\u0001\n\u0005E\u0004\u0002DAt\u0001\t\u0005\t\u0015!\u0003\u0002j\u0006E\b\u0002DA}\u0001\t\u0005\t\u0015!\u0003\u0002j\u0006m\bb\u0002B\u0002\u0001\u0011\u0005!QA\u0003\u0007\u0005\u000b\u0002\u0001%a\u0007\u0006\r\t\u001d\u0003\u0001\tB%\u000b\u0019\u0011)\u0006\u0001\u0011\u0003X!I!Q\f\u0001C\u0002\u0013\u0005#q\f\u0005\t\u0005C\u0002\u0001\u0015!\u0003\u0002r!Q!1\r\u0001\t\u0006\u0004%\tB!\u001a\t\u0015\tM\u0004\u0001#b\u0001\n\u0003\u0012)\bC\u0005\u0003x\u0001\u0011\r\u0011\"\u0001\u0003`!A!\u0011\u0010\u0001!\u0002\u0013\t\t\bC\u0005\u0003|\u0001\u0011\r\u0011\"\u0001\u0003~!A!\u0011\u0012\u0001!\u0002\u0013\u0011y\bC\u0005\u0003\f\u0002\u0011\r\u0011\"\u0001\u0003~!A!Q\u0012\u0001!\u0002\u0013\u0011y\bC\u0005\u0003\u0010\u0002\u0011\r\u0011\"\u0001\u0003~!A!\u0011\u0013\u0001!\u0002\u0013\u0011y\bC\u0005\u0003\u0014\u0002\u0011\r\u0011\"\u0001\u0003~!A!Q\u0013\u0001!\u0002\u0013\u0011y\bC\u0005\u0003\u0018\u0002\u0011\r\u0011\"\u0005\u0003\u001a\"A!q\u0015\u0001!\u0002\u0013\u0011Y\nC\u0005\u0003*\u0002\u0011\r\u0011\"\u0005\u0003,\"A!q\u0017\u0001!\u0002\u0013\u0011i\u000bC\u0005\u0003:\u0002\u0011\r\u0011\"\u0005\u0003<\"A!1\u0019\u0001!\u0002\u0013\u0011i\fC\u0005\u0003F\u0002\u0011\r\u0011\"\u0005\u0003H\"A!Q\u001b\u0001!\u0002\u0013\u0011I\rC\u0005\u0003X\u0002\u0011\r\u0011\"\u0005\u0003Z\"A!q\u001d\u0001!\u0002\u0013\u0011Y\u000eC\u0005\u0003j\u0002\u0011\r\u0011\"\u0011\u0003l\"A!Q \u0001!\u0002\u0013\u0011i\u000fC\u0004\u0003\u0000\u0002!\ta!\u0001\t\u0013\r5\u0003A1A\u0005B\t-\b\u0002CB(\u0001\u0001\u0006IA!<\t\u0013\rE\u0003A1A\u0005\u0002\t-\b\u0002CB*\u0001\u0001\u0006IA!<\t\u0013\rU\u0003A1A\u0005\u0002\t-\b\u0002CB,\u0001\u0001\u0006IA!<\t\u0013\re\u0003A1A\u0005\u0002\t-\b\u0002CB.\u0001\u0001\u0006IA!<\t\u0013\ru\u0003A1A\u0005\u0002\t-\b\u0002CB0\u0001\u0001\u0006IA!<\t\u0013\r\u0005\u0004A1A\u0005\u0002\t-\b\u0002CB2\u0001\u0001\u0006IA!<\t\u0013\r\u0015\u0004A1A\u0005\u0002\t-\b\u0002CB4\u0001\u0001\u0006IA!<\t\u0013\r%\u0004A1A\u0005\u0002\r-\u0004\u0002CB?\u0001\u0001\u0006Ia!\u001c\t\u0013\r}\u0004A1A\u0005\u0002\r\u0005\u0005\u0002CBH\u0001\u0001\u0006Iaa!\t\u0015\rE\u0005\u0001#b\u0001\n\u0003\u001a\u0019\n\u0003\u0006\u00042\u0002A)\u0019!C!\u0007'C!ba-\u0001\u0011\u000b\u0007I\u0011IB[\u0011%\u00199\f\u0001b\u0001\n\u0003\u0019I\f\u0003\u0005\u0005\b\u0001\u0001\u000b\u0011BB^\u0011\u001d!I\u0001\u0001C\u0001\u0007sC\u0011\u0002b\u0003\u0001\u0005\u0004%\t\u0001\"\u0004\t\u0011\u0011U\u0001\u0001)A\u0005\t\u001fAq\u0001b\u0006\u0001\t\u0003\"iAA\nBG\u000e|WO\u001c;TS\u0012,7\r[1j]\u0006\u0003\bO\u0003\u0002J\u0015\u00069\u0011mY2pk:$(BA&M\u0003\u001dAwN]5{K:T\u0011!T\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001!B\u0011\u0011KU\u0007\u0002\u0015&\u00111K\u0013\u0002\u0015\u0003\n\u001cHO]1diNKG-Z2iC&t\u0017\t\u001d9\u0002#MLG-Z2iC&t7+\u001a;uS:<7\u000f\u0005\u0002R-&\u0011qK\u0013\u0002\u0012'&$Wm\u00195bS:\u001cV\r\u001e;j]\u001e\u001c\u0018B\u0001+SQ\u0011\t!LZ4\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016\u0001\u00028b[\u0016T!a\u00181\u0002\r%t'.Z2u\u0015\t\t'-\u0001\u0004h_><G.\u001a\u0006\u0002G\u0006\u00191m\\7\n\u0005\u0015d&!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017%\u00015\u0002#MKG-Z2iC&t7+\u001a;uS:<7/A\fdkN$x.\\*fGJ,GoU3sS\u0006d\u0017N_3sgB!1\u000e\u001d:y\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019h/D\u0001u\u0015\t)h.\u0001\u0003mC:<\u0017BA<u\u0005\u0011\u0011\u0015\u0010^3\u0011\u0007edh0D\u0001{\u0015\tY(*\u0001\u0004tK\u000e\u0014X\r^\u0005\u0003{j\u0014\u0001cU3de\u0016$8+\u001a:jC2L'0\u001a:\u0011\u0005e|\u0018bAA\u0001u\n11+Z2sKRL!!\u001b*)\u000b\tQf-a\u0002\"\u0005\u0005%\u0011aF\"vgR|WnU3de\u0016$8+\u001a:jC2L'0\u001a:t\u0003\r\u001aWo\u001d;p[\u0006\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\\*fe&\fG.\u001b>feN\u0004Ra\u001b9s\u0003\u001f\u0001b!!\u0005\u0002\u0018\u0005mQBAA\n\u0015\r\t)BS\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002\u001a\u0005M!!\u0006+sC:\u001c\u0018m\u0019;j_:\u001cVM]5bY&TXM\u001d\t\t\u0003;\t\t#!\n\u000225\u0011\u0011q\u0004\u0006\u0004\u0003+A\u0015\u0002BA\u0012\u0003?\u0011!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,)\u000b1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!\u0011qFA\u0015\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\r\u0005M\u0012\u0011HA\u0013\u001b\t\t)DC\u0002\u00028)\u000bQ\u0001\u001d:p_\u001aLA!a\u000f\u00026\t)\u0001K]8pM\"*1A\u00174\u0002@\u0005\u0012\u0011\u0011I\u0001$\u0007V\u001cHo\\7BG\u000e|WO\u001c;Ue\u0006t7/Y2uS>t7+\u001a:jC2L'0\u001a:t\u0003=\u0019Wo\u001d;p[\u0006\u0003\u0018n\u0012:pkB\u001c\b#B6\u0002H\u0005-\u0013bAA%Y\n!A*[:u!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nA\u0001\u001b;ua*\u0019\u0011Q\u000b%\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002Z\u0005=#AG!dG>,h\u000e^!qa2L7-\u0019;j_:\f\u0005/[$s_V\u0004\b&\u0002\u0003[M\u0006u\u0013EAA0\u0003=\u0019Uo\u001d;p[\u0006\u0003\u0018n\u0012:pkB\u001c\u0018\u0001\u0005:fU\u0016\u001cG/\u001a3Ba&\u0004\u0016\r\u001e5t!\u0015Y\u0017qIA3!!\t9'!\u001c\u0002r\u0005ETBAA5\u0015\r\tYGS\u0001\u0006kRLGn]\u0005\u0005\u0003_\nIG\u0001\u0003QC&\u0014\b\u0003BA:\u0003\u000bsA!!\u001e\u0002\u0002B!\u0011qOA?\u001b\t\tIHC\u0002\u0002|9\u000ba\u0001\u0010:p_Rt$BAA@\u0003\u0015\u00198-\u00197b\u0013\u0011\t\u0019)! \u0002\rA\u0013X\rZ3g\u0013\u0011\t9)!#\u0003\rM#(/\u001b8h\u0015\u0011\t\u0019)! \n\u0007\u0005\u0005$\u000bK\u0003\u00065\u001a\fy)\t\u0002\u0002\u0012\u0006\u0001\"+\u001a6fGR,G-\u00119j!\u0006$\bn]\u0001\u0018GV\u001cHo\\7NKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004Ra[A$\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;C\u0015!B:uCR,\u0017\u0002BAQ\u00037\u0013\u0001#T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:)\u000b\u0019Qf-!*\"\u0005\u0005\u001d\u0016aF\"vgR|W.T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:t\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8Ti>\u0004\b/\u001a:\u0011\u0007E\u000bi+C\u0002\u00020*\u00131cU5eK\u000eD\u0017-\u001b8BaB\u001cFo\u001c9qKJL1!!+SQ\u00159!LZA[C\t\t9,\u0001\nBaBd\u0017nY1uS>t7\u000b^8qa\u0016\u0014\u0018\u0001\u00054pe.\u001cuN\u001c4jOV\u0014\u0018\r^8s!\u0011\ti,a1\u000e\u0005\u0005}&bAAa\u0015\u0006!am\u001c:l\u0013\u0011\t)-a0\u0003!\u0019{'o[\"p]\u001aLw-\u001e:bi>\u0014\u0018bAA]%\"*\u0001B\u00174\u0002L\u0006\u0012\u0011QZ\u0001\u0012\r>\u00148nQ8oM&<WO]1uS>t\u0017!C2iC&t\u0017J\u001c4p!\r\t\u00161[\u0005\u0004\u0003+T%!C\"iC&t\u0017J\u001c4p\u0013\r\tyM\u0015\u0015\u0006\u0013i3\u00171\\\u0011\u0003\u0003;\f\u0011b\u00115bS:LeNZ8\u0002\u0015\u0005\u0004\bOV3sg&|g\u000eK\u0003\u000b5\u001a\f\u0019/\t\u0002\u0002f\u0006Q\u0011\t\u001d9WKJ\u001c\u0018n\u001c8\u0002+5\u001c'\t\\8dWJ+g-\u001a:f]\u000e,G)\u001a7bsB!\u00111^Aw\u001b\t\ti(\u0003\u0003\u0002p\u0006u$aA%oi&\u0019\u0011q\u001d*)\u000b-Qf-!>\"\u0005\u0005]\u0018\u0001H'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\t\u0016d\u0017-_\u0001\u0018[\u0006D\b*[:u_JL(+Z<sSR,G*\u001a8hi\"L1!!?SQ\u0015a!LZA\u0000C\t\u0011\t!A\fNCbD\u0015n\u001d;pef\u0014Vm\u001e:ji\u0016dUM\\4uQ\u00061A(\u001b8jiz\"\"Da\u0002\u0003\f\t=!1\u0003B\f\u00057\u0011yBa\t\u0003(\t-\"q\u0006B\u001a\u0005o\u00012A!\u0003\u0001\u001b\u0005A\u0005\"\u0002+\u000e\u0001\u0004)\u0006&\u0002B\u00065\u001a<\u0007\"B5\u000e\u0001\u0004Q\u0007F\u0002B\b5\u001a\f9\u0001C\u0004\u0002\f5\u0001\r!!\u0004)\r\tM!LZA \u0011\u001d\t\u0019%\u0004a\u0001\u0003\u000bBcAa\u0006[M\u0006u\u0003bBA1\u001b\u0001\u0007\u00111\r\u0015\u0007\u00057Qf-a$\t\u000f\u0005MU\u00021\u0001\u0002\u0016\"2!q\u0004.g\u0003KCq!!+\u000e\u0001\u0004\tY\u000b\u000b\u0004\u0003$i3\u0017Q\u0017\u0005\b\u0003sk\u0001\u0019AA^Q\u0019\u00119C\u00174\u0002L\"9\u0011qZ\u0007A\u0002\u0005E\u0007F\u0002B\u00165\u001a\fY\u000eC\u0004\u0002`6\u0001\r!!\u001d)\r\t=\"LZAr\u0011\u001d\t9/\u0004a\u0001\u0003SDcAa\r[M\u0006U\bbBA}\u001b\u0001\u0007\u0011\u0011\u001e\u0015\u0007\u0005oQf-a@)\u00075\u0011i\u0004\u0005\u0003\u0003@\t\u0005S\"\u00010\n\u0007\t\rcL\u0001\u0004J]*,7\r\u001e\u0002\u0003)b\u0013A\u0001U'P\tB!!1\nB)\u001b\t\u0011iEC\u0002\u0003P!\u000bQA\u00197pG.LAAa\u0015\u0003N\ta\u0011iY2pk:$(\t\\8dW\n!aJ\u0016%U!\u0011\u0011IA!\u0017\n\u0007\tm\u0003J\u0001\u0010BG\u000e|WO\u001c;TS\u0012,7\r[1j]:{G-\u001a,jK^Du\u000e\u001c3fe\u0006i1o^1hO\u0016\u00148i\u001c8gS\u001e,\"!!\u001d\u0002\u001dM<\u0018mZ4fe\u000e{gNZ5hA\u0005q2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u001c8i\\7qC:LwN\\\u000b\u0003\u0005O\u0002BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[B\u0015!C2p[B\fg.[8o\u0013\u0011\u0011\tHa\u001b\u0003KMKG-Z2iC&t\u0017iY2pk:$HK]1og\u0006\u001cG/[8og\u000e{W\u000e]1oS>t\u0017\u0001D4f]\u0016\u001c\u0018n\u001d\"m_\u000e\\WC\u0001B%\u0003M!\u0017\r^1ESJ\f%m]8mkR,\u0007+\u0019;i\u0003Q!\u0017\r^1ESJ\f%m]8mkR,\u0007+\u0019;iA\u0005Y1/Z2sKR\u001cFo\u001c:f+\t\u0011y\b\u0005\u0003\u0003\u0002\n\u0015UB\u0001BB\u0015\tie.\u0003\u0003\u0003\b\n\r%\u0001\u0002$jY\u0016\fAb]3de\u0016$8\u000b^8sK\u0002\na\"\\3uCN#\u0018\r^3Ti>\u0014X-A\bnKR\f7\u000b^1uKN#xN]3!\u00031A\u0017n\u001d;pef\u001cFo\u001c:f\u00035A\u0017n\u001d;pef\u001cFo\u001c:fA\u0005q1m\u001c8tK:\u001cXo]*u_J,\u0017aD2p]N,gn];t'R|'/\u001a\u0011\u0002/MLG-Z2iC&t\u0007*[:u_JL8\u000b^8sC\u001e,WC\u0001BN!\u0011\u0011iJa)\u000e\u0005\t}%b\u0001BQ\u0011\u000691\u000f^8sC\u001e,\u0017\u0002\u0002BS\u0005?\u0013Q#Q2d_VtG\u000fS5ti>\u0014\u0018p\u0015;pe\u0006<W-\u0001\rtS\u0012,7\r[1j]\"K7\u000f^8ssN#xN]1hK\u0002\nac]5eK\u000eD\u0017-\u001b8TK\u000e\u0014X\r^*u_J\fw-Z\u000b\u0003\u0005[\u0003BAa,\u000346\u0011!\u0011\u0017\u0006\u0004\u0005CS\u0015\u0002\u0002B[\u0005c\u0013acU5eK\u000eD\u0017-\u001b8TK\u000e\u0014X\r^*u_J\fw-Z\u0001\u0018g&$Wm\u00195bS:\u001cVm\u0019:fiN#xN]1hK\u0002\nAc\u001d;bi\u0016lU\r^1eCR\f7\u000b^8sC\u001e,WC\u0001B_!\u0011\u0011iJa0\n\t\t\u0005'q\u0014\u0002\u001c\u0003\u000e\u001cw.\u001e8u'R\fG/Z'fi\u0006$\u0017\r^1Ti>\u0014\u0018mZ3\u0002+M$\u0018\r^3NKR\fG-\u0019;b'R|'/Y4fA\u0005q1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,WC\u0001Be!\u0011\u0011YM!5\u000e\u0005\t5'b\u0001Bh\u0015\u0006\u0019QM^7\n\t\tM'Q\u001a\u0002\u0010\u0019\u00164X\r\u001c#C\t\u0006$\u0018MY1tK\u0006y1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,\u0007%\u0001\u000bd_:\u001cXM\\:vg\u0012\u000bG/Y*u_J\fw-Z\u000b\u0003\u00057\u0004BA!8\u0003d6\u0011!q\u001c\u0006\u0004\u0005CT\u0015!C2p]N,gn];t\u0013\u0011\u0011)Oa8\u0003)\r{gn]3ogV\u001cH)\u0019;b'R|'/Y4f\u0003U\u0019wN\\:f]N,8\u000fR1uCN#xN]1hK\u0002\n\u0011C\\8eKZKWm\u001e%pY\u0012,'OU3g+\t\u0011i\u000f\u0005\u0003\u0003p\neXB\u0001By\u0015\u0011\u0011\u0019P!>\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\t]\u0018\u0001B1lW\u0006LAAa?\u0003r\nA\u0011i\u0019;peJ+g-\u0001\no_\u0012,g+[3x\u0011>dG-\u001a:SK\u001a\u0004\u0013aE7pI&4\u0017.\u001a:TKJL\u0017\r\\5{KJ\u001cXCAB\u0002!!\t\u0019h!\u0002\u0004\n\r\u001d\u0012\u0002BB\u0004\u0003\u0013\u00131!T1q!\u0011\u0019Ya!\t\u000f\t\r511\u0004\b\u0005\u0007\u001f\u0019)B\u0004\u0003\u0002x\rE\u0011BAB\n\u0003\u0019\u0019\b/\u0019:lu&!1qCB\r\u0003\u0011\u0019wN]3\u000b\u0005\rM\u0011\u0002BB\u000f\u0007?\tq\u0001]1dW\u0006<WM\u0003\u0003\u0004\u0018\re\u0011\u0002BB\u0012\u0007K\u0011a\"T8eS\u001aLWM\u001d+za\u0016LEM\u0003\u0003\u0004\u001e\r}\u0001\u0007BB\u0015\u0007s\u0001baa\u000b\u00042\rURBAB\u0017\u0015\u0011\u0019yca\b\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\u0019\u0019d!\f\u0003!M\u0003\u0018M]6{'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003BB\u001c\u0007sa\u0001\u0001B\u0006\u0004<-\n\t\u0011!A\u0003\u0002\ru\"aA0%cE!1qHB#!\u0011\tYo!\u0011\n\t\r\r\u0013Q\u0010\u0002\b\u001d>$\b.\u001b8h!\u0011\u00199e!\u0013\u000e\u0005\r}\u0011\u0002BB&\u0007?\u0011\u0001CT8eKZKWm^'pI&4\u0017.\u001a:\u0002)9|G-\u001a,jK^\u001c\u0016P\\2ie>t\u0017N_3s\u0003Uqw\u000eZ3WS\u0016<8+\u001f8dQJ|g.\u001b>fe\u0002\nAd]5eK\u000eD\u0017-\u001b8CY>\u001c7NR8sO\u0016\u0014\u0018i\u0019;peJ+g-A\u000ftS\u0012,7\r[1j]\ncwnY6G_J<WM]!di>\u0014(+\u001a4!\u0003q\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]\u0006\u001bGo\u001c:SK\u001a\fQd]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t\u0017i\u0019;peJ+g\rI\u0001\u0017g&$Wm\u00195bS:\u0014En\\2l\u0003\u000e$xN\u001d*fM\u000692/\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017i\u0019;peJ+g\rI\u0001\u0018G\u0016\u0014H/\u001b4jG\u0006$XmU;c[&$H/\u001a:SK\u001a\f\u0001dY3si&4\u0017nY1uKN+(-\\5ui\u0016\u0014(+\u001a4!\u0003}\u0019WM\u001d;jM&\u001c\u0017\r^3TS\u001et\u0017\r^;sKNl\u0015M\\1hKJ\u0014VMZ\u0001!G\u0016\u0014H/\u001b4jG\u0006$XmU5h]\u0006$XO]3t\u001b\u0006t\u0017mZ3s%\u00164\u0007%\u0001\nts:\u001c7\u000b^1ukN\f5\r^8s%\u00164\u0017aE:z]\u000e\u001cF/\u0019;vg\u0006\u001bGo\u001c:SK\u001a\u0004\u0013A\u0003:qG\"\u000bg\u000e\u001a7feV\u00111Q\u000e\t\u0005\u0007_\u001aI(\u0004\u0002\u0004r)!11OB;\u0003\u001dA\u0017M\u001c3mKJTAaa\u001e\u0002T\u0005\u0019!\u000f]2\n\t\rm4\u0011\u000f\u0002\u000b%B\u001c\u0007*\u00198eY\u0016\u0014\u0018a\u0003:qG\"\u000bg\u000e\u001a7fe\u0002\nAB\u001d9d!J|7-Z:t_J,\"aa!\u0011\t\r\u001551R\u0007\u0003\u0007\u000fSAa!#\u0004v\u000591/\u001a:wS\u000e,\u0017\u0002BBG\u0007\u000f\u0013AB\u00159d!J|7-Z:t_J\fQB\u001d9d!J|7-Z:t_J\u0004\u0013\u0001F1qa2L7-\u0019;j_:\f\u0005/\u001b*pkR,7/\u0006\u0002\u0004\u0016B11qSBP\u0007KsAa!'\u0004\u001e:!\u0011qOBN\u0013\t\ty(\u0003\u0003\u0004\u001e\u0005u\u0014\u0002BBQ\u0007G\u00131aU3r\u0015\u0011\u0019i\"! \u0011\t\r\u001d6QV\u0007\u0003\u0007SSA!!\u0015\u0004,*!\u0011QKB\u0010\u0013\u0011\u0019yk!+\u0003\u0011\u0005\u0003\u0018NU8vi\u0016\fQbY8sK\u0006\u0003\u0018NU8vi\u0016\u001c\u0018aD7fiJL7m]!qSJ{W\u000f^3\u0016\u0005\r\u0015\u0016\u0001\u00058pI\u00164\u0016.Z<Qe>4\u0018\u000eZ3s+\t\u0019Y\f\u0005\f\u0004>\u000e\r7qYBf\u0007#\u001c\u0019na8\u0004l\u000eE81 C\u0001\u001b\t\u0019yLC\u0002\u0004B*\u000ba\u0001[3ma\u0016\u0014\u0018\u0002BBc\u0007\u007f\u0013\u0001CT8eKZKWm\u001e)s_ZLG-\u001a:\u0011\u0007\r%g\"D\u0001\u0001!\u0011\u0011Ye!4\n\t\r='Q\n\u0002\u0013\u0003\u000e\u001cw.\u001e8u\u00052|7m\u001b%fC\u0012,'\u000fE\u0002\u0004J>\u0001Ba!6\u0004\\6\u00111q\u001b\u0006\u0004\u00073D\u0015!B2iC&t\u0017\u0002BBo\u0007/\u0014a#Q2d_VtGOR3f!\u0006LX.\u001a8ug&sgm\u001c\t\u0005\u0007C\u001c9/\u0004\u0002\u0004d*\u00191Q\u001d%\u0002\t9|G-Z\u0005\u0005\u0007S\u001c\u0019O\u0001\nO_\u0012,\u0017iY2pk:$\b*[:u_JL\b\u0003BBq\u0007[LAaa<\u0004d\n\u0001bj\u001c3f\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a\t\u0005\u0007g\u001c90\u0004\u0002\u0004v*\u00191Q\u001d&\n\t\re8Q\u001f\u0002\u000f\u001d>$WmV1mY\u0016$()Y:f!\u0011\u0019\to!@\n\t\r}81\u001d\u0002\u0016\u001d>$W-Q2d_VtG/T3n_JL\bk\\8m!\u0011\u0019\t\u000fb\u0001\n\t\u0011\u001511\u001d\u0002\u0010\u0003\u000e\u001cw.\u001e8u\u001d>$WMV5fo\u0006\tbn\u001c3f-&,w\u000f\u0015:pm&$WM\u001d\u0011\u0002'\u001d,GOT8eKZKWm\u001e)s_ZLG-\u001a:\u00023Q\u0014\u0018M\\:bGRLwN\\*vE6LG\u000f\u0015:pm&$WM]\u000b\u0003\t\u001f\u0001ba!0\u0005\u0012\r\u001d\u0017\u0002\u0002C\n\u0007\u007f\u0013\u0011\u0004\u0016:b]N\f7\r^5p]N+(-\\5u!J|g/\u001b3fe\u0006QBO]1og\u0006\u001cG/[8o'V\u0014W.\u001b;Qe>4\u0018\u000eZ3sA\u0005ar-\u001a;Ue\u0006t7/Y2uS>t7+\u001e2nSR\u0004&o\u001c<jI\u0016\u0014\b")
public class AccountSidechainApp
extends AbstractSidechainApp {
    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion;
    private AccountBlock genesisBlock;
    private Seq<ApiRoute> applicationApiRoutes;
    private Seq<ApiRoute> coreApiRoutes;
    private ApiRoute metricsApiRoute;
    @Named(value="CustomAccountTransactionSerializers")
    private HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers;
    @Named(value="CustomApiGroups")
    private java.util.List<AccountApplicationApiGroup> customApiGroups;
    @Named(value="AppVersion")
    private String appVersion;
    private final String swaggerConfig;
    private final String dataDirAbsolutePath;
    private final File secretStore;
    private final File metaStateStore;
    private final File historyStore;
    private final File consensusStore;
    private final AccountHistoryStorage sidechainHistoryStorage;
    private final SidechainSecretStorage sidechainSecretStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final LevelDBDatabase stateDbStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final ActorRef nodeViewHolderRef;
    private final ActorRef nodeViewSynchronizer;
    private final ActorRef sidechainBlockForgerActorRef;
    private final ActorRef sidechainTransactionActorRef;
    private final ActorRef sidechainBlockActorRef;
    private final ActorRef certificateSubmitterRef;
    private final ActorRef certificateSignaturesManagerRef;
    private final ActorRef syncStatusActorRef;
    private final RpcHandler rpcHandler;
    private final RpcProcessor rpcProcessor;
    private final NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider;
    private final TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider;
    private volatile byte bitmap$0;

    public String swaggerConfig() {
        return this.swaggerConfig;
    }

    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sidechainTransactionsCompanion = new SidechainAccountTransactionsCompanion(this.customAccountTransactionSerializers);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.customAccountTransactionSerializers = null;
        return this.sidechainTransactionsCompanion;
    }

    public SidechainAccountTransactionsCompanion sidechainTransactionsCompanion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sidechainTransactionsCompanion$lzycompute() : this.sidechainTransactionsCompanion;
    }

    private AccountBlock genesisBlock$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.genesisBlock = (AccountBlock)new AccountBlockSerializer(this.sidechainTransactionsCompanion()).parseBytes(BytesUtils.fromHexString(super.sidechainSettings().genesisData().scGenesisBlockHex()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.genesisBlock;
    }

    @Override
    public AccountBlock genesisBlock() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.genesisBlock$lzycompute() : this.genesisBlock;
    }

    public String dataDirAbsolutePath() {
        return this.dataDirAbsolutePath;
    }

    public File secretStore() {
        return this.secretStore;
    }

    public File metaStateStore() {
        return this.metaStateStore;
    }

    public File historyStore() {
        return this.historyStore;
    }

    public File consensusStore() {
        return this.consensusStore;
    }

    public AccountHistoryStorage sidechainHistoryStorage() {
        return this.sidechainHistoryStorage;
    }

    public SidechainSecretStorage sidechainSecretStorage() {
        return this.sidechainSecretStorage;
    }

    public AccountStateMetadataStorage stateMetadataStorage() {
        return this.stateMetadataStorage;
    }

    public LevelDBDatabase stateDbStorage() {
        return this.stateDbStorage;
    }

    public ConsensusDataStorage consensusDataStorage() {
        return this.consensusDataStorage;
    }

    public ActorRef nodeViewHolderRef() {
        return this.nodeViewHolderRef;
    }

    public Map<Object, SparkzSerializer<? extends NodeViewModifier>> modifierSerializers() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)SidechainBlockBase$.MODULE$.ModifierTypeId())), (Object)new AccountBlockSerializer(this.sidechainTransactionsCompanion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)Transaction$.MODULE$.ModifierTypeId())), (Object)this.sidechainTransactionsCompanion())}));
    }

    public ActorRef nodeViewSynchronizer() {
        return this.nodeViewSynchronizer;
    }

    public ActorRef sidechainBlockForgerActorRef() {
        return this.sidechainBlockForgerActorRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public ActorRef sidechainBlockActorRef() {
        return this.sidechainBlockActorRef;
    }

    public ActorRef certificateSubmitterRef() {
        return this.certificateSubmitterRef;
    }

    public ActorRef certificateSignaturesManagerRef() {
        return this.certificateSignaturesManagerRef;
    }

    public ActorRef syncStatusActorRef() {
        return this.syncStatusActorRef;
    }

    public RpcHandler rpcHandler() {
        return this.rpcHandler;
    }

    public RpcProcessor rpcProcessor() {
        return this.rpcProcessor;
    }

    private Seq<ApiRoute> applicationApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.applicationApiRoutes = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.customApiGroups).asScala()).map((Function1 & Serializable & scala.Serializable)apiRoute -> new AccountApplicationApiRoute(this.settings().restApi(), (AccountApplicationApiGroup)apiRoute, this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem()), Buffer$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        this.customApiGroups = null;
        return this.applicationApiRoutes;
    }

    @Override
    public Seq<ApiRoute> applicationApiRoutes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.applicationApiRoutes$lzycompute() : this.applicationApiRoutes;
    }

    private Seq<ApiRoute> coreApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.coreApiRoutes = (Seq)new .colon.colon(new MainchainBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainBlockActorRef(), this.sidechainTransactionsCompanion(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainNodeApiRoute(this.peerManagerRef(), this.networkControllerRef(), this.timeProvider(), this.settings().restApi(), this.nodeViewHolderRef(), this, this.params(), this.appVersion, (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountTransactionApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainTransactionActorRef(), this.sidechainTransactionsCompanion(), this.params(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon((Object)new AccountWalletApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainSecretsCompanion(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainSubmitterApiRoute(this.settings().restApi(), this.params(), this.certificateSubmitterRef(), this.nodeViewHolderRef(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.Nothing()), (List)new .colon.colon((Object)new AccountEthRpcRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.rpcProcessor(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)Nil$.MODULE$)))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        this.appVersion = null;
        return this.coreApiRoutes;
    }

    @Override
    public Seq<ApiRoute> coreApiRoutes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.coreApiRoutes$lzycompute() : this.coreApiRoutes;
    }

    private ApiRoute metricsApiRoute$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.metricsApiRoute = super.sidechainSettings().metricsSettings().enabled() ? new AccountMetricsRoute(super.sidechainSettings().metricsSettings(), this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem(), this.executionContext()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.metricsApiRoute;
    }

    @Override
    public ApiRoute metricsApiRoute() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.metricsApiRoute$lzycompute() : this.metricsApiRoute;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider() {
        return this.nodeViewProvider;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> getNodeViewProvider() {
        return this.nodeViewProvider();
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider() {
        return this.transactionSubmitProvider;
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> getTransactionSubmitProvider() {
        return this.transactionSubmitProvider();
    }

    @Inject
    public AccountSidechainApp(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") java.util.List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") java.util.List<Pair<String, String>> rejectedApiPaths, @Named(value="CustomMessageProcessors") java.util.List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="AppVersion") String appVersion, @Named(value="MainchainBlockReferenceDelay") int mcBlockReferenceDelay, @Named(value="MaxHistoryRewriteLength") int maxHistoryRewriteLength) {
        ActorRef actorRef;
        this.customAccountTransactionSerializers = customAccountTransactionSerializers;
        this.customApiGroups = customApiGroups;
        this.appVersion = appVersion;
        super(sidechainSettings, customSecretSerializers, rejectedApiPaths, applicationStopper, forkConfigurator, chainInfo, mcBlockReferenceDelay, maxHistoryRewriteLength);
        this.swaggerConfig = Source$.MODULE$.fromResource("account/api/accountApi.yaml", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.UTF8()).getLines().mkString("\n");
        Predef$.MODULE$.require(!this.isCSWEnabled(), (Function0 & Serializable & scala.Serializable)() -> "Ceased Sidechain Withdrawal (CSW) should not be enabled in AccountSidechainApp!");
        this.dataDirAbsolutePath = super.sidechainSettings().sparkzSettings().dataDir().getAbsolutePath();
        this.secretStore = new File(new StringBuilder(7).append(this.dataDirAbsolutePath()).append("/secret").toString());
        this.metaStateStore = new File(new StringBuilder(6).append(this.dataDirAbsolutePath()).append("/state").toString());
        this.historyStore = new File(new StringBuilder(8).append(this.dataDirAbsolutePath()).append("/history").toString());
        this.consensusStore = new File(new StringBuilder(14).append(this.dataDirAbsolutePath()).append("/consensusData").toString());
        this.sidechainHistoryStorage = new AccountHistoryStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.historyStore(), 5)), this.sidechainTransactionsCompanion(), this.params());
        this.sidechainSecretStorage = new SidechainSecretStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.secretStore(), 5)), this.sidechainSecretsCompanion());
        this.stateMetadataStorage = new AccountStateMetadataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.metaStateStore(), this.params().maxHistoryRewritingLength() * 2)));
        this.stateDbStorage = this.registerClosableResource(new LevelDBDatabase(new StringBuilder(10).append(this.dataDirAbsolutePath()).append("/evm-state").toString(), super.sidechainSettings().evmStateDump().enabled()));
        this.consensusDataStorage = new ConsensusDataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.consensusStore(), 5)));
        if (this.sidechainSecretStorage().isEmpty()) {
            super.sidechainSettings().wallet().genesisSecrets().foreach((Function1 & Serializable & scala.Serializable)secretHex -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretHex))));
            super.sidechainSettings().withdrawalEpochCertificateSettings().signersSecrets().foreach((Function1 & Serializable & scala.Serializable)secretSchnorr -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretSchnorr))));
        }
        this.nodeViewHolderRef = AccountNodeViewHolderRef$.MODULE$.apply(super.sidechainSettings(), this.sidechainHistoryStorage(), this.consensusDataStorage(), this.stateMetadataStorage(), (Database)this.stateDbStorage(), (Seq<MessageProcessor>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(customMessageProcessors).asScala()), this.sidechainSecretStorage(), this.params(), this.timeProvider(), this.genesisBlock(), this.actorSystem());
        this.nodeViewSynchronizer = this.actorSystem().actorOf(AccountNodeViewSynchronizer$.MODULE$.props(this.networkControllerRef(), this.nodeViewHolderRef(), SidechainSyncInfoMessageSpec$.MODULE$, this.settings().network(), this.timeProvider(), this.modifierSerializers(), this.executionContext()));
        this.sidechainBlockForgerActorRef = AccountForgerRef$.MODULE$.apply("AccountForger", super.sidechainSettings(), this.nodeViewHolderRef(), this.mainchainSynchronizer(), this.sidechainTransactionsCompanion(), this.timeProvider(), this.params(), this.actorSystem());
        if (super.sidechainSettings().apiRateLimiter().enabled()) {
            ActorRef rateLimiterActorRef = SidechainTransactionRateLimiterActorRef$.MODULE$.apply(this.nodeViewHolderRef(), super.sidechainSettings().apiRateLimiter(), this.actorSystem(), this.executionContext());
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(rateLimiterActorRef, this.actorSystem(), this.executionContext());
        } else {
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(this.nodeViewHolderRef(), this.actorSystem(), this.executionContext());
        }
        this.sidechainTransactionActorRef = actorRef;
        this.sidechainBlockActorRef = SidechainBlockActorRef$.MODULE$.apply("AccountBlock", super.sidechainSettings(), this.sidechainBlockForgerActorRef(), ClassTag$.MODULE$.apply(AccountBlock.class), ClassTag$.MODULE$.apply(AccountHistory.class), this.actorSystem(), this.executionContext());
        this.certificateSubmitterRef = AccountCertificateSubmitterRef$.MODULE$.apply(super.sidechainSettings(), this.nodeViewHolderRef(), this.secureEnclaveApiClient(), this.params(), this.mainchainNodeChannel(), this.actorSystem(), this.executionContext());
        this.certificateSignaturesManagerRef = CertificateSignaturesManagerRef$.MODULE$.apply(this.networkControllerRef(), this.certificateSubmitterRef(), this.params(), super.sidechainSettings().sparkzSettings().network(), this.actorSystem(), this.executionContext());
        this.syncStatusActorRef = SyncStatusActorRef$.MODULE$.apply("SyncStatus", super.sidechainSettings(), this.nodeViewHolderRef(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), this.actorSystem(), this.executionContext());
        this.rpcHandler = new RpcHandler(new EthService(this.nodeViewHolderRef(), this.networkControllerRef(), this.settings().restApi().timeout(), this.params(), super.sidechainSettings().ethService(), super.sidechainSettings().sparkzSettings().network().maxIncomingConnections(), RpcUtils$.MODULE$.getClientVersion(appVersion), this.sidechainTransactionActorRef(), this.syncStatusActorRef(), this.sidechainTransactionsCompanion(), super.sidechainSettings().evmStateDump().enabled()));
        this.rpcProcessor = new RpcProcessor(this.rpcHandler());
        if (super.sidechainSettings().websocketServer().wsServer()) {
            ActorRef webSocketServerActor = WebSocketAccountServerRef$.MODULE$.apply(this.nodeViewHolderRef(), this.rpcProcessor(), super.sidechainSettings().websocketServer(), this.actorSystem(), this.executionContext());
        }
        MetricsManager.getInstance().setVersion(RpcUtils$.MODULE$.getClientVersion(appVersion));
        this.nodeViewProvider = new NodeViewProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>(this.nodeViewHolderRef());
        this.actorSystem().eventStream().publish((Object)SidechainAppEvents$SidechainApplicationStart$.MODULE$);
        this.transactionSubmitProvider = new TransactionSubmitProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>>(this.sidechainTransactionActorRef());
    }
}

