/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.wallet;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.ProofOfKnowledgeProposition;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.SchnorrSecret;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretCreator;
import io.horizen.secret.VrfSecretKey;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.transaction.Transaction;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.wallet.Wallet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.PersistentNodeViewModifier;
import sparkz.core.transaction.wallet.Vault;
import sparkz.core.transaction.wallet.VaultReader;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\t}aA\u0002\f\u0018\u0003\u0003q\u0002\u000b\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011!a\u0007A!A!\u0002\u0013i\u0007BB:\u0001\t\u0003IB\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\u0007[\u0001!\t%a\u0002\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003c\u0001A\u0011IA\u001d\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011Q\u0012\u0001\u0007\u0002\u0005=\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002|\u0002!\t%!@\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014\tq\u0011IY:ue\u0006\u001cGoV1mY\u0016$(B\u0001\r\u001a\u0003\u00199\u0018\r\u001c7fi*\u0011!dG\u0001\bQ>\u0014\u0018N_3o\u0015\u0005a\u0012AA5p\u0007\u0001)Ba\b\u001dF#N1\u0001\u0001\t\u0014V7\u0006\u0004\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007cB\u0014)UA2D\tU\u0007\u0002/%\u0011\u0011f\u0006\u0002\u0007/\u0006dG.\u001a;\u0011\u0005-rS\"\u0001\u0017\u000b\u00055J\u0012AB:fGJ,G/\u0003\u00020Y\t11+Z2sKR\u0004\"!\r\u001b\u000e\u0003IR!aM\r\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0003kI\u00121\u0002\u0015:pa>\u001c\u0018\u000e^5p]B\u0011q\u0007\u000f\u0007\u0001\t\u0015I\u0004A1\u0001;\u0005\t!\u0006,\u0005\u0002<}A\u0011\u0011\u0005P\u0005\u0003{\t\u0012qAT8uQ&tw\r\u0005\u0002@\u00056\t\u0001I\u0003\u0002B3\u0005YAO]1og\u0006\u001cG/[8o\u0013\t\u0019\u0005IA\u0006Ue\u0006t7/Y2uS>t\u0007CA\u001cF\t\u00151\u0005A1\u0001H\u0005\u0011\u0001Vj\u0014#\u0012\u0005mB\u0005CA%O\u001b\u0005Q%BA&M\u0003\u0011\u0019wN]3\u000b\u00035\u000baa\u001d9be.T\u0018BA(K\u0005i\u0001VM]:jgR,g\u000e\u001e(pI\u00164\u0016.Z<N_\u0012Lg-[3s!\t9\u0014\u000bB\u0003S\u0001\t\u00071KA\u0001X#\tYD\u000bE\u0003(\u0001Y\"\u0005\u000b\u0005\u0002W36\tqK\u0003\u0002Y\u0019\u0006!Q\u000f^5m\u0013\tQvKA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=f\tAA\\8eK&\u0011\u0001-\u0018\u0002\u000f\u001d>$WmV1mY\u0016$()Y:f!\t\u00117-D\u0001\u001a\u0013\t!\u0017D\u0001\bTS\u0012,7\r[1j]RK\b/Z:\u0002\tM,W\r\u001a\t\u0004C\u001dL\u0017B\u00015#\u0005\u0015\t%O]1z!\t\t#.\u0003\u0002lE\t!!)\u001f;f\u00035\u0019Xm\u0019:fiN#xN]1hKB\u0011a.]\u0007\u0002_*\u0011\u0001/G\u0001\bgR|'/Y4f\u0013\t\u0011xN\u0001\fTS\u0012,7\r[1j]N+7M]3u'R|'/Y4f\u0003\u0019a\u0014N\\5u}Q\u0019A+\u001e<\t\u000b\u0015\u001c\u0001\u0019\u00014\t\u000b1\u001c\u0001\u0019A7\u0002\u0013\u0005$GmU3de\u0016$HCA=\u007f!\rQH\u0010U\u0007\u0002w*\u0011\u0001LI\u0005\u0003{n\u00141\u0001\u0016:z\u0011\u0015iC\u00011\u0001+\u00031\u0011X-\\8wKN+7M]3u)\rI\u00181\u0001\u0005\u0007\u0003\u000b)\u0001\u0019\u0001\u0019\u0002\u0017A,(\r\\5d\u00136\fw-\u001a\u000b\u0005\u0003\u0013\ty\u0001\u0005\u0003\"\u0003\u0017Q\u0013bAA\u0007E\t1q\n\u001d;j_:Da!!\u0002\u0007\u0001\u0004\u0001\u0014aB:fGJ,Go\u001d\u000b\u0003\u0003+\u0001R!a\u0006\u0002&)rA!!\u0007\u0002\"A\u0019\u00111\u0004\u0012\u000e\u0005\u0005u!bAA\u0010;\u00051AH]8pizJ1!a\t#\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\r\u0019V\r\u001e\u0006\u0004\u0003G\u0011\u0013A\u00039vE2L7mS3zgR\u0011\u0011q\u0006\t\u0006\u0003/\t)\u0003M\u0001\rg\u000e\fgn\u00144gG\"\f\u0017N\u001c\u000b\u0004!\u0006U\u0002BBA\u001c\u0013\u0001\u0007a'\u0001\u0002uqR\u0019\u0001+a\u000f\t\u000f\u0005u\"\u00021\u0001\u0002@\u0005\u0019A\u000f_:\u0011\u000b\u0005\u0005\u00131\n\u001c\u000f\t\u0005\r\u0013q\t\b\u0005\u00037\t)%C\u0001$\u0013\r\tIEI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0007M+\u0017OC\u0002\u0002J\t\n\u0011c]3de\u0016$()\u001f)vE2L7mS3z)\u0011\t)&a\u0019\u0011\u000b\u0005]\u0013q\f\u0016\u000e\u0005\u0005e#b\u0001-\u0002\\)\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005e#\u0001C(qi&|g.\u00197\t\r\u0005\u00154\u00021\u00011\u0003%\u0001XO\u00197jG.+\u00170\u0001\u0006bY2\u001cVm\u0019:fiN$\"!a\u001b\u0011\u000b\u0005]\u0013Q\u000e\u0016\n\t\u0005=\u0014\u0011\f\u0002\u0005\u0019&\u001cH/A\u0007tK\u000e\u0014X\r^:PMRK\b/\u001a\u000b\u0005\u0003W\n)\bC\u0004\u0002x5\u0001\r!!\u001f\u0002\u0015M,7M]3u)f\u0004X\r\r\u0003\u0002|\u0005\r\u0005CBA\f\u0003{\n\t)\u0003\u0003\u0002\u0000\u0005%\"!B\"mCN\u001c\bcA\u001c\u0002\u0004\u0012a\u0011QQA;\u0003\u0003\u0005\tQ!\u0001\u0002\b\n\u0019q\fJ\u0019\u0012\u0005mR\u0013AC<bY2,GoU3fIR\ta-A\fbaBd\u0017pQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_R\u0019\u0001+!%\t\u000f\u0005Mu\u00021\u0001\u0002\u0016\u0006IQ\r]8dQ&sgm\u001c\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111T\r\u0002\u0013\r|gn]3ogV\u001c\u0018\u0002BAP\u00033\u0013!cQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_\u0006\u0011r-\u001a8fe\u0006$XMT3yiN+7M]3u+\u0011\t)+!-\u0015\t\u0005\u001d\u0016Q\u0017\t\u0005ur\fI\u000b\u0005\u0004\"\u0003W\u0003\u0016qV\u0005\u0004\u0003[\u0013#A\u0002+va2,'\u0007E\u00028\u0003c#q!a-\u0011\u0005\u0004\t9IA\u0001U\u0011\u001d\t9\f\u0005a\u0001\u0003s\u000bQb]3de\u0016$8I]3bi>\u0014\b#B\u0016\u0002<\u0006=\u0016bAA_Y\ti1+Z2sKR\u001c%/Z1u_J\f\u0011e]3de\u0016$()\u001f)vE2L7mS3zeU*\u0014'\u000f)s_B|7/\u001b;j_:$B!a1\u0002LB1\u0011qKA0\u0003\u000b\u00042aKAd\u0013\r\tI\r\f\u0002\u0010!JLg/\u0019;f\u0017\u0016L('N\u001b2s!9\u0011QM\tA\u0002\u00055\u0007cA\u0019\u0002P&\u0019\u0011\u0011\u001b\u001a\u00033A+(\r\\5d\u0017\u0016L('N\u001b2sA\u0013x\u000e]8tSRLwN\\\u0001\u001bg\u0016\u001c'/\u001a;CsN\u001b\u0007N\\8seB\u0013x\u000e]8tSRLwN\u001c\u000b\u0005\u0003/\fy\u000e\u0005\u0004\u0002X\u0005}\u0013\u0011\u001c\t\u0004W\u0005m\u0017bAAoY\ti1k\u00195o_J\u00148+Z2sKRDq!!\u001a\u0013\u0001\u0004\t\t\u000fE\u00022\u0003GL1!!:3\u0005I\u00196\r\u001b8peJ\u0004&o\u001c9pg&$\u0018n\u001c8\u0002)M,7M]3u\u0005f4&O\u001a)vE2L7mS3z)\u0011\tY/a=\u0011\r\u0005]\u0013qLAw!\rY\u0013q^\u0005\u0004\u0003cd#\u0001\u0004,sMN+7M]3u\u0017\u0016L\bbBA3'\u0001\u0007\u0011Q\u001f\t\u0004c\u0005]\u0018bAA}e\taaK\u001d4Qk\nd\u0017nY&fs\u0006!2/Z2sKR\u001c()\u001f)s_B|7/\u001b;j_:,B!a@\u0003\u0006Q!!\u0011\u0001B\u0005!\u0019\t9&!\u001c\u0003\u0004A\u0019qG!\u0002\u0005\u000f\t\u001dAC1\u0001\u0002\b\n\t1\u000b\u0003\u00044)\u0001\u0007!1\u0002\t\u0006c\t5!1A\u0005\u0004\u0005\u001f\u0011$a\u0007)s_>4wJZ&o_^dW\rZ4f!J|\u0007o\\:ji&|g.\u0001\ftK\u000e\u0014X\r\u001e\"z!V\u0014G.[2LKf\u0014\u0015\u0010^3t+\u0011\u0011)Ba\u0007\u0015\t\t]!Q\u0004\t\u0007\u0003/\nyF!\u0007\u0011\u0007]\u0012Y\u0002B\u0004\u0003\bU\u0011\r!a\"\t\u000bM*\u0002\u0019\u00014")
public abstract class AbstractWallet<TX extends Transaction, PMOD extends PersistentNodeViewModifier, W extends AbstractWallet<TX, PMOD, W>>
implements Wallet<Secret, Proposition, TX, PMOD, W>,
SparkzLogging,
NodeWalletBase,
SidechainTypes {
    private final byte[] seed;
    private final SidechainSecretStorage secretStorage;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Vault scanPersistent(Option modifiers) {
        return Vault.scanPersistent$((Vault)this, (Option)modifiers);
    }

    public VaultReader getReader() {
        return Vault.getReader$((Vault)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<W> addSecret(Secret secret) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "AbstractWallet: Secret must be NOT NULL.");
            $this.secretStorage.add(secret).get();
            return this;
        });
    }

    @Override
    public Try<W> removeSecret(Proposition publicImage) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(publicImage != null, (Function0 & Serializable & scala.Serializable)() -> "PublicImage must be NOT NULL.");
            $this.secretStorage.remove(publicImage).get();
            return this;
        });
    }

    @Override
    public Option<Secret> secret(Proposition publicImage) {
        return this.secretStorage.get(publicImage);
    }

    @Override
    public Set<Secret> secrets() {
        return this.secretStorage.getAll().toSet();
    }

    @Override
    public Set<Proposition> publicKeys() {
        return ((TraversableOnce)this.secretStorage.getAll().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.publicImage(), List$.MODULE$.canBuildFrom())).toSet();
    }

    public W scanOffchain(TX tx) {
        return (W)this;
    }

    public W scanOffchain(Seq<TX> txs) {
        return (W)this;
    }

    @Override
    public Optional<Secret> secretByPublicKey(Proposition publicKey) {
        Optional<Secret> optional;
        Option<Secret> option = this.secretStorage.get(publicKey);
        if (option instanceof Some) {
            Some some = (Some)option;
            Secret secret = (Secret)some.value();
            optional = Optional.of(secret);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError(option);
        }
        return optional;
    }

    @Override
    public java.util.List<Secret> allSecrets() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.secretStorage.getAll()).asJava();
    }

    @Override
    public java.util.List<Secret> secretsOfType(Class<? extends Secret> secretType) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.secretStorage.getAll().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractWallet.$anonfun$secretsOfType$1(secretType, x$2)))).asJava();
    }

    @Override
    public byte[] walletSeed() {
        return this.seed;
    }

    public abstract W applyConsensusEpochInfo(ConsensusEpochInfo var1);

    @Override
    public <T extends Secret> Try<Tuple2<W, T>> generateNextSecret(SecretCreator<T> secretCreator) {
        Try try_;
        Object object = new Object();
        try {
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                int n;
                Predef$.MODULE$.require(secretCreator != null, (Function0 & Serializable & scala.Serializable)() -> "AbstractWallet: Secret creator must be NOT NULL.");
                Set<Secret> allSecrets = this.secrets();
                byte[] salt = secretCreator.salt();
                int secretsNumber = allSecrets.count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractWallet.$anonfun$generateNextSecret$3(x$3)));
                Option<Object> option = $this.secretStorage.getNonce(salt);
                if (option instanceof Some) {
                    int nonce;
                    Some some = (Some)option;
                    n = nonce = BoxesRunTime.unboxToInt((Object)some.value());
                } else if (None$.MODULE$.equals(option)) {
                    n = 0;
                } else {
                    throw new MatchError(option);
                }
                IntRef nonce = IntRef.create((int)n);
                if (nonce.elem > 0) {
                    ++nonce.elem;
                }
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), secretsNumber).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                    byte[] seed = Blake2b256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{$this.seed, Ints.toByteArray((int)nonce$1.elem), salt}));
                    Object secret = secretCreator.generateSecret(seed);
                    if (!$this.secretStorage.contains((Secret)secret)) {
                        Try<SidechainSecretStorage> try_ = $this.secretStorage.storeSecretAndNonceAtomic((Secret)secret, nonce$1.elem, salt);
                        if (try_ instanceof Success) {
                            throw new NonLocalReturnControl(object, (Object)new Success((Object)new Tuple2((Object)this, secret)));
                        }
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            throw new RuntimeException(new StringBuilder(58).append("Can't store secret and nonce while generating next secret ").append(exception).toString(), exception);
                        }
                        throw new MatchError(try_);
                    }
                    ++nonce$1.elem;
                });
                throw new RuntimeException("Exceeded number of attempts generating secret");
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                try_ = (Try)ex.value();
            }
            throw ex;
        }
        return try_;
    }

    @Override
    public Optional<PrivateKey25519> secretByPublicKey25519Proposition(PublicKey25519Proposition publicKey) {
        Optional<PrivateKey25519> optional;
        Option<Secret> option = this.secretStorage.get(publicKey);
        if (option instanceof Some) {
            Some some = (Some)option;
            Secret secret = (Secret)some.value();
            optional = Optional.of((PrivateKey25519)secret);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError(option);
        }
        return optional;
    }

    @Override
    public Optional<SchnorrSecret> secretBySchnorrProposition(SchnorrProposition publicKey) {
        Optional<SchnorrSecret> optional;
        Option<Secret> option = this.secretStorage.get(publicKey);
        if (option instanceof Some) {
            Some some = (Some)option;
            Secret secret = (Secret)some.value();
            optional = Optional.of((SchnorrSecret)secret);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError(option);
        }
        return optional;
    }

    @Override
    public Optional<VrfSecretKey> secretByVrfPublicKey(VrfPublicKey publicKey) {
        Optional<VrfSecretKey> optional;
        Option<Secret> option = this.secretStorage.get(publicKey);
        if (option instanceof Some) {
            Some some = (Some)option;
            Secret secret = (Secret)some.value();
            optional = Optional.of((VrfSecretKey)secret);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError(option);
        }
        return optional;
    }

    @Override
    public <S extends Secret> java.util.List<S> secretsByProposition(ProofOfKnowledgeProposition<S> proposition) {
        return proposition.canBeProvedBy((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.secretStorage.getAll()).asJava()).secretsNeeded();
    }

    @Override
    public <S extends Secret> Optional<S> secretByPublicKeyBytes(byte[] proposition) {
        Optional<Object> optional;
        Option option = this.secretStorage.getAll().find((Function1 & Serializable & scala.Serializable)secret -> BoxesRunTime.boxToBoolean((boolean)AbstractWallet.$anonfun$secretByPublicKeyBytes$1(proposition, secret)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Secret s = (Secret)some.value();
            optional = Optional.of(s);
        } else if (None$.MODULE$.equals(option)) {
            optional = Optional.empty();
        } else {
            throw new MatchError((Object)option);
        }
        return optional;
    }

    public static final /* synthetic */ boolean $anonfun$secretsOfType$1(Class secretType$1, Secret x$2) {
        return x$2.getClass().equals(secretType$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateNextSecret$3(Secret x$3) {
        return x$3 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$secretByPublicKeyBytes$1(byte[] proposition$1, Secret secret) {
        return Arrays.equals(secret.publicImage().pubKeyBytes(), proposition$1);
    }

    public AbstractWallet(byte[] seed, SidechainSecretStorage secretStorage) {
        this.seed = seed;
        this.secretStorage = secretStorage;
        Vault.$init$((Vault)this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainTypes.$init$(this);
    }
}

