/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.websocket.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.websocket.server.EVENT_MESSAGE$;
import io.horizen.utxo.websocket.server.GET_MEMPOOL_TXS$;
import io.horizen.utxo.websocket.server.GET_NEW_BLOCK_HASHES_REQUEST_TYPE$;
import io.horizen.utxo.websocket.server.GET_RAW_MEMPOOL$;
import io.horizen.utxo.websocket.server.GET_SINGLE_BLOCK_REQUEST_TYPE$;
import io.horizen.utxo.websocket.server.RESPONSE_MESSAGE$;
import io.horizen.utxo.websocket.server.SidechainNodeChannelImpl;
import io.horizen.utxo.websocket.server.WebSocketServerEndpoint$;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.util.ArrayList;
import java.util.Iterator;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.SparkzLogging;

@ServerEndpoint(value="/")
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001\u0002\u000f\u001e\u0001!BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004J\u0001\u0001\u0006I!\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019y\u0005\u0001)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")!\r\u0001C\u0001G\")\u0011\u000e\u0001C\u0001U\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0004\b\u0003\u0013j\u0002\u0012BA&\r\u0019aR\u0004#\u0003\u0002N!1q'\u0004C\u0001\u0003\u001fB\u0011\"!\u0015\u000e\u0001\u0004%\t!a\u0015\t\u0013\u0005\rT\u00021A\u0005\u0002\u0005\u0015\u0004\u0002CA6\u001b\u0001\u0006K!!\u0016\t\u0011\u00055TB1A\u0005\u0002-Cq!a\u001c\u000eA\u0003%A\nC\u0004<\u001b\t\u0007I\u0011\u0002\u001f\t\r%k\u0001\u0015!\u0003>\u0011\u001d\t\t(\u0004C\u0001\u0003gBq!a\u001e\u000e\t\u0003\tI\bC\u0004\u0002~5!\t!a \t\u000f\u0005\u0005U\u0002\"\u0001\u0002\u0004\"9\u00111S\u0007\u0005\u0002\u0005U\u0005bBA_\u001b\u0011\u0005\u0011q\u0018\u0002\u0018/\u0016\u00147k\\2lKR\u001cVM\u001d<fe\u0016sG\r]8j]RT!AH\u0010\u0002\rM,'O^3s\u0015\t\u0001\u0013%A\u0005xK\n\u001cxnY6fi*\u0011!eI\u0001\u0005kRDxN\u0003\u0002%K\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u0014\u0002\u0005%|7\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!Q\u000f^5m\u0015\u0005!\u0014AB:qCJ\\'0\u0003\u00027c\ti1\u000b]1sWjdunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u000f\u0002\r5\f\u0007\u000f]3s+\u0005i\u0004C\u0001 H\u001b\u0005y$B\u0001!B\u0003!!\u0017\r^1cS:$'B\u0001\"D\u0003\u001dQ\u0017mY6t_:T!\u0001R#\u0002\u0013\u0019\f7\u000f^3sq6d'\"\u0001$\u0002\u0007\r|W.\u0003\u0002I\u007f\taqJ\u00196fGRl\u0015\r\u001d9fe\u00069Q.\u00199qKJ\u0004\u0013\u0001F:jI\u0016\u001c\u0007.Y5o\u001d>$Wm\u00115b]:,G.F\u0001M!\tQT*\u0003\u0002O;\tA2+\u001b3fG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2LU\u000e\u001d7\u0002+MLG-Z2iC&tgj\u001c3f\u0007\"\fgN\\3mA\u00051qN\\(qK:$\"AU+\u0011\u0005)\u001a\u0016B\u0001+,\u0005\u0011)f.\u001b;\t\u000bY3\u0001\u0019A,\u0002\u000fM,7o]5p]B\u0011\u0001\fX\u0007\u00023*\u0011\u0001E\u0017\u0006\u00027\u00069!.Y6beR\f\u0017BA/Z\u0005\u001d\u0019Vm]:j_:D#AB0\u0011\u0005a\u0003\u0017BA1Z\u0005\u0019yen\u00149f]\u00069qN\\\"m_N,GC\u0001*e\u0011\u00151v\u00011\u0001XQ\t9a\r\u0005\u0002YO&\u0011\u0001.\u0017\u0002\b\u001f:\u001cEn\\:f\u0003\u001dyg.\u0012:s_J$2AU6m\u0011\u00151\u0006\u00021\u0001X\u0011\u0015i\u0007\u00021\u0001o\u0003\u0005!\bCA8x\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002tO\u00051AH]8pizJ\u0011\u0001L\u0005\u0003m.\nq\u0001]1dW\u0006<W-\u0003\u0002ys\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003m.B#\u0001C>\u0011\u0005ac\u0018BA?Z\u0005\u001dye.\u0012:s_J\f\u0011c\u001c8NKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\u0015\u0011\u0016\u0011AA\u0002\u0011\u00151\u0016\u00021\u0001X\u0011\u001d\t)!\u0003a\u0001\u0003\u000f\tq!\\3tg\u0006<W\r\u0005\u0003\u0002\n\u0005Ea\u0002BA\u0006\u0003\u001b\u0001\"!]\u0016\n\u0007\u0005=1&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\t)B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001fY\u0003fA\u0005\u0002\u001aA\u0019\u0001,a\u0007\n\u0007\u0005u\u0011LA\u0005P]6+7o]1hK\u0006q\u0001O]8dKN\u001c(+Z9vKN$H#\u0002*\u0002$\u00055\u0002bBA\u0013\u0015\u0001\u0007\u0011qE\u0001\u0005UN|g\u000eE\u0002?\u0003SI1!a\u000b@\u0005!Q5o\u001c8O_\u0012,\u0007\"\u0002,\u000b\u0001\u00049\u0016\u0001\u00049s_\u000e,7o]#se>\u0014H#\u0002*\u00024\u0005U\u0002bBA\u0013\u0017\u0001\u0007\u0011q\u0005\u0005\u0006-.\u0001\ra\u0016\u0015\b\u0001\u0005e\u00121IA#!\u0011\tY$a\u0010\u000e\u0005\u0005u\"B\u0001\u0010Z\u0013\u0011\t\t%!\u0010\u0003\u001dM+'O^3s\u000b:$\u0007o\\5oi\u0006)a/\u00197vK\u0006\u0012\u0011qI\u0001\u0002_\u00059r+\u001a2T_\u000e\\W\r^*feZ,'/\u00128ea>Lg\u000e\u001e\t\u0003u5\u00192!D\u00150)\t\tY%\u0001\u0005tKN\u001c\u0018n\u001c8t+\t\t)\u0006E\u0003\u0002X\u0005}s+\u0004\u0002\u0002Z)\u0019!'a\u0017\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002Z\tI\u0011I\u001d:bs2K7\u000f^\u0001\rg\u0016\u001c8/[8og~#S-\u001d\u000b\u0004%\u0006\u001d\u0004\"CA5!\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\ng\u0016\u001c8/[8og\u0002\n\u0001d]5eK\u000eD\u0017-\u001b8O_\u0012,7\t[1o]\u0016d\u0017*\u001c9m\u0003e\u0019\u0018\u000eZ3dQ\u0006LgNT8eK\u000eC\u0017M\u001c8fY&k\u0007\u000f\u001c\u0011\u0002\u0015\u0005$GmU3tg&|g\u000eF\u0002S\u0003kBQA\u0016\fA\u0002]\u000bQB]3n_Z,7+Z:tS>tGc\u0001*\u0002|!)ak\u0006a\u0001/\u0006!bn\u001c;jMflU-\u001c9p_2\u001c\u0005.\u00198hK\u0012$\u0012AU\u0001%]>$\u0018NZ=TK6\fg\u000e^5dC2d\u0017pU;dG\u0016\u001c8OZ;m\u001b>$\u0017NZ5feR\u0019!+!\"\t\u000f\u0005\u001d\u0015\u00041\u0001\u0002\n\u0006)!\r\\8dWB!\u00111RAH\u001b\t\tiIC\u0002\u0002\b\u0006JA!!%\u0002\u000e\nq1+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017aC:f]\u0012lUm]:bO\u0016$2BUAL\u0003C\u000b)+!+\u0002:\"9\u0011\u0011\u0014\u000eA\u0002\u0005m\u0015aB7tORK\b/\u001a\t\u0004U\u0005u\u0015bAAPW\t\u0019\u0011J\u001c;\t\u000f\u0005\r&\u00041\u0001\u0002\u001c\u0006I!/Z9vKN$\u0018\n\u001a\u0005\b\u0003OS\u0002\u0019AAN\u0003)\tgn]<feRK\b/\u001a\u0005\b\u0003WS\u0002\u0019AAW\u0003\u001d\u0001\u0018-\u001f7pC\u0012\u0004B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003g{\u0014\u0001\u00028pI\u0016LA!a.\u00022\nQqJ\u00196fGRtu\u000eZ3\t\r\u0005m&\u00041\u0001X\u0003\u0019\u0019G.[3oi\u0006I1/\u001a8e\u000bJ\u0014xN\u001d\u000b\f%\u0006\u0005\u00171YAc\u0003\u0013\fi\rC\u0004\u0002$n\u0001\r!a'\t\u000f\u0005\u001d6\u00041\u0001\u0002\u001c\"9\u0011qY\u000eA\u0002\u0005m\u0015!C3se>\u00148i\u001c3f\u0011\u001d\tYm\u0007a\u0001\u0003\u000f\tqB]3ta>t7/\u001a)bs2|\u0017\r\u001a\u0005\u0007\u0003w[\u0002\u0019A,")
public class WebSocketServerEndpoint
implements SparkzLogging {
    private final ObjectMapper mapper;
    private final SidechainNodeChannelImpl sidechainNodeChannel;
    private final Logger logger;

    public static void sendError(int n, int n2, int n3, String string, Session session) {
        WebSocketServerEndpoint$.MODULE$.sendError(n, n2, n3, string, session);
    }

    public static void sendMessage(int n, int n2, int n3, ObjectNode objectNode, Session session) {
        WebSocketServerEndpoint$.MODULE$.sendMessage(n, n2, n3, objectNode, session);
    }

    public static void notifySemanticallySuccessfulModifier(SidechainBlock sidechainBlock) {
        WebSocketServerEndpoint$.MODULE$.notifySemanticallySuccessfulModifier(sidechainBlock);
    }

    public static void notifyMempoolChanged() {
        WebSocketServerEndpoint$.MODULE$.notifyMempoolChanged();
    }

    public static void removeSession(Session session) {
        WebSocketServerEndpoint$.MODULE$.removeSession(session);
    }

    public static void addSession(Session session) {
        WebSocketServerEndpoint$.MODULE$.addSession(session);
    }

    public static SidechainNodeChannelImpl sidechainNodeChannelImpl() {
        return WebSocketServerEndpoint$.MODULE$.sidechainNodeChannelImpl();
    }

    public static void sessions_$eq(ArrayList<Session> arrayList) {
        WebSocketServerEndpoint$.MODULE$.sessions_$eq(arrayList);
    }

    public static ArrayList<Session> sessions() {
        return WebSocketServerEndpoint$.MODULE$.sessions();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public SidechainNodeChannelImpl sidechainNodeChannel() {
        return this.sidechainNodeChannel;
    }

    @OnOpen
    public synchronized void onOpen(Session session) {
        WebSocketServerEndpoint$.MODULE$.addSession(session);
    }

    @OnClose
    public synchronized void onClose(Session session) {
        WebSocketServerEndpoint$.MODULE$.removeSession(session);
    }

    @OnError
    public void onError(Session session, Throwable t) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isErrorEnabled()) {
            this.log().underlying().error(new StringBuilder(19).append("Error on session ").append(session.getId()).append(": ").append(t.toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WebSocketServerEndpoint webSocketServerEndpoint = this;
        synchronized (webSocketServerEndpoint) {
            WebSocketServerEndpoint$.MODULE$.removeSession(session);
        }
    }

    @OnMessage
    public void onMessageReceived(Session session, String message) {
        block7: {
            try {
                JsonNode json = this.mapper().readTree(message);
                if (json.has("msgType")) {
                    int n = json.get("msgType").asInt();
                    switch (n) {
                        case 1: {
                            this.processRequest(json, session);
                            break;
                        }
                        case 2: {
                            this.processError(json, session);
                            break;
                        }
                        default: {
                            this.processError(json, session);
                            System.out.println(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
                            break;
                        }
                    }
                    break block7;
                }
                this.processError(json, session);
                System.out.println("Unknown message received!");
            }
            catch (Throwable ex) {
                this.processError((JsonNode)this.mapper().createObjectNode(), session);
                System.out.println(new StringBuilder(51).append("On receive message processing exception occurred = ").append(ex.getMessage()).toString());
            }
        }
    }

    public void processRequest(JsonNode json, Session session) {
        int requestType;
        JsonNode requestPayload = json.get("requestPayload");
        int requestId = json.get("requestId").asInt();
        int n = requestType = json.get("requestType").asInt();
        if (GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            if (requestPayload.has("hash")) {
                String hash = requestPayload.get("hash").asText();
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getBlockInfoByHash(hash);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit3;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(49).append("Error inside GET_SINGLE_BLOCK websocket request: ").append(ex.toString()).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "Invalid parameter", session);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else if (requestPayload.has("height")) {
                int height = requestPayload.get("height").asInt();
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getBlockInfoByHeight(height);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit6;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(49).append("Error inside GET_SINGLE_BLOCK websocket request: ").append(ex.toString()).toString());
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "Invalid parameter", session);
                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.processError(json, session);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (GET_NEW_BLOCK_HASHES_REQUEST_TYPE$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            Iterator afterHash = requestPayload.get("locatorHashes").elements();
            Seq hashes = (Seq)Nil$.MODULE$;
            while (afterHash.hasNext()) {
                hashes = (Seq)hashes.$colon$plus((Object)((JsonNode)afterHash.next()).asText(), Seq$.MODULE$.canBuildFrom());
            }
            int limit = requestPayload.get("limit").asInt();
            if (limit > 50) {
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Invalid limit size! Max limit is 50", session);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getNewBlockHashes((Seq<String>)hashes, limit);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit10;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(53).append("Error inside GET_NEW_BLOCK_HASHES websocket request: ").append(ex.toString()).toString());
                        boxedUnit10 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit10 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't find new block hashes", session);
                    BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (GET_MEMPOOL_TXS$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            Iterator txids = requestPayload.get("hash").elements();
            Seq hashes = (Seq)Nil$.MODULE$;
            while (txids.hasNext()) {
                hashes = (Seq)hashes.$colon$plus((Object)((JsonNode)txids.next()).asText(), Seq$.MODULE$.canBuildFrom());
            }
            if (hashes.size() > 10) {
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Exceed max number of transactions (10)!", session);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getMempoolTxs((Seq<String>)hashes);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit13 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit14;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(48).append("Error inside GET_MEMPOOL_TXS websocket request: ").append(ex.toString()).toString());
                        boxedUnit14 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit14 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't find mempool txs", session);
                    BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit16 = boxedUnit;
        } else if (GET_RAW_MEMPOOL$.MODULE$.code() == n) {
            Try<ObjectNode> try_ = this.sidechainNodeChannel().getRawMempool();
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                ObjectNode responsePayload = (ObjectNode)success.value();
                if (requestId == -1) {
                    WebSocketServerEndpoint$.MODULE$.sendMessage(EVENT_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit17 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(new StringBuilder(48).append("Error inside GET_RAW_MEMPOOL websocket request: ").append(ex.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't query mempool", session);
                BoxedUnit boxedUnit18 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.out.println(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void processError(JsonNode json, Session session) {
        int requestId = -1;
        if (json.has("requestId")) {
            requestId = json.get("requestId").asInt();
        }
        int requestType = -1;
        if (json.has("requestType")) {
            requestType = json.get("requestType").asInt();
        }
        WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "WebSocket message error!", session);
    }

    public WebSocketServerEndpoint() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.sidechainNodeChannel = new SidechainNodeChannelImpl();
    }
}

