/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.horizen.proposition.Proposition;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ZenCoinsUtils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.box.CoinsBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.transaction.BoxTransaction;
import java.io.ByteArrayOutputStream;
import java.util.List;
import sparkz.crypto.hash.Blake2b256;

public abstract class SidechainTransaction<P extends Proposition, B extends Box<P>>
extends BoxTransaction<P, B> {
    private byte[] _hashWithoutNonce;

    private synchronized byte[] hashWithoutNonce() {
        if (this._hashWithoutNonce == null) {
            ByteArrayOutputStream unlockersStream = new ByteArrayOutputStream();
            for (BoxUnlocker u : this.unlockers()) {
                unlockersStream.write(u.closedBoxId(), 0, u.closedBoxId().length);
            }
            ByteArrayOutputStream newBoxesPropositionsStream = new ByteArrayOutputStream();
            for (Proposition proposition : this.newBoxesPropositions()) {
                newBoxesPropositionsStream.write(proposition.bytes(), 0, proposition.bytes().length);
            }
            this._hashWithoutNonce = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{unlockersStream.toByteArray(), newBoxesPropositionsStream.toByteArray(), Longs.toByteArray((long)this.fee())}));
        }
        return this._hashWithoutNonce;
    }

    protected final long getNewBoxNonce(P newBoxProposition, int newBoxIndex) {
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{newBoxProposition.bytes(), this.hashWithoutNonce(), Ints.toByteArray((int)newBoxIndex)}));
        return BytesUtils.getLong(hash, 0);
    }

    protected abstract List<P> newBoxesPropositions();

    public abstract void transactionSemanticValidity() throws TransactionSemanticValidityException;

    @Override
    public final void semanticValidity() throws TransactionSemanticValidityException {
        if (this.bytes().length > 500000) {
            throw new TransactionSemanticValidityException("Transaction is too large.");
        }
        if (this.unlockers().size() != this.boxIdsToOpen().size()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: inputs double spend found.", this.id()));
        }
        long coinsCumulatedValue = 0L;
        long withdrawalThreshold = ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE);
        List boxes = this.newBoxes();
        int numberOfWithdrawalRequestBoxes = 0;
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            if (box.nonce() != this.getNewBoxNonce(box.proposition(), i)) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: output box [%d] nonce is invalid", this.id(), i));
            }
            if (box instanceof CoinsBox || box instanceof WithdrawalRequestBox) {
                if (box instanceof WithdrawalRequestBox) {
                    ++numberOfWithdrawalRequestBoxes;
                    if (box.value() < withdrawalThreshold) {
                        throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: Withdrawal request box [%d] value is below the threshhold[%d].", this.id(), i, withdrawalThreshold));
                    }
                }
                if (!ZenCoinsUtils.isValidMoneyRange(box.value())) {
                    throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: output coin box [%d] value is out of range.", this.id(), i));
                }
                if (ZenCoinsUtils.isValidMoneyRange(coinsCumulatedValue += box.value())) continue;
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: output coin boxes total value is out of range.", this.id()));
            }
            if (box.value() >= 0L) continue;
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: output non-coin box [%d] value is negative.", this.id(), i));
        }
        if (this.fee() < 0L) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: fee is negative.", this.id()));
        }
        if (numberOfWithdrawalRequestBoxes > MAX_WITHDRAWAL_BOXES_ALLOWED) {
            throw new TransactionSemanticValidityException(String.format("Exceed the maximum withdrawal request boxes per epoch ([%d] out of [%d])", numberOfWithdrawalRequestBoxes, MAX_WITHDRAWAL_BOXES_ALLOWED));
        }
        this.transactionSemanticValidity();
    }
}

