/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.block;

import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.utils.MerklePath;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.Utils;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.block.SidechainBlockHeader;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.companion.SidechainTransactionsCompanion;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.util.SparkzEncoder;
import sparkz.util.SparkzEncoding;
import sparkz.util.package;
import supertagged.package;

public final class SidechainBlock$
implements SparkzEncoding,
scala.Serializable {
    public static SidechainBlock$ MODULE$;
    private final byte BLOCK_VERSION;
    private final int MAX_BLOCK_SIZE;
    private final int MAX_SIDECHAIN_TXS_NUMBER;
    private final SparkzEncoder encoder;

    static {
        new SidechainBlock$();
    }

    public SparkzEncoder encoder() {
        return this.encoder;
    }

    public void sparkz$util$SparkzEncoding$_setter_$encoder_$eq(SparkzEncoder x$1) {
        this.encoder = x$1;
    }

    public byte BLOCK_VERSION() {
        return this.BLOCK_VERSION;
    }

    public int MAX_BLOCK_SIZE() {
        return this.MAX_BLOCK_SIZE;
    }

    public int MAX_SIDECHAIN_TXS_NUMBER() {
        return this.MAX_SIDECHAIN_TXS_NUMBER;
    }

    public Try<SidechainBlock> create(String parentId, byte blockVersion, long timestamp, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Seq<SidechainTransaction<Proposition, Box<Proposition>>> sidechainTransactions, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<SidechainBlockHeader>> ommers, PrivateKey25519 ownerPrivateKey, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, MerklePath forgingStakeInfoMerklePath, byte[] feePaymentsHash, SidechainTransactionsCompanion companion, Option<Signature25519> signatureOption) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Signature25519 signature25519;
            Predef$.MODULE$.require(mainchainBlockReferencesData != null);
            Predef$.MODULE$.require(sidechainTransactions != null);
            Predef$.MODULE$.require(mainchainHeaders != null);
            Predef$.MODULE$.require(ommers != null);
            Predef$.MODULE$.require(ownerPrivateKey != null);
            Predef$.MODULE$.require(forgingStakeInfo != null);
            Predef$.MODULE$.require(vrfProof != null);
            Predef$.MODULE$.require(forgingStakeInfoMerklePath != null);
            Predef$.MODULE$.require(forgingStakeInfoMerklePath.bytes().length > 0);
            PublicKey25519Proposition publicKey25519Proposition = ownerPrivateKey.publicImage();
            PublicKey25519Proposition publicKey25519Proposition2 = forgingStakeInfo.blockSignPublicKey();
            Predef$.MODULE$.require(!(publicKey25519Proposition != null ? !((Object)publicKey25519Proposition).equals(publicKey25519Proposition2) : publicKey25519Proposition2 != null));
            byte[] sidechainTransactionsMerkleRootHash = MODULE$.calculateTransactionsMerkleRootHash(sidechainTransactions);
            byte[] mainchainMerkleRootHash = SidechainBlockBase$.MODULE$.calculateMainchainMerkleRootHash(mainchainBlockReferencesData, mainchainHeaders);
            byte[] ommersMerkleRootHash = SidechainBlockBase$.MODULE$.calculateOmmersMerkleRootHash(ommers);
            Option option = signatureOption;
            if (option instanceof Some) {
                Signature25519 sig;
                Some some = (Some)option;
                signature25519 = sig = (Signature25519)some.value();
            } else if (None$.MODULE$.equals(option)) {
                SidechainBlockHeader unsignedBlockHeader = new SidechainBlockHeader(blockVersion, parentId, timestamp, forgingStakeInfo, forgingStakeInfoMerklePath, vrfProof, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, ommersMerkleRootHash, BoxesRunTime.unboxToLong((Object)((TraversableOnce)ommers.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), feePaymentsHash, new Signature25519(new byte[Signature25519.SIGNATURE_LENGTH]));
                signature25519 = ownerPrivateKey.sign(unsignedBlockHeader.messageToSign());
            } else {
                throw new MatchError((Object)option);
            }
            Signature25519 signature = signature25519;
            SidechainBlockHeader signedBlockHeader = new SidechainBlockHeader(blockVersion, parentId, timestamp, forgingStakeInfo, forgingStakeInfoMerklePath, vrfProof, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, ommersMerkleRootHash, BoxesRunTime.unboxToLong((Object)((TraversableOnce)ommers.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.score()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), feePaymentsHash, signature);
            SidechainBlock block = new SidechainBlock(signedBlockHeader, sidechainTransactions, mainchainBlockReferencesData, mainchainHeaders, ommers, companion);
            return block;
        });
    }

    public Option<Signature25519> create$default$14() {
        return None$.MODULE$;
    }

    public byte[] calculateTransactionsMerkleRootHash(Seq<SidechainTransaction<Proposition, Box<Proposition>>> sidechainTransactions) {
        return sidechainTransactions.nonEmpty() ? MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)sidechainTransactions.map((Function1 & Serializable & scala.Serializable)tx -> (byte[])package$.MODULE$.idToBytes().apply(package.ModifierId$.MODULE$.$at$at((Object)tx.id(), package.Tagger$.MODULE$.baseRaw())), Seq$.MODULE$.canBuildFrom())).asJava()).rootHash() : Utils.ZEROS_HASH;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SidechainBlock$() {
        MODULE$ = this;
        SparkzEncoding.$init$((SparkzEncoding)this);
        this.BLOCK_VERSION = 1;
        this.MAX_BLOCK_SIZE = 5000000;
        this.MAX_SIDECHAIN_TXS_NUMBER = 1000;
    }
}

