/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.transaction.mainchain.SidechainCreationSerializer;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.data.ForgerBoxData;
import java.util.Arrays;
import java.util.Optional;
import scala.compat.java8.OptionConverters;
import sparkz.crypto.hash.Blake2b256;

public final class SidechainCreation
implements SidechainRelatedMainchainOutput<ForgerBox> {
    private final MainchainTxSidechainCreationCrosschainOutput output;
    private final byte[] containingTxHash;
    private final int index;

    public SidechainCreation(MainchainTxSidechainCreationCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.output.hash(), this.containingTxHash, BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public byte[] transactionHash() {
        return this.containingTxHash;
    }

    @Override
    public byte[] sidechainId() {
        return this.output.sidechainId();
    }

    @Override
    public ForgerBox getBox() {
        PublicKey25519Proposition proposition = new PublicKey25519Proposition(BytesUtils.reverseBytes(this.output.address()));
        long value = this.output.amount();
        VrfPublicKey vrfPublicKey = new VrfPublicKey(Arrays.copyOfRange(this.output.customCreationData(), 0, VrfPublicKey.KEY_LENGTH));
        ForgerBoxData forgerBoxData = new ForgerBoxData(proposition, value, proposition, vrfPublicKey);
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.containingTxHash, Ints.toByteArray((int)this.index)}));
        long nonce = BytesUtils.getLong(hash, 0);
        return forgerBoxData.getBox(nonce);
    }

    public ForgingStakeInfo getAccountForgerStakeInfo() {
        if (this.output.customCreationData().length != VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH) {
            throw new IllegalArgumentException("Invalid sidechain creation custom data size, expected: " + VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH + ", actual: " + this.output.customCreationData().length);
        }
        VrfPublicKey vrfPublicKey = new VrfPublicKey(Arrays.copyOfRange(this.output.customCreationData(), 0, VrfPublicKey.KEY_LENGTH));
        PublicKey25519Proposition blockSignProposition = new PublicKey25519Proposition(Arrays.copyOfRange(this.output.customCreationData(), VrfPublicKey.KEY_LENGTH, VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH));
        long stakedAmount = this.output.amount();
        return new ForgingStakeInfo(blockSignProposition, vrfPublicKey, stakedAmount);
    }

    @Override
    public int transactionIndex() {
        return this.index;
    }

    public MainchainTxSidechainCreationCrosschainOutput getScCrOutput() {
        return this.output;
    }

    public Optional<byte[]> getGenSysConstantOpt() {
        return OptionConverters.toJava(this.output.constantOpt());
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return SidechainCreationSerializer.getSerializer();
    }

    public int withdrawalEpochLength() {
        return this.output.withdrawalEpochLength();
    }
}

