/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage.leveldb;

import io.horizen.storage.StorageIterator;
import io.horizen.storage.leveldb.ChangeSet;
import io.horizen.storage.leveldb.ChangeSetSerializer$;
import io.horizen.storage.leveldb.DatabaseIterator;
import io.horizen.storage.leveldb.KVStore;
import io.horizen.storage.leveldb.package$Algos$;
import io.horizen.storage.leveldb.package$Constants$;
import io.horizen.utils.ByteArrayWrapper;
import java.io.Serializable;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u000b\u0017\u0005}A\u0001\u0002\f\u0001\u0003\u0006\u0004%\t\"\f\u0005\to\u0001\u0011\t\u0011)A\u0005]!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d1\u0005A1A\u0005\u0002\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007#\u0002\u0001\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0013\u0001\t\u0003\tYeB\u0003h-!\u0005\u0001NB\u0003\u0016-!\u0005\u0011\u000eC\u0003B%\u0011\u0005Q.\u0002\u0003o%\u0001A%a\u0005,feNLwN\\3e\u0019\u0012\u00135JV*u_J,'BA\f\u0019\u0003\u001daWM^3mI\nT!!\u0007\u000e\u0002\u000fM$xN]1hK*\u00111\u0004H\u0001\bQ>\u0014\u0018N_3o\u0015\u0005i\u0012AA5p\u0007\u0001\u00192\u0001\u0001\u0011)!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bCA\u0015+\u001b\u00051\u0012BA\u0016\u0017\u0005\u001dYek\u0015;pe\u0016\f!\u0001\u001a2\u0016\u00039\u0002\"aL\u001b\u000e\u0003AR!aF\u0019\u000b\u0005I\u001a\u0014\u0001B5rqAR\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c1\u0005\t!%)A\u0002eE\u0002\nAb[3faZ+'o]5p]N,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0004\u0013:$\u0018!D6fKB4VM]:j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u0012+\u0005CA\u0015\u0001\u0011\u0015aS\u00011\u0001/\u0011\u0015AT\u00011\u0001;\u0003-1VM]:j_:\u001c8*Z=\u0016\u0003!\u00032aO%L\u0013\tQEHA\u0003BeJ\f\u0017\u0010\u0005\u0002<\u0019&\u0011Q\n\u0010\u0002\u0005\u0005f$X-\u0001\u0007WKJ\u001c\u0018n\u001c8t\u0017\u0016L\b%A\bDQ\u0006tw-Z*fiB\u0013XMZ5y+\u0005Y\u0015\u0001E\"iC:<WmU3u!J,g-\u001b=!\u0003\u0019)\b\u000fZ1uKR!Ak\\A\u0005)\t)\u0006\f\u0005\u0002<-&\u0011q\u000b\u0010\u0002\u0005+:LG\u000fC\u0003Z\u0015\u0001\u0007!,A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005m#bB\u0001/\u0012\u001d\tifM\u0004\u0002_K:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003Ez\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005ma\u0012BA\r\u001b\u0013\t9\u0002$A\nWKJ\u001c\u0018n\u001c8fI2#%i\u0013,Ti>\u0014X\r\u0005\u0002*%M\u0011!C\u001b\t\u0003w-L!\u0001\u001c\u001f\u0003\r\u0005s\u0017PU3g)\u0005A'!\u0003,feNLwN\\%e\u0011\u0015\u0001(\u00021\u0001r\u0003!!x.\u00138tKJ$\bc\u0001:xu:\u00111/\u001e\b\u0003ARL\u0011!P\u0005\u0003mr\nq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005Yd\u0004#B\u001e|{\u0006\r\u0011B\u0001?=\u0005\u0019!V\u000f\u001d7feA\u0011ap`\u0007\u0002\u0001%\u0019\u0011\u0011\u0001\u0016\u0003\u0003-\u00032A`A\u0003\u0013\r\t9A\u000b\u0002\u0002-\"9\u00111\u0002\u0006A\u0002\u00055\u0011\u0001\u0003;p%\u0016lwN^3\u0011\u0007I<X0\u0001\u0004j]N,'\u000f\u001e\u000b\u0005\u0003'\t9\u0002F\u0002V\u0003+AQ!W\u0006A\u0002iCQ\u0001]\u0006A\u0002E\faA]3n_Z,G\u0003BA\u000f\u0003C!2!VA\u0010\u0011\u0015IF\u00021\u0001[\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\t!B]8mY\n\f7m\u001b+p)\u0011\t9#a\r\u0011\u000b\u0005%\u0012qF+\u000e\u0005\u0005-\"bAA\u0017y\u0005!Q\u000f^5m\u0013\u0011\t\t$a\u000b\u0003\u0007Q\u0013\u0018\u0010\u0003\u0004\u000265\u0001\rAW\u0001\nm\u0016\u00148/[8o\u0013\u0012\f\u0001B^3sg&|gn]\u000b\u0003\u0003w\u00012A]<[\u0003=1XM]:j_:LE-\u0012=jgR\u001cH\u0003BA!\u0003\u000f\u00022aOA\"\u0013\r\t)\u0005\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019\t)d\u0004a\u00015\u0006Yq-\u001a;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0005\u0005\u0003\u0002P\u0005ES\"\u0001\r\n\u0007\u0005M\u0003DA\bTi>\u0014\u0018mZ3Ji\u0016\u0014\u0018\r^8s\u0001")
public final class VersionedLDBKVStore
implements KVStore {
    private final DB db;
    private final int keepVersions;
    private final byte[] VersionsKey;
    private final byte ChangeSetPrefix;

    @Override
    public Option<byte[]> get(byte[] key) {
        return KVStore.get$((KVStore)this, key);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll(Function2<byte[], byte[], Object> cond) {
        return KVStore.getAll$(this, cond);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll() {
        return KVStore.getAll$(this);
    }

    @Override
    public byte[] getOrElse(byte[] key, Function0<byte[]> function0) {
        return KVStore.getOrElse$(this, key, function0);
    }

    @Override
    public Seq<Tuple2<byte[], Option<byte[]>>> get(Seq<byte[]> keys) {
        return KVStore.get$((KVStore)this, keys);
    }

    @Override
    public void close() {
        KVStore.close$(this);
    }

    @Override
    public DB db() {
        return this.db;
    }

    public int keepVersions() {
        return this.keepVersions;
    }

    public byte[] VersionsKey() {
        return this.VersionsKey;
    }

    public byte ChangeSetPrefix() {
        return this.ChangeSetPrefix;
    }

    public void update(Seq<Tuple2<byte[], byte[]>> toInsert, Seq<byte[]> toRemove, byte[] version) {
        Predef$.MODULE$.require(version.length == package$Constants$.MODULE$.HashLength(), (Function0 & Serializable & scala.Serializable)() -> "Illegal version id size");
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)this.db().get(version, ro)).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Version id is already used");
        ArrayBuffer insertedKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer altered = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        toInsert.foreach((Function1 & Serializable & scala.Serializable)x -> {
            VersionedLDBKVStore.$anonfun$update$3(this, ro, insertedKeys, altered, x);
            return BoxedUnit.UNIT;
        });
        Seq removed = (Seq)toRemove.flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(k, ro)).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), x$1))), Seq$.MODULE$.canBuildFrom());
        ChangeSet changeSet = new ChangeSet((Seq<byte[]>)insertedKeys, (Seq<Tuple2<byte[], byte[]>>)removed, (Seq<Tuple2<byte[], byte[]>>)altered);
        Tuple2 tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey(), ro)).map((Function1 & Serializable & scala.Serializable)x$2 -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(version)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> version))).splitAt(package$Constants$.MODULE$.HashLength() * this.keepVersions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] updatedVersions = (byte[])tuple2._1();
        byte[] versionsToShrink = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)updatedVersions, (Object)versionsToShrink);
        Tuple2 tuple23 = tuple22;
        byte[] updatedVersions2 = (byte[])tuple23._1();
        byte[] versionsToShrink2 = (byte[])tuple23._2();
        Iterator versionIdsToShrink = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(versionsToShrink2)).grouped(package$Constants$.MODULE$.HashLength());
        WriteBatch batch = this.db().createWriteBatch();
        try {
            batch.put(this.VersionsKey(), updatedVersions2);
            versionIdsToShrink.foreach((Function1 & Serializable & scala.Serializable)x$1 -> batch.delete(x$1));
            byte by = this.ChangeSetPrefix();
            batch.put(version, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ChangeSetSerializer$.MODULE$.toBytes(changeSet))).$plus$colon((Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.Byte()));
            toInsert.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                byte[] k = (byte[])tuple2._1();
                byte[] v = (byte[])tuple2._2();
                WriteBatch writeBatch = batch.put(k, v);
                return writeBatch;
            });
            toRemove.foreach((Function1 & Serializable & scala.Serializable)x$1 -> batch.delete(x$1));
            this.db().write(batch);
        }
        finally {
            batch.close();
            ro.snapshot().close();
        }
    }

    public void insert(Seq<Tuple2<byte[], byte[]>> toInsert, byte[] version) {
        this.update(toInsert, (Seq<byte[]>)((Seq)Nil$.MODULE$), version);
    }

    public void remove(Seq<byte[]> toRemove, byte[] version) {
        this.update((Seq<Tuple2<byte[], byte[]>>)((Seq)Nil$.MODULE$), toRemove, version);
    }

    public Try<BoxedUnit> rollbackTo(byte[] versionId) {
        Failure failure;
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Option option = Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()));
        if (option instanceof Some) {
            Success success;
            Some some = (Some)option;
            byte[] bytes = (byte[])some.value();
            WriteBatch batch = this.db().createWriteBatch();
            try {
                Iterator versionsToRollBack = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$1(versionId, x$5)));
                ((IterableLike)versionsToRollBack.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Seq acc = (Seq)tuple2._1();
                    byte[] verId = (byte[])tuple2._2();
                    Option changeSetOpt = Option$.MODULE$.apply((Object)this.db().get(verId, ro)).flatMap((Function1 & Serializable & scala.Serializable)changeSetBytes -> ChangeSetSerializer$.MODULE$.parseBytesTry((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(changeSetBytes)).tail()).toOption());
                    Predef$.MODULE$.require(changeSetOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Inconsistent versioned storage state");
                    Seq seq = (Seq)acc.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(changeSetOpt).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verId), x$6), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    return seq;
                })).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] verId = (byte[])tuple2._1();
                    ChangeSet changeSet = (ChangeSet)tuple2._2();
                    changeSet.insertedKeys().foreach((Function1 & Serializable & scala.Serializable)k -> batch.delete(k));
                    changeSet.removed().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] v = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, v);
                        return writeBatch;
                    });
                    changeSet.altered().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] oldV = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, oldV);
                        return writeBatch;
                    });
                    WriteBatch writeBatch = batch.delete(verId);
                    return writeBatch;
                });
                ByteArrayWrapper wrappedVersionId = new ByteArrayWrapper(versionId);
                byte[] updatedVersions = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).map((Function1 & Serializable & scala.Serializable)x$7 -> new ByteArrayWrapper((byte[])x$7)).dropWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$11(wrappedVersionId, x$8))).foldLeft(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x0$5, x1$2) -> {
                    Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] acc = (byte[])tuple2._1();
                    ByteArrayWrapper arr = (ByteArrayWrapper)tuple2._2();
                    byte[] byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr.data())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                    return byArray;
                });
                versionsToRollBack.foreach((Function1 & Serializable & scala.Serializable)x$1 -> batch.delete(x$1));
                batch.put(this.VersionsKey(), updatedVersions);
                this.db().write(batch);
                success = new Success((Object)BoxedUnit.UNIT);
            }
            finally {
                batch.close();
                ro.snapshot().close();
            }
            failure = success;
        } else if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new Exception(new StringBuilder(18).append("Version ").append(package$Algos$.MODULE$.encode(versionId)).append(" not found").toString()));
        } else {
            throw new MatchError((Object)option);
        }
        return failure;
    }

    public Seq<byte[]> versions() {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$9)).grouped(package$Constants$.MODULE$.HashLength()), Seq$.MODULE$.canBuildFrom());
    }

    public boolean versionIdExists(byte[] versionId) {
        return this.versions().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$versionIdExists$1(versionId, x$10)));
    }

    public StorageIterator getIterator() {
        return new DatabaseIterator(this.db().iterator());
    }

    public static final /* synthetic */ void $anonfun$update$3(VersionedLDBKVStore $this, ReadOptions ro$1, ArrayBuffer insertedKeys$1, ArrayBuffer altered$1, Tuple2 x) {
        Option$.MODULE$.apply((Object)$this.db().get((byte[])x._1(), ro$1)).fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedKeys$1.$plus$eq(x._1()), (Function1 & Serializable & scala.Serializable)oldValue -> {
            altered$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)oldValue));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$1(byte[] versionId$1, byte[] x$5) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$5);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$1);
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !((Object)byteArrayWrapper).equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$11(ByteArrayWrapper wrappedVersionId$1, ByteArrayWrapper x$8) {
        ByteArrayWrapper byteArrayWrapper = x$8;
        ByteArrayWrapper byteArrayWrapper2 = wrappedVersionId$1;
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !((Object)byteArrayWrapper).equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$versionIdExists$1(byte[] versionId$2, byte[] x$10) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$10);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$2);
        return !(byteArrayWrapper != null ? !((Object)byteArrayWrapper).equals(byteArrayWrapper2) : byteArrayWrapper2 != null);
    }

    public VersionedLDBKVStore(DB db, int keepVersions) {
        this.db = db;
        this.keepVersions = keepVersions;
        KVStore.$init$(this);
        this.VersionsKey = package$Algos$.MODULE$.hash().apply("versions");
        this.ChangeSetPrefix = (byte)22;
    }
}

