/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.ProofOfKnowledgeProposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.secret.SchnorrSecretSerializer;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.secret.SecretsIdsEnum;
import io.horizen.utils.BytesUtils;
import java.util.Arrays;
import java.util.Objects;

public class SchnorrSecret
implements Secret {
    public static final int SECRET_KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrSecretKeyLength();
    public static final int PUBLIC_KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrPublicKeyLength();
    final byte[] secretBytes;
    final byte[] publicBytes;

    public SchnorrSecret(byte[] secretKey, byte[] publicKey) {
        Objects.requireNonNull(secretKey, "Secret key can't be null");
        Objects.requireNonNull(publicKey, "Public key can't be null");
        if (secretKey.length != SECRET_KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect secret key length, %d expected, %d found", SECRET_KEY_LENGTH, secretKey.length));
        }
        if (publicKey.length != PUBLIC_KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect public key length, %d expected, %d found", PUBLIC_KEY_LENGTH, publicKey.length));
        }
        this.secretBytes = Arrays.copyOf(secretKey, secretKey.length);
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    private byte[] getSecretBytes() {
        return Arrays.copyOf(this.secretBytes, this.secretBytes.length);
    }

    public byte[] getPublicBytes() {
        return this.publicBytes;
    }

    @Override
    public byte secretTypeId() {
        return SecretsIdsEnum.SchnorrSecretKeyId.id();
    }

    @Override
    public SchnorrProposition publicImage() {
        byte[] publicKey = Arrays.copyOf(this.publicBytes, this.publicBytes.length);
        return new SchnorrProposition(publicKey);
    }

    @Override
    public SecretSerializer serializer() {
        return SchnorrSecretSerializer.getSerializer();
    }

    @Override
    public boolean owns(ProofOfKnowledgeProposition proposition) {
        return Arrays.equals(this.publicBytes, proposition.pubKeyBytes());
    }

    @Override
    public SchnorrProof sign(byte[] message) {
        return new SchnorrProof(CryptoLibProvider.schnorrFunctions().sign(this.getSecretBytes(), this.getPublicBytes(), message));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrSecret that = (SchnorrSecret)o;
        return Arrays.equals(this.secretBytes, that.secretBytes) && Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.secretBytes);
        result = 31 * result + Arrays.hashCode(this.publicBytes);
        return result;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    public String toString() {
        return String.format("SchnorrSecret{privateKey=%s}", BytesUtils.toHexString(this.secretBytes).substring(0, 8));
    }

    @Override
    public Boolean isPublicKeyValid() {
        byte[] correctPublicKey = CryptoLibProvider.schnorrFunctions().getPublicKey(this.secretBytes);
        return Arrays.equals(this.publicBytes, correctPublicKey);
    }
}

