/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.SecretSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public final class PrivateKey25519Serializer
implements SecretSerializer<PrivateKey25519> {
    private static PrivateKey25519Serializer serializer = new PrivateKey25519Serializer();

    private PrivateKey25519Serializer() {
    }

    public static PrivateKey25519Serializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(PrivateKey25519 secret, Writer writer) {
        writer.putBytes(secret.privateKeyBytes);
        writer.putBytes(secret.publicKeyBytes);
    }

    @Override
    public PrivateKey25519 parse(Reader reader) {
        byte[] publicKeyBytes;
        byte[] privateKeyBytes = reader.getBytes(PrivateKey25519.PRIVATE_KEY_LENGTH);
        PrivateKey25519 privateKey25519 = new PrivateKey25519(privateKeyBytes, publicKeyBytes = reader.getBytes(PrivateKey25519.PUBLIC_KEY_LENGTH));
        if (!privateKey25519.isPublicKeyValid().booleanValue()) {
            throw new IllegalArgumentException("The public key is not corresponds to the secret key.");
        }
        return privateKey25519;
    }
}

