/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.history.validation;

import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.chain.package$;
import io.horizen.history.AbstractHistory;
import io.horizen.history.validation.HistoryBlockValidator;
import io.horizen.history.validation.InvalidMainchainDataException;
import io.horizen.history.validation.InvalidMainchainDataException$;
import io.horizen.params.NetworkParams;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.ByteArrayWrapper;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001Y4AAB\u0004\u0001!!Aq\u000b\u0001B\u0001B\u0003%\u0001\fC\u0003^\u0001\u0011\u0005a\fC\u0003b\u0001\u0011\u0005#\rC\u0003o\u0001\u0011%q\u000eC\u0003s\u0001\u0011%1O\u0001\u0011NC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dKZ\u000bG.\u001b3bi>\u0014(B\u0001\u0005\n\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0015-\tq\u0001[5ti>\u0014\u0018P\u0003\u0002\r\u001b\u00059\u0001n\u001c:ju\u0016t'\"\u0001\b\u0002\u0005%|7\u0001A\u000b\b#yYS\u0007\u0010$Q'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0011eQBD\u000b\u001b<\u000b>k\u0011aB\u0005\u00037\u001d\u0011Q\u0003S5ti>\u0014\u0018P\u00117pG.4\u0016\r\\5eCR|'\u000f\u0005\u0002\u001e=1\u0001A!B\u0010\u0001\u0005\u0004\u0001#A\u0001+Y#\t\tC\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\b\u001d>$\b.\u001b8h!\t)\u0003&D\u0001'\u0015\t93\"A\u0006ue\u0006t7/Y2uS>t\u0017BA\u0015'\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005uYC!\u0002\u0017\u0001\u0005\u0004i#!\u0001%\u0012\u0005\u0005r\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\f\u0003\u0015\u0011Gn\\2l\u0013\t\u0019\u0004G\u0001\rTS\u0012,7\r[1j]\ncwnY6IK\u0006$WM\u001d\"bg\u0016\u0004\"!H\u001b\u0005\u000bY\u0002!\u0019A\u001c\u0003\tAku\nR\t\u0003Ca\u0002BaL\u001d\u001dU%\u0011!\b\r\u0002\u0013'&$Wm\u00195bS:\u0014En\\2l\u0005\u0006\u001cX\r\u0005\u0002\u001ey\u0011)Q\b\u0001b\u0001}\t\u0019a\tU%\u0012\u0005\u0005z\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\f\u0003\u0015\u0019\u0007.Y5o\u0013\t!\u0015IA\fBEN$(/Y2u\r\u0016,\u0007+Y=nK:$8/\u00138g_B\u0011QD\u0012\u0003\u0006\u000f\u0002\u0011\r\u0001\u0013\u0002\u0006\u0011N#vJU\t\u0003C%\u0003RAS'5w\u0015k\u0011a\u0013\u0006\u0003\u0019.\tqa\u001d;pe\u0006<W-\u0003\u0002O\u0017\n1\u0012IY:ue\u0006\u001cG\u000fS5ti>\u0014\u0018p\u0015;pe\u0006<W\r\u0005\u0002\u001e!\u0012)\u0011\u000b\u0001b\u0001%\n\u0011\u0001\nV\t\u0003CM\u0003\u0002\u0002V+\u001dUQZTiT\u0007\u0002\u0013%\u0011a+\u0003\u0002\u0010\u0003\n\u001cHO]1di\"K7\u000f^8ss\u00061\u0001/\u0019:b[N\u0004\"!W.\u000e\u0003iS!aV\u0006\n\u0005qS&!\u0004(fi^|'o\u001b)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0002\u0004\u0002\"\u0007\u0001\u001dUQZTi\u0014\u0005\u0006/\n\u0001\r\u0001W\u0001\tm\u0006d\u0017\u000eZ1uKR\u00191\r\\7\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1G#\u0001\u0003vi&d\u0017B\u00015f\u0005\r!&/\u001f\t\u0003')L!a\u001b\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\r\u0001\r\u0001\u000e\u0005\u0006\u0015\r\u0001\raT\u0001\u0015m\u0006d\u0017\u000eZ1uK\u001e+g.Z:jg\ncwnY6\u0015\u0005%\u0004\b\"B9\u0005\u0001\u0004!\u0014!\u0004<fe&4\u0017.\u001a3CY>\u001c7.A\u0007wC2LG-\u0019;f\u00052|7m\u001b\u000b\u0004SR,\b\"B9\u0006\u0001\u0004!\u0004\"\u0002\u0006\u0006\u0001\u0004y\u0005")
public class MainchainBlockReferenceValidator<TX extends Transaction, H extends SidechainBlockHeaderBase, PMOD extends SidechainBlockBase<TX, H>, FPI extends AbstractFeePaymentsInfo, HSTOR extends AbstractHistoryStorage<PMOD, FPI, HSTOR>, HT extends AbstractHistory<TX, H, PMOD, FPI, HSTOR, HT>>
implements HistoryBlockValidator<TX, H, PMOD, FPI, HSTOR, HT> {
    private final NetworkParams params;

    @Override
    public Try<BoxedUnit> validate(PMOD block, HT history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (block.id().equals($this.params.sidechainGenesisBlockId())) {
                this.validateGenesisBlock(block);
            } else {
                this.validateBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(PMOD verifiedBlock) {
        if (((SidechainBlockBase)verifiedBlock).mainchainHeaders().size() != 1) {
            throw new InvalidMainchainDataException(new StringBuilder(74).append("Genesis block expect to contain only 1 MainchainHeader, instead contains ").append(((SidechainBlockBase)verifiedBlock).mainchainHeaders().size()).append(".").toString(), InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().size() != 1) {
            throw new InvalidMainchainDataException(new StringBuilder(86).append("Genesis block expect to contain only 1 MainchainBlockReferenceData, instead contains ").append(((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().size()).append(".").toString(), InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        MainchainBlockReference reference = new MainchainBlockReference((MainchainHeader)((SidechainBlockBase)verifiedBlock).mainchainHeaders().head(), (MainchainBlockReferenceData)((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().head());
        Try<BoxedUnit> try_ = reference.semanticValidity(this.params);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void validateBlock(PMOD verifiedBlock, HT history) {
        if (((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().isEmpty()) {
            return;
        }
        ObjectRef missedMainchainReferenceDataHeaderHashesInfo = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef blockId = ObjectRef.create((Object)verifiedBlock.parentId());
            ObjectRef bestMainchainReferenceDataHeaderHashOpt = ObjectRef.create((Object)None$.MODULE$);
            while (true) {
                int index;
                SidechainBlockInfo blockInfo = history.blockInfoById((String)blockId.elem);
                missedMainchainReferenceDataHeaderHashesInfo$1.elem = (Seq)((TraversableLike)blockInfo.mainchainHeaderHashes().map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2(x$1, (Object)((String)blockId$1.elem)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem), Seq$.MODULE$.canBuildFrom());
                if (((Option)bestMainchainReferenceDataHeaderHashOpt.elem).isEmpty()) {
                    bestMainchainReferenceDataHeaderHashOpt.elem = blockInfo.mainchainReferenceDataHeaderHashes().lastOption();
                }
                if (((Option)bestMainchainReferenceDataHeaderHashOpt.elem).isDefined() && (index = ((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem).indexWhere((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReferenceValidator.$anonfun$validateBlock$3(bestMainchainReferenceDataHeaderHashOpt, info)))) != -1) {
                    missedMainchainReferenceDataHeaderHashesInfo$1.elem = (Seq)((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem).drop(index + 1);
                    throw Breaks$.MODULE$.break();
                }
                blockId.elem = blockInfo.parentId();
            }
        });
        missedMainchainReferenceDataHeaderHashesInfo.elem = (Seq)((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem).$plus$plus((GenTraversableOnce)((SidechainBlockBase)verifiedBlock).mainchainHeaders().map((Function1 & Serializable & scala.Serializable)header -> new Tuple2((Object)package$.MODULE$.byteArrayToMainchainHeaderHash(header.hash()), (Object)verifiedBlock.id()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        if (((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().size() > ((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem).size()) {
            throw new InvalidMainchainDataException("Block contains more MainchainBlockReferenceData, than expected in the chain.", InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        ((TraversableOnce)((SidechainBlockBase)verifiedBlock).mainchainBlockReferencesData().zip((GenIterable)((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem), Seq$.MODULE$.canBuildFrom())).foldLeft(verifiedBlock, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            SidechainBlockBase sidechainBlockBase;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            SidechainBlockBase lastRetrievedBlock = (SidechainBlockBase)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            MainchainBlockReferenceData referenceData = (MainchainBlockReferenceData)tuple22._1();
            Tuple2 tuple23 = (Tuple2)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            ByteArrayWrapper mainchainHeaderHash = (ByteArrayWrapper)tuple23._1();
            String containingBlockId = (String)tuple23._2();
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(referenceData.headerHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeaderHash.data()))) {
                throw new InvalidMainchainDataException("MainchainBlockReferenceData header hash and MainchainHeader hash are different.", InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
            }
            String string = containingBlockId;
            String string2 = lastRetrievedBlock.id();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                sidechainBlockBase = lastRetrievedBlock;
            } else {
                String string4 = verifiedBlock.id();
                String string5 = string;
                sidechainBlockBase = !(string4 != null ? !string4.equals(string5) : string5 != null) ? verifiedBlock : (SidechainBlockBase)history.getBlockById(string).get();
            }
            SidechainBlockBase blockWithMainchainHeader = sidechainBlockBase;
            MainchainHeader mainchainHeader = (MainchainHeader)blockWithMainchainHeader.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReferenceValidator.$anonfun$validateBlock$6(mainchainHeaderHash, header))).get();
            MainchainBlockReference reference = new MainchainBlockReference(mainchainHeader, referenceData);
            Try<BoxedUnit> try_ = reference.semanticValidity($this.params);
            if (!(try_ instanceof Success)) {
                if (!(try_ instanceof Failure)) throw new MatchError(try_);
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return blockWithMainchainHeader;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateBlock$3(ObjectRef bestMainchainReferenceDataHeaderHashOpt$1, Tuple2 info) {
        return BoxesRunTime.equals((Object)info._1(), (Object)((Option)bestMainchainReferenceDataHeaderHashOpt$1.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$validateBlock$6(ByteArrayWrapper mainchainHeaderHash$1, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeaderHash$1.data()));
    }

    public MainchainBlockReferenceValidator(NetworkParams params) {
        this.params = params;
    }
}

