/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.forge;

import akka.util.Timeout;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.MainchainHeaderSerializer$;
import io.horizen.block.Ommer;
import io.horizen.block.Ommer$;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.MainchainHeaderInfo;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.consensus.ConsensusDataProvider;
import io.horizen.consensus.ConsensusEpochAndSlot;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.consensus.FullConsensusEpochInfo;
import io.horizen.forge.AbstractForgeMessageBuilder$BranchPointInfo$;
import io.horizen.forge.ForgeFailed;
import io.horizen.forge.ForgeFailure;
import io.horizen.forge.ForgeResult;
import io.horizen.forge.ForgeSuccess;
import io.horizen.forge.MainchainSynchronizer;
import io.horizen.forge.MainchainSynchronizer$;
import io.horizen.forge.NoOwnedForgingStake$;
import io.horizen.forge.SkipSlot;
import io.horizen.fork.ActiveSlotCoefficientFork$;
import io.horizen.fork.ForkManager$;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.params.RegTestParams;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.secret.PrivateKey25519;
import io.horizen.transaction.Transaction;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.DynamicTypedSerializer;
import io.horizen.utils.ForgingStakeMerklePathInfo;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.vrf.VrfOutput;
import io.horizen.wallet.AbstractWallet;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;
import sparkz.core.transaction.MemoryPool;
import sparkz.core.transaction.state.MinimalState;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0011Uf!B\u001d;\u0003\u0003\t\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001B\u001c\u0001\u0003\u0006\u0004%\ta\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005a\"Aa\u000f\u0001B\u0001B\u0003%q\u000fC\u0003{\u0001\u0011\u00051\u0010B\u0004\u0002&\u0001\u0011\t!a\n\u0005\u000f\u0005U\u0002A!\u0001\u00028\u00119\u00111\n\u0001\u0003\u0002\u00055CaBA/\u0001\t\u0005\u0011q\f\u0003\b\u0003_\u0002!\u0011AA9\t\u001d\t9\t\u0001B\u0001\u0003\u0013+a!!&\u0001\u0001\u0005]UABAZ\u0001\u0001\t)\fC\u0004\u0002J\u0002!\t!a3\u0007\r\t\u0005\u0002\u0001\u0011B\u0012\u0011)\u0011\t\u0004\u0005BK\u0002\u0013\u0005!1\u0007\u0005\u000b\u0005\u000b\u0002\"\u0011#Q\u0001\n\tU\u0002B\u0003B$!\tU\r\u0011\"\u0001\u0003J!Q!\u0011\r\t\u0003\u0012\u0003\u0006IAa\u0013\t\u0015\t\r\u0004C!f\u0001\n\u0003\u0011I\u0005\u0003\u0006\u0003fA\u0011\t\u0012)A\u0005\u0005\u0017BaA\u001f\t\u0005\u0002\t\u001d\u0004\"\u0003B9!\u0005\u0005I\u0011\u0001B:\u0011%\u0011Y\bEI\u0001\n\u0003\u0011i\bC\u0005\u0003\u0014B\t\n\u0011\"\u0001\u0003\u0016\"I!\u0011\u0014\t\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u00057\u0003\u0012\u0011!C!\u0005;C\u0011Ba,\u0011\u0003\u0003%\tA!-\t\u0013\te\u0006#!A\u0005\u0002\tm\u0006\"\u0003Bd!\u0005\u0005I\u0011\tBe\u0011%\u00119\u000eEA\u0001\n\u0003\u0011I\u000eC\u0005\u0003^B\t\t\u0011\"\u0011\u0003`\"I!\u0011\u001d\t\u0002\u0002\u0013\u0005#1\u001d\u0005\n\u0005K\u0004\u0012\u0011!C!\u0005O<\u0011Ba;\u0001\u0003\u0003E\tA!<\u0007\u0013\t\u0005\u0002!!A\t\u0002\t=\bB\u0002>&\t\u0003\u0011i\u0010C\u0005\u0003b\u0016\n\t\u0011\"\u0012\u0003d\"I!q`\u0013\u0002\u0002\u0013\u00055\u0011\u0001\u0005\n\u0007\u0013)\u0013\u0011!CA\u0007\u0017Aqa!\b\u0001\t#\u0019y\u0002C\u0004\u00046\u0001!\tba\u000e\t\u000f\rm\u0004\u0001\"\u0005\u0004~!91Q\u0014\u0001\u0005\u0012\r}\u0005bBBW\u0001\u0019\u0005!\u0011\u0017\u0005\b\u0007_\u0003a\u0011\u0001BY\u0011\u001d\u0019\t\f\u0001C\t\u0007gC\u0011b!6\u0001#\u0003%\tba6\t\u000f\rm\u0007A\"\u0001\u0004^\"IA\u0011\u000e\u0001\u0012\u0002\u0013\u0005A1\u000e\u0005\n\t_\u0002\u0011\u0013!C\u0001\u0007/Dq\u0001\"\u001d\u0001\r\u0003!\u0019\bC\u0004\u0005\u0000\u00011\t\u0001\"!\t\u000f\u0011m\u0005A\"\u0001\u0005\u001e\"9A\u0011\u0015\u0001\u0007\u0002\u0011\r&aG!cgR\u0014\u0018m\u0019;G_J<W-T3tg\u0006<WMQ;jY\u0012,'O\u0003\u0002<y\u0005)am\u001c:hK*\u0011QHP\u0001\bQ>\u0014\u0018N_3o\u0015\u0005y\u0014AA5p\u0007\u0001)RAQ0\u007f\u0003#\u00192\u0001A\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fMB\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0019\u0019\b/\u0019:lu&\u0011\u0001k\u0013\u0002\u000e'B\f'o\u001b>M_\u001e<\u0017N\\4\u0002+5\f\u0017N\\2iC&t7+\u001f8dQJ|g.\u001b>feB\u00111\u000bV\u0007\u0002u%\u0011QK\u000f\u0002\u0016\u001b\u0006Lgn\u00195bS:\u001c\u0016P\\2ie>t\u0017N_3s\u0003%\u0019w.\u001c9b]&|g\u000e\u0005\u0003Y7v[W\"A-\u000b\u0005ic\u0014!B;uS2\u001c\u0018B\u0001/Z\u0005Y!\u0015P\\1nS\u000e$\u0016\u0010]3e'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u00010`\u0019\u0001!Q\u0001\u0019\u0001C\u0002\u0005\u0014!\u0001\u0016-\u0012\u0005\t,\u0007C\u0001#d\u0013\t!WIA\u0004O_RD\u0017N\\4\u0011\u0005\u0019LW\"A4\u000b\u0005!d\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L!A[4\u0003\u0017Q\u0013\u0018M\\:bGRLwN\u001c\t\u0004M2l\u0016BA7h\u0005U!&/\u00198tC\u000e$\u0018n\u001c8TKJL\u0017\r\\5{KJ\fa\u0001]1sC6\u001cX#\u00019\u0011\u0005E\u001cX\"\u0001:\u000b\u00059d\u0014B\u0001;s\u00055qU\r^<pe.\u0004\u0016M]1ng\u00069\u0001/\u0019:b[N\u0004\u0013aI1mY><hj\\,fEN|7m[3u\u0007>tg.Z2uS>t\u0017J\u001c*fOR,7\u000f\u001e\t\u0003\tbL!!_#\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\u0012\u0002`A\u000f\u0003?\t\t#a\t\u0011\rM\u0003Q,`A\b!\tqf\u0010\u0002\u0004\u0000\u0001\t\u0007\u0011\u0011\u0001\u0002\u0002\u0011F\u0019!-a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003=\u0003\u0015\u0011Gn\\2l\u0013\u0011\ti!a\u0002\u00031MKG-Z2iC&t'\t\\8dW\"+\u0017\rZ3s\u0005\u0006\u001cX\rE\u0002_\u0003#!q!a\u0005\u0001\u0005\u0004\t)B\u0001\u0002Q\u001bF\u0019!-a\u0006\u0011\r\u0005\u0015\u0011\u0011D/~\u0013\u0011\tY\"a\u0002\u0003%MKG-Z2iC&t'\t\\8dW\n\u000b7/\u001a\u0005\u0006#\u001a\u0001\rA\u0015\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u0006]\u001a\u0001\r\u0001\u001d\u0005\u0006m\u001a\u0001\ra\u001e\u0002\u0004\rBK\u0015c\u00012\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020q\nQa\u00195bS:LA!a\r\u0002.\t9\u0012IY:ue\u0006\u001cGOR3f!\u0006LX.\u001a8ug&sgm\u001c\u0002\u0006\u0011N#vJU\t\u0004E\u0006e\u0002CCA\u001e\u0003\u0003\ny!!\u0012\u0002J5\u0011\u0011Q\b\u0006\u0004\u0003\u007fa\u0014aB:u_J\fw-Z\u0005\u0005\u0003\u0007\niD\u0001\fBEN$(/Y2u\u0011&\u001cHo\u001c:z'R|'/Y4f!\r\t9eB\u0007\u0002\u0001A\u0019\u0011q\t\u0005\u0003\u0007!K5+E\u0002c\u0003\u001f\u0002b\"!\u0015\u0002Xuk\u0018qBA#\u0003\u0013\nY&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u001f\u0002\u000f!L7\u000f^8ss&!\u0011\u0011LA*\u0005=\t%m\u001d;sC\u000e$\b*[:u_JL\bcAA$\u0013\t\u0011a\u000bT\t\u0004E\u0006\u0005\u0004#CA2\u0003Sj\u0016qBA7\u001b\t\t)GC\u0002\u0002hq\naa^1mY\u0016$\u0018\u0002BA6\u0003K\u0012a\"\u00112tiJ\f7\r^,bY2,G\u000fE\u0002\u0002H)\u0011!!T*\u0012\u0007\t\f\u0019\b\u0005\u0005\u0002v\u0005\u0005\u0015qBAC\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!B:uCR,'b\u00015\u0002~)\u0019\u0011qP'\u0002\t\r|'/Z\u0005\u0005\u0003\u0007\u000b9H\u0001\u0007NS:LW.\u00197Ti\u0006$X\rE\u0002\u0002H-\u0011!!\u0014)\u0012\u0007\t\fY\tE\u0004\u0002\u000e\u0006=U,a%\u000e\u0005\u0005m\u0014\u0002BAI\u0003w\u0012!\"T3n_JL\bk\\8m!\r\t9\u0005\u0004\u0002\u0005-&,w\u000f\u0005\u0007\u0002\u001a\u00065\u00161LAC\u0003[\n\u0019J\u0004\u0003\u0002\u001c\u0006%f\u0002BAO\u0003OsA!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G\u0003\u0015A\u0002\u001fs_>$h(C\u0001O\u0013\r\ty(T\u0005\u0005\u0003W\u000bi(\u0001\bO_\u0012,g+[3x\u0011>dG-\u001a:\n\t\u0005=\u0016\u0011\u0017\u0002\f\u0007V\u0014(/\u001a8u-&,wO\u0003\u0003\u0002,\u0006u$\u0001\u0005$pe\u001e,W*Z:tC\u001e,G+\u001f9f!9\t9,!0\u0002\\\u0005\u0015\u0015QNAJ\u0003\u0007tA!!'\u0002:&!\u00111XAY\u0003I\u0011VmY3jm\u0006\u0014G.Z'fgN\fw-Z:\n\t\u0005}\u0016\u0011\u0019\u0002\u0017\u000f\u0016$H)\u0019;b\rJ|WnQ;se\u0016tGOV5fo*!\u00111XAY!\r\u0019\u0016QY\u0005\u0004\u0003\u000fT$a\u0003$pe\u001e,'+Z:vYR\f\u0001EY;jY\u00124uN]4f\u001b\u0016\u001c8/Y4f\r>\u0014X\t]8dQ\u0006sGm\u00157piRQ\u0011QZAh\u0003c\fYP!\u0004\u0011\u0007\u0005\u001dc\u0002C\u0004\u0002R>\u0001\r!a5\u0002)\r|gn]3ogV\u001cX\t]8dQ:+XNY3s!\u0011\t).a;\u000f\t\u0005]\u0017Q\u001d\b\u0005\u00033\f\tO\u0004\u0003\u0002\\\u0006}g\u0002BAP\u0003;L\u0011aP\u0005\u0003{yJ1!a9=\u0003%\u0019wN\\:f]N,8/\u0003\u0003\u0002h\u0006%\u0018a\u00029bG.\fw-\u001a\u0006\u0004\u0003Gd\u0014\u0002BAw\u0003_\u0014AcQ8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014(\u0002BAt\u0003SDq!a=\u0010\u0001\u0004\t)0A\nd_:\u001cXM\\:vgNcw\u000e\u001e(v[\n,'\u000f\u0005\u0003\u0002V\u0006]\u0018\u0002BA}\u0003_\u00141cQ8og\u0016t7/^:TY>$h*^7cKJDq!!@\u0010\u0001\u0004\ty0A\rnGJ+g\rR1uCJ+GO]5fm\u0006dG+[7f_V$\b\u0003\u0002B\u0001\u0005\u0013i!Aa\u0001\u000b\u00071\u0013)A\u0003\u0002\u0003\b\u0005!\u0011m[6b\u0013\u0011\u0011YAa\u0001\u0003\u000fQKW.Z8vi\"9!qB\bA\u0002\tE\u0011\u0001\u00034pe\u000e,G\r\u0016=\u0011\u000b\tM!1D/\u000f\t\tU!\u0011\u0004\b\u0005\u0003?\u00139\"C\u0001G\u0013\r\t9/R\u0005\u0005\u0005;\u0011yB\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t9/\u0012\u0002\u0010\u0005J\fgn\u00195Q_&tG/\u00138g_N1\u0001c\u0011B\u0013\u0005W\u00012\u0001\u0012B\u0014\u0013\r\u0011I#\u0012\u0002\b!J|G-^2u!\r!%QF\u0005\u0004\u0005_)%\u0001D*fe&\fG.\u001b>bE2,\u0017!\u00042sC:\u001c\u0007\u000eU8j]RLE-\u0006\u0002\u00036A!!q\u0007B \u001d\u0011\u0011ID!\u0010\u000f\t\u0005u%1H\u0005\u0003\u00196K1!a:L\u0013\u0011\u0011\tEa\u0011\u0003\u00155{G-\u001b4jKJLEMC\u0002\u0002h.\u000baB\u0019:b]\u000eD\u0007k\\5oi&#\u0007%\u0001\fsK\u001a,'/\u001a8dK\u0012\u000bG/\u0019+p\u0013:\u001cG.\u001e3f+\t\u0011Y\u0005\u0005\u0004\u0003\u0014\t5#\u0011K\u0005\u0005\u0005\u001f\u0012yBA\u0002TKF\u0004BAa\u0015\u0003\\9!!Q\u000bB-\u001d\u0011\tINa\u0016\n\u0007\u0005=B(\u0003\u0003\u0002h\u00065\u0012\u0002\u0002B/\u0005?\u00121#T1j]\u000eD\u0017-\u001b8IK\u0006$WM\u001d%bg\"TA!a:\u0002.\u00059\"/\u001a4fe\u0016t7-\u001a#bi\u0006$v.\u00138dYV$W\rI\u0001\u0011Q\u0016\fG-\u001a:t)>Len\u00197vI\u0016\f\u0011\u0003[3bI\u0016\u00148\u000fV8J]\u000edW\u000fZ3!)!\u0011IGa\u001b\u0003n\t=\u0004cAA$!!9!\u0011G\fA\u0002\tU\u0002b\u0002B$/\u0001\u0007!1\n\u0005\b\u0005G:\u0002\u0019\u0001B&\u0003\u0011\u0019w\u000e]=\u0015\u0011\t%$Q\u000fB<\u0005sB\u0011B!\r\u0019!\u0003\u0005\rA!\u000e\t\u0013\t\u001d\u0003\u0004%AA\u0002\t-\u0003\"\u0003B21A\u0005\t\u0019\u0001B&\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa +\t\tU\"\u0011Q\u0016\u0003\u0005\u0007\u0003BA!\"\u0003\u00106\u0011!q\u0011\u0006\u0005\u0005\u0013\u0013Y)A\u0005v]\u000eDWmY6fI*\u0019!QR#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0012\n\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BLU\u0011\u0011YE!!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa(\u0011\t\t\u0005&1V\u0007\u0003\u0005GSAA!*\u0003(\u0006!A.\u00198h\u0015\t\u0011I+\u0001\u0003kCZ\f\u0017\u0002\u0002BW\u0005G\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BZ!\r!%QW\u0005\u0004\u0005o+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B_\u0005\u0007\u00042\u0001\u0012B`\u0013\r\u0011\t-\u0012\u0002\u0004\u0003:L\b\"\u0003Bc=\u0005\u0005\t\u0019\u0001BZ\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u001a\t\u0007\u0005\u001b\u0014\u0019N!0\u000e\u0005\t='b\u0001Bi\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU'q\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002x\u00057D\u0011B!2!\u0003\u0003\u0005\rA!0\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa(\u0002\r\u0015\fX/\u00197t)\r9(\u0011\u001e\u0005\n\u0005\u000b\u001c\u0013\u0011!a\u0001\u0005{\u000bqB\u0011:b]\u000eD\u0007k\\5oi&sgm\u001c\t\u0004\u0003\u000f*3#B\u0013\u0003r\n-\u0002\u0003\u0004Bz\u0005s\u0014)Da\u0013\u0003L\t%TB\u0001B{\u0015\r\u001190R\u0001\beVtG/[7f\u0013\u0011\u0011YP!>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003n\u0006)\u0011\r\u001d9msRA!\u0011NB\u0002\u0007\u000b\u00199\u0001C\u0004\u00032!\u0002\rA!\u000e\t\u000f\t\u001d\u0003\u00061\u0001\u0003L!9!1\r\u0015A\u0002\t-\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001b\u0019I\u0002E\u0003E\u0007\u001f\u0019\u0019\"C\u0002\u0004\u0012\u0015\u0013aa\u00149uS>t\u0007#\u0003#\u0004\u0016\tU\"1\nB&\u0013\r\u00199\"\u0012\u0002\u0007)V\u0004H.Z\u001a\t\u0013\rm\u0011&!AA\u0002\t%\u0014a\u0001=%a\u0005\u0019BO]=U_\u001a{'oZ3OKb$(\t\\8dWRQ1\u0011EB\u0015\u0007[\u0019\tda\r\u0015\t\u0005\r71\u0005\u0005\b\u0007KQ\u0003\u0019AB\u0014\u0003!qw\u000eZ3WS\u0016<\bcAA$\u001b!911\u0006\u0016A\u0002\u0005M\u0017\u0001\u00078fqR\u001cuN\\:f]N,8/\u00129pG\"tU/\u001c2fe\"91q\u0006\u0016A\u0002\u0005U\u0018a\u00068fqR\u001cuN\\:f]N,8o\u00157pi:+XNY3s\u0011\u001d\tiP\u000ba\u0001\u0003\u007fDqAa\u0004+\u0001\u0004\u0011\t\"\u0001\nhKR\u001cVm\u0019:fiN\fe\u000e\u001a)s_>4G\u0003CB\u001d\u0007W\u001aiga\u001e\u0011\u000b\u0011\u001byaa\u000f\u0011\u0017\u0011\u001bid!\u0011\u0004H\rM3qL\u0005\u0004\u0007\u007f)%A\u0002+va2,G\u0007E\u0002Y\u0007\u0007J1a!\u0012Z\u0005i1uN]4j]\u001e\u001cF/Y6f\u001b\u0016\u00148\u000e\\3QCRD\u0017J\u001c4p!\u0011\u0019Iea\u0014\u000e\u0005\r-#bAB'y\u000511/Z2sKRLAa!\u0015\u0004L\ty\u0001K]5wCR,7*Z=3kU\n\u0014\b\u0005\u0003\u0004V\rmSBAB,\u0015\r\u0019I\u0006P\u0001\u0006aJ|wNZ\u0005\u0005\u0007;\u001a9F\u0001\u0005We\u001a\u0004&o\\8g!\u0011\u0019\tga\u001a\u000e\u0005\r\r$bAB3y\u0005\u0019aO\u001d4\n\t\r%41\r\u0002\n-J4w*\u001e;qkRDq!a\u001a,\u0001\u0004\ti\u0007C\u0004\u0004p-\u0002\ra!\u001d\u0002\u0015Y\u0014h-T3tg\u0006<W\r\u0005\u0003\u0002V\u000eM\u0014\u0002BB;\u0003_\u0014!B\u0016:g\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019Ih\u000ba\u0001\u0007\u0003\n!DZ8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>\fQc\u00195fG.tU\r\u001f;Fa>\u001c\u0007.\u00118e'2|G\u000f\u0006\u0006\u0004\u0000\r\u001d5\u0011SBK\u00073\u0003R\u0001RB\b\u0007\u0003\u00032aUBB\u0013\r\u0019)I\u000f\u0002\r\r>\u0014x-\u001a$bS2,(/\u001a\u0005\b\u0007\u0013c\u0003\u0019ABF\u0003Q\u0001\u0018M]3oi\ncwnY6US6,7\u000f^1naB\u0019Ai!$\n\u0007\r=UI\u0001\u0003M_:<\u0007bBBJY\u0001\u000711R\u0001\u0019GV\u0014(/\u001a8u)&\u0004(\t\\8dWRKW.Z:uC6\u0004\bbBBLY\u0001\u0007\u00111[\u0001\u0010]\u0016DH/\u00129pG\"tU/\u001c2fe\"911\u0014\u0017A\u0002\u0005U\u0018A\u00048fqR\u001cFn\u001c;Ok6\u0014WM]\u0001\u0013O\u0016$(I]1oG\"\u0004v.\u001b8u\u0013:4w\u000e\u0006\u0003\u0004\"\u000e-\u0006CBBR\u0007O\u0013I'\u0004\u0002\u0004&*\u0011A*R\u0005\u0005\u0007S\u001b)KA\u0002UefDq!!\u0016.\u0001\u0004\tY&A\fhKRl\u0015\r\u001f\"m_\u000e\\wJ^3sQ\u0016\fGmU5{K\u0006yq-\u001a;NCb\u0014En\\2l'&TX-\u0001\u0006g_J<WM\u00117pG.$b#a1\u00046\u000e]61XB`\u0007\u0003\u001c)m!3\u0004N\u000e=7\u0011\u001b\u0005\b\u0007K\u0001\u0004\u0019AB\u0014\u0011\u001d\u0019I\f\ra\u0001\u0007\u0017\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\ru\u0006\u00071\u0001\u0003j\u0005y!M]1oG\"\u0004v.\u001b8u\u0013:4w\u000eC\u0004\u0004zA\u0002\ra!\u0011\t\u000f\r\r\u0007\u00071\u0001\u0004H\u0005\u0019\"\r\\8dWNKwM\u001c)sSZ\fG/Z&fs\"91q\u0019\u0019A\u0002\rM\u0013\u0001\u0003<sMB\u0013xn\u001c4\t\u000f\r-\u0007\u00071\u0001\u0004`\u0005IaO\u001d4PkR\u0004X\u000f\u001e\u0005\b\u0003{\u0004\u0004\u0019AA\u0000\u0011\u001d\u0011y\u0001\ra\u0001\u0005#A\u0001ba51!\u0003\u0005\ra^\u0001\nSN\u0004VM\u001c3j]\u001e\fQCZ8sO\u0016\u0014En\\2lI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0004Z*\u001aqO!!\u0002\u001d\r\u0014X-\u0019;f\u001d\u0016<(\t\\8dWR13q\\Bv\u0007[\u001cyoa=\u0005\n\u0011EAQ\u0004C\u0011\t[!I\u0004b\u000f\u0005H\u0011%C1\nC+\t/\"Y\u0006b\u001a\u0011\r\r\r6qUBqa\u0011\u0019\u0019oa:\u0011\u000f\u0005\u0015\u0011\u0011D/\u0004fB\u0019ala:\u0005\u0017\r%('!A\u0001\u0002\u000b\u0005\u0011\u0011\u0001\u0002\u0004?\u0012\n\u0004bBB\u0013e\u0001\u00071q\u0005\u0005\b\u0007{\u0013\u0004\u0019\u0001B5\u0011\u0019\u0019\tP\ra\u0001o\u0006Q\u0012n],ji\"$'/Y<bY\u0016\u0003xn\u00195MCN$(\t\\8dW\"91Q\u001f\u001aA\u0002\r]\u0018!\u00049be\u0016tGO\u00117pG.LE\r\u0005\u0003\u0004z\u0012\ra\u0002BB~\u0007\u007fl!a!@\u000b\t\u0005%\u0011QP\u0005\u0005\t\u0003\u0019i0A\u0003CY>\u001c7.\u0003\u0003\u0005\u0006\u0011\u001d!a\u0002\"m_\u000e\\\u0017\n\u001a\u0006\u0005\t\u0003\u0019i\u0010C\u0004\u0004:J\u0002\r\u0001b\u0003\u0011\t\reHQB\u0005\u0005\t\u001f!9AA\u0005US6,7\u000f^1na\"9A1\u0003\u001aA\u0002\u0011U\u0011AF7bS:\u001c\u0007.Y5o%\u00164WM]3oG\u0016$\u0015\r^1\u0011\r\tM!Q\nC\f!\u0011\t)\u0001\"\u0007\n\t\u0011m\u0011q\u0001\u0002\u001c\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016$\u0015\r^1\t\u000f\u0011}!\u00071\u0001\u0003\u0012\u0005)2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u001c\bb\u0002C\u0012e\u0001\u0007AQE\u0001\u0011[\u0006Lgn\u00195bS:DU-\u00193feN\u0004bAa\u0005\u0003N\u0011\u001d\u0002\u0003BA\u0003\tSIA\u0001b\u000b\u0002\b\tyQ*Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000fC\u0004\u00050I\u0002\r\u0001\"\r\u0002\r=lW.\u001a:t!\u0019\u0011\u0019B!\u0014\u00054A)\u0011Q\u0001C\u001b{&!AqGA\u0004\u0005\u0015yU.\\3s\u0011\u001d\u0019\u0019M\ra\u0001\u0007\u000fBq\u0001\"\u00103\u0001\u0004!y$\u0001\tg_J<\u0017N\\4Ti\u0006\\W-\u00138g_B!A\u0011\tC\"\u001b\t\tI/\u0003\u0003\u0005F\u0005%(\u0001\u0005$pe\u001eLgnZ*uC.,\u0017J\u001c4p\u0011\u001d\u00199M\ra\u0001\u0007'Bqaa33\u0001\u0004\u0019y\u0006C\u0004\u0005NI\u0002\r\u0001b\u0014\u00025\u0019|'oZ5oON#\u0018m[3J]\u001a|W*\u001a:lY\u0016\u0004\u0016\r\u001e5\u0011\u0007a#\t&C\u0002\u0005Te\u0013!\"T3sW2,\u0007+\u0019;i\u0011\u00151&\u00071\u0001X\u0011\u001d!IF\ra\u0001\u0005g\u000ba\"\u001b8qkR\u0014En\\2l'&TX\rC\u0005\u0005^I\u0002\n\u00111\u0001\u0005`\u0005y1/[4oCR,(/Z(qi&|g\u000eE\u0003E\u0007\u001f!\t\u0007\u0005\u0003\u0004V\u0011\r\u0014\u0002\u0002C3\u0007/\u0012abU5h]\u0006$XO]33kU\n\u0014\b\u0003\u0005\u0004TJ\u0002\n\u00111\u0001x\u0003e\u0019'/Z1uK:+wO\u00117pG.$C-\u001a4bk2$H%M\u001c\u0016\u0005\u00115$\u0006\u0002C0\u0005\u0003\u000b\u0011d\u0019:fCR,g*Z<CY>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00132q\u0005Y\u0002O]3dC2\u001cW\u000f\\1uK\ncwnY6IK\u0006$WM]*ju\u0016$\"Ba-\u0005v\u0011eD1\u0010C?\u0011\u001d!9(\u000ea\u0001\u0005k\t\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0007s+\u0004\u0019ABF\u0011\u001d\u0019I(\u000ea\u0001\u0007\u0003Bqaa26\u0001\u0004\u0019\u0019&\u0001\u0010d_2dWm\u0019;Ue\u0006t7/Y2uS>t7O\u0012:p[6+W\u000eU8pYRq!\u0011\u0003CB\t\u000b#I\t\"$\u0005\u0018\u0012e\u0005bBB\u0013m\u0001\u00071q\u0005\u0005\b\t\u000f3\u0004\u0019\u0001BZ\u0003-\u0011Gn\\2l'&TX-\u00138\t\u000f\u0011-e\u00071\u0001\u0005\u0016\u0005YR.Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006Dq\u0001b$7\u0001\u0004!\t*A\nxSRDGM]1xC2,\u0005o\\2i\u0013:4w\u000eE\u0002Y\t'K1\u0001\"&Z\u0005M9\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p\u0011\u001d\u0019IL\u000ea\u0001\u0007\u0017CqAa\u00047\u0001\u0004\u0011\t\"A\u0007hKR|U.\\3sgNK'0\u001a\u000b\u0005\u0005g#y\nC\u0004\u00050]\u0002\r\u0001\"\r\u0002;\u001d,GOR8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>$b\u0002\"*\u0005(\u0012%F1\u0016CW\t_#\t\f\u0005\u0004\u0003\u0014\t53\u0011\t\u0005\b\u0007WA\u0004\u0019AAj\u0011\u001d\t9\u0007\u000fa\u0001\u0003[Bq!!\u00169\u0001\u0004\tY\u0006C\u0004\u0002za\u0002\r!!\"\t\u000f\ru\u0006\b1\u0001\u0003j!9A1\u0017\u001dA\u0002\r-\u0015A\u00058fqR\u0014En\\2l)&lWm\u001d;b[B\u0004")
public abstract class AbstractForgeMessageBuilder<TX extends Transaction, H extends SidechainBlockHeaderBase, PM extends SidechainBlockBase<TX, H>>
implements SparkzLogging {
    private volatile AbstractForgeMessageBuilder$BranchPointInfo$ BranchPointInfo$module;
    private final MainchainSynchronizer mainchainSynchronizer;
    private final DynamicTypedSerializer<TX, TransactionSerializer<TX>> companion;
    private final NetworkParams params;
    private final boolean allowNoWebsocketConnectionInRegtest;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public AbstractForgeMessageBuilder$BranchPointInfo$ BranchPointInfo() {
        if (this.BranchPointInfo$module == null) {
            this.BranchPointInfo$lzycompute$1();
        }
        return this.BranchPointInfo$module;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool, ForgeResult> buildForgeMessageForEpochAndSlot(int consensusEpochNumber, int consensusSlotNumber, Timeout mcRefDataRetrievalTimeout, Iterable<TX> forcedTx) {
        Function1 & Serializable & scala.Serializable forgingFunctionForEpochAndSlot = (Function1 & Serializable & scala.Serializable)nodeView -> this.tryToForgeNextBlock(consensusEpochNumber, consensusSlotNumber, mcRefDataRetrievalTimeout, forcedTx, (NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool>)nodeView);
        NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView forgeMessage = new NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView((Function1)forgingFunctionForEpochAndSlot);
        return forgeMessage;
    }

    public ForgeResult tryToForgeNextBlock(int nextConsensusEpochNumber, int nextConsensusSlotNumber, Timeout mcRefDataRetrievalTimeout, Iterable<TX> forcedTx, NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool> nodeView) {
        ForgeResult forgeResult;
        Object object = new Object();
        try {
            ForgeResult forgeResult2;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ForgeResult forgeResult;
                BranchPointInfo info;
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("Try to forge block for epoch {} with slot {}", new Object[]{BoxesRunTime.boxToInteger((int)nextConsensusEpochNumber), BoxesRunTime.boxToInteger((int)nextConsensusSlotNumber)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Try<BranchPointInfo> try_ = this.getBranchPointInfo((AbstractHistory)nodeView.history());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        throw new NonLocalReturnControl(object, (Object)new ForgeFailed(ex));
                    }
                    throw new MatchError(try_);
                }
                Success success = (Success)try_;
                BranchPointInfo branchPointInfo = info = (BranchPointInfo)success.value();
                BranchPointInfo branchPointInfo2 = branchPointInfo;
                String parentBlockId = branchPointInfo2.branchPointId();
                SidechainBlockInfo parentBlockInfo = ((AbstractHistory)nodeView.history()).blockInfoById(parentBlockId);
                Option<ForgeFailure> option = this.checkNextEpochAndSlot(parentBlockInfo.timestamp(), ((AbstractHistory)nodeView.history()).bestBlockInfo().timestamp(), nextConsensusEpochNumber, nextConsensusSlotNumber);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ForgeFailure forgeFailure = (ForgeFailure)some.value();
                    throw new NonLocalReturnControl(object, (Object)forgeFailure);
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                long nextBlockTimestamp = TimeToEpochUtils$.MODULE$.getTimeStampForEpochAndSlot(this.params().sidechainGenesisBlockTimestamp(), nextConsensusEpochNumber, nextConsensusSlotNumber);
                FullConsensusEpochInfo consensusInfo = ((ConsensusDataProvider)nodeView.history()).getFullConsensusEpochInfoForBlock(nextBlockTimestamp, parentBlockId);
                long totalStake = consensusInfo.stakeConsensusEpochInfo().totalStake();
                byte[] vrfMessage = io.horizen.consensus.package$.MODULE$.buildVrfMessage(nextConsensusSlotNumber, consensusInfo.nonceConsensusEpochInfo());
                Seq forgingStakeMerklePathInfoSeq = (Seq)this.getForgingStakeMerklePathInfo(nextConsensusEpochNumber, (AbstractWallet)nodeView.vault(), (AbstractHistory)nodeView.history(), (MinimalState)nodeView.state(), branchPointInfo2, nextBlockTimestamp).sortWith((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)AbstractForgeMessageBuilder.$anonfun$tryToForgeNextBlock$2(x$1, x$2)));
                if (forgingStakeMerklePathInfoSeq.isEmpty()) {
                    forgeResult = NoOwnedForgingStake$.MODULE$;
                } else {
                    Seq ownedForgingDataView = (Seq)forgingStakeMerklePathInfoSeq.view().flatMap((Function1 & Serializable & scala.Serializable)forgingStakeMerklePathInfo -> Option$.MODULE$.option2Iterable(this.getSecretsAndProof((AbstractWallet)nodeView.vault(), vrfMessage, (ForgingStakeMerklePathInfo)forgingStakeMerklePathInfo)), SeqView$.MODULE$.canBuildFrom());
                    boolean percentageForkApplied = ForkManager$.MODULE$.getSidechainFork(nextConsensusEpochNumber).stakePercentageForkApplied();
                    double activeSlotCoefficient = ActiveSlotCoefficientFork$.MODULE$.get(nextConsensusEpochNumber).activeSlotCoefficient();
                    Seq eligibleForgingDataView = (Seq)ownedForgingDataView.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractForgeMessageBuilder.$anonfun$tryToForgeNextBlock$4(totalStake, percentageForkApplied, activeSlotCoefficient, x0$1)));
                    Option eligibleForgerOpt = eligibleForgingDataView.headOption();
                    ForgeResult forgingResult = (ForgeResult)eligibleForgerOpt.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple4 tuple4 = x0$2;
                        if (tuple4 == null) {
                            throw new MatchError((Object)tuple4);
                        }
                        ForgingStakeMerklePathInfo forgingStakeMerklePathInfo = (ForgingStakeMerklePathInfo)tuple4._1();
                        PrivateKey25519 privateKey25519 = (PrivateKey25519)tuple4._2();
                        VrfProof vrfProof = (VrfProof)tuple4._3();
                        VrfOutput vrfOutput = (VrfOutput)tuple4._4();
                        ForgeResult forgeResult = this.forgeBlock(nodeView, nextBlockTimestamp, branchPointInfo2, forgingStakeMerklePathInfo, privateKey25519, vrfProof, vrfOutput, mcRefDataRetrievalTimeout, forcedTx, this.forgeBlock$default$10());
                        return forgeResult;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SkipSlot("No eligible forging stake found."));
                    forgeResult = forgingResult;
                }
                return forgeResult;
            });
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                ForgeResult result = (ForgeResult)success.value();
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("Forge result is: {}", new Object[]{result});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                forgeResult2 = result;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(43).append("Failed to forge block for ").append(nextConsensusEpochNumber).append(" epoch ").append(nextConsensusSlotNumber).append(" slot due:").toString(), ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                forgeResult2 = new ForgeFailed(ex);
            } else {
                throw new MatchError((Object)try_);
            }
            forgeResult = forgeResult2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                forgeResult = (ForgeResult)ex.value();
            }
            throw ex;
        }
        return forgeResult;
    }

    public Option<Tuple4<ForgingStakeMerklePathInfo, PrivateKey25519, VrfProof, VrfOutput>> getSecretsAndProof(AbstractWallet wallet, byte[] vrfMessage, ForgingStakeMerklePathInfo forgingStakeMerklePathInfo) {
        return wallet.secret(forgingStakeMerklePathInfo.forgingStakeInfo().blockSignPublicKey()).flatMap((Function1 & Serializable & scala.Serializable)blockSignPrivateKey -> wallet.secret(forgingStakeMerklePathInfo.forgingStakeInfo().vrfPublicKey()).flatMap((Function1 & Serializable & scala.Serializable)vrfSecret -> new Some(vrfSecret.prove(vrfMessage)).map((Function1 & Serializable & scala.Serializable)vrfProofAndHash -> {
            VrfProof vrfProof = (VrfProof)vrfProofAndHash.getKey();
            VrfOutput vrfOutput = (VrfOutput)vrfProofAndHash.getValue();
            return new Tuple4((Object)forgingStakeMerklePathInfo, blockSignPrivateKey, (Object)vrfProof, (Object)vrfOutput);
        })));
    }

    public Option<ForgeFailure> checkNextEpochAndSlot(long parentBlockTimestamp, long currentTipBlockTimestamp, int nextEpochNumber, int nextSlotNumber) {
        ConsensusEpochAndSlot parentBlockEpochAndSlot = TimeToEpochUtils$.MODULE$.timestampToEpochAndSlot(this.params().sidechainGenesisBlockTimestamp(), parentBlockTimestamp);
        ConsensusEpochAndSlot currentTipBlockEpochAndSlot = TimeToEpochUtils$.MODULE$.timestampToEpochAndSlot(this.params().sidechainGenesisBlockTimestamp(), currentTipBlockTimestamp);
        ConsensusEpochAndSlot nextBlockEpochAndSlot = new ConsensusEpochAndSlot(nextEpochNumber, nextSlotNumber);
        if (nextEpochNumber - currentTipBlockEpochAndSlot.epochNumber() > 1) {
            return new Some((Object)new SkipSlot(new StringBuilder(103).append("Chain tip with epoch ").append(currentTipBlockEpochAndSlot.epochNumber()).append(" is too far in past: next block epoch=").append(nextBlockEpochAndSlot.epochNumber()).append("/slot=").append(nextBlockEpochAndSlot.slotNumber()).append(" (it is OK if we are syncing the node)").toString()));
        }
        if (parentBlockEpochAndSlot.$greater(nextBlockEpochAndSlot)) {
            return new Some((Object)new ForgeFailed(new IllegalArgumentException(new StringBuilder(104).append("Try to forge block with incorrect epochAndSlot ").append(nextBlockEpochAndSlot).append(" which are equal or less than parent block epochAndSlot: ").append(parentBlockEpochAndSlot).toString())));
        }
        ConsensusEpochAndSlot consensusEpochAndSlot = parentBlockEpochAndSlot;
        ConsensusEpochAndSlot consensusEpochAndSlot2 = nextBlockEpochAndSlot;
        if (!(consensusEpochAndSlot != null ? !((Object)consensusEpochAndSlot).equals(consensusEpochAndSlot2) : consensusEpochAndSlot2 != null)) {
            return new Some((Object)new SkipSlot(new StringBuilder(43).append("Chain tip with ").append(nextBlockEpochAndSlot).append(" has been generated already.").toString()));
        }
        if (nextEpochNumber - parentBlockEpochAndSlot.epochNumber() > 1) {
            return new Some((Object)new ForgeFailed(new IllegalArgumentException(new StringBuilder(102).append("Forging is not possible, because of whole consensus epoch is missed: current epoch = ").append(nextEpochNumber).append(", parent epoch = ").append(parentBlockEpochAndSlot.epochNumber()).toString())));
        }
        if (currentTipBlockEpochAndSlot.$greater$eq(nextBlockEpochAndSlot)) {
            return new Some((Object)new ForgeFailed(new IllegalArgumentException(new StringBuilder(102).append("Try to forge block with incorrect epochAndSlot ").append(nextBlockEpochAndSlot).append(" which are equal or less than last ommer epochAndSlot: ").append(currentTipBlockEpochAndSlot).toString())));
        }
        return None$.MODULE$;
    }

    public Try<BranchPointInfo> getBranchPointInfo(AbstractHistory history) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BranchPointInfo branchPointInfo;
            int n;
            Seq newHeaderHashes;
            ByteArrayWrapper bestMainchainCommonPointHash;
            MainchainHeaderInfo bestMainchainHeaderInfo;
            block13: {
                Tuple3 tuple3;
                block12: {
                    Tuple3 tuple32;
                    Success success;
                    Tuple2 tuple2;
                    bestMainchainHeaderInfo = (MainchainHeaderInfo)history.getBestMainchainHeaderInfo().get();
                    Try<Tuple2<Object, Seq<ByteArrayWrapper>>> try_ = $this.mainchainSynchronizer.getMainchainDivergentSuffix(history, MainchainSynchronizer$.MODULE$.MAX_BLOCKS_REQUEST());
                    if (try_ instanceof Success && (tuple2 = (Tuple2)(success = (Success)try_).value()) != null) {
                        int height = tuple2._1$mcI$sp();
                        Seq hashes = (Seq)tuple2._2();
                        tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)height), hashes.head(), hashes.tail());
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        if (!(this.params() instanceof RegTestParams) || !$this.allowNoWebsocketConnectionInRegtest) {
                            throw ex;
                        }
                        tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestMainchainHeaderInfo.height()), (Object)bestMainchainHeaderInfo.hash(), (Object)Nil$.MODULE$);
                    } else {
                        throw new MatchError(try_);
                    }
                    tuple3 = tuple32;
                    if (tuple3 == null) break block12;
                    int bestMainchainCommonPointHeight = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    bestMainchainCommonPointHash = (ByteArrayWrapper)tuple3._2();
                    newHeaderHashes = (Seq)tuple3._3();
                    n = bestMainchainCommonPointHeight;
                    Option option = ClassTag$.MODULE$.apply(ByteArrayWrapper.class).unapply((Object)bestMainchainCommonPointHash);
                    if (!option.isEmpty() && option.get() != null && newHeaderHashes != null) break block13;
                }
                throw new MatchError((Object)tuple3);
            }
            Seq seq = newHeaderHashes;
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)bestMainchainCommonPointHash, (Object)seq);
            Tuple3 tuple33 = tuple3;
            int bestMainchainCommonPointHeight = BoxesRunTime.unboxToInt((Object)tuple33._1());
            ByteArrayWrapper bestMainchainCommonPointHash2 = (ByteArrayWrapper)tuple33._2();
            Seq newHeaderHashes2 = (Seq)tuple33._3();
            newHeaderHashes2 = newHeaderHashes2.nonEmpty() && newHeaderHashes2.size() > this.params().mcBlockRefDelay() ? (Seq)newHeaderHashes2.take(newHeaderHashes2.size() - this.params().mcBlockRefDelay()) : (Seq)Nil$.MODULE$;
            ByteArrayWrapper byteArrayWrapper = bestMainchainCommonPointHash2;
            ByteArrayWrapper byteArrayWrapper2 = bestMainchainHeaderInfo.hash();
            if (!(byteArrayWrapper != null ? !((Object)byteArrayWrapper).equals(byteArrayWrapper2) : byteArrayWrapper2 != null)) {
                String branchPointId = history.bestBlockId();
                int withdrawalEpochMcBlocksLeft = this.params().withdrawalEpochLength() - history.bestBlockInfo().withdrawalEpochInfo().lastEpochIndex();
                if (withdrawalEpochMcBlocksLeft == 0) {
                    withdrawalEpochMcBlocksLeft = this.params().withdrawalEpochLength();
                }
                Seq<ByteArrayWrapper> missedMainchainReferenceDataHeaderHashes = history.missedMainchainReferenceDataHeaderHashes();
                Seq nextMainchainReferenceDataHeaderHashes = (Seq)missedMainchainReferenceDataHeaderHashes.$plus$plus((GenTraversableOnce)newHeaderHashes2, Seq$.MODULE$.canBuildFrom());
                int maxReferenceDataNumber = Math.min(withdrawalEpochMcBlocksLeft, nextMainchainReferenceDataHeaderHashes.size());
                Seq mainchainReferenceDataHeaderHashesToInclude = (Seq)nextMainchainReferenceDataHeaderHashes.take(maxReferenceDataNumber);
                Seq mainchainHeadersHashesToInclude = newHeaderHashes2;
                branchPointInfo = new BranchPointInfo(this, branchPointId, (Seq<ByteArrayWrapper>)mainchainReferenceDataHeaderHashesToInclude, (Seq<ByteArrayWrapper>)mainchainHeadersHashesToInclude);
            } else {
                int newMainchainHeadersNumber;
                int orphanedMainchainHeadersNumber = bestMainchainHeaderInfo.height() - bestMainchainCommonPointHeight;
                if (orphanedMainchainHeadersNumber >= (newMainchainHeadersNumber = newHeaderHashes2.size())) {
                    throw new Exception("No sense to forge: active branch contains orphaned MainchainHeaders, that number is greater or equal to actual new MainchainHeaders.");
                }
                int firstOrphanedHashHeight = bestMainchainCommonPointHeight + 1;
                MainchainHeaderInfo firstOrphanedMainchainHeaderInfo = (MainchainHeaderInfo)history.getMainchainHeaderInfoByHeight(firstOrphanedHashHeight).get();
                String orphanedSidechainBlockId = firstOrphanedMainchainHeaderInfo.sidechainBlockId();
                SidechainBlockInfo orphanedSidechainBlockInfo = history.blockInfoById(orphanedSidechainBlockId);
                branchPointInfo = firstOrphanedMainchainHeaderInfo.hash().equals(orphanedSidechainBlockInfo.mainchainHeaderHashes().head()) ? new BranchPointInfo(this, orphanedSidechainBlockInfo.parentId(), (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$), (Seq<ByteArrayWrapper>)newHeaderHashes2) : new BranchPointInfo(this, orphanedSidechainBlockInfo.parentId(), (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$), (Seq<ByteArrayWrapper>)((Seq)((TraversableLike)orphanedSidechainBlockInfo.mainchainHeaderHashes().takeWhile((Function1 & Serializable & scala.Serializable)hash -> BoxesRunTime.boxToBoolean((boolean)AbstractForgeMessageBuilder.$anonfun$getBranchPointInfo$2(firstOrphanedMainchainHeaderInfo, hash)))).$plus$plus((GenTraversableOnce)newHeaderHashes2, Seq$.MODULE$.canBuildFrom())));
            }
            return branchPointInfo;
        });
    }

    public abstract int getMaxBlockOverheadSize();

    public abstract int getMaxBlockSize();

    public ForgeResult forgeBlock(NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool> nodeView, long timestamp, BranchPointInfo branchPointInfo, ForgingStakeMerklePathInfo forgingStakeMerklePathInfo, PrivateKey25519 blockSignPrivateKey, VrfProof vrfProof, VrfOutput vrfOutput, Timeout mcRefDataRetrievalTimeout, Iterable<TX> forcedTx, boolean isPending) {
        ForgeSuccess<SidechainBlockBase> forgeSuccess;
        Object object = new Object();
        try {
            Product product;
            Try<SidechainBlockBase<TX, SidechainBlockHeaderBase>> tryBlock;
            BoxedUnit boxedUnit;
            Iterable<TX> transactions;
            Object object2;
            boolean isWithdrawalEpochLastBlock;
            Seq headers;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Start forging the next block...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String parentBlockId = branchPointInfo.branchPointId();
            SidechainBlockInfo parentBlockInfo = ((AbstractHistory)nodeView.history()).blockInfoById(parentBlockId);
            int withdrawalEpochMcBlocksLeft = this.params().withdrawalEpochLength() - parentBlockInfo.withdrawalEpochInfo().lastEpochIndex();
            if (withdrawalEpochMcBlocksLeft == 0) {
                withdrawalEpochMcBlocksLeft = this.params().withdrawalEpochLength();
            }
            IntRef blockSize = IntRef.create((int)this.precalculateBlockHeaderSize(parentBlockId, timestamp, forgingStakeMerklePathInfo, vrfProof));
            blockSize.elem += 8;
            Seq<ByteArrayWrapper> mainchainHeaderHashesToRetrieve = branchPointInfo.headersToInclude();
            Try<Seq<MainchainHeader>> try_ = this.mainchainSynchronizer.getMainchainBlockHeaders(mainchainHeaderHashesToRetrieve);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    return new ForgeFailed(ex);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Seq seq = headers = (Seq)success.value();
            Seq mainchainHeaders = seq;
            ListSerializer<MainchainHeader> mcHeadersSerializer = new ListSerializer<MainchainHeader>(MainchainHeaderSerializer$.MODULE$);
            blockSize.elem += mcHeadersSerializer.toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(mainchainHeaders).asJava()).length;
            Seq ommers = (Seq)Nil$.MODULE$;
            String blockId = ((AbstractHistory)nodeView.history()).bestBlockId();
            while (true) {
                String string = blockId;
                String string2 = parentBlockId;
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
                SidechainBlockBase block = (SidechainBlockBase)((AbstractHistory)nodeView.history()).getBlockById(blockId).get();
                blockId = block.parentId();
                Ommer ommer = Ommer$.MODULE$.toOmmer(block);
                ommers = (Seq)ommers.$plus$colon(ommer, Seq$.MODULE$.canBuildFrom());
            }
            blockSize.elem += this.getOmmersSize(ommers);
            Seq<ByteArrayWrapper> mainchainBlockReferenceDataToRetrieve = branchPointInfo.referenceDataToInclude();
            ArrayBuffer mainchainReferenceData = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            long startTime = System.currentTimeMillis();
            mainchainBlockReferenceDataToRetrieve.takeWhile((Function1 & Serializable & scala.Serializable)hash -> BoxesRunTime.boxToBoolean((boolean)AbstractForgeMessageBuilder.$anonfun$forgeBlock$1(this, blockSize, mainchainReferenceData, startTime, mcRefDataRetrievalTimeout, object, hash)));
            int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), timestamp);
            if (((AbstractHistory)nodeView.history()).tooManyBlocksWithoutMcHeaders(branchPointInfo.branchPointId(), mainchainHeaders.isEmpty(), consensusEpochNumber)) {
                return new SkipSlot("We can not forge until we have at least a mc block reference included, skipping this slot...");
            }
            boolean bl = isWithdrawalEpochLastBlock = mainchainReferenceData.size() == withdrawalEpochMcBlocksLeft;
            if (isWithdrawalEpochLastBlock) {
                object2 = (Iterable<TX>)package$.MODULE$.Iterable().empty();
            } else {
                String string = parentBlockId;
                String string3 = ((AbstractHistory)nodeView.history()).bestBlockId();
                object2 = (string == null ? string3 != null : !string.equals(string3)) ? (Iterable)package$.MODULE$.Iterable().empty() : (transactions = this.collectTransactionsFromMemPool(nodeView, blockSize.elem, (Seq<MainchainBlockReferenceData>)mainchainReferenceData, parentBlockInfo.withdrawalEpochInfo(), timestamp, forcedTx));
            }
            if (this.log().underlying().isTraceEnabled()) {
                this.log().underlying().trace("Transactions to apply {}", new Object[]{transactions});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool> x$1 = nodeView;
            BranchPointInfo x$2 = branchPointInfo;
            boolean x$3 = isWithdrawalEpochLastBlock;
            String x$4 = parentBlockId;
            long x$5 = timestamp;
            ArrayBuffer x$6 = mainchainReferenceData;
            Iterable<TX> x$7 = transactions;
            Seq x$8 = mainchainHeaders;
            Seq x$9 = ommers;
            PrivateKey25519 x$10 = blockSignPrivateKey;
            ForgingStakeInfo x$11 = forgingStakeMerklePathInfo.forgingStakeInfo();
            VrfProof x$12 = vrfProof;
            VrfOutput x$13 = vrfOutput;
            MerklePath x$14 = forgingStakeMerklePathInfo.merklePath();
            DynamicTypedSerializer<TX, TransactionSerializer<TX>> x$15 = this.companion;
            int x$16 = blockSize.elem;
            boolean x$17 = isPending;
            Option<Signature25519> x$18 = this.createNewBlock$default$17();
            Try<SidechainBlockBase<TX, SidechainBlockHeaderBase>> try_2 = tryBlock = this.createNewBlock(x$1, x$2, x$3, x$4, x$5, (Seq<MainchainBlockReferenceData>)x$6, x$7, (Seq<MainchainHeader>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$18, x$17);
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                SidechainBlockBase block = (SidechainBlockBase)success2.value();
                product = new ForgeSuccess<SidechainBlockBase>(block);
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable exception = failure.exception();
                product = new ForgeFailed(exception);
            } else {
                throw new MatchError(try_2);
            }
            forgeSuccess = product;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                forgeSuccess = (ForgeSuccess<SidechainBlockBase>)ex.value();
            }
            throw ex;
        }
        return forgeSuccess;
    }

    public boolean forgeBlock$default$10() {
        return false;
    }

    public abstract Try<SidechainBlockBase<TX, ? extends SidechainBlockHeaderBase>> createNewBlock(NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool> var1, BranchPointInfo var2, boolean var3, String var4, long var5, Seq<MainchainBlockReferenceData> var7, Iterable<TX> var8, Seq<MainchainHeader> var9, Seq<Ommer<H>> var10, PrivateKey25519 var11, ForgingStakeInfo var12, VrfProof var13, VrfOutput var14, MerklePath var15, DynamicTypedSerializer<TX, TransactionSerializer<TX>> var16, int var17, Option<Signature25519> var18, boolean var19);

    public Option<Signature25519> createNewBlock$default$17() {
        return None$.MODULE$;
    }

    public boolean createNewBlock$default$18() {
        return false;
    }

    public abstract int precalculateBlockHeaderSize(String var1, long var2, ForgingStakeMerklePathInfo var4, VrfProof var5);

    public abstract Iterable<TX> collectTransactionsFromMemPool(NodeViewHolder.CurrentView<AbstractHistory, MinimalState, AbstractWallet, MemoryPool> var1, int var2, Seq<MainchainBlockReferenceData> var3, WithdrawalEpochInfo var4, long var5, Iterable<TX> var7);

    public abstract int getOmmersSize(Seq<Ommer<H>> var1);

    public abstract Seq<ForgingStakeMerklePathInfo> getForgingStakeMerklePathInfo(int var1, AbstractWallet var2, AbstractHistory var3, MinimalState var4, BranchPointInfo var5, long var6);

    private final void BranchPointInfo$lzycompute$1() {
        AbstractForgeMessageBuilder abstractForgeMessageBuilder = this;
        synchronized (abstractForgeMessageBuilder) {
            if (this.BranchPointInfo$module == null) {
                this.BranchPointInfo$module = new AbstractForgeMessageBuilder$BranchPointInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$tryToForgeNextBlock$2(ForgingStakeMerklePathInfo x$1, ForgingStakeMerklePathInfo x$2) {
        return x$1.forgingStakeInfo().stakeAmount() > x$2.forgingStakeInfo().stakeAmount();
    }

    public static final /* synthetic */ boolean $anonfun$tryToForgeNextBlock$4(long totalStake$1, boolean percentageForkApplied$1, double activeSlotCoefficient$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        ForgingStakeMerklePathInfo forgingStakeMerklePathInfo = (ForgingStakeMerklePathInfo)tuple4._1();
        VrfOutput vrfOutput = (VrfOutput)tuple4._4();
        boolean bl = io.horizen.consensus.package$.MODULE$.vrfProofCheckAgainstStake(vrfOutput, forgingStakeMerklePathInfo.forgingStakeInfo().stakeAmount(), totalStake$1, percentageForkApplied$1, activeSlotCoefficient$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getBranchPointInfo$2(MainchainHeaderInfo firstOrphanedMainchainHeaderInfo$1, ByteArrayWrapper hash) {
        return !hash.equals(firstOrphanedMainchainHeaderInfo$1.hash());
    }

    public static final /* synthetic */ boolean $anonfun$forgeBlock$1(AbstractForgeMessageBuilder $this, IntRef blockSize$1, ArrayBuffer mainchainReferenceData$1, long startTime$1, Timeout mcRefDataRetrievalTimeout$3, Object nonLocalReturnKey2$1, ByteArrayWrapper hash) {
        boolean bl;
        Try<MainchainBlockReference> try_ = $this.mainchainSynchronizer.getMainchainBlockReference(hash);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            MainchainBlockReference ref = (MainchainBlockReference)success.value();
            int refDataSize = ref.data().bytes().length + 4;
            if (blockSize$1.elem + refDataSize > $this.getMaxBlockOverheadSize()) {
                BoxedUnit boxedUnit;
                if ($this.log().underlying().isInfoEnabled()) {
                    $this.log().underlying().info("Block size would exceed limit, stopping mc ref data collection. Block size {}, Data collected so far: {}, refData skipped size: {}", new Object[]{BoxesRunTime.boxToInteger((int)blockSize$1.elem), BoxesRunTime.boxToInteger((int)mainchainReferenceData$1.length()), BoxesRunTime.boxToInteger((int)refDataSize)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            } else {
                mainchainReferenceData$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MainchainBlockReferenceData[]{ref.data()}));
                blockSize$1.elem += refDataSize;
                boolean isTimeout = System.currentTimeMillis() - startTime$1 >= mcRefDataRetrievalTimeout$3.duration().toMillis();
                bl = !isTimeout;
            }
        } else {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new ForgeFailed(ex));
            }
            throw new MatchError(try_);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public AbstractForgeMessageBuilder(MainchainSynchronizer mainchainSynchronizer, DynamicTypedSerializer<TX, TransactionSerializer<TX>> companion, NetworkParams params, boolean allowNoWebsocketConnectionInRegtest) {
        this.mainchainSynchronizer = mainchainSynchronizer;
        this.companion = companion;
        this.params = params;
        this.allowNoWebsocketConnectionInRegtest = allowNoWebsocketConnectionInRegtest;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }

    public class BranchPointInfo
    implements Product,
    scala.Serializable {
        private final String branchPointId;
        private final Seq<ByteArrayWrapper> referenceDataToInclude;
        private final Seq<ByteArrayWrapper> headersToInclude;
        public final /* synthetic */ AbstractForgeMessageBuilder $outer;

        public String branchPointId() {
            return this.branchPointId;
        }

        public Seq<ByteArrayWrapper> referenceDataToInclude() {
            return this.referenceDataToInclude;
        }

        public Seq<ByteArrayWrapper> headersToInclude() {
            return this.headersToInclude;
        }

        public BranchPointInfo copy(String branchPointId, Seq<ByteArrayWrapper> referenceDataToInclude, Seq<ByteArrayWrapper> headersToInclude) {
            return new BranchPointInfo(this.io$horizen$forge$AbstractForgeMessageBuilder$BranchPointInfo$$$outer(), branchPointId, referenceDataToInclude, headersToInclude);
        }

        public String copy$default$1() {
            return this.branchPointId();
        }

        public Seq<ByteArrayWrapper> copy$default$2() {
            return this.referenceDataToInclude();
        }

        public Seq<ByteArrayWrapper> copy$default$3() {
            return this.headersToInclude();
        }

        public String productPrefix() {
            return "BranchPointInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<ByteArrayWrapper> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.branchPointId();
                    break;
                }
                case 1: {
                    seq = this.referenceDataToInclude();
                    break;
                }
                case 2: {
                    seq = this.headersToInclude();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BranchPointInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BranchPointInfo)) return false;
            if (((BranchPointInfo)object).io$horizen$forge$AbstractForgeMessageBuilder$BranchPointInfo$$$outer() != this.io$horizen$forge$AbstractForgeMessageBuilder$BranchPointInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BranchPointInfo branchPointInfo = (BranchPointInfo)x$1;
            String string = this.branchPointId();
            String string2 = branchPointInfo.branchPointId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<ByteArrayWrapper> seq = this.referenceDataToInclude();
            Seq<ByteArrayWrapper> seq2 = branchPointInfo.referenceDataToInclude();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<ByteArrayWrapper> seq3 = this.headersToInclude();
            Seq<ByteArrayWrapper> seq4 = branchPointInfo.headersToInclude();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!branchPointInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AbstractForgeMessageBuilder io$horizen$forge$AbstractForgeMessageBuilder$BranchPointInfo$$$outer() {
            return this.$outer;
        }

        public BranchPointInfo(AbstractForgeMessageBuilder $outer, String branchPointId, Seq<ByteArrayWrapper> referenceDataToInclude, Seq<ByteArrayWrapper> headersToInclude) {
            this.branchPointId = branchPointId;
            this.referenceDataToInclude = referenceDataToInclude;
            this.headersToInclude = headersToInclude;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

