/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.RlpStreamEncoder;
import java.math.BigInteger;
import java.util.ArrayList;
import org.bouncycastle.util.BigIntegers;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import scala.Array;
import sparkz.util.serialization.Writer;

public class EthereumTransactionEncoder {
    private EthereumTransactionEncoder() {
    }

    private static RlpList LegacyTransaction2RlpList(EthereumTransaction tx, boolean accountSignature) {
        ArrayList<RlpString> result = new ArrayList<RlpString>();
        result.add(RlpString.create((BigInteger)tx.getNonce()));
        result.add(RlpString.create((BigInteger)tx.getGasPrice()));
        result.add(RlpString.create((BigInteger)tx.getGasLimit()));
        result.add(RlpString.create((byte[])tx.getTo().map(AddressProposition::pubKeyBytes).orElse(Array.emptyByteArray())));
        result.add(RlpString.create((BigInteger)tx.getValue()));
        result.add(RlpString.create((byte[])tx.getData()));
        if (accountSignature) {
            BigInteger v = BigInteger.ZERO;
            BigInteger r = BigInteger.ZERO;
            BigInteger s = BigInteger.ZERO;
            if (tx.isSigned()) {
                SignatureSecp256k1 txSignature = tx.getSignature();
                v = txSignature.getV();
                r = txSignature.getR();
                s = txSignature.getS();
                if (tx.isEIP155()) {
                    v = EthereumTransactionEncoder.createEip155v(v, tx.getChainId());
                }
            } else if (tx.isEIP155()) {
                v = BigInteger.valueOf(tx.getChainId());
            }
            result.add(RlpString.create((BigInteger)v));
            result.add(RlpString.create((BigInteger)r));
            result.add(RlpString.create((BigInteger)s));
        } else if (tx.isEIP155()) {
            result.add(RlpString.create((BigInteger)BigInteger.valueOf(tx.getChainId())));
            result.add(RlpString.create((BigInteger)BigInteger.ZERO));
            result.add(RlpString.create((BigInteger)BigInteger.ZERO));
        }
        return new RlpList(result);
    }

    private static RlpList EIP1559Transaction2RlpList(EthereumTransaction tx, boolean accountSignature) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(RlpString.create((long)tx.getChainId()));
        result.add(RlpString.create((BigInteger)tx.getNonce()));
        result.add(RlpString.create((BigInteger)tx.getMaxPriorityFeePerGas()));
        result.add(RlpString.create((BigInteger)tx.getMaxFeePerGas()));
        result.add(RlpString.create((BigInteger)tx.getGasLimit()));
        result.add(RlpString.create((byte[])tx.getTo().map(AddressProposition::pubKeyBytes).orElse(Array.emptyByteArray())));
        result.add(RlpString.create((BigInteger)tx.getValue()));
        result.add(RlpString.create((byte[])tx.getData()));
        result.add(new RlpList(new RlpType[0]));
        if (accountSignature) {
            BigInteger r = BigInteger.ZERO;
            BigInteger s = BigInteger.ZERO;
            if (tx.isSigned()) {
                SignatureSecp256k1 txSignature = tx.getSignature();
                r = txSignature.getR();
                s = txSignature.getS();
                result.add(RlpString.create((long)EthereumTransactionEncoder.getRecId(txSignature.getV(), tx.getChainId())));
            } else {
                result.add(RlpString.create((long)tx.getChainId()));
            }
            result.add(RlpString.create((BigInteger)r));
            result.add(RlpString.create((BigInteger)s));
        }
        return new RlpList(result);
    }

    public static void encodeAsRlpValues(EthereumTransaction tx, boolean accountSignature, Writer writer) {
        if (tx.isEIP1559()) {
            EthereumTransactionEncoder.encodeEip1559AsRlpValues(tx, accountSignature, writer);
        } else {
            EthereumTransactionEncoder.encodeLegacyAsRlpValues(tx, accountSignature, writer);
        }
    }

    private static void encodeLegacyAsRlpValues(EthereumTransaction tx, boolean accountSignature, Writer writer) {
        RlpList rlpList = EthereumTransactionEncoder.LegacyTransaction2RlpList(tx, accountSignature);
        RlpStreamEncoder.encode((RlpType)rlpList, writer);
    }

    private static void encodeEip1559AsRlpValues(EthereumTransaction tx, boolean accountSignature, Writer writer) {
        writer.putUByte((int)tx.version());
        RlpList rlpList = EthereumTransactionEncoder.EIP1559Transaction2RlpList(tx, accountSignature);
        RlpStreamEncoder.encode((RlpType)rlpList, writer);
    }

    private static BigInteger createEip155v(BigInteger v, long chainId) {
        v = v.subtract(BigInteger.valueOf(27L));
        v = v.add(BigInteger.valueOf(chainId).multiply(BigIntegers.TWO));
        v = v.add(BigInteger.valueOf(35L));
        return v;
    }

    private static int getRecId(BigInteger v, long chainId) {
        BigInteger lowerRealV = BigInteger.valueOf(27L);
        BigInteger lowerRealVPlus1 = lowerRealV.add(BigInteger.ONE);
        BigInteger lowerRealVReplayProtected = BigInteger.valueOf(35L);
        BigInteger chainIdInc = BigInteger.valueOf(35L);
        if (!v.equals(lowerRealV) && !v.equals(lowerRealVPlus1)) {
            if (v.compareTo(lowerRealVReplayProtected) >= 0) {
                return v.subtract(BigInteger.valueOf(chainId).multiply(BigIntegers.TWO)).subtract(chainIdInc).intValue();
            }
            throw new IllegalArgumentException(String.format("Unsupported v parameter: %s", v));
        }
        return v.subtract(lowerRealV).intValue();
    }
}

