/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.fork.Version1_3_0Fork$;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.FeeCapTooLowException;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.InsufficientFundsException;
import io.horizen.account.state.IntrinsicGasException;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.Invocation$;
import io.horizen.account.state.MaxInitCodeSizeExceededException;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceMaxException;
import io.horizen.account.state.NonceTooHighException;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.ProtocolParams$;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.WriteProtectionException;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.evm.Address;
import io.horizen.evm.EvmContext;
import io.horizen.evm.ForkRules;
import io.horizen.evm.Tracer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\f\u0018\u0001\u0001B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001M\u0011!\u0001\u0006A!A!\u0002\u0013i\u0005\u0002C)\u0001\u0005\u000b\u0007I\u0011\u0001*\t\u0011Y\u0003!\u0011!Q\u0001\nMCQa\u0016\u0001\u0005\u0002aCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004m\u0001\u0001\u0006I!\u0019\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019A\b\u0001)A\u0005_\"9\u0011\u0010\u0001a\u0001\n\u0003Q\bb\u0002@\u0001\u0001\u0004%\ta \u0005\b\u0003\u0017\u0001\u0001\u0015)\u0003|\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA.\u0001\u0011%\u0011Q\f\u0002\u0010'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]*\u0011\u0001$G\u0001\u0006gR\fG/\u001a\u0006\u00035m\tq!Y2d_VtGO\u0003\u0002\u001d;\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u0010\u0002\u0005%|7\u0001A\n\u0005\u0001\u0005:s\u0006\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA!\u001e;jY*\tA&\u0001\u0004ta\u0006\u00148N_\u0005\u0003]%\u0012Qb\u00159be.THj\\4hS:<\u0007C\u0001\u00192\u001b\u00059\u0012B\u0001\u001a\u0018\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0003wS\u0016<\bC\u0001\u00196\u0013\t1tCA\fTi\u0006$X\r\u00122BG\u000e|WO\u001c;Ti\u0006$XMV5fo\u0006\tR.Z:tC\u001e,\u0007K]8dKN\u001cxN]:\u0011\u0007e\nEI\u0004\u0002;\u007f9\u00111HP\u0007\u0002y)\u0011QhH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!\u0001Q\u0012\u0002\u000fA\f7m[1hK&\u0011!i\u0011\u0002\u0004'\u0016\f(B\u0001!$!\t\u0001T)\u0003\u0002G/\t\u0001R*Z:tC\u001e,\u0007K]8dKN\u001cxN]\u0001\rE2|7m[$bgB{w\u000e\u001c\t\u0003a%K!AS\f\u0003\u000f\u001d\u000b7\u000fU8pY\u0006a!\r\\8dW\u000e{g\u000e^3yiV\tQ\n\u0005\u00021\u001d&\u0011qj\u0006\u0002\r\u00052|7m[\"p]R,\u0007\u0010^\u0001\u000eE2|7m[\"p]R,\u0007\u0010\u001e\u0011\u0002\u00075\u001cx-F\u0001T!\t\u0001D+\u0003\u0002V/\t9Q*Z:tC\u001e,\u0017\u0001B7tO\u0002\na\u0001P5oSRtDCB-[7rkf\f\u0005\u00021\u0001!)1\u0007\u0003a\u0001i!)q\u0007\u0003a\u0001q!)q\t\u0003a\u0001\u0011\")1\n\u0003a\u0001\u001b\")\u0011\u000b\u0003a\u0001'\u0006y\u0011N\u001c<pG\u0006$\u0018n\u001c8Ti\u0006\u001c7.F\u0001b!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\b[V$\u0018M\u00197f\u0015\t17%\u0001\u0006d_2dWm\u0019;j_:L!\u0001[2\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u00021U&\u00111n\u0006\u0002\u000b\u0013:4xnY1uS>t\u0017\u0001E5om>\u001c\u0017\r^5p]N#\u0018mY6!\u0003\u0019!(/Y2feV\tq\u000eE\u0002#aJL!!]\u0012\u0003\r=\u0003H/[8o!\t\u0019h/D\u0001u\u0015\t)8$A\u0002fm6L!a\u001e;\u0003\rQ\u0013\u0018mY3s\u0003\u001d!(/Y2fe\u0002\nQ\u0001Z3qi\",\u0012a\u001f\t\u0003EqL!!`\u0012\u0003\u0007%sG/A\u0005eKB$\bn\u0018\u0013fcR!\u0011\u0011AA\u0004!\r\u0011\u00131A\u0005\u0004\u0003\u000b\u0019#\u0001B+oSRD\u0001\"!\u0003\u000f\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0014A\u00023faRD\u0007%\u0001\u0006ue\u0006t7/\u001b;j_:$\"!!\u0005\u0011\u000b\t\n\u0019\"a\u0006\n\u0007\u0005U1EA\u0003BeJ\f\u0017\u0010E\u0002#\u00033I1!a\u0007$\u0005\u0011\u0011\u0015\u0010^3)\u000bA\ty\"a\u000b\u0011\u000b\t\n\t#!\n\n\u0007\u0005\r2E\u0001\u0004uQJ|wo\u001d\t\u0004a\u0005\u001d\u0012bAA\u0015/\tAR\t_3dkRLwN\u001c$bS2,G-\u0012=dKB$\u0018n\u001c8$\u0005\u0005\u0015\u0002&\u0002\t\u00020\u0005]\u0002#\u0002\u0012\u0002\"\u0005E\u0002c\u0001\u0019\u00024%\u0019\u0011QG\f\u0003/%sg/\u00197jI6+7o]1hK\u0016C8-\u001a9uS>t7EAA\u0019\u0003!\u0001(/Z\"iK\u000e\\G\u0003BA\u0001\u0003{AQ!U\tA\u0002M\u000baAY;z\u000f\u0006\u001cHc\u0001%\u0002D!)\u0011K\u0005a\u0001'\u0006I!/\u001a4v]\u0012<\u0015m\u001d\u000b\u0007\u0003\u0003\tI%a\u0013\t\u000bE\u001b\u0002\u0019A*\t\r\u000553\u00031\u0001I\u0003\r9\u0017m]\u0001\bKb,7-\u001e;f)\u0011\t\t\"a\u0015\t\r\u0005UC\u00031\u0001j\u0003)IgN^8dCRLwN\u001c\u0015\u0006)\u0005}\u00111\u0006\u0015\u0006)\u0005=\u0012qG\u0001\u0007S:4xn[3\u0015\r\u0005E\u0011qLA2\u0011\u0019\t\t'\u0006a\u0001\t\u0006I\u0001O]8dKN\u001cxN\u001d\u0005\u0007\u0003+*\u0002\u0019A5")
public class StateTransition
implements SparkzLogging,
ExecutionContext {
    private final StateDbAccountStateView view;
    private final Seq<MessageProcessor> messageProcessors;
    private final GasPool blockGasPool;
    private final BlockContext blockContext;
    private final Message msg;
    private final ListBuffer<Invocation> invocationStack;
    private final Option<Tracer> tracer;
    private int depth;
    private final Logger logger;

    @Override
    public byte[] executeDepth(Invocation invocation, int additionalDepth) throws InvalidMessageException, ExecutionFailedException {
        return ExecutionContext.executeDepth$(this, invocation, additionalDepth);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BlockContext blockContext() {
        return this.blockContext;
    }

    @Override
    public Message msg() {
        return this.msg;
    }

    private ListBuffer<Invocation> invocationStack() {
        return this.invocationStack;
    }

    private Option<Tracer> tracer() {
        return this.tracer;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    public byte[] transition() throws InvalidMessageException, ExecutionFailedException {
        byte[] byArray;
        this.preCheck(this.msg());
        BigInteger initialBlockGas = this.blockGasPool.getGas();
        int rollback = this.view.snapshot();
        boolean skipRefund = false;
        GasPool gasPool = this.buyGas(this.msg());
        this.tracer().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.CaptureTxStart(gasPool.initialGas());
            return BoxedUnit.UNIT;
        });
        try {
            try {
                boolean isShanghaiActive = Version1_3_0Fork$.MODULE$.get(this.blockContext().consensusEpochNumber).active();
                BigInteger intrinsicGas = GasUtil$.MODULE$.intrinsicGas(this.msg().getData(), this.msg().getTo().isEmpty(), isShanghaiActive);
                if (gasPool.getGas().compareTo(intrinsicGas) < 0) {
                    throw new IntrinsicGasException(gasPool.getGas(), intrinsicGas);
                }
                gasPool.subGas(intrinsicGas);
                if (isShanghaiActive && this.msg().getTo().isEmpty() && this.msg().getData().length > ProtocolParams$.MODULE$.MaxInitCodeSize()) {
                    throw new MaxInitCodeSizeExceededException(this.msg().getData().length, ProtocolParams$.MODULE$.MaxInitCodeSize());
                }
                this.view.setupAccessList(this.msg(), this.blockContext().forgerAddress, new ForkRules(isShanghaiActive));
                this.view.increaseNonce(this.msg().getFrom());
                byArray = this.execute(Invocation$.MODULE$.fromMessage(this.msg(), gasPool));
            }
            catch (ExecutionFailedException err) {
                throw err;
            }
            catch (Exception err) {
                skipRefund = true;
                this.view.revertToSnapshot(rollback);
                this.blockGasPool.addGas(initialBlockGas.subtract(this.blockGasPool.getGas()));
                throw err;
            }
        }
        finally {
            if (!skipRefund) {
                this.refundGas(this.msg(), gasPool);
            }
            this.tracer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.CaptureTxEnd(gasPool.getGas());
                return BoxedUnit.UNIT;
            });
        }
        return byArray;
    }

    private void preCheck(Message msg) {
        Address sender = msg.getFrom();
        if (!msg.getIsFakeMsg()) {
            BigInteger stateNonce = this.view.getNonce(sender);
            int n = msg.getNonce().compareTo(stateNonce);
            switch (n) {
                default: 
            }
            if (n < 0) {
                throw new NonceTooLowException(sender, msg.getNonce(), stateNonce);
            }
            if (n > 0) {
                throw new NonceTooHighException(sender, msg.getNonce(), stateNonce);
            }
            if (!BigIntegerUtil$.MODULE$.isUint64(stateNonce.add(BigInteger.ONE))) {
                throw new NonceMaxException(sender, stateNonce);
            }
            if (!this.view.isEoaAccount(sender)) {
                throw new SenderNotEoaException(sender, this.view.getCodeHash(sender));
            }
        }
        if (!(msg.getIsFakeMsg() && msg.getGasFeeCap().bitLength() <= 0 || msg.getGasFeeCap().compareTo(this.blockContext().baseFee) >= 0)) {
            throw new FeeCapTooLowException(sender, msg.getGasFeeCap(), this.blockContext().baseFee);
        }
    }

    private GasPool buyGas(Message msg) {
        BigInteger want;
        BigInteger gas = msg.getGasLimit();
        BigInteger effectiveFees = gas.multiply(msg.getGasPrice());
        BigInteger maxFees = msg.getGasFeeCap() == null ? effectiveFees : gas.multiply(msg.getGasFeeCap());
        Address sender = msg.getFrom();
        BigInteger have = this.view.getBalance(sender);
        if (have.compareTo(want = maxFees.add(msg.getValue())) < 0) {
            throw new InsufficientFundsException(sender, have, want);
        }
        if (this.blockGasPool.getGas().compareTo(gas) < 0) {
            throw new GasLimitReached();
        }
        this.blockGasPool.subGas(gas);
        this.view.subBalance(sender, effectiveFees);
        return new GasPool(gas);
    }

    private void refundGas(Message msg, GasPool gas) {
        gas.addGas(this.view.getRefund().min(gas.getUsedGas().divide(GasUtil$.MODULE$.RefundQuotientEIP3529())));
        BigInteger remaining = gas.getGas().multiply(msg.getGasPrice());
        this.view.addBalance(msg.getFrom(), remaining);
        this.blockGasPool.addGas(gas.getGas());
    }

    @Override
    public byte[] execute(Invocation invocation) throws InvalidMessageException, ExecutionFailedException {
        byte[] byArray;
        boolean firstReadOnlyInvocation;
        if (this.depth() > 1024) {
            throw new ExecutionRevertedException("max call depth exceeded");
        }
        Option callerGas = this.invocationStack().headOption().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.gasPool());
        callerGas.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.subGas(invocation.gasPool().getGas());
            return BoxedUnit.UNIT;
        });
        boolean bl = firstReadOnlyInvocation = invocation.readOnly() && !this.view.readOnly();
        if (firstReadOnlyInvocation) {
            this.view.enableWriteProtection();
        }
        try {
            if (invocation.readOnly() && invocation.value().signum() != 0) {
                throw new WriteProtectionException("invalid value transfer during read-only invocation");
            }
            Option option = this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.canProcess(invocation, this.view, this.blockContext().consensusEpochNumber)));
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("No message processor found for invocation: {}", new Object[]{invocation});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException("Unable to execute invocation.");
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            MessageProcessor processor = (MessageProcessor)some.value();
            byte[] byArray2 = this.invoke(processor, invocation);
            byArray = byArray2;
        }
        finally {
            if (firstReadOnlyInvocation) {
                this.view.disableWriteProtection();
            }
            callerGas.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.addGas(invocation.gasPool().getGas());
                return BoxedUnit.UNIT;
            });
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] invoke(MessageProcessor processor, Invocation invocation) {
        block5: {
            if (!processor.customTracing()) {
                this.tracer().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invoke$1$adapted(io.horizen.account.state.StateTransition io.horizen.account.state.Invocation io.horizen.evm.Tracer ), (Lio/horizen/evm/Tracer;)Ljava/lang/Object;)((StateTransition)this, (Invocation)invocation));
            }
            this.invocationStack().prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Invocation[]{invocation}));
            this.depth_$eq(this.depth() + 1);
            revert = this.view.snapshot();
            result = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$invoke$2(io.horizen.account.state.StateTransition io.horizen.account.state.MessageProcessor io.horizen.account.state.Invocation ), ()[B)((StateTransition)this, (MessageProcessor)processor, (Invocation)invocation));
            var6_5 = false;
            var7_6 = null;
            var8_7 = result;
            if (!(var8_7 instanceof Failure)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Failure)var8_7;
            if (var7_6.exception() instanceof ExecutionRevertedException) {
                this.view.revertToSnapshot(revert);
                var3_8 = BoxedUnit.UNIT;
            } else if (var6_5 && var7_6.exception() instanceof ExecutionFailedException) {
                this.view.revertToSnapshot(revert);
                invocation.gasPool().subGas(invocation.gasPool().getGas());
                var3_9 = BoxedUnit.UNIT;
            } else {
                var3_10 = BoxedUnit.UNIT;
            }
            this.depth_$eq(this.depth() - 1);
            this.invocationStack().remove(0);
            if (processor.customTracing()) break block5;
            this.tracer().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$invoke$3$adapted(io.horizen.account.state.StateTransition scala.util.Try io.horizen.account.state.Invocation io.horizen.evm.Tracer ), (Lio/horizen/evm/Tracer;)Ljava/lang/Object;)((StateTransition)this, (Try)result, (Invocation)invocation));
        }
        return (byte[])result.get();
    }

    public static final /* synthetic */ void $anonfun$invoke$1(StateTransition $this, Invocation invocation$2, Tracer tracer) {
        if ($this.depth() == 0) {
            EvmContext context = new EvmContext(BigInteger.valueOf($this.blockContext().chainID), $this.blockContext().forgerAddress, $this.blockContext().blockGasLimit, $this.msg().getGasPrice(), BigInteger.valueOf($this.blockContext().blockNumber), BigInteger.valueOf($this.blockContext().timestamp), $this.blockContext().baseFee, $this.blockContext().random, new ForkRules(Version1_3_0Fork$.MODULE$.get($this.blockContext().consensusEpochNumber).active()));
            tracer.CaptureStart($this.view.getStateDbHandle(), context, invocation$2.caller(), (Address)invocation$2.callee().orNull(Predef$.MODULE$.$conforms()), invocation$2.callee().isEmpty(), invocation$2.input(), invocation$2.gasPool().initialGas(), invocation$2.value());
        } else {
            tracer.CaptureEnter(invocation$2.guessOpCode(), invocation$2.caller(), (Address)invocation$2.callee().orNull(Predef$.MODULE$.$conforms()), invocation$2.input(), invocation$2.gasPool().initialGas(), invocation$2.value());
        }
    }

    public static final /* synthetic */ byte[] $anonfun$invoke$2(StateTransition $this, MessageProcessor processor$1, Invocation invocation$2) {
        return processor$1.process(invocation$2, $this.view, $this);
    }

    public static final /* synthetic */ void $anonfun$invoke$3(StateTransition $this, Try result$1, Invocation invocation$2, Tracer tracer) {
        String string;
        byte[] byArray;
        Failure failure;
        Throwable err;
        Try try_ = result$1;
        if (try_ instanceof Failure && (err = (failure = (Failure)try_).exception()) instanceof ExecutionRevertedException) {
            ExecutionRevertedException executionRevertedException = (ExecutionRevertedException)err;
            byArray = executionRevertedException.returnData;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] value = (byte[])success.value();
            byArray = value;
        } else {
            byArray = Array$.MODULE$.emptyByteArray();
        }
        byte[] output = byArray;
        Try try_2 = result$1;
        if (try_2 instanceof Failure) {
            Failure failure2 = (Failure)try_2;
            Throwable exception = failure2.exception();
            string = exception.getMessage();
        } else {
            string = "";
        }
        String error = string;
        if ($this.depth() == 0) {
            tracer.CaptureEnd(output, invocation$2.gasPool().getUsedGas(), error);
        } else {
            tracer.CaptureExit(output, invocation$2.gasPool().getUsedGas(), error);
        }
    }

    public StateTransition(StateDbAccountStateView view, Seq<MessageProcessor> messageProcessors, GasPool blockGasPool, BlockContext blockContext, Message msg) {
        this.view = view;
        this.messageProcessors = messageProcessors;
        this.blockGasPool = blockGasPool;
        this.blockContext = blockContext;
        this.msg = msg;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        ExecutionContext.$init$(this);
        this.invocationStack = new ListBuffer();
        this.tracer = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(blockContext.getTracer()));
        this.depth = 0;
    }

    public static final /* synthetic */ Object $anonfun$invoke$1$adapted(StateTransition $this, Invocation invocation$2, Tracer tracer) {
        StateTransition.$anonfun$invoke$1($this, invocation$2, tracer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$invoke$3$adapted(StateTransition $this, Try result$1, Invocation invocation$2, Tracer tracer) {
        StateTransition.$anonfun$invoke$3($this, result$1, invocation$2, tracer);
        return BoxedUnit.UNIT;
    }
}

