/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.events.EthereumEvent;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec!B\b\u0011\u0003\u0003I\u0002\"\u0002\u0018\u0001\t\u0003y\u0003bB\u0019\u0001\u0005\u00045\tA\r\u0005\bs\u0001\u0011\rQ\"\u0001;\u0011!!\u0005\u0001#b\u0001\n\u0003Q\u0004\"B#\u0001\t\u00032\u0005bBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\u000f\u0001\t\u0003\tYdB\u0004\u0002@AA\t!!\u0011\u0007\r=\u0001\u0002\u0012AA\"\u0011\u0019q3\u0002\"\u0001\u0002L!A\u0011QJ\u0006C\u0002\u0013\u0005!\bC\u0004\u0002P-\u0001\u000b\u0011B\u001e\u0003?9\u000bG/\u001b<f'6\f'\u000f^\"p]R\u0014\u0018m\u0019;Ng\u001e\u0004&o\\2fgN|'O\u0003\u0002\u0012%\u0005)1\u000f^1uK*\u00111\u0003F\u0001\bC\u000e\u001cw.\u001e8u\u0015\t)b#A\u0004i_JL'0\u001a8\u000b\u0003]\t!![8\u0004\u0001M!\u0001A\u0007\u0012'!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u00142kK\u000e$\bCA\u0012%\u001b\u0005\u0001\u0012BA\u0013\u0011\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'\u000f\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013AB:qCJ\\'0\u0003\u0002.Q\ti1\u000b]1sWjdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005\r\u0002\u0011aD2p]R\u0014\u0018m\u0019;BI\u0012\u0014Xm]:\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u000b\u0002\u0007\u00154X.\u0003\u00029k\t9\u0011\t\u001a3sKN\u001c\u0018\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#A\u001e\u0011\u0007qz\u0014)D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0015\t%O]1z!\ta$)\u0003\u0002D{\t!!)\u001f;f\u0003A\u0019wN\u001c;sC\u000e$8i\u001c3f\u0011\u0006\u001c\b.\u0001\u0003j]&$HcA$K\u001fB\u0011A\bS\u0005\u0003\u0013v\u0012A!\u00168ji\")1*\u0002a\u0001\u0019\u0006!a/[3x!\t\u0019S*\u0003\u0002O!\t!\")Y:f\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^DQ\u0001U\u0003A\u0002E\u000bAcY8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014\bC\u0001\u001fS\u0013\t\u0019VHA\u0002J]RD3!B+\\!\rad\u000bW\u0005\u0003/v\u0012a\u0001\u001e5s_^\u001c\bCA\u0012Z\u0013\tQ\u0006CA\u0014NKN\u001c\u0018mZ3Qe>\u001cWm]:pe&s\u0017\u000e^5bY&T\u0018\r^5p]\u0016C8-\u001a9uS>t\u0017'\u0002\u0010]O\u0006\u0005\u0001CA/e\u001d\tq&\r\u0005\u0002`{5\t\u0001M\u0003\u0002b1\u00051AH]8pizJ!aY\u001f\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003Gv\nTa\t5mw6,\"!\u001b6\u0016\u0003q#Qa\u001b\rC\u0002A\u0014\u0011\u0001V\u0005\u0003[:\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$BA8>\u0003\u0019!\bN]8xgF\u0011\u0011\u000f\u001e\t\u0003yIL!a]\u001f\u0003\u000f9{G\u000f[5oOB\u0011Q\u000f\u001f\b\u0003yYL!a^\u001f\u0002\u000fA\f7m[1hK&\u0011\u0011P\u001f\u0002\n)\"\u0014xn^1cY\u0016T!a^\u001f2\u000b\rbXP`8\u000f\u0005qj\u0018BA8>c\u0011\u0011C(P@\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019B\u0016!D2vgR|W\u000e\u0016:bG&tw\r\u0006\u0002\u0002\bA\u0019A(!\u0003\n\u0007\u0005-QHA\u0004C_>dW-\u00198\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0005\u0002\b\u0005E\u00111DA\u000f\u0011\u001d\t\u0019b\u0002a\u0001\u0003+\t!\"\u001b8w_\u000e\fG/[8o!\r\u0019\u0013qC\u0005\u0004\u00033\u0001\"AC%om>\u001c\u0017\r^5p]\")1j\u0002a\u0001\u0019\")\u0001k\u0002a\u0001#\u0006Yr-\u001a;Fi\",'/Z;n\u0007>t7/\u001a8tkN$\u0015\r^1M_\u001e$B!a\t\u00020A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*A\tqA]3dK&\u0004H/\u0003\u0003\u0002.\u0005\u001d\"\u0001G#uQ\u0016\u0014X-^7D_:\u001cXM\\:vg\u0012\u000bG/\u0019'pO\"9\u0011\u0011\u0007\u0005A\u0002\u0005M\u0012!B3wK:$\bc\u0001\u001f\u00026%\u0019\u0011qG\u001f\u0003\u0007\u0005s\u00170A\nsKF,\u0018N]3Jg:{G\u000fU1zC\ndW\rF\u0002H\u0003{Aq!a\u0005\n\u0001\u0004\t)\"A\u0010OCRLg/Z*nCJ$8i\u001c8ue\u0006\u001cG/T:h!J|7-Z:t_J\u0004\"aI\u0006\u0014\u0007-\t)\u0005E\u0002=\u0003\u000fJ1!!\u0013>\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011I\u0001\u0013\u001dVcEj\u0018%F1~\u001bFKU%O\u000f~\u001b$'A\nO+2cu\fS#Y?N#&+\u0013(H?N\u0012\u0004\u0005")
public abstract class NativeSmartContractMsgProcessor
implements MessageProcessor,
SparkzLogging {
    private byte[] contractCodeHash;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static byte[] NULL_HEX_STRING_32() {
        return NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public abstract Address contractAddress();

    public abstract byte[] contractCode();

    private byte[] contractCodeHash$lzycompute() {
        NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = this;
        synchronized (nativeSmartContractMsgProcessor) {
            if (!this.bitmap$0) {
                this.contractCodeHash = Keccak256$.MODULE$.hash(this.contractCode());
                this.bitmap$0 = true;
            }
        }
        return this.contractCodeHash;
    }

    public byte[] contractCodeHash() {
        return !this.bitmap$0 ? this.contractCodeHash$lzycompute() : this.contractCodeHash;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) throws MessageProcessorInitializationException {
        if (!view.accountExists(this.contractAddress())) {
            BoxedUnit boxedUnit;
            view.addAccount(this.contractAddress(), this.contractCode());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("created Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(23).append("Account ").append(this.contractAddress()).append(" already exists").toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(errorMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new MessageProcessorInitializationException(errorMsg);
        }
    }

    @Override
    public boolean customTracing() {
        return false;
    }

    @Override
    public boolean canProcess(Invocation invocation, BaseAccountStateView view, int consensusEpochNumber) {
        return invocation.callee().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NativeSmartContractMsgProcessor.$anonfun$canProcess$1(this, x$1)));
    }

    public EthereumConsensusDataLog getEthereumConsensusDataLog(Object event) {
        return EthereumEvent.getEthereumConsensusDataLog(this.contractAddress(), event);
    }

    public void requireIsNotPayable(Invocation invocation) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(NativeSmartContractMsgProcessor $this, Address x$1) {
        return $this.contractAddress().equals((Object)x$1);
    }

    public NativeSmartContractMsgProcessor() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

