/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.fork.Version1_3_0Fork$;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoListEncoder$;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddNewStakeCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakeStorage;
import io.horizen.account.state.ForgerStakeStorage$;
import io.horizen.account.state.ForgerStakeStorageElem;
import io.horizen.account.state.ForgerStakeStorageV1$;
import io.horizen.account.state.ForgerStakeStorageV2$;
import io.horizen.account.state.ForgerStakeStorageVersion$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GetPagedForgersStakesOfUserCmdInput;
import io.horizen.account.state.GetPagedForgersStakesOfUserCmdInputDecoder$;
import io.horizen.account.state.GetPagedListOfStakesCmdInput;
import io.horizen.account.state.GetPagedListOfStakesCmdInputDecoder$;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.Invocation$;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.OpenStakeForgerListCmdInputDecoder$;
import io.horizen.account.state.PagedListOfStakesOutput;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.RemoveStakeCmdInputDecoder$;
import io.horizen.account.state.StakeAmount;
import io.horizen.account.state.StakeOfCmdInput;
import io.horizen.account.state.StakeOfCmdInputDecoder$;
import io.horizen.account.state.events.DelegateForgerStake;
import io.horizen.account.state.events.DelegateForgerStake$;
import io.horizen.account.state.events.OpenForgerList;
import io.horizen.account.state.events.OpenForgerList$;
import io.horizen.account.state.events.StakeUpgrade;
import io.horizen.account.state.events.StakeUpgrade$;
import io.horizen.account.state.events.WithdrawForgerStake;
import io.horizen.account.state.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r-e\u0001\u0002&L\u0001RC\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tY\u0002\u0011\t\u0012)A\u0005O\")Q\u000e\u0001C\u0001]\"9\u0011\u000f\u0001b\u0001\n\u0003\u0012\bBB=\u0001A\u0003%1\u000fC\u0004{\u0001\t\u0007I\u0011I>\t\u000f\u0005\u0015\u0001\u0001)A\u0005y\"A\u0011q\u0001\u0001C\u0002\u0013\u0005a\rC\u0004\u0002\n\u0001\u0001\u000b\u0011B4\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003W\u0002A\u0011AA7\u0011!\t\u0019\t\u0001C!\u001f\u0006\u0015\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003g\u0003A\u0011AA[\u0011%\ti\rAI\u0001\n\u0003\ty\rC\u0004\u0002f\u0002!I!a:\t\u000f\u00055\b\u0001\"\u0011\u0002p\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA! \u0001\t\u0003\u0011y\bC\u0004\u0003\b\u0002!\tE!#\t\u0011\t%\u0006\u0001\"\u0011P\u0005WCqAa,\u0001\t\u0013\u0011\t\f\u0003\u0005\u00038\u0002!\te\u0014B]\u0011%\u0011y\fAA\u0001\n\u0003\u0011\t\rC\u0005\u0003F\u0002\t\n\u0011\"\u0001\u0003H\"I!1\u001a\u0001\u0002\u0002\u0013\u0005#Q\u001a\u0005\n\u00057\u0004\u0011\u0011!C\u0001\u0005;D\u0011Ba8\u0001\u0003\u0003%\tA!9\t\u0013\t5\b!!A\u0005B\t=\b\"\u0003B\u007f\u0001\u0005\u0005I\u0011\u0001B\u0000\u0011%\u0019\u0019\u0001AA\u0001\n\u0003\u001a)\u0001C\u0005\u0004\b\u0001\t\t\u0011\"\u0011\u0004\n!I11\u0002\u0001\u0002\u0002\u0013\u00053QB\u0004\b\u0007#Y\u0005\u0012AB\n\r\u0019Q5\n#\u0001\u0004\u0016!1Qn\fC\u0001\u0007;A\u0001ba\b0\u0005\u0004%\ta\u001f\u0005\b\u0007Cy\u0003\u0015!\u0003}\u0011%\u0019\u0019c\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u00046=\u0002\u000b\u0011BB\u0014\u0011%\u00199d\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004:=\u0002\u000b\u0011BB\u0014\u0011%\u0019Yd\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004>=\u0002\u000b\u0011BB\u0014\u0011%\u0019yd\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004B=\u0002\u000b\u0011BB\u0014\u0011%\u0019\u0019e\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004F=\u0002\u000b\u0011BB\u0014\u0011%\u00199e\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004J=\u0002\u000b\u0011BB\u0014\u0011%\u0019Ye\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004N=\u0002\u000b\u0011BB\u0014\u0011%\u0019ye\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004R=\u0002\u000b\u0011BB\u0014\u0011%\u0019\u0019f\fb\u0001\n\u0003\u0019)\u0003\u0003\u0005\u0004V=\u0002\u000b\u0011BB\u0014\u0011\u001d\u00199f\fC\u0001\u00073Bqa!\u001a0\t\u0003\u00199\u0007C\u0005\u0004r=\n\t\u0011\"!\u0004t!I1qO\u0018\u0002\u0002\u0013\u00055\u0011\u0010\u0005\n\u0007\u0003{\u0013\u0011!C\u0005\u0007\u0007\u0013qCR8sO\u0016\u00148\u000b^1lK6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u00051k\u0015!B:uCR,'B\u0001(P\u0003\u001d\t7mY8v]RT!\u0001U)\u0002\u000f!|'/\u001b>f]*\t!+\u0001\u0002j_\u000e\u00011#\u0002\u0001V3r\u0013\u0007C\u0001,X\u001b\u0005Y\u0015B\u0001-L\u0005}q\u0015\r^5wKNk\u0017M\u001d;D_:$(/Y2u\u001bN<\u0007K]8dKN\u001cxN\u001d\t\u0003-jK!aW&\u0003)\u0019{'oZ3s'R\f7.Z:Qe>4\u0018\u000eZ3s!\ti\u0006-D\u0001_\u0015\u0005y\u0016!B:dC2\f\u0017BA1_\u0005\u001d\u0001&o\u001c3vGR\u0004\"!X2\n\u0005\u0011t&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001h!\tA'.D\u0001j\u0015\t)w*\u0003\u0002lS\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003_B\u0004\"A\u0016\u0001\t\u000b\u0015\u001c\u0001\u0019A4\u0002\u001f\r|g\u000e\u001e:bGR\fE\r\u001a:fgN,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m>\u000b1!\u001a<n\u0013\tAXOA\u0004BI\u0012\u0014Xm]:\u0002!\r|g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#\u0001?\u0011\u0007ukx0\u0003\u0002\u007f=\n)\u0011I\u001d:bsB\u0019Q,!\u0001\n\u0007\u0005\raL\u0001\u0003CsR,\u0017!D2p]R\u0014\u0018m\u0019;D_\u0012,\u0007%A\u0007oKR<xN]6QCJ\fWn]\u0001\u000f]\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:!\u0003)9W\r^*uC.,\u0017\n\u001a\u000b\u0004y\u0006=\u0001bBA\t\u0015\u0001\u0007\u00111C\u0001\u0004[N<\u0007c\u0001,\u0002\u0016%\u0019\u0011qC&\u0003\u000f5+7o]1hK\u0006!\u0011N\\5u)\u0019\ti\"a\t\u0002.A\u0019Q,a\b\n\u0007\u0005\u0005bL\u0001\u0003V]&$\bbBA\u0013\u0017\u0001\u0007\u0011qE\u0001\u0005m&,w\u000fE\u0002W\u0003SI1!a\u000bL\u0005Q\u0011\u0015m]3BG\u000e|WO\u001c;Ti\u0006$XMV5fo\"9\u0011qF\u0006A\u0002\u0005E\u0012\u0001F2p]N,gn];t\u000bB|7\r\u001b(v[\n,'\u000fE\u0002^\u0003gI1!!\u000e_\u0005\rIe\u000e^\u0001\u001dO\u0016$hi\u001c:hKJ\u001cF/Y6f'R|'/Y4f-\u0016\u00148/[8o)\u0019\tY$a\u0018\u0002bA!\u0011QHA-\u001d\u0011\ty$!\u0016\u000f\t\u0005\u0005\u00131\u000b\b\u0005\u0003\u0007\n\tF\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-3+\u0001\u0004=e>|GOP\u0005\u0002%&\u0011\u0001+U\u0005\u0003\u001d>K!\u0001T'\n\u0007\u0005]3*A\rG_J<WM]*uC.,7\u000b^8sC\u001e,g+\u001a:tS>t\u0017\u0002BA.\u0003;\u0012\u0011DR8sO\u0016\u00148\u000b^1lKN#xN]1hKZ+'o]5p]*\u0019\u0011qK&\t\u000f\u0005\u0015B\u00021\u0001\u0002(!9\u00111\r\u0007A\u0002\u0005\u0015\u0014\u0001E5t\r>\u00148NV\u0019`g\u0005\u001bG/\u001b<f!\ri\u0016qM\u0005\u0004\u0003Sr&a\u0002\"p_2,\u0017M\\\u0001\u000eM&tGm\u0015;bW\u0016$\u0015\r^1\u0015\u0011\u0005=\u00141PA?\u0003\u0003\u0003R!XA9\u0003kJ1!a\u001d_\u0005\u0019y\u0005\u000f^5p]B\u0019a+a\u001e\n\u0007\u0005e4JA\bG_J<WM]*uC.,G)\u0019;b\u0011\u001d\t)#\u0004a\u0001\u0003OAa!a \u000e\u0001\u0004a\u0018aB:uC.,\u0017\n\u001a\u0005\b\u0003Gj\u0001\u0019AA3\u0003YI7OR8sO\u0016\u00148\u000b^1lK\u00063\u0018-\u001b7bE2,GCBA3\u0003\u000f\u000bI\tC\u0004\u0002&9\u0001\r!a\n\t\u000f\u0005\rd\u00021\u0001\u0002f\u0005A\u0012\r\u001a3TG\u000e\u0013X-\u0019;j_:4uN]4feN#\u0018m[3\u0015\u0013q\fy)!%\u0002\u0016\u0006%\u0006bBA\u0013\u001f\u0001\u0007\u0011q\u0005\u0005\u0007\u0003'{\u0001\u0019A:\u0002\u000b=<h.\u001a:\t\u000f\u0005]u\u00021\u0001\u0002\u001a\u0006)a/\u00197vKB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001B7bi\"T!!a)\u0002\t)\fg/Y\u0005\u0005\u0003O\u000biJ\u0001\u0006CS\u001eLe\u000e^3hKJDq!a+\u0010\u0001\u0004\ti+\u0001\u0003eCR\f\u0007c\u0001,\u00020&\u0019\u0011\u0011W&\u0003'\u0005#GMT3x'R\f7.Z\"nI&s\u0007/\u001e;\u0002!\u0011|\u0017\t\u001a3OK^\u001cF/Y6f\u00076$Gc\u0003?\u00028\u0006\u0005\u00171YAc\u0003\u0013Dq!!/\u0011\u0001\u0004\tY,\u0001\u0006j]Z|7-\u0019;j_:\u00042AVA_\u0013\r\tyl\u0013\u0002\u000b\u0013:4xnY1uS>t\u0007bBA\u0013!\u0001\u0007\u0011q\u0005\u0005\b\u0003#\u0001\u0002\u0019AA\n\u0011\u001d\t9\r\u0005a\u0001\u0003K\n\u0011#[:G_J\\g+M04?\u0006\u001bG/\u001b<f\u0011%\tY\r\u0005I\u0001\u0002\u0004\t)'A\njg\u001e+g.Z:jgN\u001b7I]3bi&|g.\u0001\u000ee_\u0006#GMT3x'R\f7.Z\"nI\u0012\"WMZ1vYR$S'\u0006\u0002\u0002R*\"\u0011QMAjW\t\t)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\u0013Ut7\r[3dW\u0016$'bAAp=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0018\u0011\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!H2iK\u000e\\\u0017J\u001c9vi\u0012{Wm\u001d8u\u0007>tG/Y5o!\u0006\u0014\u0018-\\:\u0015\t\u0005u\u0011\u0011\u001e\u0005\u0007\u0003W\u0014\u0002\u0019\u0001?\u0002\u0011\r\fG\u000e\u001c3bi\u0006\facZ3u\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm\u001d\u000b\u0007\u0003c\u0014IAa\u0003\u0011\r\u0005M\u0018Q B\u0002\u001d\u0011\t)0!?\u000f\t\u0005\u001d\u0013q_\u0005\u0002?&\u0019\u00111 0\u0002\u000fA\f7m[1hK&!\u0011q B\u0001\u0005\r\u0019V-\u001d\u0006\u0004\u0003wt\u0006c\u0001,\u0003\u0006%\u0019!qA&\u0003/\u0005\u001b7m\\;oi\u001a{'oZ5oON#\u0018m[3J]\u001a|\u0007bBA\u0013'\u0001\u0007\u0011q\u0005\u0005\b\u0003G\u001a\u0002\u0019AA3\u0003m9W\r\u001e)bO\u0016$G*[:u\u001f\u001a4uN]4feN\u001cF/Y6fgRA!\u0011\u0003B\f\u00053\u0011i\u0002E\u0004^\u0005'\t\t$!=\n\u0007\tUaL\u0001\u0004UkBdWM\r\u0005\b\u0003K!\u0002\u0019AA\u0014\u0011\u001d\u0011Y\u0002\u0006a\u0001\u0003c\t\u0001b\u001d;beR\u0004vn\u001d\u0005\b\u0005?!\u0002\u0019AA\u0019\u0003!\u0001\u0018mZ3TSj,\u0017!F4fi\u001a{'oZ3s'R\f7.Z*u_J\fw-\u001a\u000b\u0007\u0005K\u0011YC!\f\u0011\u0007Y\u00139#C\u0002\u0003*-\u0013!CR8sO\u0016\u00148\u000b^1lKN#xN]1hK\"9\u0011QE\u000bA\u0002\u0005\u001d\u0002bBA2+\u0001\u0007\u0011QM\u0001%I>,fn\u00195fG.,GmR3u\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm]\"nIR)APa\r\u00036!9\u0011Q\u0005\fA\u0002\u0005\u001d\u0002bBA2-\u0001\u0007\u0011QM\u0001\u0016I><U\r\u001e'jgR|eMR8sO\u0016\u00148oQ7e)\u001da(1\bB\u001f\u0005\u007fAq!!/\u0018\u0001\u0004\tY\fC\u0004\u0002&]\u0001\r!a\n\t\u000f\u0005\rt\u00031\u0001\u0002f\u0005QBm\\$fiB\u000bw-\u001a3MSN$xJ\u001a$pe\u001e,'o]\"nIR)AP!\u0012\u0003H!9\u0011\u0011\u0018\rA\u0002\u0005m\u0006bBA\u00131\u0001\u0007\u0011qE\u0001\rI>,\u0006o\u001a:bI\u0016\u001cU\u000e\u001a\u000b\u0006y\n5#q\n\u0005\b\u0003sK\u0002\u0019AA^\u0011\u001d\t)#\u0007a\u0001\u0003O\t!d\u00195fG.\u001cUO\u001d:f]R\u001cFo\u001c:bO\u00164VM]:j_:$b!!\b\u0003V\t]\u0003bBA\u00135\u0001\u0007\u0011q\u0005\u0005\b\u00053R\u0002\u0019AA\u001e\u0003Y\u0011X-];je\u0016$7\u000b^8sC\u001e,g+\u001a:tS>t\u0017\u0001\u00043p'R\f7.Z(g\u00076$G#\u0002?\u0003`\t\u0005\u0004bBA]7\u0001\u0007\u00111\u0018\u0005\b\u0003KY\u0002\u0019AA\u0014\u0003\u0001\"wnR3u!\u0006<W\r\u001a$pe\u001e,'o]*uC.,7o\u00144Vg\u0016\u00148)\u001c3\u0015\u000bq\u00149G!\u001b\t\u000f\u0005eF\u00041\u0001\u0002<\"9\u0011Q\u0005\u000fA\u0002\u0005\u001d\u0012\u0001\u00053p%\u0016lwN^3Ti\u0006\\WmQ7e)%a(q\u000eB9\u0005g\u0012)\bC\u0004\u0002:v\u0001\r!a/\t\u000f\u0005\u0015R\u00041\u0001\u0002(!9\u0011\u0011C\u000fA\u0002\u0005M\u0001bBA2;\u0001\u0007\u0011QM\u0001\u001bO\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJ\u001c\u0018J\u001c3fq2K7\u000f\u001e\u000b\u0004y\nm\u0004bBA\u0013=\u0001\u0007\u0011qE\u0001\u0019I>|\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$Gc\u0002?\u0003\u0002\n\r%Q\u0011\u0005\b\u0003s{\u0002\u0019AA^\u0011\u001d\t)c\ba\u0001\u0003OAq!!\u0005 \u0001\u0004\t\u0019\"A\u0004qe>\u001cWm]:\u0015\u000fq\u0014YI!$\u0003\u0010\"9\u0011\u0011\u0018\u0011A\u0002\u0005m\u0006bBA\u0013A\u0001\u0007\u0011q\u0005\u0005\b\u0005#\u0003\u0003\u0019\u0001BJ\u0003\u001d\u0019wN\u001c;fqR\u00042A\u0016BK\u0013\r\u00119j\u0013\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDS\u0001\tBN\u0005O\u0003R!\u0018BO\u0005CK1Aa(_\u0005\u0019!\bN]8xgB\u0019aKa)\n\u0007\t\u00156J\u0001\rFq\u0016\u001cW\u000f^5p]\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u001c#A!)\u0002!%\u001chi\u001c:hKJd\u0015n\u001d;Pa\u0016tG\u0003BA3\u0005[Cq!!\n\"\u0001\u0004\t9#A\rjg\u001a{'oZ3s\u0019&\u001cHo\u00149f]Vs7\r[3dW\u0016$G\u0003BA3\u0005gCaA!.#\u0001\u0004a\u0018\u0001\u00027jgR\f1dZ3u\u00032dwn^3e\r>\u0014x-\u001a:MSN$\u0018J\u001c3fq\u0016\u001cH\u0003\u0002B^\u0005{\u0003b!a=\u0002~\u0006E\u0002bBA\u0013G\u0001\u0007\u0011qE\u0001\u0005G>\u0004\u0018\u0010F\u0002p\u0005\u0007Dq!\u001a\u0013\u0011\u0002\u0003\u0007q-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t%'fA4\u0002T\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa4\u0011\t\tE'q[\u0007\u0003\u0005'TAA!6\u0002\"\u0006!A.\u00198h\u0013\u0011\u0011INa5\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\r(\u0011\u001e\t\u0004;\n\u0015\u0018b\u0001Bt=\n\u0019\u0011I\\=\t\u0013\t-\b&!AA\u0002\u0005E\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003rB1!1\u001fB}\u0005Gl!A!>\u000b\u0007\t]h,\u0001\u0006d_2dWm\u0019;j_:LAAa?\u0003v\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)g!\u0001\t\u0013\t-(&!AA\u0002\t\r\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002f\r=\u0001\"\u0003Bv[\u0005\u0005\t\u0019\u0001Br\u0003]1uN]4feN#\u0018m[3Ng\u001e\u0004&o\\2fgN|'\u000f\u0005\u0002W_M!qfa\u0006c!\ri6\u0011D\u0005\u0004\u00077q&AB!osJ+g\r\u0006\u0002\u0004\u0014\u0005I\"+Z:ue&\u001cG/\u001a3G_J<WM\u001d$mC\u001e\u001cH*[:u\u0003i\u0011Vm\u001d;sS\u000e$X\r\u001a$pe\u001e,'O\u00127bONd\u0015n\u001d;!\u0003a9U\r\u001e)bO\u0016$G*[:u\u001f\u001a4uN]4feN\u001cU\u000eZ\u000b\u0003\u0007O\u0001Ba!\u000b\u000429!11FB\u0017!\r\t9EX\u0005\u0004\u0007_q\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003Z\u000eM\"bAB\u0018=\u0006Ir)\u001a;QC\u001e,G\rT5ti>3gi\u001c:hKJ\u001c8)\u001c3!\u0003M9U\r\u001e'jgR|eMR8sO\u0016\u00148oQ7e\u0003Q9U\r\u001e'jgR|eMR8sO\u0016\u00148oQ7eA\u0005q\u0011\t\u001a3OK^\u001cF/Y6f\u00076$\u0017aD!eI:+wo\u0015;bW\u0016\u001cU\u000e\u001a\u0011\u0002\u001dI+Wn\u001c<f'R\f7.Z\"nI\u0006y!+Z7pm\u0016\u001cF/Y6f\u00076$\u0007%\u0001\fPa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e\u0003]y\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$\u0007%A\u000fPa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e\u0007>\u0014(/Z2u\u0003yy\u0005/\u001a8Ti\u0006\\WMR8sO\u0016\u0014H*[:u\u00076$7i\u001c:sK\u000e$\b%\u0001\u0006Va\u001e\u0014\u0018\rZ3D[\u0012\f1\"\u00169he\u0006$WmQ7eA\u0005Q1\u000b^1lK>37)\u001c3\u0002\u0017M#\u0018m[3PM\u000ekG\rI\u0001\u001f\u000f\u0016$\b+Y4fI\u001a{'oZ3sgN#\u0018m[3t\u001f\u001a,6/\u001a:D[\u0012\fqdR3u!\u0006<W\r\u001a$pe\u001e,'o]*uC.,7o\u00144Vg\u0016\u00148)\u001c3!\u0003y9W\r\u001e*f[>4Xm\u0015;bW\u0016\u001cU\u000eZ'fgN\fw-\u001a+p'&<g\u000eF\u0004}\u00077\u001aif!\u0019\t\r\u0005}T\t1\u0001}\u0011\u0019\u0019y&\u0012a\u0001g\u0006!aM]8n\u0011\u0019\u0019\u0019'\u0012a\u0001y\u0006)an\u001c8dK\u00061s-\u001a;Pa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e\u001b\u0016\u001c8/Y4f)>\u001c\u0016n\u001a8\u0015\u000fq\u001cIg!\u001c\u0004p!911\u000e$A\u0002\u0005E\u0012a\u00034pe\u001e,'/\u00138eKbDaaa\u0018G\u0001\u0004\u0019\bBBB2\r\u0002\u0007A0A\u0003baBd\u0017\u0010F\u0002p\u0007kBQ!Z$A\u0002\u001d\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004|\ru\u0004\u0003B/\u0002r\u001dD\u0001ba I\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\"\u0011\t\tE7qQ\u0005\u0005\u0007\u0013\u0013\u0019N\u0001\u0004PE*,7\r\u001e")
public class ForgerStakeMsgProcessor
extends NativeSmartContractMsgProcessor
implements ForgerStakesProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final NetworkParams networkParams;

    public static Option<NetworkParams> unapply(ForgerStakeMsgProcessor forgerStakeMsgProcessor) {
        return ForgerStakeMsgProcessor$.MODULE$.unapply(forgerStakeMsgProcessor);
    }

    public static ForgerStakeMsgProcessor apply(NetworkParams networkParams) {
        return ForgerStakeMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] getOpenStakeForgerListCmdMessageToSign(int n, Address address, byte[] byArray) {
        return ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(n, address, byArray);
    }

    public static byte[] getRemoveStakeCmdMessageToSign(byte[] byArray, Address address, byte[] byArray2) {
        return ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(byArray, address, byArray2);
    }

    public static String GetPagedForgersStakesOfUserCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetPagedForgersStakesOfUserCmd();
    }

    public static String StakeOfCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.StakeOfCmd();
    }

    public static String UpgradeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.UpgradeCmd();
    }

    public static String OpenStakeForgerListCmdCorrect() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
    }

    public static String OpenStakeForgerListCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
    }

    public static String RemoveStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
    }

    public static String AddNewStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
    }

    public static String GetListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
    }

    public static String GetPagedListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetPagedListOfForgersCmd();
    }

    public static byte[] RestrictedForgerFlagsList() {
        return ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    public byte[] getStakeId(Message msg) {
        return Keccak256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{msg.getFrom().toBytes(), msg.getNonce().toByteArray(), msg.getValue().toByteArray(), msg.getData()}));
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        super.init(view, consensusEpochNumber);
        Enumeration.Value forgingStakeStorageVersion = Version1_3_0Fork$.MODULE$.get(consensusEpochNumber).active() ? ForgerStakeStorageVersion$.MODULE$.VERSION_2() : ForgerStakeStorageVersion$.MODULE$.VERSION_1();
        ForgerStakeStorage forgingStakeStorage = ForgerStakeStorage$.MODULE$.apply(forgingStakeStorageVersion);
        forgingStakeStorage.setupStorage(view);
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("restrictForgerList already set");
        }
    }

    public Enumeration.Value getForgerStakeStorageVersion(BaseAccountStateView view, boolean isForkV1_3Active) {
        return isForkV1_3Active ? ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view) : ForgerStakeStorageVersion$.MODULE$.VERSION_1();
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId, boolean isForkV1_3Active) {
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        return stakeStorage.findStakeData(view, stakeId);
    }

    @Override
    public boolean isForgerStakeAvailable(BaseAccountStateView view, boolean isForkV1_3Active) {
        boolean bl;
        if (!isForkV1_3Active) {
            bl = true;
        } else {
            ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, true);
            bl = stakeStorage.isForgerStakeAvailable(view);
        }
        return bl;
    }

    @Override
    public byte[] addScCreationForgerStake(BaseAccountStateView view, Address owner, BigInteger value, AddNewStakeCmdInput data) {
        Message msg = new Message(owner, Optional.of(this.contractAddress()), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, value, BigInteger.ONE.negate(), Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), data.encode()}), false);
        return this.doAddNewStakeCmd(Invocation$.MODULE$.fromMessage(msg), view, msg, Version1_3_0Fork$.MODULE$.get(0).active(), true);
    }

    public byte[] doAddNewStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg, boolean isForkV1_3_Active, boolean isGenesisScCreation) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        BigInteger stakedAmount = invocation.value();
        if (stakedAmount.signum() <= 0) {
            throw new ExecutionRevertedException("Value must not be zero");
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount)) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Value is not a legal wei amount: ").append(stakedAmount.toString()).toString());
        }
        if (!view.accountExists(invocation.caller()) && !isGenesisScCreation) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(invocation.caller()).toString());
        }
        if (!this.isForgerStakeAvailable(view, isForkV1_3_Active)) {
            throw new ExecutionRevertedException("Unable to add new forger stake");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        AddNewStakeCmdInput cmdInput = (AddNewStakeCmdInput)AddNewStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPublicKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPublicKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        Address ownerAddress = cmdInput.ownerAddress();
        if (!view.isEoaAccount(ownerAddress)) {
            throw new ExecutionRevertedException("Owner account is not an EOA");
        }
        if (!(isGenesisScCreation || this.isForgerListOpen(view) || this.networkParams().allowedForgersList().contains((Object)new Tuple2((Object)blockSignPublicKey, (Object)vrfPublicKey)))) {
            throw new ExecutionRevertedException("Forger is not in the allowed list");
        }
        byte[] newStakeId = this.getStakeId(msg);
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3_Active);
        if (stakeStorage.existsStakeData(view, newStakeId)) {
            throw new ExecutionRevertedException(new StringBuilder(21).append("Stake ").append(BytesUtils.toHexString(newStakeId)).append(" already exists").toString());
        }
        stakeStorage.addForgerStake(view, newStakeId, blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Added stake to stateDb: newStakeId={}, blockSignPublicKey={}, vrfPublicKey={}, ownerAddress={}, stakedAmount={}", new Object[]{BytesUtils.toHexString(newStakeId), blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DelegateForgerStake addNewStakeEvt = DelegateForgerStake$.MODULE$.apply(invocation.caller(), ownerAddress, newStakeId, stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewStakeEvt);
        view.addLog(evmLog);
        if (isGenesisScCreation) {
            view.addBalance(this.contractAddress(), stakedAmount);
        } else {
            view.subBalance(invocation.caller(), stakedAmount);
            view.addBalance(this.contractAddress(), stakedAmount);
        }
        return newStakeId;
    }

    public boolean doAddNewStakeCmd$default$5() {
        return false;
    }

    private void checkInputDoesntContainParams(byte[] calldata) {
        if (ABIUtil.getArgumentsFromData(calldata).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(calldata.length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view, boolean isForkV1_3Active) {
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        return stakeStorage.getListOfForgersStakes(view);
    }

    @Override
    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakes(BaseAccountStateView view, int startPos, int pageSize) {
        return ForgerStakeStorageV2$.MODULE$.getPagedListOfForgersStakes(view, startPos, pageSize);
    }

    private ForgerStakeStorage getForgerStakeStorage(BaseAccountStateView view, boolean isForkV1_3Active) {
        Enumeration.Value forgerStakeStorageVersion = this.getForgerStakeStorageVersion(view, isForkV1_3Active);
        ForgerStakeStorage stakeStorage = ForgerStakeStorage$.MODULE$.apply(forgerStakeStorageVersion);
        return stakeStorage;
    }

    public byte[] doUncheckedGetListOfForgersStakesCmd(BaseAccountStateView view, boolean isForkV1_3Active) {
        Seq<AccountForgingStakeInfo> stakeList = this.getListOfForgersStakes(view, isForkV1_3Active);
        return AccountForgingStakeInfoListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(stakeList).asJava());
    }

    public byte[] doGetListOfForgersCmd(Invocation invocation, BaseAccountStateView view, boolean isForkV1_3Active) {
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation.input());
        return this.doUncheckedGetListOfForgersStakesCmd(view, isForkV1_3Active);
    }

    public byte[] doGetPagedListOfForgersCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        GetPagedListOfStakesCmdInput cmdInput = (GetPagedListOfStakesCmdInput)GetPagedListOfStakesCmdInputDecoder$.MODULE$.decode(inputParams);
        int size = cmdInput.size();
        int startPos = cmdInput.startPos();
        Tuple2<Object, Seq<AccountForgingStakeInfo>> tuple2 = this.getPagedListOfForgersStakes(view, startPos, size);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int nextPos = tuple2._1$mcI$sp();
        Seq stakeList = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextPos), (Object)stakeList);
        Tuple2 tuple23 = tuple22;
        int nextPos2 = tuple23._1$mcI$sp();
        Seq stakeList2 = (Seq)tuple23._2();
        return new PagedListOfStakesOutput(nextPos2, (Seq<AccountForgingStakeInfo>)stakeList2).encode();
    }

    public byte[] doUpgradeCmd(Invocation invocation, BaseAccountStateView view) {
        BoxedUnit boxedUnit;
        this.requireIsNotPayable(invocation);
        this.checkInputDoesntContainParams(invocation.input());
        Enumeration.Value value = ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view);
        Enumeration.Value value2 = ForgerStakeStorageVersion$.MODULE$.VERSION_2();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            BoxedUnit boxedUnit2;
            String msgStr = "Forger stake storage already upgraded";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        ForgerStakeStorage forgerStakeStorage = ForgerStakeStorage$.MODULE$.apply(ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), ForgerStakeStorageV1$.MODULE$.LinkedListTipKey());
        int numOfMigratedElem = 0;
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block10: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block9: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getStakeListItem(view, nodeReference);
                    if (tuple2 == null) break block9;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block9;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block10;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            forgerStakeStorage.addForgerStake(view, item.stakeId(), item.forgerStakeData().forgerPublicKeys().blockSignPublicKey(), item.forgerStakeData().forgerPublicKeys().vrfPublicKey(), item.forgerStakeData().ownerPublicKey().address(), item.forgerStakeData().stakedAmount());
            ForgerStakeLinkedList$.MODULE$.removeNode(view, item.stakeId(), this.contractAddress());
            nodeReference = prevNodeReference2;
            ++numOfMigratedElem;
        }
        view.removeAccountStorage(this.contractAddress(), ForgerStakeStorageV1$.MODULE$.LinkedListTipKey());
        StakeUpgrade upgradeEvent = StakeUpgrade$.MODULE$.apply(ForgerStakeStorageVersion$.MODULE$.VERSION_1().id(), ForgerStakeStorageVersion$.MODULE$.VERSION_2().id());
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(upgradeEvent);
        view.addLog(evmLog);
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Forger stakes storage upgraded successfully to version 2 - {} items migrated", new Object[]{BoxesRunTime.boxToInteger((int)numOfMigratedElem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ForgerStakeStorage$.MODULE$.saveStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
    }

    public void checkCurrentStorageVersion(BaseAccountStateView view, Enumeration.Value requiredStorageVersion) {
        Enumeration.Value value = ForgerStakeStorage$.MODULE$.getStorageVersionFromDb(view);
        Enumeration.Value value2 = requiredStorageVersion;
        if (value == null ? value2 != null : !value.equals(value2)) {
            BoxedUnit boxedUnit;
            String msgStr = "Forger stake storage not upgraded yet";
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    public byte[] doStakeOfCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        StakeOfCmdInput cmdInput = (StakeOfCmdInput)StakeOfCmdInputDecoder$.MODULE$.decode(inputParams);
        BigInteger totalStake = ForgerStakeStorageV2$.MODULE$.getOwnerStake(view, new AddressProposition(cmdInput.ownerAddress()));
        return new StakeAmount(totalStake).encode();
    }

    public byte[] doGetPagedForgersStakesOfUserCmd(Invocation invocation, BaseAccountStateView view) {
        this.requireIsNotPayable(invocation);
        this.checkCurrentStorageVersion(view, ForgerStakeStorageVersion$.MODULE$.VERSION_2());
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        GetPagedForgersStakesOfUserCmdInput cmdInput = (GetPagedForgersStakesOfUserCmdInput)GetPagedForgersStakesOfUserCmdInputDecoder$.MODULE$.decode(inputParams);
        Tuple2<Object, Seq<AccountForgingStakeInfo>> tuple2 = ForgerStakeStorageV2$.MODULE$.getPagedListOfForgersStakesOfUser(view, new AddressProposition(cmdInput.ownerAddress()), cmdInput.startPos(), cmdInput.size());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int nextPos = tuple2._1$mcI$sp();
        Seq stakeList = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextPos), (Object)stakeList);
        Tuple2 tuple23 = tuple22;
        int nextPos2 = tuple23._1$mcI$sp();
        Seq stakeList2 = (Seq)tuple23._2();
        return new PagedListOfStakesOutput(nextPos2, (Seq<AccountForgingStakeInfo>)stakeList2).encode();
    }

    public byte[] doRemoveStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg, boolean isForkV1_3Active) {
        boolean result;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        this.requireIsNotPayable(invocation);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RemoveStakeCmdInput cmdInput = (RemoveStakeCmdInput)RemoveStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        byte[] stakeId = cmdInput.stakeId();
        SignatureSecp256k1 signature = cmdInput.signature();
        ForgerStakeStorage stakeStorage = this.getForgerStakeStorage(view, isForkV1_3Active);
        ForgerStakeStorageElem stakeData = (ForgerStakeStorageElem)stakeStorage.findForgerStakeStorageElem(view, stakeId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("No such stake id in state-db");
        });
        byte[] msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(stakeId, invocation.caller(), msg.getNonce().toByteArray());
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> signature.isValid(stakeData.ownerPublicKey(), msgToSign));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(39).append("Could not verify ill-formed signature: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean bl = result = BoxesRunTime.unboxToBoolean((Object)success.value());
        boolean isValid = bl;
        if (!isValid) {
            throw new ExecutionRevertedException("Invalid signature");
        }
        stakeStorage.removeForgerStake(view, stakeId, stakeData);
        WithdrawForgerStake removeStakeEvt = WithdrawForgerStake$.MODULE$.apply(stakeData.ownerPublicKey().address(), stakeId);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakeData.stakedAmount());
        view.addBalance(stakeData.ownerPublicKey().address(), stakeData.stakedAmount());
        return stakeId;
    }

    private byte[] getAllowedForgersIndexList(BaseAccountStateView view) {
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new IllegalStateException("Illegal call when list of forger is empty");
        }
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32())) ? new byte[this.networkParams().allowedForgersList().size()] : view.getAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
    }

    public byte[] doOpenStakeForgerListCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        byte[] msgToSign;
        if (!this.networkParams().restrictForgers()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is not restricted");
        }
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is empty");
        }
        this.requireIsNotPayable(invocation);
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        OpenStakeForgerListCmdInput cmdInput = (OpenStakeForgerListCmdInput)OpenStakeForgerListCmdInputDecoder$.MODULE$.decode(inputParams);
        int forgerIndex = cmdInput.forgerIndex();
        Signature25519 signature = cmdInput.signature();
        if (this.networkParams().allowedForgersList().size() < forgerIndex + 1) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Invalid forgerIndex=").append(forgerIndex).append(": allowedForgersList size=").append(this.networkParams().allowedForgersList().size()).toString());
        }
        PublicKey25519Proposition blockSignerProposition = (PublicKey25519Proposition)((Tuple2)this.networkParams().allowedForgersList().apply(forgerIndex))._1();
        if (!signature.isValid(blockSignerProposition, msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(forgerIndex, invocation.caller(), msg.getNonce().toByteArray()))) {
            throw new ExecutionRevertedException(new StringBuilder(69).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignerProposition).toString());
        }
        byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
        if (this.isForgerListOpenUnchecked(restrictForgerList)) {
            throw new ExecutionRevertedException("Forger list already open");
        }
        if (restrictForgerList[forgerIndex] == 1) {
            throw new ExecutionRevertedException("Forger index already processed");
        }
        restrictForgerList[forgerIndex] = 1;
        view.updateAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList(), restrictForgerList);
        OpenForgerList addOpenStakeForgerListEvt = OpenForgerList$.MODULE$.apply(forgerIndex, invocation.caller(), blockSignerProposition);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addOpenStakeForgerListEvt);
        view.addLog(evmLog);
        return restrictForgerList;
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, ExecutionContext context) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = ForgerStakeMsgProcessor$.MODULE$.GetPagedListOfForgersCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
            byArray = this.doGetPagedListOfForgersCmd(invocation, gasView);
        } else {
            String string4 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doGetListOfForgersCmd(invocation, gasView, Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active());
            } else {
                String string6 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doAddNewStakeCmd(invocation, gasView, context.msg(), Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active(), this.doAddNewStakeCmd$default$5());
                } else {
                    String string8 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doRemoveStakeCmd(invocation, gasView, context.msg(), Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active());
                    } else {
                        String string10 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            byArray = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                        } else {
                            String string12 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null) && Version1_2_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                byArray = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                            } else {
                                String string14 = ForgerStakeMsgProcessor$.MODULE$.UpgradeCmd();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                    byArray = this.doUpgradeCmd(invocation, view);
                                } else {
                                    String string16 = ForgerStakeMsgProcessor$.MODULE$.StakeOfCmd();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                        byArray = this.doStakeOfCmd(invocation, gasView);
                                    } else {
                                        String string18 = ForgerStakeMsgProcessor$.MODULE$.GetPagedForgersStakesOfUserCmd();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null) && Version1_3_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                                            byArray = this.doGetPagedForgersStakesOfUserCmd(invocation, gasView);
                                        } else {
                                            throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public boolean isForgerListOpen(BaseAccountStateView view) {
        boolean bl;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            bl = this.isForgerListOpenUnchecked(restrictForgerList);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isForgerListOpenUnchecked(byte[] list) {
        return BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(list)).sum((Numeric)Numeric.ByteIsIntegral$.MODULE$)) > list.length / 2;
    }

    @Override
    public Seq<Object> getAllowedForgerListIndexes(BaseAccountStateView view) {
        Seq seq;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            seq = (Seq)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$4)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public ForgerStakeMsgProcessor copy(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ForgerStakeMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ForgerStakeMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ForgerStakeMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ForgerStakeMsgProcessor forgerStakeMsgProcessor = (ForgerStakeMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = forgerStakeMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!forgerStakeMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public ForgerStakeMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeSmartContractCode");
        this.networkParams = params;
    }
}

