/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.ForgerStakeMsgProcessor;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import sparkz.crypto.hash.Blake2b256$;

public final class ForgerStakeMsgProcessor$
implements Serializable {
    public static ForgerStakeMsgProcessor$ MODULE$;
    private final byte[] RestrictedForgerFlagsList;
    private final String GetPagedListOfForgersCmd;
    private final String GetListOfForgersCmd;
    private final String AddNewStakeCmd;
    private final String RemoveStakeCmd;
    private final String OpenStakeForgerListCmd;
    private final String OpenStakeForgerListCmdCorrect;
    private final String UpgradeCmd;
    private final String StakeOfCmd;
    private final String GetPagedForgersStakesOfUserCmd;

    static {
        new ForgerStakeMsgProcessor$();
    }

    public byte[] RestrictedForgerFlagsList() {
        return this.RestrictedForgerFlagsList;
    }

    public String GetPagedListOfForgersCmd() {
        return this.GetPagedListOfForgersCmd;
    }

    public String GetListOfForgersCmd() {
        return this.GetListOfForgersCmd;
    }

    public String AddNewStakeCmd() {
        return this.AddNewStakeCmd;
    }

    public String RemoveStakeCmd() {
        return this.RemoveStakeCmd;
    }

    public String OpenStakeForgerListCmd() {
        return this.OpenStakeForgerListCmd;
    }

    public String OpenStakeForgerListCmdCorrect() {
        return this.OpenStakeForgerListCmdCorrect;
    }

    public String UpgradeCmd() {
        return this.UpgradeCmd;
    }

    public String StakeOfCmd() {
        return this.StakeOfCmd;
    }

    public String GetPagedForgersStakesOfUserCmd() {
        return this.GetPagedForgersStakesOfUserCmd;
    }

    public byte[] getRemoveStakeCmdMessageToSign(byte[] stakeId, Address from, byte[] nonce) {
        return Bytes.concat((byte[][])new byte[][]{from.toBytes(), nonce, stakeId});
    }

    public byte[] getOpenStakeForgerListCmdMessageToSign(int forgerIndex, Address from, byte[] nonce) {
        Predef$.MODULE$.require(forgerIndex >= 0);
        return Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)forgerIndex), from.toBytes(), nonce});
    }

    public ForgerStakeMsgProcessor apply(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public Option<NetworkParams> unapply(ForgerStakeMsgProcessor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.params());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ForgerStakeMsgProcessor$() {
        MODULE$ = this;
        this.RestrictedForgerFlagsList = Blake2b256$.MODULE$.hash("ClosedForgerList");
        this.GetPagedListOfForgersCmd = ABIUtil.getABIMethodId("getPagedForgersStakes(int32,int32)");
        this.GetListOfForgersCmd = ABIUtil.getABIMethodId("getAllForgersStakes()");
        this.AddNewStakeCmd = ABIUtil.getABIMethodId("delegate(bytes32,bytes32,bytes1,address)");
        this.RemoveStakeCmd = ABIUtil.getABIMethodId("withdraw(bytes32,bytes1,bytes32,bytes32)");
        this.OpenStakeForgerListCmd = ABIUtil.getABIMethodId("openStakeForgerList(uint32,bytes32,bytes32");
        this.OpenStakeForgerListCmdCorrect = ABIUtil.getABIMethodId("openStakeForgerList(uint32,bytes32,bytes32)");
        this.UpgradeCmd = ABIUtil.getABIMethodId("upgrade()");
        this.StakeOfCmd = ABIUtil.getABIMethodId("stakeOf(address)");
        this.GetPagedForgersStakesOfUserCmd = ABIUtil.getABIMethodId("getPagedForgersStakesByUser(address,int32,int32)");
        Predef$.MODULE$.require(this.GetPagedListOfForgersCmd().length() == 8 && this.GetListOfForgersCmd().length() == 8 && this.AddNewStakeCmd().length() == 8 && this.RemoveStakeCmd().length() == 8 && this.OpenStakeForgerListCmd().length() == 8 && this.OpenStakeForgerListCmdCorrect().length() == 8 && this.UpgradeCmd().length() == 8 && this.StakeOfCmd().length() == 8 && this.GetPagedForgersStakesOfUserCmd().length() == 8);
    }
}

