/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.horizen.certnative.BackwardTransfer;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.history.validation.InvalidTransactionChainIdException;
import io.horizen.account.history.validation.InvalidTransactionChainIdException$;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.StateDbAccountStateView$;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.utils.Secp256k1;
import io.horizen.block.MainchainBackwardTransferCertificateOutput;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.state.State;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.transaction.Transaction;
import sparkz.core.transaction.state.TransactionValidation;
import sparkz.core.utils.NetworkTimeProvider;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0011%f\u0001B#G\u0001=C!\"a\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0017\u0011)\tI\u0004\u0001B\u0001B\u0003%\u0011q\u0006\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\n\u0005u\u0002BCA$\u0001\t\u0005\t\u0015!\u0003\u0002J!Q\u0011q\n\u0001\u0003\u0006\u0004%\t%!\u0015\t\u0015\u0005=\u0004A!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002r\u0001\u0011\t\u0011)A\u0005\u0003gB!\"a \u0001\u0005\u0003\u0005\u000b\u0011BAA\u0011)\ti\t\u0001B\u0001B\u0003%\u0011q\u0012\u0005\b\u0003S\u0003A\u0011AAV\u000b\u0015\tY\f\u0001\u0011p\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002X\u0002!I!!7\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!q\u0005\u0001\u0005B\t%\u0002b\u0002B\u001e\u0001\u0011\u0005#Q\b\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqAa\u0014\u0001\t\u0003\u0011\t\u0006C\u0004\u0003j\u0001!\tEa\u001b\t\u000f\te\u0004\u0001\"\u0011\u0003|!9!1\u0013\u0001\u0005B\tU\u0005b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005\u000b\u0004A\u0011\tBd\u0011\u001d\u0011Y\r\u0001C!\u0005\u001bDqA!9\u0001\t\u0003\u0012\u0019\u000fC\u0004\u0003l\u0002!\tE!<\t\u000f\tE\b\u0001\"\u0011\u0003t\"9!Q\u001f\u0001\u0005B\t]\b\"CB\u000b\u0001E\u0005I\u0011AB\f\u0011\u001d\u0019i\u0003\u0001C!\u0007_Aqa!\r\u0001\t\u0003\u001a\u0019\u0004C\u0004\u00048\u0001!\te!\u000f\t\u000f\r%\u0003\u0001\"\u0011\u0004L!91\u0011\f\u0001\u0005B\rm\u0003bBB<\u0001\u0011\u00053\u0011\u0010\u0005\b\u0007w\u0002A\u0011IB?\u0011\u001d\u0019\t\t\u0001C!\u0007\u0007Cqaa\"\u0001\t\u0003\u001aI\tC\u0004\u0004\u0018\u0002!\te!'\t\u000f\r\u0015\u0006\u0001\"\u0011\u0004(\"911\u0016\u0001\u0005B\r5\u0006bBBg\u0001\u0011\u00053q\u001a\u0005\n\u0007?\u0004\u0011\u0013!C\u0001\u0007CDqa!:\u0001\t\u0003\u001a9\u000fC\u0004\u0004r\u0002!\tea=\t\u000f\re\b\u0001\"\u0011\u0004|\"9Aq\u0002\u0001\u0005B\re\u0004b\u0002C\t\u0001\u0011\u0005C1\u0003\u0005\b\t/\u0001A\u0011\tC\r\u0011\u001d!Y\u0002\u0001C!\t;Aq\u0001\"\u000b\u0001\t\u0003\"Y\u0003C\u0004\u00054\u0001!\t\u0005\"\u000e\t\u000f\u0011u\u0002\u0001\"\u0011\u0005@!9AQ\t\u0001\u0005B\u0011\u001d\u0003b\u0002C&\u0001\u0011\u0005CQ\n\u0005\b\t#\u0002A\u0011\tC*\u0011\u001d!9\u0006\u0001C!\t3Bq\u0001\"\u0019\u0001\t\u0003\"\u0019\u0007C\u0004\u0005f\u0001!\t\u0005b\u0019\t\u000f\u0011\u001d\u0004\u0001\"\u0011\u0005j!9AQ\u000e\u0001\u0005B\u0011=ta\u0002C;\r\"\u0005Aq\u000f\u0004\u0007\u000b\u001aC\t\u0001\"\u001f\t\u000f\u0005%\u0016\t\"\u0001\u0005\u0002\"AA1Q!\u0005\u0002)#)\t\u0003\u0005\u0005\u0016\u0006#\tA\u0013CL\u00051\t5mY8v]R\u001cF/\u0019;f\u0015\t9\u0005*A\u0003ti\u0006$XM\u0003\u0002J\u0015\u00069\u0011mY2pk:$(BA&M\u0003\u001dAwN]5{K:T\u0011!T\u0001\u0003S>\u001c\u0001a\u0005\u0006\u0001!FL\u0018qAA\n\u0003?\u0001b!\u0015*UM2|W\"\u0001&\n\u0005MS%!D!cgR\u0014\u0018m\u0019;Ti\u0006$X\r\u0005\u0003V1j\u0003W\"\u0001,\u000b\u0005]C\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:L!!\u0017,\u0003%\u0005\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\u001c\t\u00037zk\u0011\u0001\u0018\u0006\u0003;*\u000b1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&\u0011q\f\u0018\u0002\f!J|\u0007o\\:ji&|g\u000eE\u0002bIjk\u0011A\u0019\u0006\u0003G*\u000bQ\u0001\u001d:p_\u001aL!!\u001a2\u0003\u000bA\u0013xn\u001c4\u0011\u0005\u001dTW\"\u00015\u000b\u0005%D\u0015!\u00022m_\u000e\\\u0017BA6i\u0005I\t5mY8v]R\u0014En\\2l\u0011\u0016\fG-\u001a:\u0011\u0005\u001dl\u0017B\u00018i\u00051\t5mY8v]R\u0014En\\2l!\t\u0001\b!D\u0001G!\u0019\u0011H\u000f\u00167w_6\t1O\u0003\u0002H\u0015&\u0011Qo\u001d\u0002\u0006'R\fG/\u001a\t\u0003a^L!\u0001\u001f$\u0003!\u0005\u001b7m\\;oiN#\u0018\r^3WS\u0016<\b\u0003\u0002>\u0002\u0004Qk\u0011a\u001f\u0006\u0003\u000frT!aV?\u000b\u0005y|\u0018\u0001B2pe\u0016T!!!\u0001\u0002\rM\u0004\u0018M]6{\u0013\r\t)a\u001f\u0002\u0016)J\fgn]1di&|gNV1mS\u0012\fG/[8o!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\u0011\u0006!an\u001c3f\u0013\u0011\t\t\"a\u0003\u0003!9{G-Z!dG>,h\u000e^*uCR,\u0007\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e!*A\u0003vi&d7/\u0003\u0003\u0002\u001e\u0005]!aF\"m_N\f'\r\\3SKN|WO]2f\u0011\u0006tG\r\\3s!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u007f\u0006!Q\u000f^5m\u0013\u0011\tI#a\t\u0003\u001bM\u0003\u0018M]6{\u0019><w-\u001b8h\u0003\u0019\u0001\u0018M]1ngV\u0011\u0011q\u0006\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0019\u00111\u0006&\n\t\u0005]\u00121\u0007\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002\u000fA\f'/Y7tA\u0005aA/[7f!J|g/\u001b3feB!\u0011qHA\"\u001b\t\t\tEC\u0002\u0002\u001auLA!!\u0012\u0002B\t\u0019b*\u001a;x_J\\G+[7f!J|g/\u001b3fe\u0006\t\"\r\\8dW\"\u000b7\u000f\u001b)s_ZLG-\u001a:\u0011\u0007A\fY%C\u0002\u0002N\u0019\u0013\u0001\u0004S5ti>\u0014\u0018P\u00117pG.D\u0015m\u001d5Qe>4\u0018\u000eZ3s\u0003\u001d1XM]:j_:,\"!a\u0015\u0011\t\u0005U\u0013\u0011\u000e\b\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\rd\u0002BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c*\u0001\u0004=e>|GOP\u0005\u0003\u0003\u0003I!A`@\n\u0007\u0005\u001dT0A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u000b-\u0016\u00148/[8o)\u0006<'bAA4{\u0006Aa/\u001a:tS>t\u0007%\u0001\u000bti\u0006$X-T3uC\u0012\fG/Y*u_J\fw-\u001a\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010%\u0002\u000fM$xN]1hK&!\u0011QPA<\u0005m\t5mY8v]R\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uCN#xN]1hK\u0006q1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,\u0007\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d%*A\u0002fm6LA!a#\u0002\u0006\nAA)\u0019;bE\u0006\u001cX-A\tnKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004b!!%\u0002\u001e\u0006\rf\u0002BAJ\u00033sA!a\u0017\u0002\u0016&\u0011\u0011qS\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003O\nYJ\u0003\u0002\u0002\u0018&!\u0011qTAQ\u0005\r\u0019V-\u001d\u0006\u0005\u0003O\nY\nE\u0002q\u0003KK1!a*G\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/\u0001\u0004=S:LGO\u0010\u000b\u0010_\u00065\u0016qVAY\u0003g\u000b),a.\u0002:\"9\u00111\u0006\u0006A\u0002\u0005=\u0002bBA\u001e\u0015\u0001\u0007\u0011Q\b\u0005\b\u0003\u000fR\u0001\u0019AA%\u0011\u001d\tyE\u0003a\u0001\u0003'Bq!!\u001d\u000b\u0001\u0004\t\u0019\bC\u0004\u0002\u0000)\u0001\r!!!\t\u000f\u00055%\u00021\u0001\u0002\u0010\n!aJV\"U\u00039Ig.\u001b;Qe>\u001cWm]:peN$B!!1\u0002LB)\u00111YAd_6\u0011\u0011Q\u0019\u0006\u0005\u0003K\tY*\u0003\u0003\u0002J\u0006\u0015'a\u0001+ss\"9\u0011Q\u001a\u0007A\u0002\u0005M\u0013AD5oSRL\u0017\r\u001c,feNLwN\\\u0001\u000eCB\u0004H._'pI&4\u0017.\u001a:\u0015\t\u0005\u0005\u00171\u001b\u0005\u0007\u0003+l\u0001\u0019\u00017\u0002\u00075|G-A\tfm\u0006dgi\u001c:hKJ\u001c(+Z<be\u0012$\"\"a7\u0002d\u0006\u0015\u0018q\u001eB\b!\u0011\ti.a8\u000e\u0005\u0005m\u0015\u0002BAq\u00037\u0013A!\u00168ji\"1\u0011Q\u001b\bA\u00021Dq!a:\u000f\u0001\u0004\tI/\u0001\fn_\u0012<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p!\u0011\t)\"a;\n\t\u00055\u0018q\u0003\u0002\u0014/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\u001c\u0005\b\u0003ct\u0001\u0019AAz\u0003Q\u0019wN\\:f]N,8/\u00129pG\"tU/\u001c2feB!\u0011Q\u001fB\u0005\u001d\u0011\t9P!\u0002\u000f\t\u0005e(\u0011\u0001\b\u0005\u0003w\fyP\u0004\u0003\u0002\\\u0005u\u0018\"A'\n\u0005-c\u0015b\u0001B\u0002\u0015\u0006I1m\u001c8tK:\u001cXo]\u0005\u0005\u0003O\u00129AC\u0002\u0003\u0004)KAAa\u0003\u0003\u000e\t!2i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJTA!a\u001a\u0003\b!1!\u0011\u0003\bA\u0002Y\f\u0011b\u001d;bi\u00164\u0016.Z<\u0002;Y\fG.\u001b3bi\u0016$v\u000e])vC2LG/_\"feRLg-[2bi\u0016$b!a7\u0003\u0018\t\u0015\u0002b\u0002B\r\u001f\u0001\u0007!1D\u0001\u0016i>\u0004\u0018+^1mSRL8)\u001a:uS\u001aL7-\u0019;f!\u0011\u0011iB!\t\u000e\u0005\t}!BA5K\u0013\u0011\u0011\u0019Ca\b\u00035]KG\u000f\u001b3sC^\fG.\u00129pG\"\u001cUM\u001d;jM&\u001c\u0017\r^3\t\r\tEq\u00021\u0001w\u0003eI7oU<ji\u000eD\u0017N\\4D_:\u001cXM\\:vg\u0016\u0003xn\u00195\u0015\t\t-\"\u0011\u0007\t\u0005\u0003;\u0014i#\u0003\u0003\u00030\u0005m%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005g\u0001\u0002\u0019\u0001B\u001b\u00039\u0011Gn\\2l)&lWm\u0015;b[B\u0004B!!8\u00038%!!\u0011HAN\u0005\u0011auN\\4\u0002\u0015I|G\u000e\u001c2bG.$v\u000e\u0006\u0003\u0002B\n}\u0002bBA(#\u0001\u0007\u00111K\u0001\u0011[\u0006D(k\u001c7mE\u0006\u001c7\u000eR3qi\",\"A!\u0012\u0011\t\u0005u'qI\u0005\u0005\u0005\u0013\nYJA\u0002J]R\fqaZ3u-&,w/F\u0001w\u0003Y9W\r^*uCR,GI\u0019,jK^4%o\\7S_>$H\u0003\u0002B*\u00053\u00022\u0001\u001dB+\u0013\r\u00119F\u0012\u0002\u0018'R\fG/\u001a#c\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^DqAa\u0017\u0015\u0001\u0004\u0011i&A\u0005ti\u0006$XMU8piB1\u0011Q\u001cB0\u0005GJAA!\u0019\u0002\u001c\n)\u0011I\u001d:bsB!\u0011Q\u001cB3\u0013\u0011\u00119'a'\u0003\t\tKH/Z\u0001\u0016O\u0016$x+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;t)\u0011\u0011iG!\u001e\u0011\r\u0005E\u0015Q\u0014B8!\r\u0001(\u0011O\u0005\u0004\u0005g2%!E,ji\"$'/Y<bYJ+\u0017/^3ti\"9!qO\u000bA\u0002\t\u0015\u0013aD<ji\"$'/Y<bY\u0016\u0003xn\u00195\u0002#\t\f7m[<be\u0012$&/\u00198tM\u0016\u00148\u000f\u0006\u0003\u0003~\tE\u0005CBAI\u0003;\u0013y\b\u0005\u0003\u0003\u0002\n5UB\u0001BB\u0015\u0011\u0011)Ia\"\u0002\u0015\r,'\u000f\u001e8bi&4XMC\u0002L\u0005\u0013S!Aa#\u0002\u0007\r|W.\u0003\u0003\u0003\u0010\n\r%\u0001\u0005\"bG.<\u0018M\u001d3Ue\u0006t7OZ3s\u0011\u001d\u00119H\u0006a\u0001\u0005\u000b\n\u0001c[3z%>$\u0018\r^5p]B\u0013xn\u001c4\u0015\u0011\t]%Q\u0016BX\u0005g\u0003b!!8\u0003\u001a\nu\u0015\u0002\u0002BN\u00037\u0013aa\u00149uS>t\u0007\u0003\u0002BP\u0005Sk!A!)\u000b\t\t\r&QU\u0001\u0005W\u0016L8OC\u0002\u0003(*\u000bAcY3si&4\u0017nY1uKN,(-\\5ui\u0016\u0014\u0018\u0002\u0002BV\u0005C\u0013\u0001cS3z%>$\u0018\r^5p]B\u0013xn\u001c4\t\u000f\t]t\u00031\u0001\u0003F!9!\u0011W\fA\u0002\t\u0015\u0013!D5oI\u0016DxJZ*jO:,'\u000fC\u0004\u00036^\u0001\rA!\u0012\u0002\u000f-,\u0017\u0010V=qK\u0006q1-\u001a:uS\u001aLWM]:LKf\u001cH\u0003\u0002B^\u0005\u0007\u0004b!!8\u0003\u001a\nu\u0006\u0003\u0002BP\u0005\u007fKAA!1\u0003\"\nq1)\u001a:uS\u001aLWM]:LKf\u001c\bb\u0002B<1\u0001\u0007!QI\u0001\u001fY\u0006\u001cHoQ3si&4\u0017nY1uKJ+g-\u001a:f]\u000e,G-\u00129pG\",\"A!3\u0011\r\u0005u'\u0011\u0014B#\u0003}a\u0017m\u001d;DKJ$\u0018NZ5dCR,7+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u000b\u0003\u0005\u001f\u0004b!!8\u0003\u001a\nE\u0007\u0003\u0002Bj\u00057tAA!6\u0003Z:!\u0011\u0011\fBl\u0013\r\t)c`\u0005\u0005\u0003O\n\u0019#\u0003\u0003\u0003^\n}'AC'pI&4\u0017.\u001a:JI*!\u0011qMA\u0012\u0003-\u0019WM\u001d;jM&\u001c\u0017\r^3\u0015\t\t\u0015(q\u001d\t\u0007\u0003;\u0014IJa\u0007\t\u000f\t%8\u00041\u0001\u0003F\u0005I\"/\u001a4fe\u0016t7-\u001a3XSRDGM]1xC2,\u0005o\\2i\u0003a9W\r\u001e+paF+\u0018\r\\5us\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0005\u0005K\u0014y\u000fC\u0004\u0003jr\u0001\rA!\u0012\u0002\u0013!\f7oQ3bg\u0016$GC\u0001B\u0016\u0003I9W\r\u001e$fKB\u000b\u00170\\3oiNLeNZ8\u0015\u0011\te8QAB\u0004\u0007\u0013\u0001b!!%\u0002\u001e\nm\b\u0003\u0002B\u007f\u0007\u0003i!Aa@\u000b\u0007\u0005e\u0001*\u0003\u0003\u0004\u0004\t}(AD!dG>,h\u000e\u001e)bs6,g\u000e\u001e\u0005\b\u0005or\u0002\u0019\u0001B#\u0011\u001d\t\tP\ba\u0001\u0003gD\u0011ba\u0003\u001f!\u0003\u0005\ra!\u0004\u0002)\tdwnY6U_\u0006\u0003\b/\u001a8e\r\u0016,\u0017J\u001c4p!\u0019\tiN!'\u0004\u0010A!!Q`B\t\u0013\u0011\u0019\u0019Ba@\u0003'\u0005\u001b7m\\;oi\ncwnY6GK\u0016LeNZ8\u00029\u001d,GOR3f!\u0006LX.\u001a8ug&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0004\u0016\u0005\u0007\u001b\u0019Yb\u000b\u0002\u0004\u001eA!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012!C;oG\",7m[3e\u0015\u0011\u00199#a'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004,\r\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061r-\u001a;XSRDGM]1xC2,\u0005o\\2i\u0013:4w.\u0006\u0002\u0002j\u00069r-\u001a;D_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM]\u000b\u0003\u0007k\u0001b!!8\u0003\u001a\u0006M\u0018AH4fi>\u0013H-\u001a:fI\u001a{'oZ5oON#\u0018m[3t\u0013:4wnU3r)\u0011\u0019Yd!\u0012\u0011\r\u0005E\u0015QTB\u001f!\u0011\u0019yd!\u0011\u000e\u0005\t\u001d\u0011\u0002BB\"\u0005\u000f\u0011\u0001CR8sO&twm\u0015;bW\u0016LeNZ8\t\u000f\r\u001d#\u00051\u0001\u0003F\u0005YQ\r]8dQ:+XNY3s\u0003q9W\r^\"veJ,g\u000e^\"p]N,gn];t\u000bB|7\r[%oM>,\"a!\u0014\u0011\u0011\u0005u7q\nBi\u0007'JAa!\u0015\u0002\u001c\n1A+\u001e9mKJ\u0002Baa\u0010\u0004V%!1q\u000bB\u0004\u0005I\u0019uN\\:f]N,8/\u00129pG\"LeNZ8\u0002\u0015\u001d,GOQ1mC:\u001cW\r\u0006\u0003\u0004^\r5\u0004\u0003BB0\u0007Sj!a!\u0019\u000b\t\r\r4QM\u0001\u0005[\u0006$\bN\u0003\u0002\u0004h\u0005!!.\u0019<b\u0013\u0011\u0019Yg!\u0019\u0003\u0015\tKw-\u00138uK\u001e,'\u000fC\u0004\u0004p\u0011\u0002\ra!\u001d\u0002\u000f\u0005$GM]3tgB!\u00111QB:\u0013\u0011\u0019)(!\"\u0003\u000f\u0005#GM]3tg\u0006\u0019r-\u001a;BG\u000e|WO\u001c;Ti\u0006$XMU8piV\u0011!QL\u0001\fO\u0016$8i\u001c3f\u0011\u0006\u001c\b\u000e\u0006\u0003\u0003^\r}\u0004bBB8M\u0001\u00071\u0011O\u0001\tO\u0016$hj\u001c8dKR!1QLBC\u0011\u001d\u0019yg\na\u0001\u0007c\nacZ3u\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm\u001d\u000b\u0005\u0007\u0017\u001b\u0019\n\u0005\u0004\u0002\u0012\u0006u5Q\u0012\t\u0004a\u000e=\u0015bABI\r\n9\u0012iY2pk:$hi\u001c:hS:<7\u000b^1lK&sgm\u001c\u0005\b\u0007+C\u0003\u0019\u0001B\u0016\u0003AI7OR8sWZ\u000btlM!di&4X-A\u000ehKR\u0004\u0016mZ3e\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm\u001d\u000b\u0007\u00077\u001bij!)\u0011\u0011\u0005u7q\nB#\u0007\u0017Cqaa(*\u0001\u0004\u0011)%\u0001\u0005ti\u0006\u0014H\u000fU8t\u0011\u001d\u0019\u0019+\u000ba\u0001\u0005\u000b\n\u0001\u0002]1hKNK'0Z\u0001\u0015O\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJd\u0015n\u001d;\u0016\u0005\r%\u0006CBAI\u0003;\u0013)%\u0001\nhKR4uN]4feN#\u0018m[3ECR\fGCBBX\u0007o\u001bY\r\u0005\u0004\u0002^\ne5\u0011\u0017\t\u0004a\u000eM\u0016bAB[\r\nyai\u001c:hKJ\u001cF/Y6f\t\u0006$\u0018\rC\u0004\u0004:.\u0002\raa/\u0002\u000fM$\u0018m[3JIB!1QXBc\u001d\u0011\u0019yl!1\u0011\t\u0005m\u00131T\u0005\u0005\u0007\u0007\fY*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007\u000f\u001cIM\u0001\u0004TiJLgn\u001a\u0006\u0005\u0007\u0007\fY\nC\u0004\u0004\u0016.\u0002\rAa\u000b\u00023\u001d,G\u000fT5ti>3WjY!eIJ|uO\\3sg\"L\u0007o\u001d\u000b\u0005\u0007#\u001cI\u000e\u0005\u0004\u0002\u0012\u0006u51\u001b\t\u0004a\u000eU\u0017bABl\r\n\u0019RjY!eIJ|uO\\3sg\"L\u0007\u000fR1uC\"I11\u001c\u0017\u0011\u0002\u0003\u00071Q\\\u0001\rg\u000e\fE\r\u001a:fgN|\u0005\u000f\u001e\t\u0007\u0003;\u0014Ija/\u0002G\u001d,G\u000fT5ti>3WjY!eIJ|uO\\3sg\"L\u0007o\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u001d\u0016\u0005\u0007;\u001cY\"A\rhKRd\u0015n\u001d;PM>;h.\u001a:TG\u0006#GM]3tg\u0016\u001cHCABu!\u0019\t\t*!(\u0004lB\u0019\u0001o!<\n\u0007\r=hI\u0001\bPo:,'oU2BI\u0012\u0014Xm]:\u0002%=<h.\u001a:tQ&\u0004H)\u0019;b\u000bbL7\u000f\u001e\u000b\u0005\u0005W\u0019)\u0010C\u0004\u0004x>\u0002\rA!\u0018\u0002\u0017=<h.\u001a:tQ&\u0004\u0018\nZ\u0001\bO\u0016$Hj\\4t)\u0011\u0019i\u0010b\u0003\u0011\r\u0005u'qLB\u0000!\u0011!\t\u0001b\u0002\u000e\u0005\u0011\r!b\u0001C\u0003\r\u00069!/Z2fSB$\u0018\u0002\u0002C\u0005\t\u0007\u0011\u0001$\u0012;iKJ,W/\\\"p]N,gn];t\t\u0006$\u0018\rT8h\u0011\u001d!i\u0001\ra\u0001\u0005;\na\u0001\u001e=ICND\u0017aE4fi&sG/\u001a:nK\u0012L\u0017\r^3S_>$\u0018aB4fi\u000e{G-\u001a\u000b\u0005\u0005;\")\u0002C\u0004\u0004pI\u0002\ra!\u001d\u0002\u001d\u001d,GOT3yi\n\u000b7/\u001a$fKV\u00111QL\u0001\u0016O\u0016$HK]1og\u0006\u001cG/[8o%\u0016\u001cW-\u001b9u)\u0011!y\u0002b\n\u0011\r\u0005u'\u0011\u0014C\u0011!\u0011!\t\u0001b\t\n\t\u0011\u0015B1\u0001\u0002\u0010\u000bRDWM]3v[J+7-Z5qi\"9AQ\u0002\u001bA\u0002\tu\u0013\u0001E4fiN#\u0018\r^3EE\"\u000bg\u000e\u001a7f+\t!i\u0003\u0005\u0003\u0002\u0004\u0012=\u0012\u0002\u0002C\u0019\u0003\u000b\u0013aBU3t_V\u00148-\u001a%b]\u0012dW-A\thKR\f5mY8v]R\u001cFo\u001c:bO\u0016$bA!\u0018\u00058\u0011e\u0002bBB8m\u0001\u00071\u0011\u000f\u0005\b\tw1\u0004\u0019\u0001B/\u0003\rYW-_\u0001\u0017O\u0016$\u0018iY2pk:$8\u000b^8sC\u001e,')\u001f;fgR1!Q\fC!\t\u0007Bqaa\u001c8\u0001\u0004\u0019\t\bC\u0004\u0005<]\u0002\rA!\u0018\u0002\u001b\u0005\u001c7m\\;oi\u0016C\u0018n\u001d;t)\u0011\u0011Y\u0003\"\u0013\t\u000f\r=\u0004\b1\u0001\u0004r\u0005a\u0011n]#pC\u0006\u001b7m\\;oiR!!1\u0006C(\u0011\u001d\u0019y'\u000fa\u0001\u0007c\na#[:T[\u0006\u0014HoQ8oiJ\f7\r^!dG>,h\u000e\u001e\u000b\u0005\u0005W!)\u0006C\u0004\u0004pi\u0002\ra!\u001d\u0002\u0011Y\fG.\u001b3bi\u0016$B\u0001b\u0017\u0005^A1\u00111YAd\u00037Da\u0001b\u0018<\u0001\u0004!\u0016A\u0001;y\u0003iI7oV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b'bgRLe\u000eZ3y+\t\u0011Y#A\u0007jg\u001a{'oZ5oO>\u0003XM\\\u0001\u0017SN4uN]4feN#\u0018m[3Bm\u0006LG.\u00192mKR!!1\u0006C6\u0011\u001d\u0019)J\u0010a\u0001\u0005W\t!#\u001e;y_6+'o\u001b7f)J,WMU8piR!A\u0011\u000fC:!\u0019\tiN!'\u0003^!9!qO A\u0002\t\u0015\u0013\u0001D!dG>,h\u000e^*uCR,\u0007C\u00019B'\u0015\tE1PA\u0010!\u0011\ti\u000e\" \n\t\u0011}\u00141\u0014\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0011]\u0014\u0001\u0004:fgR|'/Z*uCR,GC\u0004CD\t\u0013#Y\t\"$\u0005\u0010\u0012EE1\u0013\t\u0006\u0003;\u0014Ij\u001c\u0005\b\u0003c\u001a\u0005\u0019AA:\u0011\u001d\tyh\u0011a\u0001\u0003\u0003Cq!!$D\u0001\u0004\ty\tC\u0004\u0002,\r\u0003\r!a\f\t\u000f\u0005m2\t1\u0001\u0002>!9\u0011qI\"A\u0002\u0005%\u0013AE2sK\u0006$XmR3oKNL7o\u0015;bi\u0016$\u0002#!1\u0005\u001a\u0012mEQ\u0014CP\tC#\u0019\u000b\"*\t\u000f\u0005ED\t1\u0001\u0002t!9\u0011q\u0010#A\u0002\u0005\u0005\u0005bBAG\t\u0002\u0007\u0011q\u0012\u0005\b\u0003W!\u0005\u0019AA\u0018\u0011\u001d\tY\u0004\u0012a\u0001\u0003{Aq!a\u0012E\u0001\u0004\tI\u0005\u0003\u0004\u0005(\u0012\u0003\r\u0001\\\u0001\rO\u0016tWm]5t\u00052|7m\u001b")
public class AccountState
extends AbstractState<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountState>
implements State<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlock, AccountStateView, AccountState>,
TransactionValidation<AccountTransaction<Proposition, Proof<Proposition>>>,
NodeAccountState,
ClosableResourceHandler,
SparkzLogging {
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final HistoryBlockHashProvider blockHashProvider;
    private final String version;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> messageProcessors;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public boolean isValid(Transaction tx) {
        return TransactionValidation.isValid$((TransactionValidation)this, (Transaction)tx);
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> filterValid(Seq<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return TransactionValidation.filterValid$((TransactionValidation)this, txs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public String version() {
        return this.version;
    }

    public Try<AccountState> io$horizen$account$state$AccountState$$initProcessors(String initialVersion) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)view -> {
            int consensusEpochNumber = view.getConsensusEpochNumberAsInt();
            $this.messageProcessors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
                processor.init(view, consensusEpochNumber);
                return BoxedUnit.UNIT;
            });
            try {
                view.commit(initialVersion);
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(44).append("Could not commit view with initial version: ").append(initialVersion).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg, t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw t;
            }
            return this;
        }));
    }

    public Try<AccountState> applyModifier(AccountBlock mod) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(package$.MODULE$.versionToBytes(this.version()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray((byte[])package$.MODULE$.idToBytes().apply((Object)mod.parentId()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Incorrect state version!: ").append(mod.parentId()).append(" found, ").append(this.version()).append(" expected").toString());
            return (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                BoxedUnit boxedUnit;
                if (stateView.hasCeased()) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(53).append("Can't apply Block ").append(mod.id()).append(", because the sidechain has ceased.").toString();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new IllegalStateException(errMsg);
                }
                int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp());
                mod.sidechainTransactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    tx.semanticValidity(consensusEpochNumber);
                    return BoxedUnit.UNIT;
                });
                WithdrawalEpochInfo currentWithdrawalEpochInfo = this.getWithdrawalEpochInfo();
                WithdrawalEpochInfo modWithdrawalEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod, currentWithdrawalEpochInfo, this.params());
                if (this.params().isNonCeasing()) {
                    ((IterableLike)mod.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.topQualityCertificate()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
                        this.validateTopQualityCertificate(cert, stateView);
                        return BoxedUnit.UNIT;
                    });
                } else if (WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(mod, currentWithdrawalEpochInfo, this.params())) {
                    int certReferencedEpochNumber = modWithdrawalEpochInfo.epoch() - 1;
                    Option topQualityCertificateOpt = mod.topQualityCertificateOpt().orElse((Function0 & Serializable & scala.Serializable)() -> stateView.getTopQualityCertificate(certReferencedEpochNumber));
                    Option option = topQualityCertificateOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        WithdrawalEpochCertificate cert2 = (WithdrawalEpochCertificate)some.value();
                        this.validateTopQualityCertificate(cert2, (AccountStateView)stateView);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit4;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(131).append("In the end of the certificate submission window of epoch ").append(modWithdrawalEpochInfo.epoch()).append(" ").append("there are no certificates referenced to the epoch ").append(certReferencedEpochNumber).append(". Sidechain has ceased.").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        stateView.setCeased();
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                }
                stateView.updateWithdrawalEpochInfo(modWithdrawalEpochInfo);
                stateView.updateConsensusEpochNumber(consensusEpochNumber);
                ObjectRef cumGasUsed = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumBaseFee = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumForgerTips = ObjectRef.create((Object)BigInteger.ZERO);
                boolean ftToSmartContractForkActive = Version1_2_0Fork$.MODULE$.get(consensusEpochNumber).active();
                mod.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountState.$anonfun$applyModifier$8(stateView, mod, ftToSmartContractForkActive, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                int blockNumber = $this.stateMetadataStorage.getHeight() + 1;
                byte[] blockHash = (byte[])package$.MODULE$.idToBytes().apply((Object)mod.id());
                GasPool blockGasPool = new GasPool(mod.header().gasLimit());
                BlockContext blockContext = new BlockContext(mod.header(), blockNumber, consensusEpochNumber, modWithdrawalEpochInfo.epoch(), this.params().chainId(), $this.blockHashProvider);
                ((TraversableLike)mod.sidechainTransactions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountState.$anonfun$applyModifier$9(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    AccountState.$anonfun$applyModifier$10(this, stateView, blockGasPool, blockContext, cumGasUsed, blockHash, blockNumber, receiptList, cumBaseFee, cumForgerTips, x$3);
                    return BoxedUnit.UNIT;
                });
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("cumBaseFee={}, cumForgerTips={}", (Object[])new BigInteger[]{(BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stateView.updateFeePaymentInfo(new AccountBlockFeeInfo((BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem, mod.header().forgerAddress()));
                stateView.updateForgerBlockCounter(mod.forgerPublicKey(), consensusEpochNumber);
                this.evalForgersReward(mod, modWithdrawalEpochInfo, consensusEpochNumber, (AccountStateView)stateView);
                mod.verifyLogsBloomConsistency((Seq<EthereumReceipt>)receiptList);
                mod.verifyReceiptDataConsistency((Seq<EthereumConsensusDataReceipt>)((Seq)receiptList.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.consensusDataReceipt(), ListBuffer$.MODULE$.canBuildFrom())));
                BigInteger gasUsed = (BigInteger)receiptList.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.consensusDataReceipt().cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
                mod.verifyGasUsedConsistency(gasUsed);
                byte[] stateRoot = stateView.getIntermediateRoot();
                mod.verifyStateRootDataConsistency(stateRoot);
                stateView.updateTransactionReceipts((Seq<EthereumReceipt>)receiptList);
                stateView.updateNextBaseFee(FeeUtils$.MODULE$.calculateNextBaseFee(mod, this.params()));
                stateView.commit(package$.MODULE$.idToVersion(mod.id()));
                return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, package$.MODULE$.idToVersion(mod.id()), $this.stateMetadataStorage, $this.stateDbStorage, $this.messageProcessors);
            });
        });
    }

    private void evalForgersReward(AccountBlock mod, WithdrawalEpochInfo modWithdrawalEpochInfo, int consensusEpochNumber, AccountStateView stateView) {
        boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(modWithdrawalEpochInfo, this.params());
        if (isWithdrawalEpochFinished) {
            BoxedUnit boxedUnit;
            Seq<AccountPayment> feePayments = stateView.getFeePaymentsInfo(modWithdrawalEpochInfo.epoch(), consensusEpochNumber, (Option<AccountBlockFeeInfo>)None$.MODULE$);
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("End of Withdrawal Epoch {} reached, added {} rewards with block {}", new Object[]{BoxesRunTime.boxToInteger((int)modWithdrawalEpochInfo.epoch()), BoxesRunTime.boxToInteger((int)feePayments.length()), mod.header().id()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash(feePayments);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(feePaymentsHash))) {
                BoxedUnit boxedUnit2;
                String errMsg = new StringBuilder(72).append("Block ").append(mod.id()).append(": computed feePaymentsHash ").append(BytesUtils.toHexString(feePaymentsHash)).append(" is different from the one in the block").toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            stateView.resetForgerPoolAndBlockCounters(consensusEpochNumber);
            feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                AccountState.$anonfun$evalForgersReward$1(this, stateView, payment);
                return BoxedUnit.UNIT;
            });
        } else if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(AccountFeePaymentsUtils$.MODULE$.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH()))) {
            String errMsg = new StringBuilder(66).append("Block ").append(mod.id()).append(" has feePaymentsHash ").append(BytesUtils.toHexString(mod.feePaymentsHash())).append(" defined when no fee payments expected.").toString();
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void validateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate, AccountStateView stateView) {
        int certReferencedEpochNumber = topQualityCertificate.epochNumber();
        Seq<WithdrawalRequest> expectedWithdrawalRequests = stateView.getWithdrawalRequests(certReferencedEpochNumber);
        if (topQualityCertificate.backwardTransferOutputs().size() != expectedWithdrawalRequests.size()) {
            throw new IllegalStateException(new StringBuilder(139).append("Epoch ").append(certReferencedEpochNumber).append(" top quality certificate backward transfers ").append("number ").append(topQualityCertificate.backwardTransferOutputs().size()).append(" is different than expected ").append(expectedWithdrawalRequests.size()).append(". ").append("Node's active chain is the fork from MC perspective.").toString());
        }
        ((IterableLike)topQualityCertificate.backwardTransferOutputs().zip(expectedWithdrawalRequests, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountState.$anonfun$validateTopQualityCertificate$1(certReferencedEpochNumber, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isSwitchingConsensusEpoch(long blockTimeStamp) {
        int currentConsensusEpoch;
        int blockConsensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), blockTimeStamp);
        return blockConsensusEpoch != (currentConsensusEpoch = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))));
    }

    public Try<AccountState> rollbackTo(String version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            AccountStateMetadataStorage newMetaState = (AccountStateMetadataStorage)$this.stateMetadataStorage.rollback(new ByteArrayWrapper(package$.MODULE$.versionToBytes(version))).get();
            return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, version, newMetaState, $this.stateDbStorage, $this.messageProcessors);
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during rollback.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int maxRollbackDepth() {
        return this.stateMetadataStorage.rollbackVersions().size();
    }

    @Override
    public AccountStateView getView() {
        Hash stateRoot = new Hash(this.stateMetadataStorage.getAccountStateRoot());
        StateDB statedb = new StateDB(this.stateDbStorage, stateRoot);
        return new AccountStateView(this.stateMetadataStorage.getView(), statedb, this.messageProcessors);
    }

    public StateDbAccountStateView getStateDbViewFromRoot(byte[] stateRoot) {
        return new StateDbAccountStateView(new StateDB(this.stateDbStorage, new Hash(stateRoot)), this.messageProcessors, StateDbAccountStateView$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.getWithdrawalRequests(withdrawalEpoch));
    }

    @Override
    public Seq<BackwardTransfer> backwardTransfers(int withdrawalEpoch) {
        return (Seq)((TraversableLike)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getWithdrawalRequests(withdrawalEpoch))).map((Function1 & Serializable & scala.Serializable)wr -> new BackwardTransfer(wr.proposition().bytes(), wr.valueInZennies()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.keyRotationProof(withdrawalEpoch, indexOfSigner, keyType));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        Some some;
        block3: {
            block2: {
                if (withdrawalEpoch == -1) break block2;
                Enumeration.Value value = this.params().circuitType();
                Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
                if (value != null ? !value.equals(value2) : value2 != null) break block3;
            }
            some = new Some((Object)new CertifiersKeys((Vector<SchnorrProposition>)this.params().signersPublicKeys().toVector(), (Vector<SchnorrProposition>)this.params().mastersPublicKeys().toVector()));
            return some;
        }
        some = (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$9 -> x$9.certifiersKeys(withdrawalEpoch));
        return some;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.stateMetadataStorage.lastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.stateMetadataStorage.lastCertificateSidechainBlockId();
    }

    @Override
    public Option<WithdrawalEpochCertificate> certificate(int referencedWithdrawalEpoch) {
        return this.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        return this.stateMetadataStorage.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public boolean hasCeased() {
        return this.stateMetadataStorage.hasCeased();
    }

    @Override
    public Seq<AccountPayment> getFeePaymentsInfo(int withdrawalEpoch, int consensusEpochNumber, Option<AccountBlockFeeInfo> blockToAppendFeeInfo) {
        Seq<AccountBlockFeeInfo> feePaymentInfoSeq = this.stateMetadataStorage.getFeePayments(withdrawalEpoch);
        Map<AddressProposition, BigInteger> mcForgerPoolRewards = this.stateMetadataStorage.getMcForgerPoolRewards();
        return AccountFeePaymentsUtils$.MODULE$.getForgersRewards(feePaymentInfoSeq, mcForgerPoolRewards);
    }

    @Override
    public Option<AccountBlockFeeInfo> getFeePaymentsInfo$default$3() {
        return None$.MODULE$;
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return this.stateMetadataStorage.getWithdrawalEpochInfo();
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.stateMetadataStorage.getConsensusEpochNumber();
    }

    @Override
    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq(int epochNumber) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$10 -> x$10.getOrderedForgingStakesInfoSeq(epochNumber));
    }

    @Override
    public Tuple2<String, ConsensusEpochInfo> getCurrentConsensusEpochInfo() {
        Seq<ForgingStakeInfo> forgingStakes;
        int consensusEpochNumber;
        Option<Object> option = this.getConsensusEpochNumber();
        if (option instanceof Some) {
            Some some = (Some)option;
            consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
            forgingStakes = this.getOrderedForgingStakesInfoSeq(consensusEpochNumber);
            if (forgingStakes.isEmpty()) {
                throw new IllegalStateException("ForgerStakes list can't be empty.");
            }
        } else {
            throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
        }
        String lastBlockInEpoch = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)this.stateMetadataStorage.lastVersionId().get()).data());
        ConsensusEpochInfo consensusEpochInfo = new ConsensusEpochInfo(consensusEpochNumber, MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakes.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava()), BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakes.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.stakeAmount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Tuple2 tuple2 = new Tuple2((Object)lastBlockInEpoch, (Object)consensusEpochInfo);
        return tuple2;
    }

    @Override
    public BigInteger getBalance(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$12 -> x$12.getBalance(address));
    }

    @Override
    public byte[] getAccountStateRoot() {
        return this.stateMetadataStorage.getAccountStateRoot();
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$13 -> x$13.getCodeHash(address));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$14 -> x$14.getNonce(address));
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(boolean isForkV1_3Active) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$15 -> x$15.getListOfForgersStakes(isForkV1_3Active));
    }

    @Override
    public Tuple2<Object, Seq<AccountForgingStakeInfo>> getPagedListOfForgersStakes(int startPos, int pageSize) {
        return (Tuple2)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$16 -> x$16.getPagedListOfForgersStakes(startPos, pageSize));
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$17 -> x$17.getAllowedForgerList());
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId, boolean isForkV1_3Active) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$18 -> x$18.getForgerStakeData(stakeId, isForkV1_3Active));
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(Option<String> scAddressOpt) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$19 -> x$19.getListOfMcAddrOwnerships(scAddressOpt));
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$20 -> x$20.getListOfOwnerScAddresses());
    }

    @Override
    public boolean ownershipDataExist(byte[] ownershipId) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.ownershipDataExist(ownershipId))));
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$22 -> x$22.getLogs(txHash));
    }

    @Override
    public byte[] getIntermediateRoot() {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$23 -> x$23.getIntermediateRoot());
    }

    @Override
    public byte[] getCode(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$24 -> x$24.getCode(address));
    }

    @Override
    public BigInteger getNextBaseFee() {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$25 -> x$25.getNextBaseFee());
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$26 -> x$26.getTransactionReceipt(txHash));
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return (ResourceHandle)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$27 -> x$27.getStateDbHandle());
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$28 -> x$28.getAccountStorage(address, key));
    }

    @Override
    public byte[] getAccountStorageBytes(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$29 -> x$29.getAccountStorageBytes(address, key));
    }

    @Override
    public boolean accountExists(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.accountExists(address))));
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isEoaAccount(address))));
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.isSmartContractAccount(address))));
    }

    public Try<BoxedUnit> validate(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!(tx instanceof EthereumTransaction)) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(46).append("Transaction ").append(tx.id()).append(": instance of class ").append(tx.getClass().getName()).append(", not of type ").append(EthereumTransaction.class.getName()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if ((ethTx.isEIP155() || ethTx.isEIP1559()) && !BoxesRunTime.equalsNumObject((Number)ethTx.getChainId(), (Object)BoxesRunTime.boxToLong((long)this.params().chainId()))) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(61).append("Transaction ").append(ethTx.id()).append(": chainId=").append(ethTx.getChainId()).append(" is different from expected SC chainId ").append(this.params().chainId()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new InvalidTransactionChainIdException(errMsg, InvalidTransactionChainIdException$.MODULE$.$lessinit$greater$default$2());
            }
            int consensusEpochNumber = BoxesRunTime.unboxToInt((Object)$this.stateMetadataStorage.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            ethTx.semanticValidity(consensusEpochNumber);
            Address sender = ethTx.getFrom().address();
            GasFeeFork feeFork = GasFeeFork$.MODULE$.get(consensusEpochNumber);
            if (feeFork.blockGasLimit().compareTo(ethTx.getGasLimit()) < 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Transaction gas limit exceeds block gas limit: tx gas limit ").append(ethTx.getGasLimit()).append(", block gas limit ").append(feeFork.blockGasLimit()).toString());
            }
            if (feeFork.baseFeeMinimum().compareTo(ethTx.getMaxFeePerGas()) > 0) {
                throw new IllegalArgumentException(new StringBuilder(64).append("max fee per gas below minimum: address ").append(sender).append(", maxFeePerGas ").append(ethTx.getMaxFeePerGas()).append(", minimum ").append(feeFork.baseFeeMinimum()).toString());
            }
            this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                AccountState.$anonfun$validate$3(sender, ethTx, stateView);
                return BoxedUnit.UNIT;
            });
        }).recoverWith((PartialFunction)new scala.Serializable(this, tx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;
            private final AccountTransaction tx$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isDebugEnabled()) {
                    this.$outer.log().underlying().debug(new StringBuilder(22).append("Not valid transaction ").append(this.tx$1.id()).toString(), A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tx$1 = tx$1;
            }
        });
    }

    @Override
    public boolean isWithdrawalEpochLastIndex() {
        return WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(this.getWithdrawalEpochInfo(), this.params());
    }

    @Override
    public boolean isForgingOpen() {
        return this.params().restrictForgers() ? BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.isForgingOpen()))) : true;
    }

    @Override
    public boolean isForgerStakeAvailable(boolean isForkV1_3Active) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)x$34.isForgerStakeAvailable(isForkV1_3Active))));
    }

    @Override
    public Option<byte[]> utxoMerkleTreeRoot(int withdrawalEpoch) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$8(AccountStateView stateView$1, AccountBlock mod$1, boolean ftToSmartContractForkActive$1, MainchainBlockReferenceData mcBlockRefData) {
        stateView$1.addTopQualityCertificates(mcBlockRefData, mod$1.id());
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData, ftToSmartContractForkActive$1);
    }

    public static final /* synthetic */ boolean $anonfun$applyModifier$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$10(AccountState $this, AccountStateView stateView$1, GasPool blockGasPool$1, BlockContext blockContext$1, ObjectRef cumGasUsed$1, byte[] blockHash$1, int blockNumber$1, ListBuffer receiptList$1, ObjectRef cumBaseFee$1, ObjectRef cumForgerTips$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple2 tuple22;
            BigInteger txGasUsed;
            AccountTransaction tx = (AccountTransaction)tuple2._1();
            int txIndex = tuple2._2$mcI$sp();
            boolean bl = false;
            Failure failure = null;
            Try<EthereumConsensusDataReceipt> try_ = stateView$1.applyTransaction(tx, txIndex, blockGasPool$1, blockContext$1);
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract((BigInteger)cumGasUsed$1.elem);
                cumGasUsed$1.elem = consensusDataReceipt.cumulativeGasUsed();
                EthereumTransaction ethTx = (EthereumTransaction)tx;
                byte[] txHash = BytesUtils.fromHexString(ethTx.id());
                None$ contractAddress = ethTx.getTo().isEmpty() ? Option$.MODULE$.apply((Object)Secp256k1.generateContractAddress(ethTx.getFrom().address(), ethTx.getNonce())) : None$.MODULE$;
                EthereumReceipt fullReceipt = new EthereumReceipt(consensusDataReceipt, txHash, txIndex, blockHash$1, blockNumber$1, txGasUsed, (Option<Address>)contractAddress);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("Adding to receipt list: {}", new Object[]{fullReceipt.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                receiptList$1.$plus$eq((Object)fullReceipt);
                Tuple2<BigInteger, BigInteger> tuple23 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                BigInteger txBaseFeePerGas = (BigInteger)tuple23._1();
                BigInteger txForgerTipPerGas = (BigInteger)tuple23._2();
                tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
            } else {
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable err = failure.exception();
                    if (err instanceof GasLimitReached) {
                        BoxedUnit boxedUnit;
                        GasLimitReached gasLimitReached = (GasLimitReached)err;
                        if ($this.log().underlying().isErrorEnabled()) {
                            $this.log().underlying().error("Could not apply tx, block gas limit exceeded");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new IllegalArgumentException("Could not apply tx, block gas limit exceeded", gasLimitReached);
                    }
                }
                if (bl) {
                    BoxedUnit boxedUnit;
                    Throwable err = failure.exception();
                    if ($this.log().underlying().isErrorEnabled()) {
                        $this.log().underlying().error("Could not apply tx", err);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(err);
                }
                throw new MatchError(try_);
            }
            Tuple2 tuple24 = tuple22;
            BigInteger txBaseFeePerGas = (BigInteger)tuple24._1();
            BigInteger txForgerTipPerGas = (BigInteger)tuple24._2();
            cumBaseFee$1.elem = ((BigInteger)cumBaseFee$1.elem).add(txBaseFeePerGas.multiply(txGasUsed));
            cumForgerTips$1.elem = ((BigInteger)cumForgerTips$1.elem).add(txForgerTipPerGas.multiply(txGasUsed));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$evalForgersReward$1(AccountState $this, AccountStateView stateView$2, AccountPayment payment) {
        BoxedUnit boxedUnit;
        stateView$2.addBalance(payment.address().address(), payment.value());
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug(" address: {} / value: {}", new Object[]{payment.address().address(), payment.value()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$validateTopQualityCertificate$1(int certReferencedEpochNumber$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MainchainBackwardTransferCertificateOutput certOutput = (MainchainBackwardTransferCertificateOutput)tuple2._1();
            WithdrawalRequest expectedWithdrawalRequest = (WithdrawalRequest)tuple2._2();
            if (certOutput.amount() != expectedWithdrawalRequest.valueInZennies() || !Arrays.equals(certOutput.pubKeyHash(), expectedWithdrawalRequest.proposition().bytes())) {
                throw new IllegalStateException(new StringBuilder(135).append("Epoch ").append(certReferencedEpochNumber$2).append(" top quality certificate backward transfers ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validate$3(Address sender$1, EthereumTransaction ethTx$1, AccountStateView stateView) {
        BigInteger stateNonce = stateView.getNonce(sender$1);
        if (stateNonce.compareTo(ethTx$1.getNonce()) > 0) {
            throw new NonceTooLowException(sender$1, ethTx$1.getNonce(), stateNonce);
        }
        BigInteger maxTxCost = ethTx$1.maxCost();
        BigInteger currentBalance = stateView.getBalance(sender$1);
        if (currentBalance.compareTo(maxTxCost) < 0) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Insufficient funds for executing transaction: balance ").append(currentBalance).append(", tx cost ").append(maxTxCost).toString());
        }
        if (!stateView.isEoaAccount(sender$1)) {
            throw new SenderNotEoaException(sender$1, stateView.getCodeHash(sender$1));
        }
    }

    public AccountState(NetworkParams params, NetworkTimeProvider timeProvider, HistoryBlockHashProvider blockHashProvider, String version, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> messageProcessors) {
        this.params = params;
        this.timeProvider = timeProvider;
        this.blockHashProvider = blockHashProvider;
        this.version = version;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.messageProcessors = messageProcessors;
        TransactionValidation.$init$((TransactionValidation)this);
        ClosableResourceHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

