/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.serialization;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import io.horizen.account.serialization.EthByteDeserializer;
import io.horizen.account.serialization.EthByteSerializer;
import io.horizen.evm.utils.BigIntegerDeserializer;
import io.horizen.evm.utils.BigIntegerSerializer;
import java.math.BigInteger;

public class EthJsonMapper {
    private static final ObjectMapper mapper;

    private EthJsonMapper() {
    }

    public static String serialize(Object value) throws Exception {
        return mapper.writeValueAsString(value);
    }

    public static <T> T deserialize(String json, Class<T> type) throws Exception {
        return (T)mapper.readValue(json, type);
    }

    public static ObjectMapper getMapper() {
        return mapper.copy();
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BigInteger.class, (JsonSerializer)new BigIntegerSerializer());
        module.addDeserializer(BigInteger.class, (JsonDeserializer)new BigIntegerDeserializer());
        module.addSerializer(byte[].class, (JsonSerializer)new EthByteSerializer());
        module.addDeserializer(byte[].class, (JsonDeserializer)new EthByteDeserializer());
        mapper = new ObjectMapper();
        mapper.registerModule((Module)new DefaultScalaModule());
        mapper.registerModule((Module)module);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

