/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.horizen.account.api.rpc.handler.RpcException;
import io.horizen.account.api.rpc.request.RpcRequest;
import io.horizen.account.api.rpc.service.NotAllowedOnSeederNode;
import io.horizen.account.api.rpc.service.RpcMethod;
import io.horizen.account.api.rpc.service.RpcOptionalParameters;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import io.horizen.account.serialization.EthJsonMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;

public class RpcService {
    private final HashMap<String, Method> rpcMethods = new HashMap();
    private final ObjectMapper mapper;

    public RpcService() {
        Method[] methods;
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            RpcMethod annotation = method.getAnnotation(RpcMethod.class);
            if (annotation == null) continue;
            this.rpcMethods.put(annotation.value(), method);
        }
        this.mapper = EthJsonMapper.getMapper();
    }

    public boolean hasMethod(String method) {
        return this.rpcMethods.containsKey(method);
    }

    public boolean isDisabledOnSeederNode(Method method) {
        return method.getAnnotation(NotAllowedOnSeederNode.class) != null;
    }

    public boolean isNotAllowed(Method method) {
        return false;
    }

    private Object[] convertArgs(Method method, JsonNode args) throws RpcException {
        int argsCount;
        RpcOptionalParameters optionalAnnotation = method.getAnnotation(RpcOptionalParameters.class);
        int optionalParameters = optionalAnnotation == null ? 0 : optionalAnnotation.value();
        Class<?>[] parameters = method.getParameterTypes();
        int n = argsCount = args == null ? 0 : args.size();
        if (args != null && !args.isArray() || argsCount > parameters.length || argsCount < parameters.length - optionalParameters) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams));
        }
        try {
            Object[] convertedArgs = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                convertedArgs[i] = this.mapper.convertValue((Object)(args == null ? null : args.get(i)), parameters[i]);
            }
            return convertedArgs;
        }
        catch (IllegalArgumentException err) {
            LogManager.getLogger().trace("RPC call with invalid params: " + method, (Throwable)err);
            for (Throwable cause = err.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RpcException)) continue;
                throw (RpcException)cause;
            }
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, err.getMessage()));
        }
    }

    public Object execute(RpcRequest req) throws Throwable {
        Method method = this.rpcMethods.get(req.method);
        if (method == null) {
            throw new RpcException(RpcError.fromCode(RpcCode.MethodNotFound));
        }
        if (this.isNotAllowed(method)) {
            throw new RpcException(RpcError.fromCode(RpcCode.ActionNotAllowed));
        }
        Object[] args = this.convertArgs(method, req.params);
        try {
            return method.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            LogManager.getLogger().trace("RPC call failed: " + method, (Throwable)e);
            throw e.getCause();
        }
        catch (IllegalArgumentException e) {
            LogManager.getLogger().trace("RPC call failed: " + method, (Throwable)e);
            throw e.getCause();
        }
    }
}

