/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.service;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.api.rpc.service.Backend;
import io.horizen.account.api.rpc.service.Backend$GasAndReward$2$;
import io.horizen.account.api.rpc.service.TipCache;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import sparkz.util.SparkzLogging;
import sparkz.util.package;
import supertagged.package;

public final class Backend$
implements SparkzLogging {
    public static Backend$ MODULE$;
    private final BigInteger MAX_GAS_PRICE;
    private final int SUGGEST_TIP_TX_LIMIT;
    private Option<TipCache> tipCache;
    private final Logger logger;

    static {
        new Backend$();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private BigInteger MAX_GAS_PRICE() {
        return this.MAX_GAS_PRICE;
    }

    private int SUGGEST_TIP_TX_LIMIT() {
        return this.SUGGEST_TIP_TX_LIMIT;
    }

    public Option<TipCache> tipCache() {
        return this.tipCache;
    }

    public void tipCache_$eq(Option<TipCache> x$1) {
        this.tipCache = x$1;
    }

    public BigInteger calculateGasPrice(AccountHistory history, BigInteger baseFee) {
        return this.suggestTipCap(history).add(baseFee);
    }

    public BigInteger suggestTipCap(AccountHistory history) {
        return this.suggestTipCap(history, 20, 20, this.MAX_GAS_PRICE(), BigInteger.TWO);
    }

    public BigInteger suggestTipCap(AccountHistory history, int blockCount, int percentile, BigInteger maxPrice, BigInteger ignorePrice) {
        Option option;
        BigInteger lastPrice;
        String headHash;
        int number;
        block14: {
            Tuple2 tuple2;
            block13: {
                number = history.getCurrentHeight();
                headHash = history.bestBlockId();
                tuple2 = (Tuple2)this.tipCache().fold((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Option$.MODULE$.empty(), (Object)BigInteger.ZERO), (Function1 & Serializable & scala.Serializable)cache -> new Tuple2((Object)new Some((Object)cache.blockHash()), (Object)cache.value()));
                if (tuple2 == null) break block13;
                Option lastHead = (Option)tuple2._1();
                lastPrice = (BigInteger)tuple2._2();
                if (lastHead == null) break block13;
                option = lastHead;
                if (lastPrice != null) break block14;
            }
            throw new MatchError((Object)tuple2);
        }
        BigInteger bigInteger = lastPrice;
        Tuple2 tuple2 = new Tuple2((Object)option, (Object)bigInteger);
        Tuple2 tuple22 = tuple2;
        Option lastHead = (Option)tuple22._1();
        BigInteger lastPrice2 = (BigInteger)tuple22._2();
        if (lastHead.isDefined()) {
            Object object = lastHead.get();
            String string = headHash;
            if (!(object != null ? !object.equals(string) : string != null)) {
                return lastPrice2;
            }
        }
        int sent = 0;
        int exp = 0;
        Seq prices = (Seq)Nil$.MODULE$;
        Seq results = (Seq)Nil$.MODULE$;
        while (sent < blockCount && number > 0) {
            prices = (Seq)prices.$colon$plus(this.getBlockPrices(history, number, ignorePrice, this.SUGGEST_TIP_TX_LIMIT()), Seq$.MODULE$.canBuildFrom());
            ++sent;
            ++exp;
            --number;
        }
        while (exp > 0) {
            Option pricesOfABlock = (Option)prices.head();
            prices = (Seq)prices.drop(1);
            if (pricesOfABlock.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Error retrieving blocks in history while suggesting tip cap, returning the cached one");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return lastPrice2;
            }
            --exp;
            Seq res = (Seq)pricesOfABlock.get();
            if (res.isEmpty()) {
                res = (Seq)new .colon.colon((Object)lastPrice2, (List)Nil$.MODULE$);
            }
            if (res.length() == 1 && results.length() + 1 + exp < blockCount * 2 && number > 0) {
                prices = (Seq)prices.$colon$plus(this.getBlockPrices(history, number, ignorePrice, this.SUGGEST_TIP_TX_LIMIT()), Seq$.MODULE$.canBuildFrom());
                ++exp;
                --number;
            }
            results = (Seq)results.$plus$plus((GenTraversableOnce)res, Seq$.MODULE$.canBuildFrom());
        }
        BigInteger resultPrice = lastPrice2;
        if (!results.isEmpty()) {
            resultPrice = ((BigInteger)((Option)((PartialFunction)results.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).lift().apply((Object)BoxesRunTime.boxToInteger((int)((results.length() - 1) * percentile / 100)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> lastPrice2)).min(maxPrice);
        }
        this.tipCache_$eq((Option<TipCache>)new Some((Object)new TipCache(headHash, resultPrice)));
        return resultPrice;
    }

    public int suggestTipCap$default$2() {
        return 20;
    }

    public int suggestTipCap$default$3() {
        return 20;
    }

    public BigInteger suggestTipCap$default$4() {
        return this.MAX_GAS_PRICE();
    }

    public BigInteger suggestTipCap$default$5() {
        return BigInteger.TWO;
    }

    private Option<Seq<BigInteger>> getBlockPrices(AccountHistory history, int blockHeight, BigInteger ignoreUnder, int limit) {
        Option<String> blockId = history.blockIdByHeight(blockHeight);
        if (blockId.isEmpty()) {
            return Option$.MODULE$.empty();
        }
        Option blockOpt = history.getStorageBlockById((String)package.ModifierId$.MODULE$.apply(blockId.get(), package.Tagger$.MODULE$.baseRaw()));
        if (blockOpt.isEmpty()) {
            return Option$.MODULE$.empty();
        }
        AccountBlock block = (AccountBlock)blockOpt.get();
        return new Some(((IterableLike)((SeqLike)((TraversableLike)((TraversableLike)block.transactions().filter((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)Backend$.$anonfun$getBlockPrices$1(block, tx)))).map((Function1 & Serializable & scala.Serializable)tx -> MODULE$.getEffectiveGasTip((EthereumTransaction)tx, block.header().baseFee()), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)gasTip -> BoxesRunTime.boxToBoolean((boolean)Backend$.$anonfun$getBlockPrices$3(ignoreUnder, gasTip)))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).take(limit));
    }

    public BigInteger[] getRewardsForBlock(AccountBlock block, AccountStateView stateView, double[] percentiles) {
        public class Io_horizen_account_api_rpc_service_Backend$GasAndReward$1
        implements Product,
        scala.Serializable {
            private final long gasUsed;
            private final BigInteger reward;

            public long gasUsed() {
                return this.gasUsed;
            }

            public BigInteger reward() {
                return this.reward;
            }

            public Io_horizen_account_api_rpc_service_Backend$GasAndReward$1 copy(long gasUsed, BigInteger reward) {
                return new Io_horizen_account_api_rpc_service_Backend$GasAndReward$1(gasUsed, reward);
            }

            public long copy$default$1() {
                return this.gasUsed();
            }

            public BigInteger copy$default$2() {
                return this.reward();
            }

            public String productPrefix() {
                return "GasAndReward";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Number number;
                int n = x$1;
                switch (n) {
                    case 0: {
                        number = BoxesRunTime.boxToLong((long)this.gasUsed());
                        break;
                    }
                    case 1: {
                        number = this.reward();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return number;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Io_horizen_account_api_rpc_service_Backend$GasAndReward$1;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.gasUsed()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reward()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Io_horizen_account_api_rpc_service_Backend$GasAndReward$1 var4_4 = (Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)x$1;
                if (this.gasUsed() != var4_4.gasUsed()) return false;
                if (!BoxesRunTime.equalsNumNum((Number)this.reward(), (Number)var4_4.reward())) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Io_horizen_account_api_rpc_service_Backend$GasAndReward$1(long gasUsed, BigInteger reward) {
                this.gasUsed = gasUsed;
                this.reward = reward;
                Product.$init$((Product)this);
            }
        }
        LazyRef GasAndReward$module = new LazyRef();
        Seq txs = (Seq)block.transactions().map((Function1 & Serializable & scala.Serializable)x$2 -> (EthereumTransaction)x$2, Seq$.MODULE$.canBuildFrom());
        if (txs.isEmpty()) {
            return (BigInteger[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).map((Function1 & Serializable & scala.Serializable)x$3 -> Backend$.$anonfun$getRewardsForBlock$2(BoxesRunTime.unboxToDouble((Object)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BigInteger.class)));
        }
        Iterator sortedRewards = ((IterableLike)((SeqLike)txs.map((Function1 & Serializable & scala.Serializable)tx -> this.GasAndReward$3(GasAndReward$module).apply(((EthereumReceipt)stateView.getTransactionReceipt(BytesUtils.fromHexString(tx.id())).get()).gasUsed().longValueExact(), MODULE$.getEffectiveGasTip((EthereumTransaction)tx, block.header().baseFee())), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.reward(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).iterator();
        ObjectRef current = ObjectRef.create((Object)((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)sortedRewards.next()));
        LongRef sumGasUsed = LongRef.create((long)((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current.elem).gasUsed());
        BigInteger[] rewards = new BigInteger[percentiles.length];
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long thresholdGasUsed = (long)(block.header().gasUsed().doubleValue() * percentiles[i] / (double)100);
            while (sumGasUsed$1.elem < thresholdGasUsed && sortedRewards.hasNext()) {
                current$1.elem = (Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)sortedRewards.next();
                sumGasUsed$1.elem += ((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current$1.elem).gasUsed();
            }
            rewards$1[i] = ((Io_horizen_account_api_rpc_service_Backend$GasAndReward$1)current$1.elem).reward();
        });
        return rewards;
    }

    private BigInteger getEffectiveGasTip(EthereumTransaction tx, BigInteger baseFee) {
        return baseFee == null ? tx.getMaxPriorityFeePerGas() : tx.getMaxPriorityFeePerGas().min(tx.getMaxFeePerGas().subtract(baseFee));
    }

    public static final /* synthetic */ boolean $anonfun$getBlockPrices$1(AccountBlock block$1, AccountTransaction tx) {
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(tx.getFrom().bytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(block$1.forgerPublicKey().bytes()));
    }

    public static final /* synthetic */ boolean $anonfun$getBlockPrices$3(BigInteger ignoreUnder$1, BigInteger gasTip) {
        return ignoreUnder$1 == null || gasTip.compareTo(ignoreUnder$1) >= 0;
    }

    public static final /* synthetic */ BigInteger $anonfun$getRewardsForBlock$2(double x$3) {
        return BigInteger.ZERO;
    }

    private static final /* synthetic */ Backend$GasAndReward$2$ GasAndReward$lzycompute$1(LazyRef GasAndReward$module$1) {
        Backend$GasAndReward$2$ backend$GasAndReward$2$;
        LazyRef lazyRef = GasAndReward$module$1;
        synchronized (lazyRef) {
            backend$GasAndReward$2$ = GasAndReward$module$1.initialized() ? (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.value()) : (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.initialize((Object)new Backend$GasAndReward$2$()));
        }
        return backend$GasAndReward$2$;
    }

    private final Backend$GasAndReward$2$ GasAndReward$3(LazyRef GasAndReward$module$1) {
        return GasAndReward$module$1.initialized() ? (Backend$GasAndReward$2$)((Object)GasAndReward$module$1.value()) : Backend$.GasAndReward$lzycompute$1(GasAndReward$module$1);
    }

    private Backend$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.MAX_GAS_PRICE = FeeUtils$.MODULE$.INITIAL_BASE_FEE().multiply(BigInteger.valueOf(500L));
        this.SUGGEST_TIP_TX_LIMIT = 3;
        this.tipCache = Option$.MODULE$.empty();
    }
}

