/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.http.route;

import com.google.common.primitives.Bytes;
import io.horizen.account.api.http.route.AccountTransactionRestScheme;
import io.horizen.account.state.CertificateKeyRotationMsgProcessor$;
import io.horizen.account.state.SubmitKeyRotationCmdInput;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.proof.SchnorrProof;
import io.horizen.proof.SchnorrSignatureSerializer;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.SchnorrPropositionSerializer;
import io.horizen.utils.BytesUtils;
import scala.Enumeration;

public final class AccountTransactionRestScheme$ {
    public static AccountTransactionRestScheme$ MODULE$;

    static {
        new AccountTransactionRestScheme$();
    }

    public String encodeSubmitKeyRotationRequestCmd(AccountTransactionRestScheme.ReqCreateKeyRotationTransaction request) {
        Enumeration.Value keyType = KeyRotationProofTypes$.MODULE$.apply(request.keyType());
        int index = request.keyIndex();
        SchnorrProposition newKey = SchnorrPropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(request.newKey()));
        SchnorrProof signingSignature = (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(request.signingKeySignature()));
        SchnorrProof masterSignature = (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(request.masterKeySignature()));
        SchnorrProof newKeySignature = (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(request.newKeySignature()));
        KeyRotationProof keyRotationProof = new KeyRotationProof(keyType, index, newKey, signingSignature, masterSignature);
        return BytesUtils.toHexString(Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig()), new SubmitKeyRotationCmdInput(keyRotationProof, newKeySignature).encode()}));
    }

    public String normalizeScAddress(String str) {
        String str2 = str.startsWith("0x") ? str.substring(2) : str;
        return str2.toLowerCase();
    }

    private AccountTransactionRestScheme$() {
        MODULE$ = this;
    }
}

