/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppEvents$SidechainApplicationStart$;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.SidechainSyncInfoMessageSpec$;
import io.horizen.account.AccountNodeViewHolderRef$;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.api.http.route.AccountApplicationApiRoute;
import io.horizen.account.api.http.route.AccountBlockApiRoute;
import io.horizen.account.api.http.route.AccountEthRpcRoute;
import io.horizen.account.api.http.route.AccountTransactionApiRoute;
import io.horizen.account.api.http.route.AccountWalletApiRoute;
import io.horizen.account.api.rpc.handler.RpcHandler;
import io.horizen.account.api.rpc.service.EthService;
import io.horizen.account.api.rpc.service.RpcProcessor;
import io.horizen.account.api.rpc.service.RpcUtils$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.certificatesubmitter.AccountCertificateSubmitterRef$;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.forger.AccountForgerRef$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.network.AccountNodeViewSynchronizer$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.api.http.SidechainBlockActorRef$;
import io.horizen.api.http.SidechainTransactionActorRef$;
import io.horizen.api.http.SidechainTransactionRateLimiterActorRef$;
import io.horizen.api.http.route.MainchainBlockApiRoute;
import io.horizen.api.http.route.SidechainNodeApiRoute;
import io.horizen.api.http.route.SidechainSubmitterApiRoute;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.certificatesubmitter.network.CertificateSignaturesManagerRef$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.evm.Database;
import io.horizen.evm.LevelDBDatabase;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.NodeViewProvider;
import io.horizen.helper.NodeViewProviderImpl;
import io.horizen.helper.TransactionSubmitProvider;
import io.horizen.helper.TransactionSubmitProviderImpl;
import io.horizen.network.SyncStatusActorRef$;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sparkz.core.NodeViewModifier;
import sparkz.core.api.http.ApiRoute;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.core.transaction.Transaction$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ma\u0001\u0002$H\u00019C\u0011b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001V,\t\u0015!\u0004!\u0011!Q\u0001\n%\f\t\u0001\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"!\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u00111\ty\u0006\u0001B\u0001B\u0003%\u0011\u0011MAE\u0011)\t\t\n\u0001B\u0001B\u0003%\u00111\u0013\u0005\r\u0003O\u0003!\u0011!Q\u0001\n\u0005%\u0016q\u0016\u0005\r\u0003o\u0003!\u0011!Q\u0001\n\u0005e\u0016Q\u0019\u0005\r\u0003\u001b\u0004!\u0011!Q\u0001\n\u0005=\u0017Q\u001b\u0005\u000b\u0003;\u0004!\u0011!Q\u0001\n\u0005=\u0004\u0002DAs\u0001\t\u0005\t\u0015!\u0003\u0002h\u0006=\b\u0002DA|\u0001\t\u0005\t\u0015!\u0003\u0002h\u0006e\bb\u0002B\u0001\u0001\u0011\u0005!1A\u0003\u0007\u0005\u0007\u0002\u0001%!\u0007\u0006\r\t\u0015\u0003\u0001\tB$\u000b\u0019\u0011\u0019\u0006\u0001\u0011\u0003V!I!1\f\u0001C\u0002\u0013\u0005#Q\f\u0005\t\u0005?\u0002\u0001\u0015!\u0003\u0002p!Q!\u0011\r\u0001\t\u0006\u0004%\tBa\u0019\t\u0015\tE\u0004\u0001#b\u0001\n\u0003\u0012\u0019\bC\u0005\u0003v\u0001\u0011\r\u0011\"\u0001\u0003^!A!q\u000f\u0001!\u0002\u0013\ty\u0007C\u0005\u0003z\u0001\u0011\r\u0011\"\u0001\u0003|!A!q\u0011\u0001!\u0002\u0013\u0011i\bC\u0005\u0003\n\u0002\u0011\r\u0011\"\u0001\u0003|!A!1\u0012\u0001!\u0002\u0013\u0011i\bC\u0005\u0003\u000e\u0002\u0011\r\u0011\"\u0001\u0003|!A!q\u0012\u0001!\u0002\u0013\u0011i\bC\u0005\u0003\u0012\u0002\u0011\r\u0011\"\u0001\u0003|!A!1\u0013\u0001!\u0002\u0013\u0011i\bC\u0005\u0003\u0016\u0002\u0011\r\u0011\"\u0005\u0003\u0018\"A!Q\u0015\u0001!\u0002\u0013\u0011I\nC\u0005\u0003(\u0002\u0011\r\u0011\"\u0005\u0003*\"A!Q\u0017\u0001!\u0002\u0013\u0011Y\u000bC\u0005\u00038\u0002\u0011\r\u0011\"\u0005\u0003:\"A!\u0011\u0019\u0001!\u0002\u0013\u0011Y\fC\u0005\u0003D\u0002\u0011\r\u0011\"\u0005\u0003F\"A!1\u001b\u0001!\u0002\u0013\u00119\rC\u0005\u0003V\u0002\u0011\r\u0011\"\u0005\u0003X\"A!Q\u001d\u0001!\u0002\u0013\u0011I\u000eC\u0005\u0003h\u0002\u0011\r\u0011\"\u0011\u0003j\"A!1 \u0001!\u0002\u0013\u0011Y\u000fC\u0004\u0003~\u0002!\tAa@\t\u0013\r-\u0003A1A\u0005B\t%\b\u0002CB'\u0001\u0001\u0006IAa;\t\u0013\r=\u0003A1A\u0005\u0002\t%\b\u0002CB)\u0001\u0001\u0006IAa;\t\u0013\rM\u0003A1A\u0005\u0002\t%\b\u0002CB+\u0001\u0001\u0006IAa;\t\u0013\r]\u0003A1A\u0005\u0002\t%\b\u0002CB-\u0001\u0001\u0006IAa;\t\u0013\rm\u0003A1A\u0005\u0002\t%\b\u0002CB/\u0001\u0001\u0006IAa;\t\u0013\r}\u0003A1A\u0005\u0002\t%\b\u0002CB1\u0001\u0001\u0006IAa;\t\u0013\r\r\u0004A1A\u0005\u0002\t%\b\u0002CB3\u0001\u0001\u0006IAa;\t\u0013\r\u001d\u0004A1A\u0005\u0002\r%\u0004\u0002CB>\u0001\u0001\u0006Iaa\u001b\t\u0013\ru\u0004A1A\u0005\u0002\r}\u0004\u0002CBG\u0001\u0001\u0006Ia!!\t\u0015\r=\u0005\u0001#b\u0001\n\u0003\u001a\t\n\u0003\u0006\u00040\u0002A)\u0019!C!\u0007#C\u0011b!-\u0001\u0005\u0004%\taa-\t\u0011\u0011\u0005\u0001\u0001)A\u0005\u0007kCq\u0001b\u0001\u0001\t\u0003\u0019\u0019\fC\u0005\u0005\u0006\u0001\u0011\r\u0011\"\u0001\u0005\b!AAq\u0002\u0001!\u0002\u0013!I\u0001C\u0004\u0005\u0012\u0001!\t\u0005b\u0002\u0003'\u0005\u001b7m\\;oiNKG-Z2iC&t\u0017\t\u001d9\u000b\u0005!K\u0015aB1dG>,h\u000e\u001e\u0006\u0003\u0015.\u000bq\u0001[8sSj,gNC\u0001M\u0003\tIwn\u0001\u0001\u0014\u0005\u0001y\u0005C\u0001)R\u001b\u0005I\u0015B\u0001*J\u0005Q\t%m\u001d;sC\u000e$8+\u001b3fG\"\f\u0017N\\!qa\u0006\t2/\u001b3fG\"\f\u0017N\\*fiRLgnZ:\u0011\u0005A+\u0016B\u0001,J\u0005E\u0019\u0016\u000eZ3dQ\u0006LgnU3ui&twm]\u0005\u0003'FCC!A-fMB\u0011!lY\u0007\u00027*\u0011A,X\u0001\u0005]\u0006lWM\u0003\u0002_?\u00061\u0011N\u001c6fGRT!\u0001Y1\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0011\u0017aA2p[&\u0011Am\u0017\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002O\u0006\t2+\u001b3fG\"\f\u0017N\\*fiRLgnZ:\u0002/\r,8\u000f^8n'\u0016\u001c'/\u001a;TKJL\u0017\r\\5{KJ\u001c\b\u0003\u00026pc^l\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u001dA\u0015m\u001d5NCB\u0004\"A];\u000e\u0003MT!\u0001^7\u0002\t1\fgnZ\u0005\u0003mN\u0014AAQ=uKB\u0019\u0001p_?\u000e\u0003eT!A_%\u0002\rM,7M]3u\u0013\ta\u0018P\u0001\tTK\u000e\u0014X\r^*fe&\fG.\u001b>feB\u0011\u0001P`\u0005\u0003\u007ff\u0014aaU3de\u0016$\u0018B\u00015RQ\u0015\u0011\u0011,ZA\u0003C\t\t9!A\fDkN$x.\\*fGJ,GoU3sS\u0006d\u0017N_3sg\u0006\u00193-^:u_6\f5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8TKJL\u0017\r\\5{KJ\u001c\b#\u00026pc\u00065\u0001CBA\b\u0003+\tI\"\u0004\u0002\u0002\u0012)\u0019\u00111C%\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003/\t\tBA\u000bUe\u0006t7/Y2uS>t7+\u001a:jC2L'0\u001a:\u0011\u0011\u0005m\u0011qDA\u0012\u0003_i!!!\b\u000b\u0007\u0005Mq)\u0003\u0003\u0002\"\u0005u!AE!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u0004B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003SI\u0015a\u00039s_B|7/\u001b;j_:LA!!\f\u0002(\tY\u0001K]8q_NLG/[8o!\u0019\t\t$a\u000e\u0002$5\u0011\u00111\u0007\u0006\u0004\u0003kI\u0015!\u00029s_>4\u0017\u0002BA\u001d\u0003g\u0011Q\u0001\u0015:p_\u001aDSaA-f\u0003{\t#!a\u0010\u0002G\r+8\u000f^8n\u0003\u000e\u001cw.\u001e8u)J\fgn]1di&|gnU3sS\u0006d\u0017N_3sg\u0006y1-^:u_6\f\u0005/[$s_V\u00048\u000fE\u0003k\u0003\u000b\nI%C\u0002\u0002H-\u0014A\u0001T5tiB!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00025uiBT1!a\u0015H\u0003\r\t\u0007/[\u0005\u0005\u0003/\niE\u0001\u000eBG\u000e|WO\u001c;BaBd\u0017nY1uS>t\u0017\t]5He>,\b\u000fK\u0003\u00053\u0016\fY&\t\u0002\u0002^\u0005y1)^:u_6\f\u0005/[$s_V\u00048/\u0001\tsK*,7\r^3e\u0003BL\u0007+\u0019;igB)!.!\u0012\u0002dAA\u0011QMA6\u0003_\ny'\u0004\u0002\u0002h)\u0019\u0011\u0011N%\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0014q\r\u0002\u0005!\u0006L'\u000f\u0005\u0003\u0002r\u0005\re\u0002BA:\u0003\u007f\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sj\u0015A\u0002\u001fs_>$hH\u0003\u0002\u0002~\u0005)1oY1mC&!\u0011\u0011QA>\u0003\u0019\u0001&/\u001a3fM&!\u0011QQAD\u0005\u0019\u0019FO]5oO*!\u0011\u0011QA>\u0013\r\ty&\u0015\u0015\u0006\u000be+\u0017QR\u0011\u0003\u0003\u001f\u000b\u0001CU3kK\u000e$X\rZ!qSB\u000bG\u000f[:\u0002/\r,8\u000f^8n\u001b\u0016\u001c8/Y4f!J|7-Z:t_J\u001c\b#\u00026\u0002F\u0005U\u0005\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mu)A\u0003ti\u0006$X-\u0003\u0003\u0002 \u0006e%\u0001E'fgN\fw-\u001a)s_\u000e,7o]8sQ\u00151\u0011,ZARC\t\t)+A\fDkN$x.\\'fgN\fw-\u001a)s_\u000e,7o]8sg\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o'R|\u0007\u000f]3s!\r\u0001\u00161V\u0005\u0004\u0003[K%aE*jI\u0016\u001c\u0007.Y5o\u0003B\u00048\u000b^8qa\u0016\u0014\u0018bAAT#\"*q!W3\u00024\u0006\u0012\u0011QW\u0001\u0013\u0003B\u0004H.[2bi&|gn\u0015;paB,'/\u0001\tg_J\\7i\u001c8gS\u001e,(/\u0019;peB!\u00111XAa\u001b\t\tiLC\u0002\u0002@&\u000bAAZ8sW&!\u00111YA_\u0005A1uN]6D_:4\u0017nZ;sCR|'/C\u0002\u00028FCS\u0001C-f\u0003\u0013\f#!a3\u0002#\u0019{'o[\"p]\u001aLw-\u001e:bi&|g.A\u0005dQ\u0006Lg.\u00138g_B\u0019\u0001+!5\n\u0007\u0005M\u0017JA\u0005DQ\u0006Lg.\u00138g_&\u0019\u0011QZ))\u000b%IV-!7\"\u0005\u0005m\u0017!C\"iC&t\u0017J\u001c4p\u0003)\t\u0007\u000f\u001d,feNLwN\u001c\u0015\u0006\u0015e+\u0017\u0011]\u0011\u0003\u0003G\f!\"\u00119q-\u0016\u00148/[8o\u0003Ui7M\u00117pG.\u0014VMZ3sK:\u001cW\rR3mCf\u0004B!!;\u0002l6\u0011\u00111P\u0005\u0005\u0003[\fYHA\u0002J]RL1!!:RQ\u0015Y\u0011,ZAzC\t\t)0\u0001\u000fNC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\u0012+G.Y=\u0002/5\f\u0007\u0010S5ti>\u0014\u0018PU3xe&$X\rT3oORD\u0017bAA|#\"*A\"W3\u0002~\u0006\u0012\u0011q`\u0001\u0018\u001b\u0006D\b*[:u_JL(+Z<sSR,G*\u001a8hi\"\fa\u0001P5oSRtDC\u0007B\u0003\u0005\u0013\u0011iA!\u0005\u0003\u0016\te!Q\u0004B\u0011\u0005K\u0011IC!\f\u00032\tU\u0002c\u0001B\u0004\u00015\tq\tC\u0003T\u001b\u0001\u0007A\u000bK\u0003\u0003\ne+g\rC\u0003i\u001b\u0001\u0007\u0011\u000e\u000b\u0004\u0003\u000ee+\u0017Q\u0001\u0005\b\u0003\u0013i\u0001\u0019AA\u0006Q\u0019\u0011\t\"W3\u0002>!9\u0011\u0011I\u0007A\u0002\u0005\r\u0003F\u0002B\u000b3\u0016\fY\u0006C\u0004\u0002`5\u0001\r!!\u0019)\r\te\u0011,ZAG\u0011\u001d\t\t*\u0004a\u0001\u0003'CcA!\bZK\u0006\r\u0006bBAT\u001b\u0001\u0007\u0011\u0011\u0016\u0015\u0007\u0005CIV-a-\t\u000f\u0005]V\u00021\u0001\u0002:\"2!QE-f\u0003\u0013Dq!!4\u000e\u0001\u0004\ty\r\u000b\u0004\u0003*e+\u0017\u0011\u001c\u0005\b\u0003;l\u0001\u0019AA8Q\u0019\u0011i#W3\u0002b\"9\u0011Q]\u0007A\u0002\u0005\u001d\bF\u0002B\u00193\u0016\f\u0019\u0010C\u0004\u0002x6\u0001\r!a:)\r\tU\u0012,ZA\u007fQ\ri!1\b\t\u0005\u0005{\u0011y$D\u0001^\u0013\r\u0011\t%\u0018\u0002\u0007\u0013:TWm\u0019;\u0003\u0005QC&\u0001\u0002)N\u001f\u0012\u0003BA!\u0013\u0003P5\u0011!1\n\u0006\u0004\u0005\u001b:\u0015!\u00022m_\u000e\\\u0017\u0002\u0002B)\u0005\u0017\u0012A\"Q2d_VtGO\u00117pG.\u0014AA\u0014,I)B!!q\u0001B,\u0013\r\u0011If\u0012\u0002\u001f\u0003\u000e\u001cw.\u001e8u'&$Wm\u00195bS:tu\u000eZ3WS\u0016<\bj\u001c7eKJ\fQb]<bO\u001e,'oQ8oM&<WCAA8\u00039\u0019x/Y4hKJ\u001cuN\u001c4jO\u0002\nad]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t7oQ8na\u0006t\u0017n\u001c8\u0016\u0005\t\u0015\u0004\u0003\u0002B4\u0005[j!A!\u001b\u000b\u0007\t-t)A\u0005d_6\u0004\u0018M\\5p]&!!q\u000eB5\u0005\u0015\u001a\u0016\u000eZ3dQ\u0006Lg.Q2d_VtG\u000f\u0016:b]N\f7\r^5p]N\u001cu.\u001c9b]&|g.\u0001\u0007hK:,7/[:CY>\u001c7.\u0006\u0002\u0003H\u0005\u0019B-\u0019;b\t&\u0014\u0018IY:pYV$X\rU1uQ\u0006!B-\u0019;b\t&\u0014\u0018IY:pYV$X\rU1uQ\u0002\n1b]3de\u0016$8\u000b^8sKV\u0011!Q\u0010\t\u0005\u0005\u007f\u0012\u0019)\u0004\u0002\u0003\u0002*\u0011A*\\\u0005\u0005\u0005\u000b\u0013\tI\u0001\u0003GS2,\u0017\u0001D:fGJ,Go\u0015;pe\u0016\u0004\u0013AD7fi\u0006\u001cF/\u0019;f'R|'/Z\u0001\u0010[\u0016$\u0018m\u0015;bi\u0016\u001cFo\u001c:fA\u0005a\u0001.[:u_JL8\u000b^8sK\u0006i\u0001.[:u_JL8\u000b^8sK\u0002\nabY8og\u0016t7/^:Ti>\u0014X-A\bd_:\u001cXM\\:vgN#xN]3!\u0003]\u0019\u0018\u000eZ3dQ\u0006Lg\u000eS5ti>\u0014\u0018p\u0015;pe\u0006<W-\u0006\u0002\u0003\u001aB!!1\u0014BQ\u001b\t\u0011iJC\u0002\u0003 \u001e\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0003$\nu%!F!dG>,h\u000e\u001e%jgR|'/_*u_J\fw-Z\u0001\u0019g&$Wm\u00195bS:D\u0015n\u001d;pef\u001cFo\u001c:bO\u0016\u0004\u0013AF:jI\u0016\u001c\u0007.Y5o'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3\u0016\u0005\t-\u0006\u0003\u0002BW\u0005ck!Aa,\u000b\u0007\t}\u0015*\u0003\u0003\u00034\n=&AF*jI\u0016\u001c\u0007.Y5o'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3\u0002/MLG-Z2iC&t7+Z2sKR\u001cFo\u001c:bO\u0016\u0004\u0013\u0001F:uCR,W*\u001a;bI\u0006$\u0018m\u0015;pe\u0006<W-\u0006\u0002\u0003<B!!1\u0014B_\u0013\u0011\u0011yL!(\u00037\u0005\u001b7m\\;oiN#\u0018\r^3NKR\fG-\u0019;b'R|'/Y4f\u0003U\u0019H/\u0019;f\u001b\u0016$\u0018\rZ1uCN#xN]1hK\u0002\nab\u001d;bi\u0016$%m\u0015;pe\u0006<W-\u0006\u0002\u0003HB!!\u0011\u001aBh\u001b\t\u0011YMC\u0002\u0003N&\u000b1!\u001a<n\u0013\u0011\u0011\tNa3\u0003\u001f1+g/\u001a7E\u0005\u0012\u000bG/\u00192bg\u0016\fqb\u001d;bi\u0016$%m\u0015;pe\u0006<W\rI\u0001\u0015G>t7/\u001a8tkN$\u0015\r^1Ti>\u0014\u0018mZ3\u0016\u0005\te\u0007\u0003\u0002Bn\u0005Cl!A!8\u000b\u0007\t}\u0017*A\u0005d_:\u001cXM\\:vg&!!1\u001dBo\u0005Q\u0019uN\\:f]N,8\u000fR1uCN#xN]1hK\u0006)2m\u001c8tK:\u001cXo\u001d#bi\u0006\u001cFo\u001c:bO\u0016\u0004\u0013!\u00058pI\u00164\u0016.Z<I_2$WM\u001d*fMV\u0011!1\u001e\t\u0005\u0005[\u001490\u0004\u0002\u0003p*!!\u0011\u001fBz\u0003\u0015\t7\r^8s\u0015\t\u0011)0\u0001\u0003bW.\f\u0017\u0002\u0002B}\u0005_\u0014\u0001\"Q2u_J\u0014VMZ\u0001\u0013]>$WMV5fo\"{G\u000eZ3s%\u00164\u0007%A\nn_\u0012Lg-[3s'\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u0004\u0002AA\u0011\u0011OB\u0002\u0007\u000f\u0019)#\u0003\u0003\u0004\u0006\u0005\u001d%aA'baB!1\u0011BB\u0010\u001d\u0011\u0019Ya!\u0007\u000f\t\r511\u0003\b\u0005\u0003k\u001ay!\u0003\u0002\u0004\u0012\u000511\u000f]1sWjLAa!\u0006\u0004\u0018\u0005!1m\u001c:f\u0015\t\u0019\t\"\u0003\u0003\u0004\u001c\ru\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0007+\u00199\"\u0003\u0003\u0004\"\r\r\"AD'pI&4\u0017.\u001a:UsB,\u0017\n\u001a\u0006\u0005\u00077\u0019i\u0002\r\u0003\u0004(\r]\u0002CBB\u0015\u0007_\u0019\u0019$\u0004\u0002\u0004,)!1QFB\u000f\u00035\u0019XM]5bY&T\u0018\r^5p]&!1\u0011GB\u0016\u0005A\u0019\u0006/\u0019:luN+'/[1mSj,'\u000f\u0005\u0003\u00046\r]B\u0002\u0001\u0003\f\u0007sY\u0013\u0011!A\u0001\u0006\u0003\u0019YDA\u0002`IE\nBa!\u0010\u0004DA!\u0011\u0011^B \u0013\u0011\u0019\t%a\u001f\u0003\u000f9{G\u000f[5oOB!1QIB$\u001b\t\u0019i\"\u0003\u0003\u0004J\ru!\u0001\u0005(pI\u00164\u0016.Z<N_\u0012Lg-[3s\u0003Qqw\u000eZ3WS\u0016<8+\u001f8dQJ|g.\u001b>fe\u0006)bn\u001c3f-&,woU=oG\"\u0014xN\\5{KJ\u0004\u0013\u0001H:jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b$pe\u001e,'/Q2u_J\u0014VMZ\u0001\u001eg&$Wm\u00195bS:\u0014En\\2l\r>\u0014x-\u001a:BGR|'OU3gA\u0005a2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\f5\r^8s%\u00164\u0017!H:jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|g.Q2u_J\u0014VM\u001a\u0011\u0002-MLG-Z2iC&t'\t\\8dW\u0006\u001bGo\u001c:SK\u001a\fqc]5eK\u000eD\u0017-\u001b8CY>\u001c7.Q2u_J\u0014VM\u001a\u0011\u0002/\r,'\u000f^5gS\u000e\fG/Z*vE6LG\u000f^3s%\u00164\u0017\u0001G2feRLg-[2bi\u0016\u001cVOY7jiR,'OU3gA\u0005y2-\u001a:uS\u001aL7-\u0019;f'&<g.\u0019;ve\u0016\u001cX*\u00198bO\u0016\u0014(+\u001a4\u0002A\r,'\u000f^5gS\u000e\fG/Z*jO:\fG/\u001e:fg6\u000bg.Y4feJ+g\rI\u0001\u0013gft7m\u0015;biV\u001c\u0018i\u0019;peJ+g-A\nts:\u001c7\u000b^1ukN\f5\r^8s%\u00164\u0007%\u0001\u0006sa\u000eD\u0015M\u001c3mKJ,\"aa\u001b\u0011\t\r54qO\u0007\u0003\u0007_RAa!\u001d\u0004t\u00059\u0001.\u00198eY\u0016\u0014(\u0002BB;\u0003#\n1A\u001d9d\u0013\u0011\u0019Iha\u001c\u0003\u0015I\u00038\rS1oI2,'/A\u0006sa\u000eD\u0015M\u001c3mKJ\u0004\u0013\u0001\u0004:qGB\u0013xnY3tg>\u0014XCABA!\u0011\u0019\u0019i!#\u000e\u0005\r\u0015%\u0002BBD\u0007g\nqa]3sm&\u001cW-\u0003\u0003\u0004\f\u000e\u0015%\u0001\u0004*qGB\u0013xnY3tg>\u0014\u0018!\u0004:qGB\u0013xnY3tg>\u0014\b%\u0001\u000bbaBd\u0017nY1uS>t\u0017\t]5S_V$Xm]\u000b\u0003\u0007'\u0003ba!&\u0004\u001e\u000e\rf\u0002BBL\u00077sA!!\u001e\u0004\u001a&\u0011\u0011QP\u0005\u0005\u00077\tY(\u0003\u0003\u0004 \u000e\u0005&aA*fc*!11DA>!\u0011\u0019)ka+\u000e\u0005\r\u001d&\u0002BA(\u0007SSA!a\u0015\u0004\u001e%!1QVBT\u0005!\t\u0005/\u001b*pkR,\u0017!D2pe\u0016\f\u0005/\u001b*pkR,7/\u0001\to_\u0012,g+[3x!J|g/\u001b3feV\u00111Q\u0017\t\u0017\u0007o\u001bil!1\u0004F\u000e-7QZBm\u0007K\u001cYo!>\u0004|6\u00111\u0011\u0018\u0006\u0004\u0007wK\u0015A\u00025fYB,'/\u0003\u0003\u0004@\u000ee&\u0001\u0005(pI\u00164\u0016.Z<Qe>4\u0018\u000eZ3s!\r\u0019\u0019MD\u0007\u0002\u0001A!!\u0011JBd\u0013\u0011\u0019IMa\u0013\u0003%\u0005\u001b7m\\;oi\ncwnY6IK\u0006$WM\u001d\t\u0004\u0007\u0007|\u0001\u0003BBh\u0007+l!a!5\u000b\u0007\rMw)A\u0003dQ\u0006Lg.\u0003\u0003\u0004X\u000eE'AF!dG>,h\u000e\u001e$fKB\u000b\u00170\\3oiNLeNZ8\u0011\t\rm7\u0011]\u0007\u0003\u0007;T1aa8H\u0003\u0011qw\u000eZ3\n\t\r\r8Q\u001c\u0002\u0013\u001d>$W-Q2d_VtG\u000fS5ti>\u0014\u0018\u0010\u0005\u0003\u0004\\\u000e\u001d\u0018\u0002BBu\u0007;\u0014\u0001CT8eK\u0006\u001b7m\\;oiN#\u0018\r^3\u0011\t\r58\u0011_\u0007\u0003\u0007_T1aa8J\u0013\u0011\u0019\u0019pa<\u0003\u001d9{G-Z,bY2,GOQ1tKB!11\\B|\u0013\u0011\u0019Ip!8\u0003+9{G-Z!dG>,h\u000e^'f[>\u0014\u0018\u0010U8pYB!11\\B\u007f\u0013\u0011\u0019yp!8\u0003\u001f\u0005\u001b7m\\;oi:{G-\u001a,jK^\f\u0011C\\8eKZKWm\u001e)s_ZLG-\u001a:!\u0003M9W\r\u001e(pI\u00164\u0016.Z<Qe>4\u0018\u000eZ3s\u0003e!(/\u00198tC\u000e$\u0018n\u001c8Tk\nl\u0017\u000e\u001e)s_ZLG-\u001a:\u0016\u0005\u0011%\u0001CBB\\\t\u0017\u0019\t-\u0003\u0003\u0005\u000e\re&!\u0007+sC:\u001c\u0018m\u0019;j_:\u001cVOY7jiB\u0013xN^5eKJ\f!\u0004\u001e:b]N\f7\r^5p]N+(-\\5u!J|g/\u001b3fe\u0002\nAdZ3u)J\fgn]1di&|gnU;c[&$\bK]8wS\u0012,'\u000f")
public class AccountSidechainApp
extends AbstractSidechainApp {
    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion;
    private AccountBlock genesisBlock;
    private Seq<ApiRoute> applicationApiRoutes;
    private Seq<ApiRoute> coreApiRoutes;
    @Named(value="CustomAccountTransactionSerializers")
    private HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers;
    @Named(value="CustomApiGroups")
    private java.util.List<AccountApplicationApiGroup> customApiGroups;
    @Named(value="AppVersion")
    private String appVersion;
    private final String swaggerConfig;
    private final String dataDirAbsolutePath;
    private final File secretStore;
    private final File metaStateStore;
    private final File historyStore;
    private final File consensusStore;
    private final AccountHistoryStorage sidechainHistoryStorage;
    private final SidechainSecretStorage sidechainSecretStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final LevelDBDatabase stateDbStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final ActorRef nodeViewHolderRef;
    private final ActorRef nodeViewSynchronizer;
    private final ActorRef sidechainBlockForgerActorRef;
    private final ActorRef sidechainTransactionActorRef;
    private final ActorRef sidechainBlockActorRef;
    private final ActorRef certificateSubmitterRef;
    private final ActorRef certificateSignaturesManagerRef;
    private final ActorRef syncStatusActorRef;
    private final RpcHandler rpcHandler;
    private final RpcProcessor rpcProcessor;
    private final NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider;
    private final TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider;
    private volatile byte bitmap$0;

    public String swaggerConfig() {
        return this.swaggerConfig;
    }

    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sidechainTransactionsCompanion = new SidechainAccountTransactionsCompanion(this.customAccountTransactionSerializers);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.customAccountTransactionSerializers = null;
        return this.sidechainTransactionsCompanion;
    }

    public SidechainAccountTransactionsCompanion sidechainTransactionsCompanion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sidechainTransactionsCompanion$lzycompute() : this.sidechainTransactionsCompanion;
    }

    private AccountBlock genesisBlock$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.genesisBlock = (AccountBlock)new AccountBlockSerializer(this.sidechainTransactionsCompanion()).parseBytes(BytesUtils.fromHexString(super.sidechainSettings().genesisData().scGenesisBlockHex()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.genesisBlock;
    }

    @Override
    public AccountBlock genesisBlock() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.genesisBlock$lzycompute() : this.genesisBlock;
    }

    public String dataDirAbsolutePath() {
        return this.dataDirAbsolutePath;
    }

    public File secretStore() {
        return this.secretStore;
    }

    public File metaStateStore() {
        return this.metaStateStore;
    }

    public File historyStore() {
        return this.historyStore;
    }

    public File consensusStore() {
        return this.consensusStore;
    }

    public AccountHistoryStorage sidechainHistoryStorage() {
        return this.sidechainHistoryStorage;
    }

    public SidechainSecretStorage sidechainSecretStorage() {
        return this.sidechainSecretStorage;
    }

    public AccountStateMetadataStorage stateMetadataStorage() {
        return this.stateMetadataStorage;
    }

    public LevelDBDatabase stateDbStorage() {
        return this.stateDbStorage;
    }

    public ConsensusDataStorage consensusDataStorage() {
        return this.consensusDataStorage;
    }

    public ActorRef nodeViewHolderRef() {
        return this.nodeViewHolderRef;
    }

    public Map<Object, SparkzSerializer<? extends NodeViewModifier>> modifierSerializers() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)SidechainBlockBase$.MODULE$.ModifierTypeId())), (Object)new AccountBlockSerializer(this.sidechainTransactionsCompanion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)Transaction$.MODULE$.ModifierTypeId())), (Object)this.sidechainTransactionsCompanion())}));
    }

    public ActorRef nodeViewSynchronizer() {
        return this.nodeViewSynchronizer;
    }

    public ActorRef sidechainBlockForgerActorRef() {
        return this.sidechainBlockForgerActorRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public ActorRef sidechainBlockActorRef() {
        return this.sidechainBlockActorRef;
    }

    public ActorRef certificateSubmitterRef() {
        return this.certificateSubmitterRef;
    }

    public ActorRef certificateSignaturesManagerRef() {
        return this.certificateSignaturesManagerRef;
    }

    public ActorRef syncStatusActorRef() {
        return this.syncStatusActorRef;
    }

    public RpcHandler rpcHandler() {
        return this.rpcHandler;
    }

    public RpcProcessor rpcProcessor() {
        return this.rpcProcessor;
    }

    private Seq<ApiRoute> applicationApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.applicationApiRoutes = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.customApiGroups).asScala()).map((Function1 & Serializable & scala.Serializable)apiRoute -> new AccountApplicationApiRoute(this.settings().restApi(), (AccountApplicationApiGroup)apiRoute, this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem()), Buffer$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        this.customApiGroups = null;
        return this.applicationApiRoutes;
    }

    @Override
    public Seq<ApiRoute> applicationApiRoutes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.applicationApiRoutes$lzycompute() : this.applicationApiRoutes;
    }

    private Seq<ApiRoute> coreApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.coreApiRoutes = (Seq)new .colon.colon(new MainchainBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainBlockActorRef(), this.sidechainTransactionsCompanion(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainNodeApiRoute(this.peerManagerRef(), this.networkControllerRef(), this.timeProvider(), this.settings().restApi(), this.nodeViewHolderRef(), this, this.params(), this.appVersion, (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountTransactionApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainTransactionActorRef(), this.sidechainTransactionsCompanion(), this.params(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon((Object)new AccountWalletApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainSecretsCompanion(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainSubmitterApiRoute(this.settings().restApi(), this.params(), this.certificateSubmitterRef(), this.nodeViewHolderRef(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.Nothing()), (List)new .colon.colon((Object)new AccountEthRpcRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.rpcProcessor(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)Nil$.MODULE$)))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        this.appVersion = null;
        return this.coreApiRoutes;
    }

    @Override
    public Seq<ApiRoute> coreApiRoutes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.coreApiRoutes$lzycompute() : this.coreApiRoutes;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider() {
        return this.nodeViewProvider;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> getNodeViewProvider() {
        return this.nodeViewProvider();
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider() {
        return this.transactionSubmitProvider;
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> getTransactionSubmitProvider() {
        return this.transactionSubmitProvider();
    }

    @Inject
    public AccountSidechainApp(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") java.util.List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") java.util.List<Pair<String, String>> rejectedApiPaths, @Named(value="CustomMessageProcessors") java.util.List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="AppVersion") String appVersion, @Named(value="MainchainBlockReferenceDelay") int mcBlockReferenceDelay, @Named(value="MaxHistoryRewriteLength") int maxHistoryRewriteLength) {
        ActorRef actorRef;
        this.customAccountTransactionSerializers = customAccountTransactionSerializers;
        this.customApiGroups = customApiGroups;
        this.appVersion = appVersion;
        super(sidechainSettings, customSecretSerializers, rejectedApiPaths, applicationStopper, forkConfigurator, chainInfo, mcBlockReferenceDelay, maxHistoryRewriteLength);
        this.swaggerConfig = Source$.MODULE$.fromResource("account/api/accountApi.yaml", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.UTF8()).getLines().mkString("\n");
        Predef$.MODULE$.require(!this.isCSWEnabled(), (Function0 & Serializable & scala.Serializable)() -> "Ceased Sidechain Withdrawal (CSW) should not be enabled in AccountSidechainApp!");
        this.dataDirAbsolutePath = super.sidechainSettings().sparkzSettings().dataDir().getAbsolutePath();
        this.secretStore = new File(new StringBuilder(7).append(this.dataDirAbsolutePath()).append("/secret").toString());
        this.metaStateStore = new File(new StringBuilder(6).append(this.dataDirAbsolutePath()).append("/state").toString());
        this.historyStore = new File(new StringBuilder(8).append(this.dataDirAbsolutePath()).append("/history").toString());
        this.consensusStore = new File(new StringBuilder(14).append(this.dataDirAbsolutePath()).append("/consensusData").toString());
        this.sidechainHistoryStorage = new AccountHistoryStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.historyStore(), 5)), this.sidechainTransactionsCompanion(), this.params());
        this.sidechainSecretStorage = new SidechainSecretStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.secretStore(), 5)), this.sidechainSecretsCompanion());
        this.stateMetadataStorage = new AccountStateMetadataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.metaStateStore(), this.params().maxHistoryRewritingLength() * 2)));
        this.stateDbStorage = this.registerClosableResource(new LevelDBDatabase(new StringBuilder(10).append(this.dataDirAbsolutePath()).append("/evm-state").toString()));
        this.consensusDataStorage = new ConsensusDataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.consensusStore(), 5)));
        if (this.sidechainSecretStorage().isEmpty()) {
            super.sidechainSettings().wallet().genesisSecrets().foreach((Function1 & Serializable & scala.Serializable)secretHex -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretHex))));
            super.sidechainSettings().withdrawalEpochCertificateSettings().signersSecrets().foreach((Function1 & Serializable & scala.Serializable)secretSchnorr -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretSchnorr))));
        }
        this.nodeViewHolderRef = AccountNodeViewHolderRef$.MODULE$.apply(super.sidechainSettings(), this.sidechainHistoryStorage(), this.consensusDataStorage(), this.stateMetadataStorage(), (Database)this.stateDbStorage(), (Seq<MessageProcessor>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(customMessageProcessors).asScala()), this.sidechainSecretStorage(), this.params(), this.timeProvider(), this.genesisBlock(), this.actorSystem());
        this.nodeViewSynchronizer = this.actorSystem().actorOf(AccountNodeViewSynchronizer$.MODULE$.props(this.networkControllerRef(), this.nodeViewHolderRef(), SidechainSyncInfoMessageSpec$.MODULE$, this.settings().network(), this.timeProvider(), this.modifierSerializers(), this.executionContext()));
        this.sidechainBlockForgerActorRef = AccountForgerRef$.MODULE$.apply("AccountForger", super.sidechainSettings(), this.nodeViewHolderRef(), this.mainchainSynchronizer(), this.sidechainTransactionsCompanion(), this.timeProvider(), this.params(), this.actorSystem());
        if (super.sidechainSettings().apiRateLimiter().enabled()) {
            ActorRef rateLimiterActorRef = SidechainTransactionRateLimiterActorRef$.MODULE$.apply(this.nodeViewHolderRef(), super.sidechainSettings().apiRateLimiter(), this.actorSystem(), this.executionContext());
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(rateLimiterActorRef, this.actorSystem(), this.executionContext());
        } else {
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(this.nodeViewHolderRef(), this.actorSystem(), this.executionContext());
        }
        this.sidechainTransactionActorRef = actorRef;
        this.sidechainBlockActorRef = SidechainBlockActorRef$.MODULE$.apply("AccountBlock", super.sidechainSettings(), this.sidechainBlockForgerActorRef(), ClassTag$.MODULE$.apply(AccountBlock.class), ClassTag$.MODULE$.apply(AccountHistory.class), this.actorSystem(), this.executionContext());
        this.certificateSubmitterRef = AccountCertificateSubmitterRef$.MODULE$.apply(super.sidechainSettings(), this.nodeViewHolderRef(), this.secureEnclaveApiClient(), this.params(), this.mainchainNodeChannel(), this.actorSystem(), this.executionContext());
        this.certificateSignaturesManagerRef = CertificateSignaturesManagerRef$.MODULE$.apply(this.networkControllerRef(), this.certificateSubmitterRef(), this.params(), super.sidechainSettings().sparkzSettings().network(), this.actorSystem(), this.executionContext());
        this.syncStatusActorRef = SyncStatusActorRef$.MODULE$.apply("SyncStatus", super.sidechainSettings(), this.nodeViewHolderRef(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), this.actorSystem(), this.executionContext());
        this.rpcHandler = new RpcHandler(new EthService(this.nodeViewHolderRef(), this.networkControllerRef(), this.settings().restApi().timeout(), this.params(), super.sidechainSettings().ethService(), super.sidechainSettings().sparkzSettings().network().maxIncomingConnections(), RpcUtils$.MODULE$.getClientVersion(), this.sidechainTransactionActorRef(), this.syncStatusActorRef(), this.sidechainTransactionsCompanion()));
        this.rpcProcessor = new RpcProcessor(this.rpcHandler());
        if (super.sidechainSettings().websocketServer().wsServer()) {
            ActorRef webSocketServerActor = WebSocketAccountServerRef$.MODULE$.apply(this.nodeViewHolderRef(), this.rpcProcessor(), super.sidechainSettings().websocketServer(), this.actorSystem(), this.executionContext());
        }
        this.nodeViewProvider = new NodeViewProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>(this.nodeViewHolderRef());
        this.actorSystem().eventStream().publish((Object)SidechainAppEvents$SidechainApplicationStart$.MODULE$);
        this.transactionSubmitProvider = new TransactionSubmitProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>>(this.sidechainTransactionActorRef());
    }
}

