/*
 * Decompiled with CFR 0.152.
 */
package io.horizen;

import com.fasterxml.jackson.databind.JsonNode;
import io.horizen.SidechainModel;
import io.horizen.block.MainchainBlockReference;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.cryptolibprovider.CircuitTypes;
import io.horizen.params.NetworkParams;
import io.horizen.params.RegTestParams;
import io.horizen.proof.VrfProof;
import io.horizen.secret.PrivateKey25519;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.utils.MerklePath;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.companion.SidechainTransactionsCompanion;
import io.horizen.vrf.VrfOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public abstract class AbstractUTXOModel
implements SidechainModel<SidechainBlock> {
    private static final String model = "utxo";

    @Override
    public String getModelName() {
        return model;
    }

    @Override
    public SidechainBlock buildScGenesisBlock(MainchainBlockReference mcRef, SidechainCreation sidechainCreation, JsonNode json, PrivateKey25519 key, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath mp, NetworkParams params) {
        byte blockVersion = SidechainBlock.BLOCK_VERSION();
        byte[] feePaymentsHash = new byte[32];
        ForgerBox forgerBox = sidechainCreation.getBox();
        ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(forgerBox.blockSignProposition(), forgerBox.vrfPubKey(), forgerBox.value());
        SidechainTransactionsCompanion sidechainTransactionsCompanion = new SidechainTransactionsCompanion(new HashMap(), CircuitTypes.NaiveThresholdSignatureCircuit());
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        int regtestBlockTimestampRewind = json.has("regtestBlockTimestampRewind") ? json.get("regtestBlockTimestampRewind").asInt() : 0;
        long timestamp = params instanceof RegTestParams ? currentTimeSeconds - (long)regtestBlockTimestampRewind : currentTimeSeconds;
        return (SidechainBlock)SidechainBlock.create((String)params.sidechainGenesisBlockParentId(), (byte)blockVersion, (long)timestamp, (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(Collections.singletonList(mcRef.data())).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(new ArrayList()).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(Collections.singletonList(mcRef.header())).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(new ArrayList()).asScala()).toSeq(), (PrivateKey25519)key, (ForgingStakeInfo)forgingStakeInfo, (VrfProof)vrfProof, (MerklePath)mp, (byte[])feePaymentsHash, (SidechainTransactionsCompanion)sidechainTransactionsCompanion, (Option)Option.empty()).get();
    }
}

