/*
 * Decompiled with CFR 0.152.
 */
package io.horizen;

import io.horizen.ScBootstrappingToolCommandProcessor;
import io.horizen.settings.LogInitializer;
import io.horizen.tools.utils.MessagePrinter;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractScBootstrappingTool {
    protected final MessagePrinter printer;

    public AbstractScBootstrappingTool(MessagePrinter printer) {
        this.printer = printer;
    }

    protected abstract ScBootstrappingToolCommandProcessor getBootstrappingToolCommandProcessor();

    public void startCommandTool(String[] args) {
        String logDir = System.getProperty("java.io.tmpdir");
        String logFileName = "sc_bootstrapping_tool.log";
        LogInitializer.initLogManager((String)logDir, (String)logFileName, (String)"all", (String)"error");
        Logger logger = LogManager.getLogger(AbstractScBootstrappingTool.class);
        ScBootstrappingToolCommandProcessor processor = this.getBootstrappingToolCommandProcessor();
        if (args.length > 0) {
            try {
                StringBuilder cmd = new StringBuilder(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    cmd.append(" ").append(args[i]);
                }
                logger.info("Starting bootstrapping tool with cmd input: " + String.valueOf(cmd));
                processor.processCommand(cmd.toString());
            }
            catch (Exception e) {
                this.printer.print(e.getMessage());
            }
        } else {
            this.printer.print("Tool successfully started...\nPlease, enter the command:");
            Scanner scanner = new Scanner(System.in);
            while (true) {
                String input = scanner.nextLine();
                try {
                    if (input.startsWith("exit")) break;
                    logger.info("Starting bootstrapping tool with cmd input: " + input);
                    processor.processCommand(input);
                }
                catch (Exception e) {
                    this.printer.print(e.getMessage());
                }
            }
        }
        logger.info("... exiting bootstrapping tool application.");
    }
}

