/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Address;
import io.horizen.evm.BlockHashCallback;
import io.horizen.evm.ForkRules;
import io.horizen.evm.Hash;
import io.horizen.evm.InvocationCallback;
import io.horizen.evm.Tracer;
import java.math.BigInteger;

public class EvmContext {
    public final BigInteger chainID;
    public final Address coinbase;
    public final BigInteger gasLimit;
    public final BigInteger gasPrice;
    public final BigInteger blockNumber;
    public final BigInteger time;
    public final BigInteger baseFee;
    public final Hash random;
    public final ForkRules rules;
    private BlockHashCallback blockHashCallback;
    private Address[] externalContracts;
    private InvocationCallback externalCallback;
    private Tracer tracer;
    private int initialDepth;

    public EvmContext(BigInteger chainID, Address coinbase, BigInteger gasLimit, BigInteger gasPrice, BigInteger blockNumber, BigInteger time, BigInteger baseFee, Hash random, ForkRules rules) {
        this.chainID = chainID;
        this.coinbase = coinbase;
        this.gasLimit = gasLimit;
        this.gasPrice = gasPrice;
        this.blockNumber = blockNumber;
        this.time = time;
        this.baseFee = baseFee;
        this.random = random;
        this.rules = rules;
    }

    EvmContext() {
        this.chainID = BigInteger.ZERO;
        this.coinbase = Address.ZERO;
        this.gasLimit = BigInteger.ZERO;
        this.gasPrice = BigInteger.ZERO;
        this.blockNumber = BigInteger.ZERO;
        this.time = BigInteger.ZERO;
        this.baseFee = BigInteger.ZERO;
        this.random = Hash.ZERO;
        this.rules = new ForkRules(false);
    }

    public BlockHashCallback getBlockHashCallback() {
        return this.blockHashCallback;
    }

    public void setBlockHashCallback(BlockHashCallback blockHashCallback) {
        this.blockHashCallback = blockHashCallback;
    }

    public Address[] getExternalContracts() {
        return this.externalContracts;
    }

    public void setExternalContracts(Address[] externalContracts) {
        this.externalContracts = externalContracts;
    }

    public InvocationCallback getExternalCallback() {
        return this.externalCallback;
    }

    public void setExternalCallback(InvocationCallback externalCallback) {
        this.externalCallback = externalCallback;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public int getInitialDepth() {
        return this.initialDepth;
    }

    public void setInitialDepth(int initialDepth) {
        this.initialDepth = initialDepth;
    }
}

